/*******************************************************************************
* FILE NAME: ixfntset.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in ixfntset.hpp                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Materials - Property of IBM                                       *
*   (C) Copyright IBM Corporation 1992, 1997 All Rights Reserved.              *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
// Revision: 50 1.2 source/albert/graph2d/ixfntset.cpp, 2d, ioc.v400, 990114 

#include <ixfntset.hpp>
#include <istring.hpp>
#include <iprimlck.hpp>

XFontSet
IXFontSet::getFontSet(Display *dpy, const char *xlfd)
{
    IFUNCTRACE_DEVELOP();
    ITRACE_DEVELOP(IString("Requesting font: ") + IString(xlfd));
    if (! xlfd_cache.isEmpty()) {
        ISortedSet<IXLFDFontSet>::Cursor cursor(xlfd_cache);
        forICursor (cursor) {
            if ((strcasecmp((const char *)(xlfd_cache.elementAt(cursor).xlfd()),
                            xlfd) == 0) &&
                (xlfd_cache.elementAt(cursor).display() == dpy)) {

                ITRACE_DEVELOP("Using cached font.");
                return xlfd_cache.elementAt(cursor).fontset();
            }
        }
    }
    
    ITRACE_DEVELOP("Font not cached, use XCreateFontSet.");
    
    // nothing is found, create a new one.
    char** missing_charset_list_return;
    int missing_charset_count_return;
    char* def_string_return;
    XFontSet aFontSet = NULL;
    
    aFontSet = XCreateFontSet(dpy, xlfd,
                              &missing_charset_list_return,
                              &missing_charset_count_return,
                              &def_string_return);
    
    if (missing_charset_list_return)
        XFreeStringList(missing_charset_list_return);
    
    if (aFontSet)
        xlfd_cache.add(IXLFDFontSet(dpy, IString(xlfd), aFontSet));
    
    // aFontSet can be null
    return aFontSet;
}

IXFontSet::~IXFontSet() {
    if (! xlfd_cache.isEmpty()) {
        ISortedSet<IXLFDFontSet>::Cursor cursor(xlfd_cache);
        forICursor (cursor) {
            XFreeFontSet(xlfd_cache.elementAt(cursor).display(), 
                         xlfd_cache.elementAt(cursor).fontset());
        }
    }
}

static IXFontSet *ixfontset = 0;

XFontSet
IXCreateFontSet(Display *display, const char *xlfd)
{
    if (! ixfontset) {
        IPrimalLock lockinit;
        if (! ixfontset)
            ixfontset = new IXFontSet;
    }
    return ixfontset->getFontSet(display, xlfd);
}

#pragma enum(4)
#pragma pack(push,4)

class IXFontSetStatic
{
public:
    ~IXFontSetStatic() { if (ixfontset) delete ixfontset; }
};

#pragma pack(pop)
#pragma enum(pop)

static IXFontSetStatic fontSetStatic;
