// ----------------------------------------------------------------------------
// FILE NAME: idllstat.cpp
//
// DESCRIPTION:
//   This file contains the implementation of the functions in idllstat.hpp
//
//
// COPYRIGHT:
//   IBM Open Class Library
//   (C) Copyright International Business Machines Corporation 1992, 1997
//   Licensed Material - Program-Property of IBM - All Rights Reserved.
//   US Government Users Restricted Rights - Use, duplication, or disclosure
//   restricted by GSA ADP Schedule Contract with IBM Corp.
//
// Revision: 70 1.8.2.1 source/core/base/idllstat.cpp, appsupport, ioc.v400, 990114 
// ----------------------------------------------------------------------------

#include <ibase.hpp>
#include <idllstat.hpp>
#include <idllimp.hpp>
#include <iexcept.hpp>
#include <itrace.hpp>
#include <ireslock.hpp>
#include <ibhandle.hpp>
#include <iprimlck.hpp>


#ifdef IC_PAGETUNE
    #define _IDLLSTAT_CPP_
    #include <ipagetun.h>
#endif

// ----------------------------------------------------------------------------
//  IDLLStaticPtr: Static data
// ----------------------------------------------------------------------------
IDLLSet* IDLLStaticPtr::fgDLLSet = 0;
IPrivateResource* IDLLStaticPtr::fgDLLKey = 0;


// ----------------------------------------------------------------------------
// IDLLStaticPtr::~IDLLStaticPtr
// ----------------------------------------------------------------------------
IDLLStaticPtr::~IDLLStaticPtr ()
{
    IPrimalLock lockCleaUp;

    if(fgDLLSet)
        delete fgDLLSet;

    if(fgDLLKey)
        delete fgDLLKey;
}

// ----------------------------------------------------------------------------
// IDLLStaticPtr::dllSet
// ----------------------------------------------------------------------------
IDLLSet& IDLLStaticPtr::dllSet()
{
    if(!fgDLLSet)
    {
        IPrimalLock lockInit;

        if (!fgDLLSet)
            fgDLLSet = new IDLLSet;
    }
    return *fgDLLSet;
}


// ----------------------------------------------------------------------------
// IDLLStaticPtr::dllKey
// ----------------------------------------------------------------------------
IPrivateResource& IDLLStaticPtr::dllKey()
{
    if (!fgDLLKey)
    {
        IPrimalLock lockInit;

        if (!fgDLLKey)
            fgDLLKey = new IPrivateResource;
    }
    return *fgDLLKey;
}

// ----------------------------------------------------------------------------
// IDLLSet::IDLLSet
// ----------------------------------------------------------------------------
IDLLSet::IDLLSet()
   : fDLLSet(5)
{
}

IDLLSet::~IDLLSet()
{
}



// ----------------------------------------------------------------------------
// IDLLSet::find
// ----------------------------------------------------------------------------
IRefCountedDLLImp* IDLLSet::find(const IRefCountedDLLImp* dllImp)
{
    IRefCountedDLLImp* currentDLLImp = 0;
    IVPtrSet<IRefCountedDLLImp*>::Cursor cursor( fDLLSet );
    bool found = false;
    for (cursor.setToFirst(); cursor.isValid() && found==false; cursor.setToNext())
    {
        currentDLLImp = fDLLSet.elementAt( cursor );
        if ( *currentDLLImp == *dllImp )
            found = true;
    }
    if ( found )
        return currentDLLImp;
    else
        return 0;
}


// ----------------------------------------------------------------------------
// IDLLSet::find
// ----------------------------------------------------------------------------
IRefCountedDLLImp* IDLLSet::find(const IModuleHandle& moduleHandle)
{
    IRefCountedDLLImp* currentDLLImp = 0;
    IVPtrSet<IRefCountedDLLImp*>::Cursor cursor( fDLLSet );
    bool found = false;
    for (cursor.setToFirst(); cursor.isValid() && found==false; cursor.setToNext())
    {
        currentDLLImp = fDLLSet.elementAt( cursor );
        if ( currentDLLImp->handle() == moduleHandle )
            found = true;
    }
    if ( found )
        return currentDLLImp;
    else
        return 0;
}

// ----------------------------------------------------------------------------
// IDLLSet::add
// ----------------------------------------------------------------------------
void IDLLSet::add ( IRefCountedDLLImp* dllImp)
{
    fDLLSet.add(dllImp);
}

// ----------------------------------------------------------------------------
// IDLLSet::remove
// ----------------------------------------------------------------------------
void IDLLSet::remove ( IRefCountedDLLImp* dllImp)
{
    fDLLSet.remove(dllImp);
}
