// Revision: 94 1.14.1.21 source/ui/baseapp/imenubar.cpp, menu, ioc.v400, 990114 
/*******************************************************************************
* FILE NAME: imenubar.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in imenubar.hpp.                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#pragma priority( -2147481424 )

extern "C"
  {
  #define INCL_WINFRAMEMGR
  #define INCL_WINMENUS
  #define INCL_WINWINDOWMGR
  #include <iwindefs.h>

  #ifdef IC_MOTIF
    #include <Xm/RowColumn.h>
    #include <Xm/MainW.h>
  #endif //IC_MOTIF
  }

#include <ibidiset.hpp>
#include <icconst.h>
#include <iexcept.hpp>
#include <iframe.hpp>
#include <iframprv.hpp>
#include <imenubar.hpp>
#include <imenuprv.hpp>
#include <iplatfrm.hpp>
#include <ireslib.hpp>
#include <itrace.hpp>

#ifdef IC_MOTIF
  #include <imbarprv.hpp>
  #include <iwinpriv.hpp>
  #include <icconst.h>
#endif //IC_MOTIF

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IMENUBAR_CPP_
  #include <ipagetun.h>
#endif

// Initialize static objects and notification strings.
#pragma data_seg(ICLStaticConst)
#pragma data_seg()


const IMenuBar::Style
#ifdef IC_PMWIN
  IMenuBar::empty             ( 0, IMBS_EMPTY ),
  IMenuBar::wrapper           ( 0, IMBS_WRAPPER ),
  IMenuBar::classDefaultStyle ( 0, IMBS_EMPTY );
#endif //IC_PMWIN
#ifdef IC_MOTIF
  IMenuBar::empty             (0x01),
  IMenuBar::wrapper           (0x02),
  IMenuBar::classDefaultStyle = IMenuBar::empty;
#endif //IC_MOTIF

IMenuBar::Style IMenuBar::currentDefaultStyle = IMenuBar::classDefaultStyle;


#ifdef IC_MOTIFPM
class MenuBarWindow : public MenuWindow {
typedef MenuWindow
  Inherited;      // 26845A
public:
  MenuBarWindow ( unsigned long        id,
                  unsigned long        style,
                  const IWindowHandle& parent,
                  const IWindowHandle& owner )
  {
#ifdef IC_PM
    IWindowHandle
      whMenu = create( FID_MENU,
                       0,
                       style,
                       WC_MENU,
                       parent,
                       owner,
                       IRectangle(),
                       0,
                       0,
                       IWindow::onTopOfSiblings );
#endif //IC_PM
#ifdef IC_MOTIF
    IWindowHandle
      whMenu = create( IC_FRAME_MENU_ID,
                       NULL,
                       style,
                       (IXmCreateFunction)XmCreateMenuBar,
                       parent,
                       owner,
                       IRectangle(),
                       NULL,
                       0 );
#endif  //IC_MOTIF
    startHandlingEventsFor(whMenu);
  }

virtual
 ~MenuBarWindow ( )
  { }

#ifdef IC_MOTIF
virtual bool
  passEventToOwner ( IEvent& event ); // 26845A
#endif  //IC_MOTIF

}; //class MenuBarWindow
#endif  //IC_MOTIFPM


#ifdef IC_MOTIF 
/*------------------------------------------------------------------------------
| MenuBarWindow::passEventToOwner                                              |
|                                                                              |
| Returns whether or not the event can be passed up to the owner of the        |
| menu bar.                                                                    |
------------------------------------------------------------------------------*/
bool MenuBarWindow::passEventToOwner( IEvent& event ) { // 26845A
  switch ( event.eventId() )
  {
    case WM_BUTTON1DOWN:
    case WM_BUTTON2DOWN:
    case WM_BUTTON3DOWN:
    case WM_BUTTON1UP:
    case WM_BUTTON2UP:
    case WM_BUTTON3UP:
    case WM_BUTTON1CLICK:
    case WM_BUTTON2CLICK:
    case WM_BUTTON3CLICK:
    case WM_BUTTON1DBLCLK:
    case WM_BUTTON2DBLCLK:
    case WM_BUTTON3DBLCLK:
    case WM_CHORD:
    {
      event.setPassToOwner(false);
      break;
    }
    case xEvent(KeyPress):
    {
      IKeyboardEvent keyEvent( event );
      if (keyEvent.isVirtual() )
      {
        if (keyEvent.virtualKey() == IKeyboardEvent::enter )
        {
          event.setPassToOwner(false);
          break;
        }
      }
      break;
    }

    default:
      Inherited::passEventToOwner( event );
      break;
  }
  return event.passToOwner();
}

/*------------------------------------------------------------------------------
| IMenuBarData::IMenuBarData                                     |
------------------------------------------------------------------------------*/
IMenuBarData::IMenuBarData ( )
{
  bMotifWrapper = false;
  frameMBar = NULL;
  frameWin = NULL;
}

/*------------------------------------------------------------------------------
| IMenuBarData::~IMenuBarData                                    |
------------------------------------------------------------------------------*/
IMenuBarData::~IMenuBarData ()
{
}
#endif //IC_MOTIF


/*------------------------------------------------------------------------------
| IMenuBar::IMenuBar                                                           |
|  Create empty or wrapper                                                     |
------------------------------------------------------------------------------*/
IMenuBar::IMenuBar( IFrameWindow* owner,
                    const Style&  style )
#ifdef IC_PMWIN
          : fMenuBarData( 0 )
#else  //IC_PMWIN
          : fMenuBarData(new IMenuBarData() )
#endif //IC_MOTIF
{
   IMODTRACE_DEVELOP("IMenuBar::ctor(1)");
   IASSERTPARM(owner != 0);

   // Set extended style
//AJ: need?   setExtendedStyle( extendedStyle() | style.asExtendedUnsignedLong() );

   /* Check for both empty and wrapper being set,
    * or neither set.
    */
   if ( ( (style & wrapper) && (style & empty) ) ||       // both set
        ( !(style & (wrapper | empty)) ) )     // neither set
   {
     ITHROWLIBRARYERROR(IC_INVALIDSTYLE,
                        IBaseErrorInfo::invalidRequest,
                        IException::recoverable);
   }

#ifdef IC_WIN
   // Query for an existing menu and get the handle of it
   HMENU frameMenuBar = GetMenu( owner->handle() );
   if (style & empty)
   {
     // Create a new empty menu
     fhMenu = CreateMenu();
     fowner = owner->handle();
     fmenuFrame = owner;

     // Set this new menu as the menu for the window
     SetMenu( fowner, fhMenu );

     // If there was a previous menu, destroy it
     if (frameMenuBar)
     {
       DestroyMenu( frameMenuBar );

       // Reset lookup table pointer since menu is now empty
       if (!(IPlatform::isWin9x() || IPlatform::isNTNewShell()))
         owner->fFrameWindowData->fpSubmenuList = 0;
     }

     // We can't give the menu bar bidirectional attributes until
     // it has at least one item, since bidi attributes can only
     // be assigned to menu items. We handle this later in
     // IMenu::addItem.

     // Update frame window to display with new menubar
     DrawMenuBar( fowner );

   }
   else    // it's a wrapper
   {
     if (frameMenuBar == 0) {
       ITHROWLIBRARYERROR(IC_NO_FRAME_MENUBAR,
                          IBaseErrorInfo::invalidRequest,
                          IException::recoverable);
     } /* endif */
     // Save the menu handle and the owner in private data
     fhMenu = frameMenuBar;
     fowner = owner->handle();
     fmenuFrame = owner;
   }
#endif //IC_WIN

#ifdef IC_PM
   HWND frameMenuBar = IWindow::handleWithParent(FID_MENU, owner->handle());
   if (style & empty)
   {
     IWindowHandle ownerHandle(0);
     if (owner)
       ownerHandle = owner->handle();

     MenuBarWindow* menuWindow =
            new MenuBarWindow( FID_MENU,
                                style.asUnsignedLong() | MS_ACTIONBAR |
                                       WS_VISIBLE | WS_SYNCPAINT,
                                ownerHandle,
                                ownerHandle);

     if (frameMenuBar)
        WinDestroyWindow(frameMenuBar);

     owner->postEvent(WM_UPDATEFRAME,            // Cause frame to update
                      IEventData(FCF_MENU, 0),   // to include menu.
                      IEventData());

     // Create a IWindow wrapper for whMenu & make it our non-portable "menu" window
     menuWindow->setMenu( this );
     setWindow(menuWindow);

   }
   else    // it's a wrapper
   {
     if (frameMenuBar == 0)
       ITHROWLIBRARYERROR(IC_NO_FRAME_MENUBAR,
                          IBaseErrorInfo::invalidRequest,
                          IException::recoverable);
     // Create a IWindow wrapper for frameMenuBar & make it our non-portable "menu" window
     MenuWindow* menuWindow = dynamic_cast<MenuWindow*>(
        IWindow::windowWithHandle((IWindowHandle)frameMenuBar));
     if (!menuWindow)
        menuWindow = new MenuWindow((IWindowHandle)frameMenuBar, 0);
     menuWindow->setAutoDestroyWindow(false);
     menuWindow->reserveUserWindowWord( false );
     menuWindow->setMenu( this );
     setWindow(menuWindow);
   }
#endif //IC_PM

#ifdef IC_MOTIF
   /* Obtain the owner's "MainWindow" child; Menu Bar
    * must be created on the MainWindow and not BullitenBoard
    */
   IWindowHandle
     mainWHandle = IXmMainWindow::getMainWindowChild( owner->handle() );
   IASSERTPARM( mainWHandle != 0 );

   Widget frameMenuBar=0, curCmdWindow=0, curHScroll=0, curVScroll=0, curWork=0;
   XtVaGetValues(mainWHandle,
                 XmNmenuBar, &frameMenuBar,
                 XmNcommandWindow, &curCmdWindow,
                 XmNhorizontalScrollBar, &curHScroll,
                 XmNverticalScrollBar, &curVScroll,
                 XmNworkWindow, &curWork,
                 NULL);

   if (style & empty)
   {
      // Create the menubar object (note we can't call
      // create(...,IWindow*, IWindow*,...) here, parent
      // is a raw widget.
     MenuBarWindow* menuWindow =
        new MenuBarWindow( IC_FRAME_MENU_ID,
                            style.asUnsignedLong(),
                            mainWHandle,
                            owner->handle() );
     menuWindow->setMenu(this);
     setWindow(menuWindow);
     registerCallbacks();   //call private method to register necessary menu callbacks

     // If there was an old menu bar object, destroy it.
     if (frameMenuBar)
         XtDestroyWidget(frameMenuBar);

     // Install the object just created as the menu bar on the frame
     XmMainWindowSetAreas(mainWHandle,          // Cause frame to update
                          menuWindow->handle(), // to include menu.
                          curCmdWindow,
                          curHScroll,
                          curVScroll,
                          curWork);

     XtManageChild(menuWindow->handle());
     show();
  }
  else    // it's a wrapper
  {
     if (frameMenuBar == 0)
       ITHROWLIBRARYERROR(IC_NO_FRAME_MENUBAR,
                          IBaseErrorInfo::invalidRequest,
                          IException::recoverable);

     /* Wrapper the previously created menuBar (frameMenuBar) by :
      *    1. if it exists, remove the previously-created frameMenuBar
      *       IWindow wrapper from window list (freeing its handlers);
      *    2. delete our current fMenuData;
      *    3. set this IMenu::fMenuData with same IMenu::fMenuData as the
      *       previously created menuBar (if it exists); use getPData()
      *       because it handles reference counting for pData
      */
     MenuWindow* menuBarWrapper = dynamic_cast<MenuWindow*> (
       IWindow::windowWithHandle(IWindowHandle(frameMenuBar)) );
     IMenuBar* priorMBar = owner->fFrameWindowData->menuBar();
     // Application is allowed ONLY a SINGLE menubar wrapper (not to
     // include the IOC menubar wrapper ctored by the IFrameWindow.
     // Attempting to have more than a SINGLE menubar wrapper causes
     // an exception to be thrown.
     if ( menuBarWrapper && menuBarWrapper->menu() != priorMBar)
        ITHROWLIBRARYERROR(IC_INVALID_MENU_WRAPPER,
                           IBaseErrorInfo::invalidRequest,
                           IException::recoverable);
 
     if (menuBarWrapper)
     {
       //NOTYET
//       menuBarWrapper->setAutoDestroyWindow( false );  // Do not destroy widget.
       IWindow::removeFromWindowSet(menuBarWrapper);

       IMenu* oldMenu = menuBarWrapper->menu();
       if (oldMenu && oldMenu->fMenuData)
       {
          // Copy menu data from old wrapper, and increment reference count.
          delete this->fMenuData;
          this->fMenuData = &(oldMenu->fMenuData->getPData());
       }
     }
     /*    4. Create a fresh IWindow wrapper for the frameMenuBar widget
      *       and make it our non-portable "menu" window. This wrapper IWindow
      *       will be automatically deleted when the widget is destroyed, but
      *       will leave this menubar widget intact when the wrapper is deleted;
      *    5. Store pointer to this as a window attribute of the fresh IWindow wrapper
      */
     MenuWindow* menuWindow = new MenuWindow((IWindowHandle)frameMenuBar, 0);
     menuWindow->setMenu( this );
     menuWindow->setAutoDestroyWindow(false);
     setWindow(menuWindow);

     registerCallbacks();   //call private method to register necessary menu callbacks
     window()->setOwner( owner );

     /*    6. set this fMenuData::pMenu with the IMenu* of this object;
      *    7. set wrapper flag;
      *    8. save IMenuBar widget;
      *    9. save IFrameWindow pointer
          10. manage the widget (to insure it shows up)       //AJ:26232
      */
     this->fMenuData->pMenu = (IMenu*) this;
     fMenuBarData->bMotifWrapper = true;
     fMenuBarData->frameMBar = this->window()->handle();
     fMenuBarData->frameWin = (IFrameWindow*)this->owner();
     XtManageChild(menuWindow->handle());                     //AJ:26232
  }
#endif //IC_MOTIF
}

/*------------------------------------------------------------------------------
| IMenuBar::IMenuBar                                                           |
|  Create the menu from resource file                                          |
------------------------------------------------------------------------------*/
IMenuBar::IMenuBar( const IResourceId& menuResId,
                    IFrameWindow*      owner )
#ifdef IC_PMWIN
          : fMenuBarData( 0 )
#else  //IC_PMWIN
          : fMenuBarData(new IMenuBarData() )
#endif //IC_MOTIF
{
   IMODTRACE_DEVELOP("IMenuBar::ctor(2)");
   IASSERTPARM(owner);

#ifdef IC_WIN
   // Query for an existing menu and get the handle of it
   HMENU frameMenuBar = GetMenu( owner->handle() );
   fhMenu = (void*)
     (menuResId.resourceLibrary()).loadMenu(menuResId, owner);

   // set owner handle
   fowner = owner->handle();
   fmenuFrame = owner;

   // Set this new menu as the menu for the window
   SetMenu( fowner, fhMenu );

   // If there was a previous menu, destroy it
   if (frameMenuBar)
     DestroyMenu( frameMenuBar );

   // Build the lookup table for this if old menu style
   if (!(IPlatform::isWin9x() || IPlatform::isNTNewShell()))
   {
     if (frameMenuBar)
       IMenuPrivate::deleteLookUpTable( fmenuFrame );
     IMenuPrivate::buildLookUpTableFromResourceLoad( fmenuFrame,
                                                     fhMenu, menuResId );
   }

   // Let the menu bar inherit the bidi attributes of its owner.
   if ( IBidiSettings::isBidiSupported() )
   {
      IBidiSettings
        bidiSettings( *owner );
      IMenuPrivate::setBidiAttributes( fhMenu, bidiSettings );
   }

   // Update frame window to display with new menubar
   DrawMenuBar( fowner );
#endif //IC_WIN

#ifdef IC_PM
   HWND frameMenuBar = IWindow::handleWithParent(FID_MENU, owner->handle());
   IWindowHandle whMenu =
     (menuResId.resourceLibrary()).loadMenu(menuResId, owner);
   if (frameMenuBar)
   {       //Destroy the old FID_MENU (wrapper window) & IMenuBar
     MenuWindow* menuBarWrapper = dynamic_cast<MenuWindow*>(
       IWindow::windowWithHandle(IWindowHandle(frameMenuBar)));
     if (menuBarWrapper)
     {
       IMenu* oldMenu = menuBarWrapper->menu();
       if (oldMenu)
          delete oldMenu;
       else
          delete menuBarWrapper;
     }
     else
     {
       WinDestroyWindow(frameMenuBar);
     }
   }

   // Create a IWindow wrapper for whMenu & make it our non-portable "menu" window
   MenuWindow* menuWindow = new MenuWindow((IWindowHandle)whMenu, 0);
   menuWindow->reserveUserWindowWord( false );
   menuWindow->setMenu( this );
   setWindow(menuWindow);

   owner->postEvent(WM_UPDATEFRAME,            // Cause frame to update
                    IEventData(FCF_MENU, 0),   // to include menu.
                    IEventData());
#endif //IC_PM

#ifdef IC_MOTIF
   /* Obtain the owner's "MainWindow" child; Menu Bar
    * must be created on the MainWindow and not BullitenBoard
    */
   IWindowHandle
   mainWHandle = IXmMainWindow::getMainWindowChild( owner->handle() );
   IASSERTPARM( mainWHandle != 0 );

   Widget frameMenuBar=0, curCmdWindow=0, curHScroll=0, curVScroll=0, curWork=0;
   XtVaGetValues(mainWHandle,
                 XmNmenuBar, &frameMenuBar,
                 XmNcommandWindow, &curCmdWindow,
                 XmNhorizontalScrollBar, &curHScroll,
                 XmNverticalScrollBar, &curVScroll,
                 XmNworkWindow, &curWork,
                 NULL);

   /* Wrapper the previously created menuBar (frameMenuBar) if
    *   it was created by the IFrameWindow accelerator or menuBar
    *   style.  Wrapper if frameWindow Id equals current menuBar
    *   id and equals desired menuBar id.
    */
   MenuWindow* menuBarWrapper = dynamic_cast<MenuWindow*>(
     IWindow::windowWithHandle(IWindowHandle(frameMenuBar)) );
   IMenuBar* priorMBar = owner->fFrameWindowData->menuBar();
   // Application is allowed ONLY a SINGLE menubar wrapper (not to
   // include the IOC menubar wrapper ctored by the IFrameWindow.
   // Attempting to have more than a SINGLE menubar wrapper causes
   // an exception to be thrown.
   if ( menuBarWrapper && menuBarWrapper->menu() != priorMBar)
      ITHROWLIBRARYERROR(IC_INVALID_MENU_WRAPPER,
                         IBaseErrorInfo::invalidRequest,
                         IException::recoverable);

   if ( (frameMenuBar) && (menuBarWrapper) &&
        (owner->id() == menuBarWrapper->id()) &&
        (owner->id() == menuResId.id()) )
   {

     /* Wrapper the previously created menu bar widget (frameMenuBar) by :
      *    1. removing the previously created frameMenuBar IWindow wrapper
      *       from window list (freeing its handlers), & delete the associated IMenuBar;
      *    2. allow IWindow destructor to destroy the IWindow wrapper
      *         object while leaving the menubar widgets intact;
      *    3. delete this IMenu::fMenuData;
      *    4. set this IMenu::fMenuData with same IMenu::fMenuData as the
      *       previously created menuBar; use getPData() because it
      *       handles reference counting for pData
      */
     //NOTYET
     IWindow::removeFromWindowSet(menuBarWrapper);

     IMenu* oldMenu = menuBarWrapper->menu();
     if (oldMenu && oldMenu->fMenuData)
     {
        // Copy menu data from old wrapper, and increment reference count.
        delete this->fMenuData;
        this->fMenuData = &(oldMenu->fMenuData->getPData());
     }
     /*    5. Create a fresh IWindow wrapper for the frameMenuBar widget
      *       and make it our non-portable "menu" window. This wrapper IWindow
      *       will be automatically deleted when the widget is destroyed, but
      *       will leave this menubar widget intact when the wrapper is deleted;
      *    6. Store pointer to this as a window attribute of the fresh IWindow wrapper,
      *       and also save the wrapper window ptr in this IMenu (via setWindow).
      *    7. register the callbacks IMenuBar needs (when the old IMenuBar is destructed,
              one set of callbacks will be removed. Since they are the same callbacks, it
              doesn't matter which set is "unregistered" as long as we still have a set left
              in place for THIS IMenuBar object to use AND they are in place after adding children;
      *    8. make a note of who our owner is
      */
     MenuWindow* menuWindow = new MenuWindow((IWindowHandle)frameMenuBar, 0);
     menuWindow->setAutoDestroyWindow(false);
     menuWindow->setMenu(this);
     setWindow(menuWindow);
     registerCallbacks();
     window()->setOwner( owner );

     /*    8. set this fMenuData::pMenu with the IMenu* of this object;
      *    9. set wrapper flag;
      *   10. save IMenuBar widget;
      *   11. save IFrameWindow pointer
      */
     this->fMenuData->pMenu = (IMenu*) this;
     fMenuBarData->bMotifWrapper = true;
     fMenuBarData->frameMBar = this->window()->handle();
     fMenuBarData->frameWin = (IFrameWindow*)this->owner();
   }
   else
   {
     // Create the menubar object (note we can't call
     // create(...,IWindow*, IWindow*,...) here, parent
     // is a raw widget.
     MenuBarWindow* menuWindow =
        new MenuBarWindow( menuResId.id(),
                            0,
                            mainWHandle,
                            owner->handle() );
     menuWindow->setAutoDestroyWindow(false);
     menuWindow->setMenu(this);
     setWindow(menuWindow);
     // load the resources into the menu
     menuResId.resourceLibrary().loadMenu(menuResId.id(),
                                          menuWindow->handle(),
                                          this);
     registerCallbacks();   //register menu callbacks after adding any menu items
                            //  This way, button gadgets don't get this callback,
                            //  and all menu-related events passed to the menubar.

     // If there was an old menu bar object, destroy it.
     if(frameMenuBar)                     //Destroy the old FID_MENU
        XtDestroyWidget(frameMenuBar);

     // Install the object just created as the menu bar on the frame
     XmMainWindowSetAreas(mainWHandle,           // Cause frame to update
                          menuWindow->handle(),  // to include menu.
                          curCmdWindow,
                          curHScroll,
                          curVScroll,
                          curWork);

     XtManageChild(menuWindow->handle());
     show();
   }   // end else
#endif //IC_MOTIF
}


/*------------------------------------------------------------------------------
| IMenuBar::~IMenuBar                                                          |
------------------------------------------------------------------------------*/
IMenuBar::~IMenuBar()
{
   IMODTRACE_DEVELOP("IMenuBar::~IMenuBar");
#ifdef IC_MOTIF
   if (fMenuBarData->bMotifWrapper)
   {
     if (isValid())
     {
       // remove any callbacks registered (e.g., during object construction)
       unregisterCallbacks();

       /* Reinstate previously removed menuBar (held in the IFrameWindow)  AJ:?????
        *  as a valid IMenuBar by giving it the IWindow wrapper for the
        *  menuBar widget, which this no longer needs. If there is no
        *  previously removed menuBar, delete the wrapper.
        */
       IFrameWindow* curFrameWin = fMenuBarData->frameWin;
       IMenuBar* priorMBar = curFrameWin->fFrameWindowData->menuBar();
       if (priorMBar)
       {
         priorMBar->setWindow(window());
         /*  Set reinstated pData::pMenu with its own IMenu*  */
         ((IMenu*)priorMBar)->fMenuData->pMenu = (IMenu*)priorMBar;
       }
     }
   }
   delete fMenuBarData;
#endif //IC_MOTIF
}


#ifdef IC_WIN
/*------------------------------------------------------------------------------
| IMenuBar::setMenu                                                            |
|  Set a new menu (populated by the caller). The previous menu-bar is destroyed|
------------------------------------------------------------------------------*/
IMenuBar& IMenuBar::setMenu( const IMenuHandle& menuHandle )
{
  SetMenu(fowner, menuHandle);
  // If there was a previous menu, destroy it
  if (fhMenu)
    DestroyMenu(fhMenu);
  fhMenu = menuHandle;
  // Update frame window to display with new menubar
  DrawMenuBar(fowner);
  return *this;
}
#endif


/*------------------------------------------------------------------------------
| IMenuBar::setMenu                                                            |
|  Set a new menu resource ID. The previous menu-bar is destroyed.             |
------------------------------------------------------------------------------*/
IMenuBar& IMenuBar::setMenu(const IResourceId& menuResId)
{

#ifdef IC_WIN
   // Query for an existing menu and get the handle of it
   IMenuHandle oldMenuBar = fhMenu;
   fhMenu = (void*)
     (menuResId.resourceLibrary()).loadMenu(menuResId, owner());
   // Set this new menu as the menu for the window
   SetMenu( fowner, fhMenu );

   // If there was a previous menu, destroy it
   if (oldMenuBar)
     DestroyMenu( oldMenuBar );

   // If old menu style, get rid of old lookup table and then build new one
   if (!(IPlatform::isWin9x() || IPlatform::isNTNewShell()))
   {
     if (oldMenuBar)
       IMenuPrivate::deleteLookUpTable( fmenuFrame );
     IMenuPrivate::buildLookUpTableFromResourceLoad( fmenuFrame,
                                                     fhMenu, menuResId );
   }

   // Let the menu bar inherit the bidi attributes of its owner.
   if ( IBidiSettings::isBidiSupported() )
   {
      if ( fowner )
      {
         // Give the menu the bidi attributes of the owner window.
         IBidiSettings
           bidiSettings( fowner );
         IMenuPrivate::setBidiAttributes( fhMenu, bidiSettings );
      }
      else
      {
         // Give the menu default bidi attributes.
         IBidiSettings
           bidiSettings( IBidiSettings::applicationDefaults() );
         IMenuPrivate::setBidiAttributes( fhMenu, bidiSettings );
      }
   }

   // Update frame window to display with new menubar
   DrawMenuBar( fowner );
#endif //IC_WIN

#ifdef IC_PM
   IWindowHandle hwndMenu =
     (menuResId.resourceLibrary()).loadMenu(menuResId, owner());
   if (id() != FID_MENU) {
      WinSetWindowUShort(hwndMenu,  //Menu window ID is create with
                         QWS_ID,    //FID_MENU. Change it.
                         (unsigned short)id());
   }
   else {
     IWindow* powner = owner();
     if (window()->isValid()) {
       // Delete the old menubar wrapper and create a new wrapper for the new hwndMenu
       window()->setAutoDestroyWindow(true);  //We want to destroy the old menubar hwnd, too
       delete window();
     }
     MenuWindow* menuWindow = new MenuWindow((IWindowHandle)hwndMenu, 0);
     menuWindow->reserveUserWindowWord( false );
     menuWindow->setMenu(this);
     setWindow(menuWindow);
     powner->postEvent(WM_UPDATEFRAME,              // Cause frame to update
                       IEventData(FCF_MENU, 0),     // to include menu.
                       IEventData());
   } /* endif */
#endif //IC_PM


#ifdef IC_MOTIF
   IWindow* powner = owner();

   // Obtain the owner's "MainWindow" child; Menu Bar
   // must be created on the MainWindow

// d8175 - Need to ignore children being destroyed.
// Also need to allow for more than one child (MBCS status area can cause this).
//
//   IWindowHandle mainWHandle = NULL;
//   WidgetList children = NULL;
//   Cardinal numChildren = 0;
//   XtVaGetValues (powner->topHandle(),
//                  XmNchildren, &children,
//                  XmNnumChildren, &numChildren,
//                  NULL);
//   if (numChildren==1)
//     mainWHandle = children[0];
//   IASSERTPARM( XmIsMainWindow(mainWHandle) );
//
   IWindowHandle
   mainWHandle = IXmMainWindow::getMainWindowChild( powner->handle() );
   IASSERTPARM( mainWHandle != 0 );

   Widget frameMenuBar=0, curCmdWindow=0, curHScroll=0, curVScroll=0, curWork=0;
   XtVaGetValues(mainWHandle,
                 XmNmenuBar, &frameMenuBar,
                 XmNcommandWindow, &curCmdWindow,
                 XmNhorizontalScrollBar, &curHScroll,
                 XmNverticalScrollBar, &curVScroll,
                 XmNworkWindow, &curWork,
                 NULL);

   IWindow* menuBarWrapper =
      IWindow::windowWithHandle(IWindowHandle(frameMenuBar));

   //We do not need to switch widgets within "this", we can switch wrapper
   //windows (set by setWindow()) & destroy the old one.
   unregisterCallbacks(); 

   // before deleting window loop through menu and delete
   //  all submenus
   IMenu::Cursor cursor(*this);   // 27835A 
   cursor.setToFirst();           // 27835A
   while (cursor.isValid()) {     // 27835A
       IMenuItem element = this->elementAt(cursor);   // 27835A
       if (element.isSubmenu()) {            // 27835A
           /* if have a submenu, remove the submenu */
           this->removeSubmenuAt(cursor);    // 27835A
       } else { 
           /* otherwise have a menu item, remove it */
           this->deleteAt(cursor);           // 27835A
       }
       cursor.setToFirst();                  // 27835A
   }
   
   delete window();

   // Create the menubar object (note we can't call
   // create(...,IWindow*, IWindow*,...) here, parent
   // is a raw widget.
   MenuBarWindow* menuWindow =
      new MenuBarWindow( menuResId.id(),
                          0,
                          mainWHandle,
                          powner->handle() );
   menuWindow->setMenu( this );
   setWindow(menuWindow);
   // load the resources into the menu
   menuResId.resourceLibrary().loadMenu(menuResId.id(),
                                        menuWindow->handle(),
                                        this);

   // The following is necessary for the menu to show up when changed on the
   // fly.
   XtManageChild( menuWindow->handle() );
   show();
   XMapWindow( XtDisplay(menuWindow->handle()), XtWindow(menuWindow->handle()) );

   // Install the object just created as the menu bar on the frame
   XmMainWindowSetAreas(mainWHandle,            // Cause frame to update
                        menuWindow->handle(),   // to include menu.
                        curCmdWindow,
                        curHScroll,
                        curVScroll,
                        curWork);
#endif //IC_MOTIF

   return *this;
}

/*------------------------------------------------------------------------------
| IMenuBar::Style  IMenuBar :: defaultStyle                                    |
|                                                                              |
| Return the default style for new menu bar objects.                           |
------------------------------------------------------------------------------*/
IMenuBar::Style IMenuBar::defaultStyle()
{
  return currentDefaultStyle;
}

#ifdef IC_WIN
/*------------------------------------------------------------------------------
| IMenuBar::setDefaultStyle                                                    |
|                                                                              |
| Set the default style for new menu bar objects.                              |
------------------------------------------------------------------------------*/
void IMenuBar::setDefaultStyle( const IMenuBar::Style& newDefault )
{
  currentDefaultStyle = newDefault;
}
#endif

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IMenuBar::registerCallbacks                                                  |
|                                                                              |
| Add callbacks and X event handlers for events which menu bar can             |
| experience.                                                                  |
------------------------------------------------------------------------------*/
void IMenuBar::registerCallbacks()
{
   IWindowHandle widget = window()->handle();   // get validated widget handle
   if ( !XtIsSubclass(widget, xmRowColumnWidgetClass) )
     ITHROWGUIERROR("CantRegisterNonRowColumnWidget");

   // Add the callback to handle the changed flag
   XtAddCallback(
      (Widget)widget,           // widget
      XmNentryCallback,         // callback name
      imenuMotifCallback,       // callback routine
      NULL);                    // client data
}

/*------------------------------------------------------------------------------
| IMenuBar::unregisterCallbacks                                                |
|                                                                              |
| Remove callbacks and X event handlers added in registerCallbacks().          |
------------------------------------------------------------------------------*/
void IMenuBar::unregisterCallbacks()
{
   IWindowHandle widget = window()->handle();   // get validated widget handle
   if ( !XtIsSubclass(widget, xmRowColumnWidgetClass) )
     ITHROWGUIERROR("CantRegisterNonRowColumnWidget");

   // Remove the callback to handle the changed flag
   XtRemoveCallback(
      (Widget)widget,           // widget
      XmNentryCallback,         // callback name
      imenuMotifCallback,       // callback routine
      NULL);                    // client data
}
#endif //IC_MOTIF
