// Revision: 85 1.7.1.10 source/ui/basectl/iiconctl.cpp, staticctls, ioc.v400, 990114 
/*******************************************************************************
* FILE NAME: iiconctl.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in iiconctl.hpp.                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#pragma priority( -2147481524 )

// #define IC_TRACE_ALL

extern "C"
{
  #define INCL_GPIBITMAPS
  #define INCL_WINPOINTERS
  #define INCL_WINSTATICS           // SS_xxx
  #include <iwindefs.h>
}

#include <ibmpdata.hpp>
#include <ibmpstat.hpp>
#include <icconst.h>
#include <idefstyl.h>
#include <iexcept.hpp>
#include <ihandle.hpp>
#include <iiconctl.hpp>
#include <iiconhdr.hpp>
#include <ipoint.hpp>
#include <irect.hpp>
#include <ireslib.hpp>
#include <istring.hpp>
#include <ithread.hpp>
#include <iiconctp.hpp>
#include <iplatfrm.hpp>
#include <itrace.hpp>

// Segment definitions.
#ifdef IC_PAGETUNE
  #define _IICONCTL_CPP_
  #include <ipagetun.h>
#endif

/***************************************************************/
/* Public icon styles.                                         */
/***************************************************************/
const IIconControl::Style
#if (IC_OBSOLETE <= IC_OBSOLETE_3)
  IIconControl::sizeToIcon        (1, IIconControl__sizeToIcon       ),
#endif // IC_OBSOLETE
  IIconControl::sizeImageToWindow (1, IIconControl__sizeImageToWindow),
  IIconControl::sizeWindowToImage (1, IIconControl__sizeWindowToImage),
  IIconControl::classDefaultStyle (2, IIconControl__classDefaultStyle);

/***************************************************************/
/* Default style for new objects (initial value).              */
/***************************************************************/
IIconControl::Style
  IIconControl::currentDefaultStyle(2, IIconControl__classDefaultStyle);

/*------------------------------------------------------------------------------
| IIconControl::IIconControl                                                   |
------------------------------------------------------------------------------*/
IIconControl::IIconControl ( unsigned long      ulId,
                             IWindow*           pwndParent,
                             IWindow*           pwndOwner,
                             const IResourceId& iconId,
                             const IRectangle&  rectInit,
                             const Style&       icsStyle )
  : IBitmapControl(ulId,pwndParent,pwndOwner,
                   IBitmapHandle(),
                   rectInit,
                   IWindow::noStyle)
  , fIconControlData( new IIconControlData )
  , iconHandle(0)
  , returnback(false)
{
  IMODTRACE_ALL("IIconControl::IIconControl (IResourceId)");
  // Assertions on input parms.

  IASSERTPARM(pwndParent!=0);
  initialize(icsStyle );

  fIconControlData->fdefaultHandler.handleEventsFor( this );
  setIcon(iconId);                // Load and set icon.
  if (icsStyle & IWindow::visible)
  {
     show();
     refresh(IWindow::immediate);
  }
}

/*------------------------------------------------------------------------------
| IIconControl::IIconControl                                                   |
------------------------------------------------------------------------------*/
IIconControl::IIconControl ( unsigned long     ulId,
                             IWindow*          pwndParent,
                             IWindow*          pwndOwner,
                             unsigned long     iconId,
                             const IRectangle& rectInit,
                             const Style&      icsStyle )
  : IBitmapControl(ulId,pwndParent,pwndOwner,IBitmapHandle(),
                   rectInit,
                   IWindow::noStyle)
  , fIconControlData( new IIconControlData )
  , iconHandle(0)
  , returnback(false)
{
  IMODTRACE_ALL("IIconControl::IIconControl (unsigned long)");
  // Assertions on input parms.
  IASSERTPARM(pwndParent!=0);
  initialize(icsStyle);
  fIconControlData->fdefaultHandler.handleEventsFor( this );
  setIcon(iconId);                // Load and set icon.
  if (icsStyle & IWindow::visible)
  {
     show();
     refresh(IWindow::immediate);
  }
}

/*------------------------------------------------------------------------------
| IIconControl::IIconControl                                                   |
------------------------------------------------------------------------------*/
IIconControl::IIconControl ( unsigned long         ulId,
                             IWindow*              pwndParent,
                             IWindow*              pwndOwner,
                             const IPointerHandle& iconId,
                             const IRectangle&     rectInit,
                             const Style&          icsStyle )
  : IBitmapControl(ulId,pwndParent,pwndOwner,IBitmapHandle(),
                   rectInit,
                   IWindow::noStyle)
  , fIconControlData( new IIconControlData )
  , iconHandle(0)
  , returnback(false)
{
  IMODTRACE_ALL("IIconControl::IIconControl (IPointerHandle)");
  // Assertions on input parms.
  IASSERTPARM(pwndParent!=0);
  initialize(icsStyle);
  fIconControlData->fdefaultHandler.handleEventsFor( this );
  setIcon(iconId);                // Load and set icon.
  if (icsStyle & IWindow::visible)
  {
     show();
     refresh(IWindow::immediate);
  }
}

/*------------------------------------------------------------------------------
| IIconControl::IIconControl                                                   |
|  Construct an icon control on a standard window using a                      |
|  system-provided icon.                                                       |
------------------------------------------------------------------------------*/
IIconControl::IIconControl ( unsigned long                      ulId,
                             IWindow*                           pwndParent,
                             IWindow*                           pwndOwner,
                             ISystemPointerHandle::EPointerType icon,
                             const IRectangle&                  rectInit,
                             const Style&                       icsStyle )
  : IBitmapControl(ulId,pwndParent,pwndOwner,IBitmapHandle(),
                   rectInit,
                   IWindow::noStyle)
  , fIconControlData( new IIconControlData )
  , iconHandle(0)
  , returnback(false)
{
  IMODTRACE_ALL("IIconControl::IIconControl (EPointerType)");
  // Assertions on input parms.
  IASSERTPARM(pwndParent!=0);
  initialize(icsStyle);
  fIconControlData->fdefaultHandler.handleEventsFor( this );
  ISystemPointerHandle tmp(icon);
  setIcon(tmp);                  // Associate with control.
  if (icsStyle & IWindow::visible)
  {
     show();
     refresh(IWindow::immediate);
  }
}

#if (IC_OBSOLETE <= IC_OBSOLETE_3)
/*------------------------------------------------------------------------------
| IIconControl::IIconControl                                                   |
|  Construct an icon control on a standard window using a                      |
|  system-provided icon.                                                       |
------------------------------------------------------------------------------*/
IIconControl::IIconControl ( unsigned long                    ulId,
                             IWindow*                         pwndParent,
                             IWindow*                         pwndOwner,
                             ISystemPointerHandle::Identifier icon,
                             const IRectangle&                rectInit,
                             const Style&                     icsStyle )
  : IBitmapControl(ulId,pwndParent,pwndOwner,IBitmapHandle(),
                   rectInit,
                   IWindow::noStyle)
  , fIconControlData( new IIconControlData )
  , iconHandle(0)
  , returnback(false)
{
  IMODTRACE_ALL("IIconControl::IIconControl (Identifier)");
  // Assertions on input parms.
  IASSERTPARM(pwndParent!=0);
  initialize(icsStyle);
  fIconControlData->fdefaultHandler.handleEventsFor( this );
  ISystemPointerHandle tmp(icon);
  setIcon(tmp);                  // Associate with control.
  if (icsStyle & IWindow::visible)
  {
     show();
     refresh(IWindow::immediate);
  }
}
#endif // IC_OBSOLETE

/*------------------------------------------------------------------------------
| IIconControl::IIconControl                                                   |
|  Construct on a tag template window.                                         |
------------------------------------------------------------------------------*/
IIconControl::IIconControl ( unsigned long ulId,
                             IWindow*      pdlgwndParent )
  : IBitmapControl(ulId,pdlgwndParent)
  , fIconControlData( new IIconControlData )
  , iconHandle(0)
  , returnback(true)
{
  IMODTRACE_ALL("IIconControl::IIconControl (dialog template)");
#ifdef IC_PMWIN
  unsigned long ulStyle = style();
#ifdef IC_PM
  IEventResult evt = handle().sendEvent( SM_QUERYHANDLE,
                                         IEventParameter1( 0 ),
                                         IEventParameter2( 0 ));
  HPOINTER pnt=evt.asUnsignedLong();
  ulStyle &= (unsigned long)(~SS_ICON);
  ulStyle |= SS_TEXT;
#endif
#ifdef IC_WIN
  IEventResult evt = handle().sendEvent( STM_GETICON,
                                         IEventParameter1( 0 ),
                                         IEventParameter2( 0 ));
  HCURSOR  pnt= evt;
  ulStyle &= (unsigned long)(~SS_TYPEMASK);
  ulStyle |= SS_LEFT;
#endif
  setStyle(ulStyle);
  setIcon(IPointerHandle(pnt));
  fIconControlData->fdefaultHandler.handleEventsFor( this );
#endif // IC_PMWIN
}

/*------------------------------------------------------------------------------
| IIconControl::IIconControl                                                   |
|  Constructor to instantiate from an existing icon control.                   |
------------------------------------------------------------------------------*/
IIconControl::IIconControl ( const IWindowHandle& wh )
  : IBitmapControl(wh)
  , fIconControlData( new IIconControlData )
  , iconHandle(0)
  , returnback(true)
{
  IMODTRACE_ALL("IIconControl::IIconControl (wrapper)");
#ifdef IC_PMWIN
  unsigned long ulStyle = style();
#ifdef IC_PM
  HPOINTER pnt=0;
  if (ulStyle & (SS_ICON & ~SS_TEXT))
  {
     IEventResult evt = handle().sendEvent( SM_QUERYHANDLE,
                                            IEventParameter1( 0 ),
                                            IEventParameter2( 0 ));
     pnt=evt.asUnsignedLong();
  } /* endif */
  ulStyle &= (unsigned long)(~SS_ICON);
  ulStyle |= SS_TEXT;
#endif
#ifdef IC_WIN
  HCURSOR pnt=0;
  if ( (ulStyle & SS_TYPEMASK) == SS_ICON )
  {
     IEventResult evt = handle().sendEvent( SM_QUERYHANDLE,
                                            IEventParameter1( 0 ),
                                            IEventParameter2( 0 ));
     pnt = evt;
  } /* endif */
  ulStyle &= (unsigned long)(~SS_TYPEMASK);
  ulStyle |= SS_LEFT;
#endif
  fIconControlData->fdefaultHandler.handleEventsFor( this );
  setStyle(ulStyle);
  setIcon(IPointerHandle(pnt));
#endif // IC_PMWIN
}

/*------------------------------------------------------------------------------
| IIconControl::~IIconControl                                                  |
------------------------------------------------------------------------------*/
IIconControl::~IIconControl ( )
{
  IMODTRACE_ALL("IIconControl::~IIconControl");
  fIconControlData->fdefaultHandler.stopHandlingEventsFor( this );
#ifdef IC_PMWIN
  if (returnback)
  {
     try
     {
        unsigned long ulStyle = style();
#ifdef IC_PM
        ulStyle &= (SS_ICON | (unsigned long)(~SS_TEXT));
#endif
#ifdef IC_WIN
        ulStyle = (unsigned long)
            ((ulStyle & (unsigned long)~(SS_TYPEMASK)) | SS_ICON) ;
#endif
        setStyle(ulStyle);
        handle().sendEvent(SM_SETHANDLE, IEventParameter1(iconHandle),
                                         IEventParameter2(0));
     } catch (IException&) {}
  }
#endif // IC_PMWIN

  delete fIconControlData;
}

/*------------------------------------------------------------------------------
| IIconControl::Style  IIconControl::defaultStyle                              |
------------------------------------------------------------------------------*/
IIconControl::Style IIconControl::defaultStyle ( )
{
  return currentDefaultStyle;
}

/*------------------------------------------------------------------------------
| IIconControl::setDefaultStyle                                                |
------------------------------------------------------------------------------*/
void IIconControl::setDefaultStyle ( const IIconControl::Style& icsStyle )
{
  currentDefaultStyle = icsStyle;
}

/*------------------------------------------------------------------------------
| IIconControl::convertToGUIStyle                                              |
|                                                                              |
| Returns base style for the control by default, or extended style if          |
| extended flag (bExtOnly) is set.                                             |
------------------------------------------------------------------------------*/
unsigned long IIconControl::convertToGUIStyle ( const IBitFlag& guiStyle,
                                                bool bExtOnly ) const
{
  // Obtain the style from the class (IBitmapControl) that we inherit from.
  return Inherited::convertToGUIStyle( guiStyle, bExtOnly );

  // No additional processing as IBitmapControl::convertToGUIStyle will do all
  // the required processing.
}

/*------------------------------------------------------------------------------
| IIconControl::setIcon                                                        |
------------------------------------------------------------------------------*/
IIconControl& IIconControl::setIcon ( unsigned long iconId )
{
  setIcon(IResourceId(iconId));
  return *this;
}

/*------------------------------------------------------------------------------
| IIconControl::setIcon                                                        |
------------------------------------------------------------------------------*/
IIconControl& IIconControl::setIcon ( const IResourceId& iconId )
{
  IPointerHandle ph = iconId.resourceLibrary().loadIcon(iconId);
                                  // Load from resource library.
  setIcon(ph);
  return *this;
}

/*------------------------------------------------------------------------------
| IIconControl::setIcon                                                        |
------------------------------------------------------------------------------*/
IIconControl& IIconControl::setIcon ( const IPointerHandle& phHandle )
{
  IMODTRACE_ALL("IIconControl::setIcon");

  iconHandle = phHandle;
  this->setBitmap( IBitmapHandle(0) );

  if ( this->isSizeWindowToImageEnabled() )
     this->sizeTo( this->calcMinimumSize() );

#ifdef IC_PMWIN
  // Since the new icon being displayed may have transparent pels, we
  // need to force the parent window to repaint the background (unless
  // we have a style of fillBackground in which case we do the
  // painting already).
  if (!this->hasFillBackground() && this->parent())
  {
     this->parent()->refresh(this->rect());
  }
#endif //IC_PMWIN

  // Force a redraw.
  this->refresh();

  return *this;
}

/*------------------------------------------------------------------------------
| IIconControl::setIcon                                                        |
------------------------------------------------------------------------------*/
IIconControl& IIconControl::setIcon ( ISystemPointerHandle::Identifier icon )
{
  setIcon(ISystemPointerHandle(icon));
  return *this;
}

/*------------------------------------------------------------------------------
| IIconControl::icon                                                           |
------------------------------------------------------------------------------*/
IPointerHandle IIconControl::icon ( ) const
{
  return iconHandle;
}

/*------------------------------------------------------------------------------
| IIconControl::calcMinimumSize                                                |
|  Calculate the minimum screen size needed by the control                     |
|  which is based on the icon size.                                            |
------------------------------------------------------------------------------*/
ISize IIconControl::calcMinimumSize ( ) const
{
  ISize minSize( Inherited::calcMinimumSize() );

  if ( this->icon() && !this->bitmap() )
  {           // Icon set and no bitmap set via IBitmapControl::setBitmap.
     minSize = minSize.maximum( IIconControlData::iconSize( this->icon() ) );
  }

  return minSize;
}

/*------------------------------------------------------------------------------
| IIconControl::initialize                                                     |
------------------------------------------------------------------------------*/
IIconControl& IIconControl::initialize ( const Style& style )
{
  // Save the extended style to make sure we have a copy of it stored.
  setExtendedStyle( extendedStyle() | style.asExtendedUnsignedLong() );

  if (style & IIconControl::sizeImageToWindow)
     enableSizeImageToWindow( true );
  if ((style & IIconControl::sizeWindowToImage)
#if (IC_OBSOLETE <= IC_OBSOLETE_3)
      || (style & IIconControl::sizeToIcon)
#endif
      )
     enableSizeWindowToImage( true );

#ifdef IC_PMWIN
  unsigned long ulStyle = convertToGUIStyle( style );
  if (ulStyle & IWindow::visible.asUnsignedLong())
     ulStyle &= (~IWindow::visible.asUnsignedLong());

  setStyle(ulStyle);
#endif //IC_PMWIN

  return *this;
}

/*------------------------------------------------------------------------------
| IIconControl::visibleRectangle                                               |
|                                                                              |
| Returns the area painted by the icon control.                                |
------------------------------------------------------------------------------*/
IRectangle IIconControl::visibleRectangle ( ) const
{
  // OS2 and windows need the background redrawn by the
  // parent such as a canvas so the visible rect has no size.
  // Motif is implemented such that the image is given to the
  // widget so the parent should not draw over it.
#ifdef IC_PMWIN
  return IRectangle( this->position(), ISize( 0, 0 ));
#endif
#ifdef IC_MOTIF
  return Inherited::visibleRectangle();
#endif
}

/*------------------------------------------------------------------------------
| IIconControlData::IIconControlData                                           |
------------------------------------------------------------------------------*/
IIconControlData::IIconControlData ( )
  : fdefaultHandler()
{ }

/*------------------------------------------------------------------------------
| IIconControlData::~IIconControlData                                          |
------------------------------------------------------------------------------*/
IIconControlData::~IIconControlData ( )
{ }

/*------------------------------------------------------------------------------
| IIconControlData::iconSize                                                   |
| Computes the size of the supplied pointer handle.                            |
------------------------------------------------------------------------------*/
ISize IIconControlData::iconSize( const IPointerHandle& hicon)
{
   ISize imageSize;
   if ((IPointerHandle::Value)hicon != 0)
   {
   #ifdef IC_PM
      POINTERINFO pointerinfo;
      IQUERYPOINTERINFO( hicon, &pointerinfo );
      IBitmapHandle bitmap( pointerinfo.hbmColor == 0 ?
                             pointerinfo.hbmPointer :
                             pointerinfo.hbmColor);

      BITMAPINFOHEADER pbmpData;
      pbmpData.cbFix = sizeof( BITMAPINFOHEADER );
      pbmpData.cx = 0;
      pbmpData.cy = 0;
      if ( !IQUERYBITMAPPARAMETERS( bitmap, &pbmpData ) )
      {
         ITHROWGUIERROR( "IQUERYBITMAPPARAMETERS" );
      }

      imageSize = ISize( pbmpData.cx, pbmpData.cy );
      if ( pointerinfo.hbmColor == 0 )
         imageSize.scaleBy( 1, 0.5 );
   #endif
   #ifdef IC_WIN
      ICONINFO    pointerinfo;
      IQUERYPOINTERINFO( hicon, &pointerinfo );

      IBitmapHandle bitmap( pointerinfo.hbmColor == 0 ?
                             pointerinfo.hbmMask :
                             pointerinfo.hbmColor);
      BITMAP pbmpData;
      if ( !IQUERYBITMAPPARAMETERS( bitmap, &pbmpData ) )
      {
//       ITHROWGUIERROR( "IQUERYBITMAPPARAMETERS" );
         pbmpData.bmWidth = pbmpData.bmHeight = 32;
      }
      else imageSize = ISize( pbmpData.bmWidth, pbmpData.bmHeight );

      if ( pointerinfo.hbmColor == 0 )
         imageSize.scaleBy( 1, 0.5 );

      // Release new bitmaps created by IQUERYPOINTERINFO.
      if ( pointerinfo.hbmMask )
         DeleteObject( pointerinfo.hbmMask );
      if ( pointerinfo.hbmColor )
         DeleteObject( pointerinfo.hbmColor );
   #endif

   #ifdef IC_MOTIF
      // Get the bitmap image or image part of the icon for sizing.
      IBitmapData* bmpdata =
         IBitmapStaticPtr::pointerSet().find( hicon );
      if (!bmpdata)
         bmpdata = IBitmapStaticPtr::bitmapSet().find( hicon );
      if ( bmpdata )
      {
         imageSize = bmpdata->size();
      }
   #endif //IC_MOTIF
   }
   return imageSize;
}
