// Revision: 07 1.20 source/ui/basectl/imcelcvh.cpp, canvas, ioc.v400, 990114 
/*******************************************************************************
* FILE NAME: imcelcvh.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in imcelcvh.hpp.                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
extern "C" {
  #define INCL_WININPUT           // For WM_BUTTONnDOWN.
  #define INCL_WINWINDOWMGR       // For WinQueryMsgPos.
  #define INCL_WINPOINTERS        // For WinSetPointer.
  #define INCL_WINTRACKRECT       // For TRACKINFO, WinTrackRect.
  #define INCL_WINMESSAGEMGR      // For WinMapWindowPoints, WinQueryUpdateRect,
                                  //     WinSet/QueryWindowULong.
  #include <iwindefs.h>
  #ifdef IC_PMWIN
    #include <stdio.h>
  #endif
  }

#include <imcelcvh.hpp>
#include <ibidiset.hpp>
#include <ibundles.hpp>
#include <icmnfun.hpp>
#include <icconst.h>
#include <icolor.hpp>
#include <icoordsy.hpp>
#include <iexcept.hpp>
#include <iexgrprt.hpp>
#include <igarea2d.hpp>
#include <igrport.hpp>
#include <igbase2d.hpp>
#include <imcelcv.hpp>
#include <imcelprv.hpp>
#include <imcelrch.hpp>
#include <ipoint.hpp>
#include <isizeevt.hpp>
#include <itrace.hpp>
#ifdef IC_MOTIF
  #include <isizrect.hpp>
#endif

// Segment definitions.
#ifdef IC_PAGETUNE
  #define _IMCELCVH_CPP_
  #include <ipagetun.h>
#endif


/*------------------------------------------------------------------------------
 Default constructor, empty destructor for page tuning
------------------------------------------------------------------------------*/
IMultiCellCanvasHandler :: IMultiCellCanvasHandler ( )
  : IMultiCellCanvasHandler::Inherited ( )
  { }

IMultiCellCanvasHandler :: ~IMultiCellCanvasHandler ( )
  { }


#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
  dispatchHandlerEvent - Dispatch a handler event,
  performing significant built-in processing for some events.

------------------------------------------------------------------------------*/
bool IMultiCellCanvasHandler::dispatchHandlerEvent ( IEvent& evt )
{
 switch ( evt.eventId() )
 {
   case WM_PAINT:
   {
     IMultiCellCanvas* canvas = (IMultiCellCanvas*)evt.dispatchingWindow();

     // Check for change in bidi settings.  As a compromise between
     // performance and flexibility, we check the layout orientation in
     // a few key places, rather than on every button click and mouse
     // move (where it is needed to support drag lines).
     if ( IBidiSettings::isBidiSupported() )
     {  // Check the orientation of the canvas (this also dictates the
        // orientation of grid lines and drag lines).
        IBidiSettings
          bidiSettings( *canvas );
        canvas->fMultiCellCanvasData->fBidiLayout = bidiSettings.windowLayout();
     }

     if ( canvas->extendedStyle() &
          ( IMultiCellCanvas::gridLines.asExtendedUnsignedLong() |
            IMultiCellCanvas::dragLines.asExtendedUnsignedLong() ) )
     {
       ITRACE_ALL("IMultiCellCanvasHandler - WM_PAINT");
#ifdef IC_PM
       _RECTL rectlInvalid;
#endif
#ifdef IC_WIN
       RECT rectlInvalid;
#endif
       IQUERYUPDATERECT( canvas->handle(), &rectlInvalid );
       IRectangle rectPaint( rectlInvalid );

       // Allow default painting of the background and border.
       canvas->defaultProcedure( evt );

       // Need to hide the cursor before we paint.

       IPresSpaceHandle
         hps = canvas->presSpace();

       // Get some basic information about the canvas, including
       // the bounds of where the grid/drag lines should appear
       // (inside the border, if there is one).
       ISize sizeCanvas = canvas->size();
       unsigned long canvasWidth = sizeCanvas.width();
       IPoint
         topLeftOffset( canvas->topLeftLayoutOffset() ),
         botRightOffset( canvas->bottomRightLayoutOffset() );

       {
         // Create a graf port that matches the native orientation
         // of the operating system, because the clip region is in
         // native coordinates, as are the offsets for drawing the
         // grid/drag lines.
#ifdef IC_ORIGINUPPERLEFT
         // Coordinate system with an upper-left origin (e.g. Windows, Motif).
         IExtendedRootGrafPort
           nativeRootPort( hps, ICoordinateSystem::kOriginUpperLeft );
#else
         // Coordinate system with a lower-left origin (e.g. OS/2).
         IExtendedRootGrafPort
           nativeRootPort( hps, ICoordinateSystem::kOriginLowerLeft );
#endif

         // Set up to draw the grid/drag lines only within the
         // already-calculated clip area.
         IGRect2D
           clipRect2D( rectPaint );
         IGArea
           clipRegion( clipRect2D );
         ILinkedGrafPort
           clipPort( &nativeRootPort, &clipRegion );

         // Erase the current cross hair by drawing it again, which
         // will cause the previous colours to be displayed since
         // it is being drawn in invert mix mode.
         IFillBundle
           bgndFill( IBasicColor( canvas->backgroundColor() ) );
         bgndFill
          .setFillTransferMode( IColorTransferMode::kInvertDestination );
         ILinkedGrafPort
           drawPort( &clipPort, &bgndFill );

         // Draw vertical lines first.
#ifdef IC_ORIGINUPPERLEFT
         GCoordinate
           lineTop = topLeftOffset.y(),
           lineBottom = sizeCanvas.height() - botRightOffset.y();
#else
         GCoordinate
           lineTop = sizeCanvas.height() - topLeftOffset.y(),
           lineBottom = botRightOffset.y();
#endif
         GCoordinate
           xPos = 0;
         unsigned long i;
         bool
           leftToRight = ( canvas->fMultiCellCanvasData->fBidiLayout ==
                                        IBidiSettings::layoutLeftToRight );
         for ( i = 1; i <= canvas->pRowColHeaderList->columns(); i++ )
         {
            IRCHeader& colHeader = (*canvas->pRowColHeaderList)(i, 0);
            xPos = colHeader.offset() + colHeader.width();
            if ( ! leftToRight )
            {
               xPos = canvasWidth - xPos;
            }
            drawPort.draw( IGLine2D( IGPoint2D( xPos, lineTop ),
                                     IGPoint2D( xPos, lineBottom ) ) );
         }

         // Draw horizontal lines next.
         GCoordinate
           lineLeft = topLeftOffset.x(),
           lineRight = canvasWidth - botRightOffset.y(),
           yPos = 0;
         for ( i = 1; i <= canvas->pRowColHeaderList->rows(); i++ )
         {
            IRCHeader& rowHeader = (*canvas->pRowColHeaderList)(0, i);
#ifdef IC_ORIGINLOWERLEFT
            yPos = rowHeader.offset() - 1;
#else
            yPos = rowHeader.offset() + rowHeader.height();
#endif
            drawPort.draw( IGLine2D( IGPoint2D( lineLeft, yPos ),
                                     IGPoint2D( lineRight, yPos ) ) );
         }
       }  // Brackets to ensure the graf ports are out of scope before
          // IWindow::releasePresSpace.

       canvas->releasePresSpace( hps );

       evt.setResult( false );
       return true;                    // Do not pass on to next handler.
     }
   } /* end WM_PAINT */
   break;

#ifdef IC_WIN
   // This keeps the drag cursor when dragging the lines
   // but we are still getting WM_SETCURSORs which cause the cursor to
   // flash to the default and back to drag cursor when moving the cursor
   // along a drag line.
   case WM_SETCURSOR:
   {
      if ( ( evt.handle().asUnsigned() == evt.parameter1().asUnsignedLong() ) &&
           ( ( evt.parameter2().highNumber() == WM_BUTTON1DOWN ) ||
             ( evt.parameter2().highNumber() == WM_BUTTON2DOWN ) ||
             ( evt.parameter2().highNumber() == WM_BUTTON3DOWN ) ) )
      {
         // Eat this message to prevent resetting the cursor to the default.
         evt.setResult( true );
         return true;
      }
   }
   break;
#endif

   case WM_MOUSEMOVE:
      /****************************************************************/
      // Return sizeHorz/sizeVert pointer handle if on the split-bar
      // Use system for now - need to get container split drag pointer
      /****************************************************************/
   {
      IMultiCellCanvas* canvas = (IMultiCellCanvas*)evt.window();

      if (canvas->extendedStyle() &
                          IMultiCellCanvas::dragLines.asExtendedUnsignedLong())
      {
#ifdef IC_PM
        IPoint ptMouse( evt.parameter1().lowNumber(),
                        evt.parameter1().highNumber());
#endif
#ifdef IC_WIN
        IPoint ptMouse( evt.parameter2().lowNumber(),
                        evt.parameter2().highNumber());
#endif
        ISize sizeCanvas = canvas->size();
        IRectangle rclGridLine;
        bool bOverVertGridLine = false;
        bool bOverHorzGridLine = false;
        unsigned long width  = 0;
        unsigned long height = sizeCanvas.height();
        unsigned long canvasWidth = sizeCanvas.width();
        bool leftToRight = ( canvas->fMultiCellCanvasData->fBidiLayout ==
                                         IBidiSettings::layoutLeftToRight );
        unsigned long i;

        for ( i = 1; i <= canvas->pRowColHeaderList->columns(); i++ )
        {
           IRCHeader& colHeader = (*canvas->pRowColHeaderList)(i, 0);
           width = colHeader.offset() + colHeader.width();
           if ( ! leftToRight )
           {  // Adjust for right-to-left layouts.
              width = canvasWidth - width;
           }

           rclGridLine = IRectangle( width - 1, 0, width + 1, height );

           if ( rclGridLine.contains( ptMouse ) )
           {
             bOverVertGridLine = true;
             break;            // leave enumeration loop
           }
        }
        if ( ! bOverVertGridLine )
        {
          width  = canvasWidth;
          for ( i = 1; i <= canvas->pRowColHeaderList->rows(); i++ )
          {
             IRCHeader& rowHeader = (*canvas->pRowColHeaderList)(0, i);
#ifdef IC_ORIGINLOWERLEFT
             height = rowHeader.offset();
#else
             height = rowHeader.offset() + rowHeader.height();
#endif

             rclGridLine = IRectangle( 0, height-1, width, height+1 );

             if ( rclGridLine.contains( ptMouse ) )
             {
               bOverHorzGridLine = true;
               break;            // leave enumeration loop
             }
          }
        }
        if ( bOverVertGridLine )
        {
          ISETPOINTER( ISystemPointerHandle(ISystemPointerHandle::sizeHorizontal));
          evt.setResult( true );
          return true;
        }
        else if ( bOverHorzGridLine )
        {
          ISETPOINTER( ISystemPointerHandle(ISystemPointerHandle::sizeVertical));
          evt.setResult( true );
          return true;
        }
      }
      evt.setResult( false );
      return false;
      break;
   } /* end WM_MOUSEMOVE */

   case WM_BUTTON1DOWN:
   case WM_BUTTON2DOWN:
   case WM_BUTTON3DOWN:
      /*********************************************************/
      //If button down on the split-bar, start tracking the mouse
      //and resize controls on both sides of split-bar according to
      //where mouse button was released.
      /*********************************************************/
   {
      HWND hwnd = evt.handle();
      IMultiCellCanvas* canvas = (IMultiCellCanvas*)evt.window();

      if ( canvas->extendedStyle() &
             IMultiCellCanvas::dragLines.asExtendedUnsignedLong() )
      {
        POINTL ptScreen;

        /*********************************************************/
        //compute mouse location within the canvas window
        /*********************************************************/
        IQUERYMSGPOS( IQUERYANCHOR( hwnd ), &ptScreen );
        IMAPWINDOWPOINTS( HWND_DESKTOP, hwnd, &ptScreen, 1 );
        IPoint ptMouse( ptScreen.x, ptScreen.y );

        IRectangle rclGridLine;
        bool bOverVertGridLine = false;
        bool bOverHorzGridLine = false;
        unsigned long width  = 0;
        ISize sizeCanvas = canvas->size();
        unsigned long height = sizeCanvas.height();
        unsigned long canvasWidth = sizeCanvas.width();
        bool leftToRight = ( canvas->fMultiCellCanvasData->fBidiLayout ==
                                         IBidiSettings::layoutLeftToRight );
        unsigned long i, column=0, columnPrev=0, row=0, rowPrev=0;

        for ( i = 1; i <= canvas->pRowColHeaderList->columns(); i++ )
        {
           IRCHeader& colHeader = (*canvas->pRowColHeaderList)( i, 0 );
           width = colHeader.offset() + colHeader.width();
           if ( ! leftToRight )
           {  // Adjust for right-to-left layouts.
              width = canvasWidth - width;
           }

           rclGridLine = IRectangle( width - 1, 0, width + 1, height );

           if ( rclGridLine.contains( ptMouse ) )
           {
             bOverVertGridLine = true;
             column = i + 1;
             columnPrev = i;
             rclGridLine = IRectangle( width, 0, width + 1, height );
             break;            // leave enumeration loop
           }
        }                  // endfor
        if ( ! bOverVertGridLine )
        {
          width  = canvasWidth;
          for ( i = 1; i <= canvas->pRowColHeaderList->rows(); i++ )
          {
             IRCHeader& rowHeader = (*canvas->pRowColHeaderList)( 0, i );
#ifdef IC_ORIGINLOWERLEFT
             height = rowHeader.offset();
#else
             height = rowHeader.offset() + rowHeader.height();
#endif

             rclGridLine = IRectangle( 0, height - 1, width, height + 1 );

             if ( rclGridLine.contains( ptMouse ) )
             {
               bOverHorzGridLine = true;
               row = i + 1;
               rowPrev = i;
               rclGridLine = IRectangle( 0, height, width, height + 1 );
               break;            // leave enumeration loop
             }
          }             // endfor
        }             // endif !bOverVertGridLine

        // Clear the WS_CLIPCHILDREN bit.
        /**********************************************************/
        long lStyle = ISTYLEOF( hwnd );
        ISETWINDOWSTYLE( hwnd, lStyle & ~WS_CLIPCHILDREN );
        // Start tracking.
        TRACKINFO trk;
        /********************************************************************/
        /* A vertical drag line should track between the previous drag line */
        /* and the opposite edge of the canvas.  Vertically it should be    */
        /* contained between the top and bottom of the canvas.              */
        /********************************************************************/
        if ( bOverVertGridLine )
        {
          IRCHeader& colHeader = (*canvas->pRowColHeaderList)( columnPrev, 0 );
          if ( leftToRight )
          {  // Typical case.
             trk.rclBoundary.MINX = rclGridLine.minX() - colHeader.width();
             trk.rclBoundary.MAXX = canvasWidth;
          }
          else
          {  // Adjust for bidi.
             trk.rclBoundary.MINX = 0;
             trk.rclBoundary.MAXX = rclGridLine.minX() + colHeader.width() + 1;
          }
          trk.rclBoundary.MINY = rclGridLine.minY();
          trk.rclBoundary.MAXY = rclGridLine.maxY();

          /********************************************************/
          /* This specifies the width of the Splitbar, so         */
          /* WinTrackRect knows how wide of a thing to track. The */
          /* Splitbar is the width of a Size Border.              */
          /********************************************************/
          trk.cxBorder = 1;

          /********************************************************/
          /* This specifies the height of the splitbar so         */
          /* WinTrackRect knows how tall of a thing to track.     */
          /********************************************************/
          trk.cyBorder = trk.rclBoundary.MAXY;

          /********************************************************/
          /* This specifies the tracking rectangle used by        */
          /* WinTrackRect.                                        */
          /********************************************************/
          trk.rclTrack.MINX = rclGridLine.minX();
          trk.rclTrack.MINY = rclGridLine.minY();
          trk.rclTrack.MAXX = rclGridLine.maxX();
          trk.rclTrack.MAXY = trk.rclBoundary.MAXY;

        }
        else if (bOverHorzGridLine)
        {
          IRCHeader& rowHeader = (*canvas->pRowColHeaderList)(0,rowPrev);
          trk.rclBoundary.MINX = rclGridLine.minX();
          trk.rclBoundary.MAXX = rclGridLine.maxX();
#ifdef IC_ORIGINLOWERLEFT
          trk.rclBoundary.MINY = 0;
          trk.rclBoundary.MAXY = rclGridLine.maxY() + rowHeader.height() - 1;
#else
          trk.rclBoundary.MINY = rclGridLine.minY() - rowHeader.height();
          trk.rclBoundary.MAXY = sizeCanvas.height();
#endif

          /********************************************************/
          /* This specifies the width of the gridline, so         */
          /* WinTrackRect knows how wide of a thing to track.     */
          /********************************************************/
          trk.cxBorder = trk.rclBoundary.MAXX;

          /********************************************************/
          /* This specifies the height of the gridline so         */
          /* WinTrackRect knows how tall of a thing to track.     */
          /********************************************************/
          trk.cyBorder = 1;

          /********************************************************/
          /* This specifies the tracking rectangle used by        */
          /* WinTrackRect.                                        */
          /********************************************************/
          trk.rclTrack.MINX = rclGridLine.minX();
          trk.rclTrack.MINY = rclGridLine.minY();
          trk.rclTrack.MAXX = rclGridLine.maxX();
          trk.rclTrack.MAXY = rclGridLine.maxY();
        }

        if ( bOverHorzGridLine  ||  bOverVertGridLine )
        {
          trk.cxGrid = 0;
          trk.cyGrid = 0;
          trk.cxKeyboard = 0;
          trk.cyKeyboard = 0;

          /**********************************************************/
          /* Specify the minimum and maximum tracking size.         */
          /**********************************************************/
          trk.ptlMinTrackSize.x = trk.cxBorder;
          trk.ptlMinTrackSize.y = trk.cyBorder;
          trk.ptlMaxTrackSize.x = trk.cxBorder;
          trk.ptlMaxTrackSize.y = trk.cyBorder;

          /**********************************************************/
          /* These tracking options specify:  TF_MOVE - to center   */
          /* the pointer in the tracking rectangle. TF_ALLINBOUNDARY*/
          /* performs tracking such that no part of the tracking    */
          /* rectangle ever falls outside the bounding rectangle.   */
          /**********************************************************/
          trk.fs = TF_MOVE | TF_ALLINBOUNDARY;

          BOOL bSuc=WinTrackRect(hwnd,0,&trk);

          /**********************************************************/
          /* restore WS_CLIPCHILDREN bit                            */
          /**********************************************************/
          ISETWINDOWSTYLE( hwnd, lStyle );

          if ( row )
          {
            IRCHeader& rowHeader = (*canvas->pRowColHeaderList)( 0, rowPrev );
            long  rowDelta;
#ifdef IC_ORIGINLOWERLEFT
            rowDelta = rclGridLine.maxY() - trk.rclTrack.MAXY;
#else
            rowDelta = trk.rclTrack.MAXY - rclGridLine.maxY();
#endif
            canvas->setRowHeight( rowPrev,
                                  rowDelta + rowHeader.height() );
            canvas->setLayoutDistorted( IWindow::layoutChanged
                                         | IWindow::immediateUpdate, 0 );
          }

          if ( column )
          {
            IRCHeader& colHeader = (*canvas->pRowColHeaderList)( columnPrev, 0 );
            long colDelta = leftToRight ?
                              ( trk.rclTrack.MINX - rclGridLine.minX() ) :
                              ( rclGridLine.minX() - trk.rclTrack.MINX );
            canvas->setColumnWidth( columnPrev,
                                    colDelta + colHeader.width() );
            canvas->setLayoutDistorted( IWindow::layoutChanged
                                         | IWindow::immediateUpdate, 0 );
          }

        }       // endif bOverHorzGridLine or ...
      }       // endif extendedStyle() & ...
      break;
   } /* end WM_BUTTON...DOWN */

   case WM_SIZE:
   {
      IMultiCellCanvas* canvas = (IMultiCellCanvas*)evt.window();

      // Check for change in bidi settings.  As a compromise between
      // performance and flexibility, we check the layout orientation in
      // a few key places, rather than on every button click and mouse
      // move (where it is needed to support drag lines).
      if ( IBidiSettings::isBidiSupported() )
      {  // Check the orientation of the canvas (this also dictates the
         // orientation of grid lines and drag lines).
         IBidiSettings
           bidiSettings( *canvas );
         canvas->fMultiCellCanvasData->fBidiLayout = bidiSettings.windowLayout();
      }

      // Canvas needs new layout if either:
      // - Sized vertically and it has expandable rows or
      //   its new height is not what was used to position
      //   its child windows.
      // - Sized horizontally and it has expandable columns.
      //   or lays out child windows from right-to-left.
      bool
        newLayout = false;
      long
        newWidth = evt.parameter2().number1(),
        newHeight = evt.parameter2().number2();
      if ( newWidth  &&  newHeight )
      {  // Canvas has a non-zero size.
#ifdef IC_ORIGINLOWERLEFT
         if ( newHeight !=
                canvas->fMultiCellCanvasData->sizeForLayout.height() )
#else
         if ( newHeight !=
                 canvas->fMultiCellCanvasData->sizeForLayout.height()  &&
              canvas->fExpandRow )
#endif
         {
            newLayout = true;
         }
         else if ( newWidth !=
                    canvas->fMultiCellCanvasData->sizeForLayout.width() )
         {  // New width from last layout.
            if ( canvas->fExpandCol )
            {
               newLayout = true;
            }
            else if ( canvas->fMultiCellCanvasData->fBidiLayout ==
                                   IBidiSettings::layoutRightToLeft )
            {  // Layout based on right edge of canvas.
               newLayout = true;
            }
         }
      }
      if ( newLayout )
      {
         canvas->setLayoutDistorted( IWindow::sizeChanged |
                                     IWindow::layoutChanged, 0 );
         canvas->layout();
      }
      else
      {
         // Notification for backwards compatibility.
         canvas->setLayoutDistorted( IWindow::sizeChanged, 0 );
      }
      break;
   } /* end WM_SIZE */

 } /* endswitch */
 return false;
}
#endif // IC_PMWIN

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
  dispatchHandlerEvent - Dispatch a handler event,
  performing significant built-in processing for some events.
------------------------------------------------------------------------------*/
bool IMultiCellCanvasHandler::dispatchHandlerEvent ( IEvent& evt )
{
  switch (evt.eventId())
  {
    case xEvent(MapNotify):
    {
      if ( evt.parameter1().asUnsignedLong() ) // first time
      {
        IMultiCellCanvas* canvas = (IMultiCellCanvas*)evt.controlWindow();
        if ( ( canvas->isLayoutDistorted(IWindow::layoutChanged) ) ||
             ( (canvas->fExpandCol) || (canvas->fExpandRow) ) )
        {
          canvas->setLayoutDistorted(IWindow::layoutChanged, 0);
          canvas->layout();
        }

        if ( canvas->hasGridLines()  ||  canvas->hasDragLines() )
        {
           // Don't use bit gravity, so the canvas paints its entire
           // window whenever it is sized, including resized smaller.
           // This keeps the grid/drag lines from a previous paint
           // from being left on the screen after a partial paint.
           // Do this after letting ICanvas process this event, since
           // ICanvasHandler also gives us bit gravity.
           // Note that bit gravity is also changed in
           // IMultiCellCanvas::enableGridLines.
           canvas->dispatchRemainingHandlers( evt, true );

           IWindowHandle
             hwnd( canvas->handle() );
           XSetWindowAttributes
             attributes;
           attributes.bit_gravity = ForgetGravity;
           XChangeWindowAttributes( XtDisplay( (Widget) hwnd ),
                                    XtWindow( (Widget) hwnd ),
                                    CWBitGravity,
                                    &attributes );
           return true;
        }
      }
      break;
    }

    case xEvent(ConfigureNotify):
    {
      ISizeRectangle *sizeRect =
        (ISizeRectangle *) evt.parameter1().asUnsignedLong();

      IMultiCellCanvas* canvas = (IMultiCellCanvas*)evt.window();

      // Canvas needs new layout if either:
      // - Sized vertically and it has expandable rows or
      //   its new height is not what was used to position
      //   its child windows.
      // - Sized horizontally and it has expandable columns or
      //   or lays out child windows from right-to-left.
      bool
        newLayout = false;
      long
        newWidth = sizeRect->newRectangle().size().width(),
        newHeight = sizeRect->newRectangle().size().height();
      if ( newWidth  &&  newHeight )
      {  // Canvas has a non-zero size.
         if ( newHeight !=
                canvas->fMultiCellCanvasData->sizeForLayout.height()  &&
              canvas->fExpandRow )
         {
            newLayout = true;
         }
         else if ( newWidth !=
                     canvas->fMultiCellCanvasData->sizeForLayout.width() )
         {  // New width from last layout.
            if ( canvas->fExpandCol )
            {
               newLayout = true;
            }
            else if ( IBidiSettings::isBidiSupported() )
            {
               IBidiSettings
                 bidiSettings( *canvas );
               if ( bidiSettings.windowLayout() == IBidiSettings::layoutRightToLeft )
               {  // Layout based on right edge of canvas.
                  newLayout = true;
               }
            }
         }
      }
      if ( newLayout )
      {
         canvas->setLayoutDistorted( IWindow::sizeChanged |
                                     IWindow::layoutChanged, 0 );
         canvas->layout();
      }
      else
      {
        // Notification for backwards compatibility.
        canvas->setLayoutDistorted( IWindow::sizeChanged, 0 );
      }
      break;
    } /* end ConfigureNotify */


    case IC_UM_DRAWGRIDLINES:
    {
      IMultiCellCanvas* canvas = (IMultiCellCanvas*)evt.controlWindow();
      canvas->drawGridLines();
      break;
    }

  case xEvent(Expose):
    {
      XEvent
       *xEvent = (XEvent*)(char*) evt.parameter2();
      XExposeEvent
       *exposeEvent = (XExposeEvent*)xEvent;
      unsigned long
        exposeCount = exposeEvent->count;
      if ( exposeCount != 0 )
      {  // More expose messages still to come.
         break;
      }
      // Else fall into the IC_UM_PAINT case.
    }
  case IC_UM_PAINT:
    {
      IMODTRACE_DEVELOP("IMultiCellCanvasHandler::dispatchHandlerEvent(Expose)");
      IMultiCellCanvas* canvas = (IMultiCellCanvas*)evt.controlWindow();

      // Now paint the grid lines.
      if ( canvas->hasGridLines() )
      {
         canvas->postEvent(IC_UM_DRAWGRIDLINES, 0, 0);
      }
      break;
    } /* endcase */

    default:
      break;
  }
  return false;
}
#endif // IC_MOTIF

/*------------------------------------------------------------------------------
   handleEventsFor - begin handling events for the specified canvas.
------------------------------------------------------------------------------*/
IMultiCellCanvasHandler& IMultiCellCanvasHandler::handleEventsFor
                                                 ( IMultiCellCanvas *canvas )
{
   IASSERTPARM(canvas != 0);
   Inherited::handleEventsFor(canvas);
   return *this;
}

/*------------------------------------------------------------------------------
   stopHandleEventsFor - end handling of events for the specified canvas.
------------------------------------------------------------------------------*/
IMultiCellCanvasHandler& IMultiCellCanvasHandler::stopHandlingEventsFor
                                                 ( IMultiCellCanvas *canvas )
{
   IASSERTPARM(canvas != 0);
   Inherited::stopHandlingEventsFor(canvas);
   return *this;
}

/*------------------------------------------------------------------------------
   handleEventsFor - throw an error if someone attempts to attach
   this handler to any other IWindow besides an IMultiCellCanvas (which
   would call "handleEventsFor(IMultiCellCanvas*)" above, not this method).
------------------------------------------------------------------------------*/
IHandler& IMultiCellCanvasHandler::handleEventsFor ( IWindow * )
{                              // private to hide version in IHandler
   ITHROWLIBRARYERROR(IC_MEMBER_ACCESS_ERROR,
                      IBaseErrorInfo::invalidRequest,
                      IException::recoverable);
   return *this;
}

/*------------------------------------------------------------------------------
   stopHandlingEventsFor - throw an error if someone attempts to call
   this method for any other IWindow besides an IMultiCellCanvas (which
   would call "stopHandlingEventsFor(IMultiCellCanvas*)" above, not this method).
------------------------------------------------------------------------------*/
IHandler& IMultiCellCanvasHandler::stopHandlingEventsFor ( IWindow * )
{                              // private to hide version in IHandler
   ITHROWLIBRARYERROR(IC_MEMBER_ACCESS_ERROR,
                      IBaseErrorInfo::invalidRequest,
                      IException::recoverable);
   return *this;
}
