/******************************************************************************
* .FILE:         mmremote.h                                                   *
*                                                                             *
* .DESCRIPTION:  Multimedia Remote-Control Sample:     Symbolic Definitions   *
*                                                                             *
* .COPYRIGHT:                                                                 *
*    IBM Open Class Library                                                   *
*    Licensed Material - Program-Property of IBM                              *
*    (C) Copyright IBM Corp. 1992, 1997 - All Rights Reserved                 *
*                                                                             *
* .DISCLAIMER:                                                                *
*   The following [enclosed] code is sample code created by IBM               *
*   Corporation.  This sample code is not part of any standard IBM product    *
*   and is provided to you solely for the purpose of assisting you in the     *
*   development of your applications.  The code is provided 'AS IS',          *
*   without warranty of any kind.  IBM shall not be liable for any damages    *
*   arising out of your use of the sample code, even if they have been        *
*   advised of the possibility of such damages.                               *
*                                                                             *
* .NOTE: WE RECOMMEND USING A FIXED SPACE FONT TO LOOK AT THE SOURCE          *
*                                                                             *
******************************************************************************/
//**********************************************************************
//  IDs for bitmaps to go on the buttons                               *
//**********************************************************************

#define BMPPLAY        1000
#define BMPPLAY1       1001
#define BMPPLAY2       1002
#define BMPPLAY3       1003
#define BMPPLAY4       1004
#define BMPVIDEO       1005
#define BMPMIDI        1006
#define BMPCD          1007
#define BMPWAVE        1008
#define BMPVOLUP       1009
#define BMPVOLDN       1010
#define BMPREW         1011
#define BMPFF          1012
#define BMPPAUSE       1013
#define BMPSTOP        1014
#define BMPPOWER       1015

//**********************************************************************
//  IDs for the canvases                                               *
//**********************************************************************

#define CLIENTCANVASID 1101
#define REMOTECANVASID 1102
#define PADID          1103
#define DEVID          1104
#define CTLID          1105
#define VOLUMEID       1106
#define VKID           1107

//**********************************************************************
//  IDs for the buttons                                                *
//**********************************************************************

#define PLAYID         1201
#define STOPID         1202
#define REWID          1203
#define FFID           1204
#define PAUSEID        1205
#define POWERID        1206
#define VIDEOID        1207
#define MIDIID         1208
#define CDID           1209
#define WAVEID         1210
#define VOLUPID        1211
#define VOLDNID        1212
#define WINDOWID       1213
#define ONEID          1214
#define TWOID          1215
#define THREEID        1216
#define FOURID         1217
#define FIVEID         1218
#define SIXID          1219
#define SEVENID        1220
#define EIGHTID        1221
#define NINEID         1222
#define ZEROID         1223
#define STEPTRACKFID   1224
#define STEPTRACKBID   1225

//**********************************************************************
//  ID for readout (status line) and fly over help                     *
//**********************************************************************

#define READOUTID      1300
#define FLYTEXTID      1301

//**********************************************************************
//  Margin for multicell canvasses                                     *
//**********************************************************************

#define MARGIN           10

//**********************************************************************
//  Fly over help offsets                                              *
//**********************************************************************

#define VIDEO           1000
#define MIDI            2000
#define WAVE            3000


#define STR_TRACK           9001
#define STR_TIME_           9002
#define STR_INVALID_TRACK   9003
#define STR_TRACKS          9004
#define STR_TIME_00         9005
#define STR_TIME            9006
#define STR_HRMINSEC        9007
#define STR_NOAUDCD         9008
#define STR_CDDIS           9009
#define STR_NOCD            9010
#define STR_NOTRANS         9011
#define STR_NOWAVE          9012
#define STR_NOVID           9013
#define STR_NOMIDI          9014
#define STR_POWER           9015
#define STR_VOLUMEUP        9016
#define STR_VOLUMEDOWN      9017
#define STR_VIDEO           9018
#define STR_CD              9019
#define STR_MIDI            9020
#define STR_WAVE            9021
#define STR_HRMINSEC_00     9022
#define STR_AVI             9023
#define STR_LOAD_DEVICE     9024
#define STR_WAV_EXT         9025
#define STR_MID_EXT         9026
#define STR_LOAD_FILE       9027
#define STR_COLON           9028

#define STR_ONE             9301
#define STR_TWO             9302
#define STR_THREE           9303
#define STR_FOUR            9304
#define STR_FIVE            9305
#define STR_SIX             9306
#define STR_SEVEN           9307
#define STR_EIGHT           9308
#define STR_NINE            9309
#define STR_ZERO            9300
#define STR_PAD             9310

