/*
-------------------------------------------------------------------------------
Copyright (c) IBM Corporation 1997.
All Rights Reserved.

Permission is granted to copy, use, modify, and merge this software into your
applications and to permit others to do any of the foregoing. You must include
this permission and copyright notice in all copies and modified versions of
this software. THIS SOFTWARE IS PROVIDED IN ITS 'AS IS' CONDITION.
IBM DISCLAIMS ANY LIABILITY OF ANY KIND FOR DAMAGES WHATSOEVER RESULTING FROM
THE USE OF THIS SOFTWARE.
-------------------------------------------------------------------------------
*/
// Revision: 93 1.3.2.2 samples/testfw/smptargt.cpp, ocsamples-L1, ioc.v400, 981106 
// Sample target classes.  Used by test programs.

#include "smptargt.hpp"

ISubtest1::ISubtest1(unsigned long num, unsigned short index)
{
        fValue = num;
        fIndex = index;
}

ISubtest1::ISubtest1(const ISubtest1& other)
{
        fValue = other.fValue;
        fIndex = other.fIndex;
}

ISubtest1& ISubtest1::operator=(const ISubtest1& other)
{
        if (this != &other){
                fValue = other.fValue;
                fIndex = other.fIndex;
        }
        return *this;
}

ISubtest1::~ISubtest1()
{
}

bool ISubtest1::operator==(const ISubtest1& other)
{
        return ((fValue == other.fValue) && (fIndex == other.fIndex));
}

void ISubtest1::print(ITieredTextBuffer& out)
{
        ITest::print(out);
        out << "ISubtest1 print method is called\n";
}

void ISubtest1::test()
{
        outputTextStream() << "ISubtest1 is called with value " << fValue << "\n";
        setSuccess(true);
}


ISubtest2::ISubtest2()
{
}
ISubtest2::~ISubtest2()
{
}
void ISubtest2::test()
{
        outputTextStream() << "ISubtest2 is called\n";
        IString* str = new IString("AnyString");
        if (str->length() == 9)
                setSuccess(true);
        else setSuccess(false);

}


ISubtest3::ISubtest3()
{
}
ISubtest3::~ISubtest3()
{
}
void ISubtest3::test()
{
        outputTextStream() << "ISubtest3 is called\n";
        setSuccess(true);
}

