/*
-------------------------------------------------------------------------------
Copyright (c) IBM Corporation 1997.
All Rights Reserved.

Permission is granted to copy, use, modify, and merge this software into your
applications and to permit others to do any of the foregoing. You must include
this permission and copyright notice in all copies and modified versions of
this software. THIS SOFTWARE IS PROVIDED IN ITS 'AS IS' CONDITION.
IBM DISCLAIMS ANY LIABILITY OF ANY KIND FOR DAMAGES WHATSOEVER RESULTING FROM
THE USE OF THIS SOFTWARE.
-------------------------------------------------------------------------------
*/
// Revision: 97 1.3.2.2 samples/testfw/strmtgt.cpp, ocsamples-L1, ioc.v400, 981106 

#include <idatstrm.hpp>
#include <istrmmod.hpp>

#include "strmtgt.hpp"


static IStreamModule gTestModule("ISubtest1");
StreamableDefinitionsMacro(IStrmTarget, gTestModule);
IStrmTarget::IStrmTarget()
{
        fValue = 0;
        fIndex = 0;
}

IStrmTarget::IStrmTarget(unsigned long num, unsigned short index)
{
        fValue = num;
        fIndex = index;
}

IStrmTarget::IStrmTarget(const IStrmTarget& other)
{
        fValue = other.fValue;
        fIndex = other.fIndex;
}

IStrmTarget& IStrmTarget::operator=(const IStrmTarget& other)
{
        if (this != &other){
                fValue = other.fValue;
                fIndex = other.fIndex;
        }
        return *this;
}

bool IStrmTarget::operator==(const IStrmTarget& other)
{
        return ((fValue == other.fValue) && (fIndex == other.fIndex));
}

IStrmTarget::~IStrmTarget()
{
}


void IStrmTarget::readFromStream(IDataStream& stream)
{
        fIndex <<= stream;
        fValue <<= stream;
}

void IStrmTarget::writeToStream(IDataStream& stream) const
{
        fIndex >>= stream;
        fValue >>= stream;
}

void IStrmTarget::print(ITieredTextBuffer& out)
{
        ITest::print(out);
        out << "IStrmTarget print method is called\n";
}

void IStrmTarget::test()
{
        outputTextStream() << "IStrmTarget is called with value " << fValue << "\n";
        setSuccess(false);
}
