/*
-------------------------------------------------------------------------------
Copyright (c) IBM Corporation 1997.
All Rights Reserved.

Permission is granted to copy, use, modify, and merge this software into your
applications and to permit others to do any of the foregoing. You must include
this permission and copyright notice in all copies and modified versions of
this software. THIS SOFTWARE IS PROVIDED IN ITS 'AS IS' CONDITION.
IBM DISCLAIMS ANY LIABILITY OF ANY KIND FOR DAMAGES WHATSOEVER RESULTING FROM
THE USE OF THIS SOFTWARE.
-------------------------------------------------------------------------------
*/
// Revision: 98 1.3.2.2 samples/testfw/strmtgt.hpp, ocsamples-L1, ioc.v400, 981106 
#ifndef _STRMTGT_H
#define _STRMTGT_H

#include <itest.hpp>
#include <imstrmbl.hpp>

class IStrmTarget: public ITest, public IMStreamable {
        StreamableDeclarationsMacro(IStrmTarget);
public:
        IStrmTarget();
        IStrmTarget(unsigned long num, unsigned short index);
        IStrmTarget(const IStrmTarget&);
        IStrmTarget& operator=(const IStrmTarget&);
        bool operator==(const IStrmTarget&);
        virtual ~IStrmTarget();
        void readFromStream(IDataStream& stream);
        void writeToStream(IDataStream& stream) const;

protected:
        void print(ITieredTextBuffer& out);
        void test();
private:
        unsigned long fValue;
        unsigned short fIndex;
};

#endif
