/*
-------------------------------------------------------------------------------
Copyright (c) IBM Corporation 1997.
All Rights Reserved.

Permission is granted to copy, use, modify, and merge this software into your
applications and to permit others to do any of the foregoing. You must include
this permission and copyright notice in all copies and modified versions of
this software. THIS SOFTWARE IS PROVIDED IN ITS 'AS IS' CONDITION.
IBM DISCLAIMS ANY LIABILITY OF ANY KIND FOR DAMAGES WHATSOEVER RESULTING FROM
THE USE OF THIS SOFTWARE.
-------------------------------------------------------------------------------
*/
// Revision: 99 1.3.2.2 samples/testfw/taddtimt.cpp, ocsamples-L1, ioc.v400, 981106 
#include "taddtimt.hpp"

//------------------------------------------------------------------------------
// ISequenceAddtimingTest Methods
//------------------------------------------------------------------------------

ISequenceAddTimingTest::ISequenceAddTimingTest()
{
        fObject = NULL;
        fObjectArraySize = 0;
}

ISequenceAddTimingTest::~ISequenceAddTimingTest()
{
        timingCleanup(); // Just in case timingSetup was called without timingCleanup
}


void ISequenceAddTimingTest::timingSetup()
{
        timingCleanup(); // Just in case timingSetup was called without timingCleanup

        fObjectArraySize = timingCount();
        fObject = new IString*[fObjectArraySize];
        for (long i=0; i<fObjectArraySize; i++) fObject[i] = new IString;
        fNextObject = &fObject[0];
}

void ISequenceAddTimingTest::timingTest()
{
        fSequence.add(**fNextObject++);
}

void ISequenceAddTimingTest::timingCleanup()
{
        if (fObject != NULL) {
                for (long i=0; i<fObjectArraySize; i++) delete fObject[i];
                delete[] fObject;
                fObject = NULL;
        }
}

//eof

