/*
-------------------------------------------------------------------------------
Copyright (c) IBM Corporation 1997.
All Rights Reserved.

Permission is granted to copy, use, modify, and merge this software into your
applications and to permit others to do any of the foregoing. You must include
this permission and copyright notice in all copies and modified versions of
this software. THIS SOFTWARE IS PROVIDED IN ITS 'AS IS' CONDITION.
IBM DISCLAIMS ANY LIABILITY OF ANY KIND FOR DAMAGES WHATSOEVER RESULTING FROM
THE USE OF THIS SOFTWARE.
-------------------------------------------------------------------------------
*/
// Revision: 02 1.3.2.2 samples/testfw/tautotst.hpp, ocsamples-L1, ioc.v400, 981106 
#ifndef _TAUTOTST_H
#define _TAUTOTST_H

#include "itimetst.hpp"

//----------------------------------------------------------------------------
// IAutoSamplingTest Declaration
//----------------------------------------------------------------------------

class IAutoSamplingTest : public ITimingTest {
public:
                                        IAutoSamplingTest();
        virtual                 ~IAutoSamplingTest();

protected:
        virtual void    setup();
        virtual void    cleanup();
        virtual void    timingTest();

        virtual double  oneSample(); // TTimingTest override
        virtual double  samplingErrorMicroseconds() const; // TTimingTest override

private:
                        void    computeHighValues(double lowValue, double insideEpsilon, double outsideEpsilon);
        bool                    parseArguments();
        virtual double  calibration(); // TTimingTest override
                        void    localSetup();

        long                    fCounter;
        long                    fLeadSamples;
        double                  fLowValue;

        double                  fInsideEpsilon; // Governs fInsideHighValue
        double                  fOutsideEpsilon; // Governs fOutsideHighValue

        // These are set by ComputeHighValues
        double                  fHighValueThreshold; // At the auto sampling tolerance
        double                  fInsideHighValue; // Within the auto sampling tolerance
        double                  fOutsideHighValue; // Outside the auto sampling tolerance
};


#endif
