/*
-------------------------------------------------------------------------------
Copyright (c) IBM Corporation 1997.
All Rights Reserved.

Permission is granted to copy, use, modify, and merge this software into your
applications and to permit others to do any of the foregoing. You must include
this permission and copyright notice in all copies and modified versions of
this software. THIS SOFTWARE IS PROVIDED IN ITS 'AS IS' CONDITION.
IBM DISCLAIMS ANY LIABILITY OF ANY KIND FOR DAMAGES WHATSOEVER RESULTING FROM
THE USE OF THIS SOFTWARE.
-------------------------------------------------------------------------------
*/
// Revision: 09 1.3.2.2 samples/testfw/tinfotst.cpp, ocsamples-L1, ioc.v400, 981106 
#include "tinfotst.hpp"

IInfoTest::IInfoTest() { }

IInfoTest::~IInfoTest() { }

void IInfoTest::test()
{
        outputTextStream() << "IInfoTest - Test method called.\n";
        setSuccess(true);

        IString key("DummyKey");
        IString badkey("NotFound");
        IString value;

        // Test LookupInfo
        if (!lookupInfo(kInputSyntaxKey, value)){
                outputTextStream() << "IInfoTest - InputSyntaxKey not found by lookupInfo\n";
                setSuccess(false);
        }
        else outputTextStream() << "value found for " << kInputSyntaxKey <<" is " << value << "\n";

        if (!lookupInfo(key, value)) {
            outputTextStream() << "IInfoTest - key value not found by LookupInfo.\n";
                setSuccess(false);
        }
        else outputTextStream() << "value found for " << key <<" is " << value << "\n";

        if (lookupInfo(badkey, value)) {
            outputTextStream() << "IInfoTest - value found for bad key by LookupInfo.\n";
                setSuccess(false);
        }

}

void IInfoTest::copyInfo()
{

        addInfo(kDescriptionKey, IString("Test which tests CopyInfo and LookupInfo."));
        addInfo(kInputSyntaxKey, IString());
        addInfo(IString("DummyKey"), IString("Dummy Value"));

}


