/*
-------------------------------------------------------------------------------
Copyright (c) IBM Corporation 1997.
All Rights Reserved.

Permission is granted to copy, use, modify, and merge this software into your
applications and to permit others to do any of the foregoing. You must include
this permission and copyright notice in all copies and modified versions of
this software. THIS SOFTWARE IS PROVIDED IN ITS 'AS IS' CONDITION.
IBM DISCLAIMS ANY LIABILITY OF ANY KIND FOR DAMAGES WHATSOEVER RESULTING FROM
THE USE OF THIS SOFTWARE.
-------------------------------------------------------------------------------
*/
// Revision: 11 1.3.2.2 samples/testfw/tinputst.cpp, ocsamples-L1, ioc.v400, 981106 

#include "tinputst.hpp"
#include <iseq.h>


IInputsTest::IInputsTest() { }

IInputsTest::~IInputsTest() { }

void IInputsTest::setup()
{
        outputTextStream() << "IInputsTest - Setup method called.\n";

        char *one = new char[4];
        strcpy(one, "one");
        char *two = new char[4];
        strcpy(two, "two");
        char *three = new char[6];
        strcpy(three, "three");

        fArgv = new const char*[3];
        fArgv[0] = one;
        fArgv[1] = two;
        fArgv[2] = three;
        fArgc = 3;

        outputTextStream() << "Initial arguments are: \n";
        for (int i=0; i<fArgc; i++) {
                outputTextStream() << fArgv[i] << "\n";
        }


}

void IInputsTest::test()
{
        setSuccess(true);
        setInputs(fArgc, fArgv);
        int argc;
        char** argv;
        copyInputs(argc, argv);
        ISequence<IString> input;
        for (int j=0; j<argc && argv[j]; j++)
        {
                input.add(argv[j]);
                delete [] argv[j];
        }
        delete [] argv;

        if (input.numberOfElements() != fArgc) {
                outputTextStream() << "incorrect count returned from CopyInputs.\n";
                setSuccess(false);
        }

        outputTextStream() << "inputs after calling SetInputs and CopyInputs\n";
    ISequence<IString>::Cursor cursor(input);

        int i = 0;
        for (cursor.setToFirst(); cursor.isValid() && i<fArgc; cursor.setToNext()) {
                if (cursor.element() != fArgv[i]) {
                        outputTextStream() << "incorrect argument for " << i << " from CopyInputs\n";
                        setSuccess(false);
                }
                outputTextStream() << fArgv[i] << "\n";
                i++;
        }
}

void IInputsTest::cleanup()
{
        for (int i=0; i<fArgc; i++) {
                char * const t = (char * const) fArgv[i];
                delete [] t;
        }
        delete [] fArgv;
}

void IInputsTest::copyInfo()
{
        addInfo(kDescriptionKey, "Test which tests SetInputs and CopyInputs with argv/argc parameters.");
}


