/*
-------------------------------------------------------------------------------
Copyright (c) IBM Corporation 1997.
All Rights Reserved.

Permission is granted to copy, use, modify, and merge this software into your
applications and to permit others to do any of the foregoing. You must include
this permission and copyright notice in all copies and modified versions of
this software. THIS SOFTWARE IS PROVIDED IN ITS 'AS IS' CONDITION.
IBM DISCLAIMS ANY LIABILITY OF ANY KIND FOR DAMAGES WHATSOEVER RESULTING FROM
THE USE OF THIS SOFTWARE.
-------------------------------------------------------------------------------
*/
// Revision: 14 1.3.2.2 samples/testfw/tmultest.hpp, ocsamples-L1, ioc.v400, 981106 
#ifndef _TMULTEST_H
#define _TMULTEST_H

#include "itestmul.hpp"

//
// IMultiplexerTest tests the interface of ITestMultiplexer
//
class IMultiplexerTest: public ITestMultiplexer{
public:

        //-------------------------------------------------------------------------    // Special Member Functions
        //-------------------------------------------------------------------------
                                                                IMultiplexerTest();
                                                                IMultiplexerTest(const IMultiplexerTest&);
                        IMultiplexerTest& operator=(const IMultiplexerTest&);

        virtual                                         ~IMultiplexerTest();


        //-------------------------------------------------------------------------
        // ITest Overrides
        //-------------------------------------------------------------------------
        void                                            copyInfo();

        //-------------------------------------------------------------------------
        // Decision Functions
        //-------------------------------------------------------------------------
                        bool                            appleFunction();
                        bool                     bearFunction();
                        bool                            cartFunction();
                        bool                            doorFunction();
                        bool                            elbowFunction();

protected:
        //-------------------------------------------------------------------------
        // ITest Overrides
        //-------------------------------------------------------------------------
        virtual void                            setup();
        virtual void                            cleanup();

        //-------------------------------------------------------------------------
        // ITesIMultiplexer Overrides
        //-------------------------------------------------------------------------
        virtual void                            loadDecisions();
        bool handleDecision(ITestDecisionFn fun, const IString& key);
private:
                        bool                            parseInput();
                        bool                            textToKeywordIndex(const IString& theText, short &theIndex) const;
        const    IString&               keyword(const short keyNumber) const;

        enum { kApple = 0, kBear, kCart, kDoor, kElbow, kNumberOfKeys };

        bool            fNeedToParseInput;
        bool            fProgrammatic;  // Set by ParseInput if -p option given
        unsigned short  fTestInputsAsKeys;      // Set by ParseInput if -i <count> option given
        bool            fWasCalled[kNumberOfKeys]; // true if this function was called
        bool            fExpectCall[kNumberOfKeys]; // true if we expect a call
        IString fProgrammaticKeyword;           // Keyword for -p option


};

#endif
//eof





