/*
-------------------------------------------------------------------------------
Copyright (c) IBM Corporation 1997.
All Rights Reserved.

Permission is granted to copy, use, modify, and merge this software into your
applications and to permit others to do any of the foregoing. You must include
this permission and copyright notice in all copies and modified versions of
this software. THIS SOFTWARE IS PROVIDED IN ITS 'AS IS' CONDITION.
IBM DISCLAIMS ANY LIABILITY OF ANY KIND FOR DAMAGES WHATSOEVER RESULTING FROM
THE USE OF THIS SOFTWARE.
-------------------------------------------------------------------------------
*/
// Revision: 17 1.3.2.2 samples/testfw/tssttest.cpp, ocsamples-L1, ioc.v400, 981106 
#include "tssttest.hpp"
#include "ittxtbuf.hpp"
#include <math.h>

//-----------------------------------------------------------------------------
// IStartStopTimingTestTest: PUBLIC Special Member Functions
//-----------------------------------------------------------------------------

IStartStopTimingTestTest::IStartStopTimingTestTest()
{
}

IStartStopTimingTestTest::~IStartStopTimingTestTest()
{
}

//-----------------------------------------------------------------------------
// IStartStopTimingTestTest: PROTECTED Timing Framework Methods
//-----------------------------------------------------------------------------

void IStartStopTimingTestTest::startStopTimingTest(ITimingTestStopwatch& stopwatch)
{
        for (short i=0; i<fNumberOfIntervals;) {
                stopwatch.start();
                fActualDelay += delay(fIntervalMicroseconds[i++]);
                stopwatch.stop();
                if (i<fNumberOfIntervals) delay(fIntervalMicroseconds[i++]);
        }
}

void IStartStopTimingTestTest::emptyStartStopTimingTest(ITimingTestStopwatch& stopwatch)
{
        for (short i=0; i<fNumberOfIntervals;) {
                stopwatch.start();
                fActualDelay +=delay(fIntervalMicroseconds[kEmptyInterval]);
                i++;
                stopwatch.stop();
                if (i<fNumberOfIntervals) { // delay(fIntervalMicroseconds[i++]);
                        i++; // Don't need to call the second delay; it isn't timed anyway
                }
        }
}

void IStartStopTimingTestTest::setup()
{
        IStartStopTimingTest::setup();
        fActualDelay = 0.0;
        if (success()) {
                double a = 0.0;
                bool goodParse = parseArguments();
                fIntervalMicroseconds[kEmptyInterval] = a;
                setSuccess(goodParse);
                if (goodParse) {
                        for (short i=0; i<fNumberOfIntervals; i+=2)
                                a += fIntervalMicroseconds[i];
                        outputTextStream() << "(Nominal expected time = " << a << " us)\n";
                }
        }
}

void IStartStopTimingTestTest::cleanup()
{
        IStartStopTimingTest::cleanup();

        double t = calibratedMedianMicroseconds(), err = errorMicroseconds();
        double expected = fActualDelay / (double(timingCount()) * sampleCount());

        bool success = (expected >= (t-err)) && (expected <= (t+err));

        outputTextStream().pushTier(ITieredTextBuffer::kNormal);

        outputTextStream() << (success? "Pass": "FAIL")
                << ": measured expected time = "
                << expected << " us, " << (success? "within": "out of")
                << " range\n" ;
        outputTextStream().popTier();

        setSuccess(success);
}

//-----------------------------------------------------------------------------
// IStartStopTimingTestTest: PRIVATE Methods
//-----------------------------------------------------------------------------

bool IStartStopTimingTestTest::parseArguments()
{
        bool goodParse = true, oneGoodParse;
        IArgumentDictionary arguments(*this);
        for (fNumberOfIntervals = 0; fNumberOfIntervals < kMaximumIntervals;
                fNumberOfIntervals++) {
                double value;

                oneGoodParse = arguments.nthNumber(fNumberOfIntervals + (short)1, value, 0);

                if (goodParse && oneGoodParse) {
                        fIntervalMicroseconds[fNumberOfIntervals] = value;
                        outputTextStream() <<
                                ((fNumberOfIntervals % 2) ? "Untimed" : "Timed  ")
                                << " interval = " << value << " us\n";
                }
                else
                        break;
        }

        if (!fNumberOfIntervals) {
                outputTextStream().pushTier(ITieredTextBuffer::kHeadline);

                outputTextStream() << "IStartStopTimingTestTest - Error; please supply at least one "
                           "interval value\n" ;
                outputTextStream().popTier();
                return false;
        }
        return goodParse;
}

double IStartStopTimingTestTest::delay(double microseconds)
{
        double now;
        fClock.timeNow(now);
        double  whenToStop = now;
        double  delayInterval = microseconds;
        whenToStop += delayInterval;
        double start = now;
        while (now < whenToStop) fClock.timeNow(now);
        return now - start;
}


//eof

