/*
-------------------------------------------------------------------------------
Copyright (c) IBM Corporation 1997.
All Rights Reserved.

Permission is granted to copy, use, modify, and merge this software into your
applications and to permit others to do any of the foregoing. You must include
this permission and copyright notice in all copies and modified versions of
this software. THIS SOFTWARE IS PROVIDED IN ITS 'AS IS' CONDITION.
IBM DISCLAIMS ANY LIABILITY OF ANY KIND FOR DAMAGES WHATSOEVER RESULTING FROM
THE USE OF THIS SOFTWARE.
-------------------------------------------------------------------------------
*/
// Revision: 18 1.3.2.2 samples/testfw/tssttest.hpp, ocsamples-L1, ioc.v400, 981106 
#ifndef _TSSTTEST_H
#define _TSSTTEST_H

#include "issttest.hpp"
#include  "iargdict.hpp"
#include "ismpclck.hpp"
//-----------------------------------------------------------------------------
// TStartStopTimingTestTest Declaration
//-----------------------------------------------------------------------------

class IStartStopTimingTestTest : public IStartStopTimingTest{
public:

        //-------------------------------------------------------------------------
        // Special Member Functions
        //-------------------------------------------------------------------------
        IStartStopTimingTestTest();
        virtual ~IStartStopTimingTestTest();

protected:
        //-------------------------------------------------------------------------
        // Timing Framework Methods
        //-------------------------------------------------------------------------
        virtual void    startStopTimingTest(ITimingTestStopwatch&);
        virtual void    emptyStartStopTimingTest(ITimingTestStopwatch&);

        //-------------------------------------------------------------------------
        // TTest Framework Methods
        //-------------------------------------------------------------------------
        virtual void    setup();
        virtual void    cleanup();

private:
                        bool    parseArguments();
                        double  delay(double microseconds);

        // The following data members describe timing intervals to be used for this
        // test. The kEmptyInterval is an index to a zero interval in the
        // fIntervalMicroseconds array. The array is big enough to hold
        // kMaximumIntervals plus one extra (the kEmptyInterval). The kEmptyInterval
        // is used for the EmptyTimingTest method.
        enum    {kMaximumIntervals = 8, kEmptyInterval = kMaximumIntervals};
 ISimpleClock fClock;
        short   fNumberOfIntervals;
        double  fIntervalMicroseconds[kMaximumIntervals + 1];
        double  fActualDelay; // Records the actual total delay across all samples

};

#endif
