/*
-------------------------------------------------------------------------------
Copyright (c) IBM Corporation 1997.
All Rights Reserved.

Permission is granted to copy, use, modify, and merge this software into your
applications and to permit others to do any of the foregoing. You must include
this permission and copyright notice in all copies and modified versions of
this software. THIS SOFTWARE IS PROVIDED IN ITS 'AS IS' CONDITION.
IBM DISCLAIMS ANY LIABILITY OF ANY KIND FOR DAMAGES WHATSOEVER RESULTING FROM
THE USE OF THIS SOFTWARE.
-------------------------------------------------------------------------------
*/
// Revision: 19 1.3.2.2 samples/testfw/tstkstst.cpp, ocsamples-L1, ioc.v400, 981106 
#include "tstkstst.hpp"

#include <stdio.h>
#include <string.h>

//--------------------------------------------------------------------
// Definition of ISSTest
//--------------------------------------------------------------------
ISSTest::ISSTest() { }

ISSTest::~ISSTest() { }

void ISSTest::test() { }


void ISSTest::setStickyTestSuccess(bool success)
{
        setStickySuccess(success);
}

void ISSTest::setTestSuccess(bool success)
{
        setSuccess(success);
}


//--------------------------------------------------------------------
// Definition of IStickySuccessTest
//--------------------------------------------------------------------
IStickySuccessTest::IStickySuccessTest() { }

IStickySuccessTest::~IStickySuccessTest() { }

void IStickySuccessTest::setup()
{
        fTest = new ISSTest();
}

void IStickySuccessTest::test()
{
        setSuccess(true);

        fTest->setStickyTestSuccess(true);
        if (!fTest->success()) {
                outputTextStream() << "Error: Can't set sticky success to true\n";
                setSuccess(false);
        }

        fTest->setStickyTestSuccess(false);
        if (fTest->success()) {
                outputTextStream() << "Error: Can't set sticky success to false\n";
                setSuccess(false);
        }
        fTest->setStickyTestSuccess(true);
        if (fTest->success()) {
                outputTextStream() << "Error: Able to set sticky success to true even with sticky on.\n";
                setSuccess(false);
        }
        fTest->setTestSuccess(true);
        if (fTest->success()) {
                outputTextStream() << "Error: Able to set success to true even with sticky on.\n";
                setSuccess(false);
        }
}

void IStickySuccessTest::cleanup()
{
        delete fTest;
}

void IStickySuccessTest::copyInfo()
{
        addInfo(kDescriptionKey, IString("Test the sticky success feature of TTest."));

}

