/*
-------------------------------------------------------------------------------
Copyright (c) IBM Corporation 1997.
All Rights Reserved.

Permission is granted to copy, use, modify, and merge this software into your
applications and to permit others to do any of the foregoing. You must include
this permission and copyright notice in all copies and modified versions of
this software. THIS SOFTWARE IS PROVIDED IN ITS 'AS IS' CONDITION.
IBM DISCLAIMS ANY LIABILITY OF ANY KIND FOR DAMAGES WHATSOEVER RESULTING FROM
THE USE OF THIS SOFTWARE.
-------------------------------------------------------------------------------
*/
// Revision: 21 1.4.2.2 samples/testfw/ttargtst.cpp, ocsamples-L1, ioc.v400, 981106 
#include "ttargtst.hpp"

#include <stdio.h>
#include <string.h>
#include <iseq.h>

IArgumentDictionaryTest::IArgumentDictionaryTest() { }

IArgumentDictionaryTest::~IArgumentDictionaryTest() { }

void IArgumentDictionaryTest::setup()
{
}

void IArgumentDictionaryTest::test()
{
        IString text;
        setSuccess(true);
        IString emptyString;

        // Inputs through command line must be "-foo 100 -bar fork spoon -ccc 84 -85"
        outputTextStream() << "creating arguments from test.\n";
        IArgumentDictionary dict1(*this, "-bar");

        IString arg;
        dict1.exportTextArguments(arg);  // Testing exportTextArgument
        outputTextStream() << arg << "\n";
        if (arg != "-bar -ccc 84 -foo 100 fork spoon -85")
        {
                outputTextStream() << "creating argument from test with naked option failed\n";
                setSuccess(false);
        }
        if (dict1.countOfArguments() != 6)  // Testing countOfArguments
        {
                outputTextStream() << "countOfArguments failed\n";
                setSuccess(false);
        }

        // Test nthNumber
        double value;
        bool result = dict1.nthNumber(3, value);
        if (!result){
                outputTextStream() << "nthNumber failed\n";
                setSuccess(false);
        }

        long value2;
        if (!dict1.nthNumber(3, value2)){
                outputTextStream() << "nthNumber failed\n";
                setSuccess(false);
        }

        IString argString("-dog -fruit apple bannana -numbers 111 222");
        outputTextStream() << "createing arguments from string: " << argString << (char)'\n';
        IArgumentDictionary dict2(argString);

        IString argString2("-c -fruit apple bannana -numbers 111 222 -names \"George Washington\"  \"Abe Lincoln\" -d 1234.5678 -i 9999888899889");
        outputTextStream() << "createing arguments with naked options -fruit: " << argString2 << (char)'\n';
        IArgumentDictionary dict3(argString2, IString("-fruit"));

        // Test TextAt
        if (!dict3.textAt(IString("-c"), text)){
                outputTextStream() << "TextAt fails for -c option\n";
                setSuccess(false);
        } else if (!(text == emptyString)) {
                outputTextStream() << "Invalid value returned from TextAt -c: " <<text << (char)'\n';
                setSuccess(false);
        }

        if (!dict3.textAt(IString("-fruit"), text)){
                outputTextStream() << "TextAt fails for -fruit option\n";
                setSuccess(false);
        } else if (!(text==emptyString)) {
                outputTextStream() << "Invalid value returned from TextAt -fruit: " << text << (char)'\n';
                setSuccess(false);
        }

        if (!dict3.textAt(IString("-numbers"), text)){
                outputTextStream() << "TextAt fails for -numbers option\n";
                setSuccess(false);
        } else if (text != IString("111")) {
                outputTextStream() << "Invalid value returned from TextAt -numbers: " <<text << (char)'\n';
                setSuccess(false);
        }

        if (!dict3.textAt(IString("-names"), text)){
                outputTextStream() << "TextAt fails for -names option\n";
                setSuccess(false);
        } else if (text != IString("George Washington")) {
                outputTextStream() << "Invalid value returned from TextAt -names: " << text << (char)'\n';
                setSuccess(false);
        }

        if (dict3.textAt(IString("-bad"), text)){
                outputTextStream() << "TextAt fails for -bad option. Value returned. " << text << (char)'\n';
                setSuccess(false);
        }

        // Test Nth Value
        if (!dict3.nthValue(1, text)){
                outputTextStream() << "NthValue fails for 1\n";
                setSuccess(false);
        } else if (text != IString("apple")) {
                outputTextStream() << "Invalid value returned from NthValue(1): " << text << (char)'\n';
                setSuccess(false);
        }

        if (!dict3.nthValue(2, text)){
                outputTextStream() << "NthValue fails for 2\n";
                setSuccess(false);
        } else if (text != IString("bannana")) {
                outputTextStream() << "Invalid value returned from NthValue(2): " << text << (char)'\n';
                setSuccess(false);
        }

        if (!dict3.nthValue(3,text)){
                outputTextStream() << "NthValue fails for 3\n";
                setSuccess(false);
        } else if (text != IString("222")) {
                outputTextStream() << "Invalid value returned from NthValue(3): " <<text << (char)'\n';
                setSuccess(false);
        }

        if (!dict3.nthValue(4, text)){
                outputTextStream() << "NthValue fails for 4\n";
                setSuccess(false);
        } else if (text != IString("Abe Lincoln")) {
                outputTextStream() << "Invalid value returned from NthValue(4): " << text << (char)'\n';
                setSuccess(false);
        }

        if (dict3.nthValue(5, text)){
                outputTextStream() << "NthValue fails for 5. Value returned. " << text << (char)'\n';
                setSuccess(false);
        }

        // Test FindSimilarKeys
        if (!dict3.findSimilarKey(IString("-NumBers"), text)){
                outputTextStream() << "FindSimilarKey fails for -NumBers\n";
                setSuccess(false);
        } else if (text != IString("-numbers")) {
                outputTextStream() << "Invalid key returned from FindSimilarKeys(\"-NumBers\"): " << text << (char)'\n';
                setSuccess(false);
        }

        if (!dict3.findSimilarKey(IString("-na"), text)){
                outputTextStream() << "FindSimilarKey fails for -na\n";
                setSuccess(false);
        } else if (text != IString("-names")) {
                outputTextStream() << "Invalid key returned from FindSimilarKeys(\"-na\"): " << text << (char)'\n';
                setSuccess(false);
        }

        if (!dict3.findSimilarKey(IString("-n"), text)){
                outputTextStream() << "FindSimilarKey fails for -n\n";
                setSuccess(false);
        } else if (text != IString("-names")) {
                outputTextStream() << "Invalid key returned from FindSimilarKeys(\"-n\"): " << text << (char)'\n';
                setSuccess(false);
        }

        if (dict3.findSimilarKey(IString("-bad"), text)){
                outputTextStream() << "FindSimilarKey fails for -bad. value returned. " <<text << (char)'\n';
                setSuccess(false);
        }

        if (dict3.findSimilarKey(IString("-longoptionhere"), text)){
                outputTextStream() << "FindSimilarKey fails for -longoptionhere. value returned. " << text << (char)'\n';
                setSuccess(false);
        }

        // Test LookupSimilarKeys
        dict3.lookupSimilarKeys(true);
        if (!dict3.textAt(IString("-NumB"), text)){
                outputTextStream() << "TextAt fails for -NumB\n";
                setSuccess(false);
        } else if (text != IString("111")) {
                outputTextStream() << "Invalid key returned from TextAt(\"-NumB\"): " << text << (char)'\n';
                setSuccess(false);
        }

        // Test RemoveLookup
        dict3.removeOnLookup(true);
        if (!dict3.textAt(IString("-n"),text)){
                outputTextStream() << "TextAt fails for -n\n";
                setSuccess(false);
        } else if ( text != IString("George Washington")) {
                outputTextStream() << "Invalid key returned from TextAt(\"-n\"): " << text << (char)'\n';
                setSuccess(false);
        }

        if (!dict3.textAt(IString("-n"),text)){
                outputTextStream() << "TextAt fails for -n (2nd call)\n";
                setSuccess(false);
        } else if (text != IString("111")) {
                outputTextStream() << "Invalid key returned from TextAt(\"-n\") (2nd call): " << text << (char)'\n';
                setSuccess(false);
        }

        if (dict3.textAt(IString("-numbers"), text)){
                outputTextStream() << "TextAt fails for -numbers. value returned\n";
                setSuccess(false);
        }

        if (dict3.textAt(IString("-names"), text)){
                outputTextStream() << "TextAt fails for -names. value returned\n";
                setSuccess(false);
        }

        const char**            argv = new const char*[100];
        int                     argc = 0;

        argv[argc] = "command"; argc++;
        argv[argc] = "-a"; argc++;
        argv[argc] = "one"; argc++;
        argv[argc] = "two two"; argc++;
        argv[argc] = "three"; argc++;

        const char **v = argv;

        outputTextStream() << "createing arguments from argc, argv:\n " ;
        outputTextStream() << " arguments are: \n";
        for (int j=0; j<argc; j++) {
                outputTextStream() << argv[j] << (char)'\n';
        }
        IArgumentDictionary dict4(argc, v);
        delete [] argv;


        if (!dict4.textAt(IString("-a"),text)){
                outputTextStream() << "textAt fails for -a option\n";
                setSuccess(false);
        } else if (text !=IString("one")) {
                outputTextStream() << "Invalid value returned from textAt -a: " << text << (char)'\n';
                setSuccess(false);
        }

        if (!dict4.nthValue(1, text)){
                outputTextStream() << "NthValue fails for 1\n";
                setSuccess(false);
        } else if (text != IString("two two")) {
                outputTextStream() << "Invalid value returned from NthValue(1): " << text << (char)'\n';
                setSuccess(false);
        }


        if (!dict4.nthValue(2,text)){
                outputTextStream() << "NthValue fails for 2\n";
                setSuccess(false);
        } else if (text !=IString("three")) {
                outputTextStream() << "Invalid value returned from NthValue(2): " << text << (char)'\n';
                setSuccess(false);
        }

        IString argCopy;
        dict4.exportTextArguments(argCopy);
        if (argCopy != IString("-a one two two three")) {
                outputTextStream() << "Invalid string returned from ExporITextArguments: " << argCopy << (char)'\n';
                setSuccess(false);
        }



        // Test NumberAt.  This is copied from the NumberAtTest in TestTestFramework.
        enum EType {kInt, kFloat};

        const double kFloatFiller = 9.9;
        const long kIntFiller = 99;

        //static
         const struct {
                char*   key;
                char*   value;
                bool    valid;          // if true, then this should parse successfully
                EType   type;
                long    intValue;       // Used if type == kInt
                double  floatValue;     // Used if type == kFloat
        } kCase[] = {
                {"-l1", "2147483647",   true,   kInt,   2147483647,                     kFloatFiller},
                {"-l2", "-2147483648",  true,   kInt,   ((long)-2147483648),kFloatFiller},
                {"-l3", "0",                    true,   kInt,   0,                                      kFloatFiller},

                {"-x1", "2147483648",   false,  kInt,   kIntFiller,                     kFloatFiller},
                {"-x2", "-2147483649",  false,  kInt,   kIntFiller,                     kFloatFiller},
                {"-x3", "1234.5678",    false,  kInt,   kIntFiller,                     kFloatFiller},
#ifndef __OS2__
                {"-x4", "abc",                  false,  kInt,   kIntFiller,                     kFloatFiller},
#endif
                {"-f1", "0",                    true,   kFloat, kIntFiller,             0.0                     },
                {"-f2", "1",                    true,   kFloat, kIntFiller,             1.0                     },
                {"-f3", "-1",                   true,   kFloat, kIntFiller,             -1.0            },
                {"-f4", "1234.5678",    true,   kFloat, kIntFiller,             1234.5678       },
                {"-f5", "-9876.5432",   true,   kFloat, kIntFiller,             -9876.5432      },

                {"-y1", "abc",                  false,  kFloat, kIntFiller,             kFloatFiller},
                {"-y2", "-1e99999999",  false,  kFloat, kIntFiller,             kFloatFiller}
        };

        //static const long kNCases = sizeof(kCase)/sizeof(kCase[0]);
        const long kNCases = sizeof(kCase)/sizeof(kCase[0]);


        IString inputs;
        long i;
        IString space(" ");
        for (i=0; i<kNCases; ++i) {
                inputs += IString(kCase[i].key);
                inputs += space;
                inputs += IString(kCase[i].value);
                inputs += space;
        }

        IArgumentDictionary dict5(inputs);

        IString key;

        bool successes = success();
        bool there;
        volatile bool okay = true; // volatile so as to survive an exception

        long longNumber;
        double doubleNumber;

        for (i=0; i<kNCases; ++i) {
                key = IString(kCase[i].key);

                outputTextStream().setTier(ITieredTextBuffer::kHeadline);
                okay = false;

                        if (kCase[i].type == kInt) {
                                if (there = dict5.numberAt(key, longNumber)) {
                                        if (longNumber == kCase[i].intValue && kCase[i].valid)
                                                okay = true;
                                }
                        }
                        else {
                                if (there = dict5.numberAt(key, doubleNumber)) {
                                        if (doubleNumber == kCase[i].floatValue && kCase[i].valid)
                                                okay = true;
                                }
                        }
                        if (!there && !kCase[i].valid) {
                                okay = true;
                        } else if (!there) {
                                outputTextStream() << "Key not found or not valid argument: " << key << (char)'\n';
                        }

                if (okay) outputTextStream().setTier(ITieredTextBuffer::kHeadline);
                else successes = false;

                outputTextStream()
                        << (okay? "Pass: ": "FAIL: ")
                        << (kCase[i].type == kInt ? "int": "float")
                        << " \"" << kCase[i].value;

                if (kCase[i].valid) {
                        outputTextStream()
                                << "\", expected ";

                        if (kCase[i].type == kInt) {
                                outputTextStream() << kCase[i].intValue
                                        << ", actual " << longNumber << (char)'\n';
                        }
                        else {
                                outputTextStream() << kCase[i].floatValue
                                        << ", actual " << doubleNumber << (char)'\n';
                        }
                }
                else {
                        outputTextStream()
                                << "\", expected conversion failure\n";
                }
        }


        setSuccess(successes);
}

void IArgumentDictionaryTest::cleanup()
{
}

void IArgumentDictionaryTest::copyInfo()
{
        addInfo(kDescriptionKey, IString("Test which tests TextArgumentDictionary."));

        addInfo(kInputSyntaxKey, IString("[-c count] [-s string]"));

}

