/*
-------------------------------------------------------------------------------
Copyright (c) IBM Corporation 1997.
All Rights Reserved.

Permission is granted to copy, use, modify, and merge this software into your
applications and to permit others to do any of the foregoing. You must include
this permission and copyright notice in all copies and modified versions of
this software. THIS SOFTWARE IS PROVIDED IN ITS 'AS IS' CONDITION.
IBM DISCLAIMS ANY LIABILITY OF ANY KIND FOR DAMAGES WHATSOEVER RESULTING FROM
THE USE OF THIS SOFTWARE.
-------------------------------------------------------------------------------
*/
// Revision: 23 1.5.2.2 samples/testfw/ttbuftst.cpp, ocsamples-L1, ioc.v400, 981106 
#include "ttbuftst.hpp"

ITieredTextBufferTest::ITieredTextBufferTest() { }

ITieredTextBufferTest::~ITieredTextBufferTest() { }

void ITieredTextBufferTest::test()
{
        unsigned char uc = 'A';
        signed char sc  = 'B';
        char c = 'C';
        static char s[] = "abcdefghijklmnopqrstuvwxyz";
        int i = 425;
        short int j = 17;
        unsigned int u = 0xf179;
        long int l = 75000L;
        float f = 12.978;
        double d = -97.4583;
        unsigned long ul = 4147483647L;
        unsigned short us = 60000;
        char *helloText = "hello";
        long double ld = -1234.1234;
        IString string("simple text");
        ITieredTextBuffer& out = outputTextStream();

        ITieredTextBuffer::ETier saveTier, tier;
        saveTier = out.tier();

        setSuccess(true);
        // test ostream operator.
        out << "ITieredTextBufferTest - Test method called.\n";
        out << "signed char is  " << sc << "\n";
        out << "char is  " << c << "\n";
        out << "int is  " << i << "\n";
        out << "short is " << j<< "\n";
        out << "float is  " << f << "\n";
        out << "double is  " << d << "\n";
        out << "long is  " << l << "\n";
        out << "unsigned long is  " << ul << "\n";
        out << "unsigned short is  " << us << "\n";
        out << "unsigned int is " << u << "\n";
        out << "unsigned char is  " << uc << "\n";
        out << "char string is  " << s << "\n";
        // out << "helloText pointer is  " << (void *)helloText << "\n";
        out << "long double is  " << ld << "\n";
        out << "IString is " << string << "\n";


        // test setIndent, setRelativeIndent and indent
        out.setIndent(1);
        if (out.indent() != 1){
                out << "error in indentation\n";
                setSuccess(false);
        }
        else out << "indent = 1\n";

        out.setRelativeIndent(1);
        out.setRelativeIndent(2);
        out.setRelativeIndent(-1);
        if (out.indent() != 3){
                out << "error in indentation\n";
                setSuccess(false);
        }
        else out << "indent = 3\n";

        out.setIndent(0);
        if (out.indent() != 0){
                out << "error in indentation\n";
                setSuccess(false);
        }
        else out << "indent = 0\n";


        // test SetTier and GetTier
        out.setTier(ITieredTextBuffer::kGeneral);
        tier = out.tier();

        if (tier != ITieredTextBuffer::kGeneral) {
                out.setTier(saveTier);
                out << "error in setting tier.\n";
                setSuccess(false);
        }

        out.setTier(saveTier);


        // test SetEchoTier and GetEchoTier
        saveTier = out.echoTier();
        out.setEchoTier(ITieredTextBuffer::kGeneral);
        tier = out.echoTier();

        if (tier != ITieredTextBuffer::kGeneral) {
                out.setEchoTier(saveTier);
                out << "error in setting tier.\n";
                setSuccess(false);
        }

        out.setEchoTier(saveTier);

        // test PushTier and PopTier
        saveTier = out.tier();
        out.pushTier(ITieredTextBuffer::kDebug);

        if (out.tier() != ITieredTextBuffer::kDebug) {
                out.setTier(saveTier);
                out << "error in pushing tier.\n";
                setSuccess(false);
        }

        if (out.popTier() != ITieredTextBuffer::kDebug) {
                out.setTier(saveTier);
                out << "error incorrect tier returned from PopTier.\n";
                setSuccess(false);
        }

        if (out.tier() != saveTier) {
                out.setTier(saveTier);
                out << "PopTier does not restore tier.\n";
                setSuccess(false);
        }

        out.setTier(saveTier);

}


