/*
-------------------------------------------------------------------------------
Copyright (c) IBM Corporation 1997.
All Rights Reserved.

Permission is granted to copy, use, modify, and merge this software into your
applications and to permit others to do any of the foregoing. You must include
this permission and copyright notice in all copies and modified versions of
this software. THIS SOFTWARE IS PROVIDED IN ITS 'AS IS' CONDITION.
IBM DISCLAIMS ANY LIABILITY OF ANY KIND FOR DAMAGES WHATSOEVER RESULTING FROM
THE USE OF THIS SOFTWARE.
-------------------------------------------------------------------------------
*/
// Revision: 26 1.3.2.2 samples/testfw/ttestrun.hpp, ocsamples-L1, ioc.v400, 981106 
#ifndef _TTESTRUN_H
#define _TTESTRUN_H

#include "itest.hpp"


//-----------------------------------------------------------------------------
//  ITestTestRun tests ITest::run
//-----------------------------------------------------------------------------
class ITestTestRun: public ITest {
public:

        //----------------------------------------------------------------------
        // Special Member Functions
        //----------------------------------------------------------------------
                                                                ITestTestRun();
                                                                ITestTestRun(const ITestTestRun&);
                        ITestTestRun&           operator=(const ITestTestRun&);
        virtual                                         ~ITestTestRun();

        //----------------------------------------------------------------------
        // ITest Overrides
        //----------------------------------------------------------------------
        virtual void                            run();

protected:
        //----------------------------------------------------------------------
        // ITest Overrides
        //----------------------------------------------------------------------
        virtual void                            reset();
        virtual void                            setup();
        virtual void                            test();
        virtual void                            cleanup();

private:
                        bool                            parseInput();

        ITest::EStage   fExceptionStage;
        ITest::EStage   fNextExpectedStage;
        bool            fNeedToParseInput;
        bool            fLocalSuccess;

};

#endif
//eof

