/*
-------------------------------------------------------------------------------
Copyright (c) IBM Corporation 1997.
All Rights Reserved.

Permission is granted to copy, use, modify, and merge this software into your
applications and to permit others to do any of the foregoing. You must include
this permission and copyright notice in all copies and modified versions of
this software. THIS SOFTWARE IS PROVIDED IN ITS 'AS IS' CONDITION.
IBM DISCLAIMS ANY LIABILITY OF ANY KIND FOR DAMAGES WHATSOEVER RESULTING FROM
THE USE OF THIS SOFTWARE.
-------------------------------------------------------------------------------
*/
// Revision: 29 1.5.2.2 samples/testfw/ttimetst.cpp, ocsamples-L1, ioc.v400, 981106 

#include "ttimetst.hpp"

ITimingTestTest::ITimingTestTest()
{
}

ITimingTestTest::ITimingTestTest(const ITimingTestTest& source):ITimingTest(source)
{
}

ITimingTestTest::~ITimingTestTest()
{
}

void
ITimingTestTest::setup()
{
        bool            timingOn = true;

        ITimingTest::setup();

        setTimingOn(timingOn);  // default value
        setTimingCount(500);   // default = 300
        setSampleCount(25);   // default = 10
        setAutomaticSampling(true);  // default value
        setMaximumSampleWindows(20);  // default = 10
        setAutomaticSampleTolerance(0.05);  // default = 0.1
}

void
ITimingTestTest::timingSetup()
{
        static long             samples = 0;
        unsigned long           sampleCount;
        ITieredTextBuffer&      out = outputTextStream();

        sampleCount = samplesTaken();
        if (samples != sampleCount) {
                out << "samples = " << samples << "\tsampleCount = " << sampleCount << "\n";
                setSuccess(false);
        }
        samples++;
}

void
ITimingTestTest::timingTest()
{

}

void
ITimingTestTest::cleanup()
{
        long                    sampleCount, samplesTaken, comparisonCount;
        double                  *samplesArray, *comparisonArray;
        ITieredTextBuffer&      out = outputTextStream();
        ITimingTestTest other(*this);

        ITimingTest::cleanup();

    copySamples (sampleCount, samplesArray);
        for (int i = 0; i < sampleCount; i++) {
                out << "Sample #" << i << ":  " << samplesArray[i] << "\n";
        }

        //  Now let's check out that copy constructor...

        comparisonCount = other.sampleCount();

        if (comparisonCount != sampleCount) {
                out << "Error: sampleCount does not equal comparisonCount.\n";
                setSuccess(false);
        }

        other.copySamples(comparisonCount, comparisonArray);
        for (int j = 0; j < comparisonCount; j++) {
                if (samplesArray[j] != comparisonArray[j]) {
                        out << "Error: copy constructed sampleArray is not identical to original.\n";
                        setSuccess(false);
                }
        }

        delete samplesArray;
        delete comparisonArray;
}


