/*
*****************************************************************************************
*                                                                                       *
* COPYRIGHT:                                                                            *
*   IBM Open Class Library                                                              *
*   (C) Copyright International Business Machines Corporation,  1997                    *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.                  *
*   US Government Users Restricted Rights - Use, duplication, or disclosure             *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                              *
*                                                                                       *
*****************************************************************************************
*/
// Revision: 62 1.6.1.5 source/core/text/intl/compare/posix/posxcoll.cpp, text, ioc.v400, 990114 
//===============================================================================
//
// File posxcoll.cpp
//
//
//
// Created by: Helena Shih
//
// Modification History:
//
//      Date         Name          Description
//
//===============================================================================

#include <string.h>
#include <stdlib.h>
#include <wchar.h>
#include <locale.h>

#ifndef IC_ITXTCOLL
#include <itxtcoll.hpp>
#endif

#ifndef IC_ITXCLIMP
#include <itxclimp.hpp>
#endif

#ifndef IC_IEXCBASE
#include <iexcbase.hpp>
#endif

#ifdef IC_PAGETUNE
        #define _POSXCOLL_CPP
        #include <ipagetun.h>
#endif

#ifdef __POSIX__
IPOSIXCollation::IPOSIXCollation()
        : ICollation()
{
}

IPOSIXCollation::IPOSIXCollation(const ILocaleKey& localeKey,
                                 ICollation::ECollationStrength strength)
{
    this->setLocaleKey(localeKey);
    this->setStrength(strength);
}

IPOSIXCollation::IPOSIXCollation(const IPOSIXCollation& order)
        : ICollation(order)
{
}

IPOSIXCollation::~IPOSIXCollation(void)
{
    this->setLocaleKey(ILocaleKey::defaultLocale());
    this->setStrength(ICollation::kTertiaryDifference);
}

IPOSIXCollation&
IPOSIXCollation::operator=(const IPOSIXCollation& that)
{
    return *this;
}

IText
IPOSIXCollation::displayName(const ILocaleKey& desiredLanguage,
                             ILocaleKey::ELookupStrategy strategy) const
{
    return (localeKey().displayName(desiredLanguage, strategy));
}

int
IPOSIXCollation::do_compare(const UniChar* sourceLow,
                            const UniChar* sourceHigh,
                            const UniChar* targetLow,
                            const UniChar* targetHigh) const
{
        if ((sourceHigh < sourceLow) || (targetHigh < targetLow)) {
                ITHROW(IInvalidParameter("Incorrect text offsets!"));
        }
    char *locStr, *saveStr = 0;
    if (NULL != (locStr = setlocale(LC_ALL, NULL))) {
        saveStr = new char[strlen(locStr)+1];
        strcpy(saveStr, locStr);
    }
    setlocale(LC_ALL, localeKey().posixID());
    int result = wcscoll((wchar_t*)sourceLow, (wchar_t*)targetLow);
    if (saveStr) {
        setlocale(LC_ALL, saveStr);
        delete [] saveStr;
    }
    if (result < 0 ) {
       return ICollation::kSourceLess;
    } else if (result > 0) {
       return ICollation::kSourceGreater;
    } else {
       return ICollation::kSourceEqual;
    }
}

IText
IPOSIXCollation::do_transform(const IText& source) const
{
    UniChar *sourceStr = 0;
    IText::length_type chunkLength = 0;
    wchar_t *newString = 0;
    char *locStr = 0, *saveStr = 0;

    if (NULL != (locStr = setlocale(LC_ALL, NULL))) {
        saveStr = new char[strlen(locStr)+1];
        strcpy(saveStr, locStr);
    }
    setlocale(LC_ALL, localeKey().posixID());
    sourceStr = createUniCharChunk(source, chunkLength);
    size_t  length = wcsxfrm(NULL, (wchar_t*)sourceStr, 0),
                    oldLength = wcslen((wchar_t*)sourceStr);
    if (length) {
            newString = new wchar_t[length+1];
    }
#ifdef __OS2__
    if (wcsxfrm(newString, (wchar_t*)sourceStr, oldLength) != length) {
        // this seems wrong, but the version below (which is based on what the POSIX
                // manual says) doesn't work right              --RTG
#elif defined(_AIX)
    if (wcsxfrm(newString, (wchar_t*)sourceStr, length) != length) {
#endif
            ITHROW( IInvalidRequest( "Unknown system error occurs when calling wcsxfrm()." ) );
    }
    IText tmp((UniChar*)newString);
    if (newString)
        delete [] newString;
    delete [] sourceStr;
    if (saveStr) {
        setlocale(LC_ALL, saveStr);
        delete [] saveStr;
    }
    return tmp;
}

#endif
