// Revision: 16 1.8.1.8 source/dde/iddeccnv.cpp, dde, ioc.v400, 990114 
/*******************************************************************************
* FILE NAME: iddeccnv.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Definition of the class(es):                                               *
*     IDDEClientConversation - Defines a client DDE conversation.              *
*     IDDEActiveServer       - Represents a DDE server supporting a            *
*                              particular topic.                               *
*     IDDEActiveServerSet    - Set of active DDE servers.                      *
*     IDDEClientHotLinkSet   - Set of active hot links.                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *                                          *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
extern "C"
{
   #define INCL_WINDDE
   #define INCL_DOSQUEUES
   #define INCL_DOSPROCESS
   #define INCL_DOSERRORS
   #define INCL_DOSSEMAPHORES
   #include <iwindefs.h>
   #include <string.h>
   #ifdef IC_WIN
      #include <dde.h>            // for Win32 DDE definition
   #endif
}

#include <iddeccnv.hpp>

#ifdef IC_PMWIN

#include <iddeinfo.hpp>
#include <iddecset.hpp>
#include <itrace.hpp>
#include <irect.hpp>
#include <iexcept.hpp>
#include <iddeevt.hpp>
#include <iobjwin.hpp>
#include <iqueue2.h>
#include <iset2.h>
#include <icconst.h>
#include <ithread.hpp>

void    CCNVasDebugInfo( IEvent * foo );        //mkb for debugging
void    CCNVasDebugInfo( IEvent * foo )
{
   ITrace::write( "asDebugInfo(IEvent*) msg=" + IString(foo->eventId())
                + ", wParam=" + IString(foo->parameter1().asUnsignedLong())
                + ", lParam=" + IString(foo->parameter2().asUnsignedLong()));
}

#ifdef IC_PM
/*------------------------------------------------------------------------------
| An object of this class is create in the dispatchEventFromQueue function.    |
| This guarantees that when we exit that secondary thread function, (either    |
| because an exception has been thrown, or because we issued a                 |
| DosCloseQueue in the IDDEClientConversation dtor), that the DosWaitEvenSem   |
| in the IDDEClientConversation dtor will be satisfied and the dtor will       |
| safely complete.                                                             |
------------------------------------------------------------------------------*/
class IDDEFreeSemaphore {
public:
  IDDEFreeSemaphore ( unsigned long semaphore )
       : ulClSem(semaphore) { }
 ~IDDEFreeSemaphore ( ) {
    DosPostEventSem(ulClSem); }
unsigned long
  ulClSem;
};  // IDDEFreeSemaphore
#endif  /* IC_PM */

/*------------------------------------------------------------------------------
|  class IDDEClientConversationData                                            |
------------------------------------------------------------------------------*/
#ifdef IC_WIN
class IDDEClientConversationData
{
public:
   bool
     fClWaitInitAck;
};
#endif  /* IC_WIN */

/*------------------------------------------------------------------------------
|  class IDDEClosedConversation                                                |
------------------------------------------------------------------------------*/
class IDDEClosedConversation : public IDDEActiveServer {
public:
  IDDEClosedConversation  ( const char * appName,
                            const char * topic,
                            const IWindowHandle serverId,
                            bool userclose = false );
  ~IDDEClosedConversation ( );
IWindowHandle
  serverHandle ( ) const { return wndhClServer; }
bool
  userClosed ( ) const { return fClUsrCls; }
private:
IWindowHandle
  wndhClServer;
bool
  fClUsrCls;
}; // IDDEClosedConversation

/*------------------------------------------------------------------------------
|  class IDDEHotLinkXEvent                                                     |
------------------------------------------------------------------------------*/
class IDDEHotLinkXEvent : public IDDEClientHotLinkEvent {
public:
  IDDEHotLinkXEvent ( IEvent evt );
  ~IDDEHotLinkXEvent ( );
bool
  isCloseInProgress ( ) const { return fClCloseInPrgrs; }
void
  setCloseInProgress (bool clsInPrgrs) { fClCloseInPrgrs = clsInPrgrs; }
private:
bool
  fClCloseInPrgrs;
}; // IDDEHotLinkXEvent

/*------------------------------------------------------------------------------
| Transaction Queue                                                            |
|                                                                              |
| The transaction queue will maintain all transactions. When the transaction   |
| is completed and acknowledged by the server it is removed from the queue.    |
| The queue is protected from concurrent updates by the use of a semaphore     |
| (IPrivateResource).                                                          |
------------------------------------------------------------------------------*/
class IDDETransactionQueue : public IVPtrQueue<IDDEClientAcknowledgeEvent*>
{
public:
  IDDETransactionQueue ( );
  ~IDDETransactionQueue ( );
IPrivateResource
 &semaphor()
    { return priResCl; }
private:
  IDDETransactionQueue ( const IDDETransactionQueue& ) {}
  IDDETransactionQueue& operator= ( const IDDETransactionQueue& );
IPrivateResource
  priResCl;
}; // IDDETransactionQueue

/*------------------------------------------------------------------------------
|  class IDDEClosedConversationSet                                             |
------------------------------------------------------------------------------*/
class IDDEClosedConversationSet : public IVPtrSet<IDDEClosedConversation*>
{
public:
  IDDEClosedConversationSet ( );
  ~IDDEClosedConversationSet ( );
IPrivateResource
 &semaphor()
    { return priResCl; }
private:
  IDDEClosedConversationSet ( const IDDEClosedConversationSet& ) {}
  IDDEClosedConversationSet& operator= ( const IDDEClosedConversationSet& );
IPrivateResource
  priResCl;
}; // IDDEClosedConversationSet

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IDDECCNV_CPP_
  #include <ipagetun.h>
#endif

/*------------------------------------------------------------------------------
| IDdeleteElemASS                                                              |
------------------------------------------------------------------------------*/
bool  // not static because used by iddecset.cpp during destruction
  IDdeleteElemASS ( IDDEActiveServer* const& activeServer,
                    void*  )
{
   delete (IDDEActiveServer*)activeServer;
   return true;
}

/*------------------------------------------------------------------------------
| IDdeleteElemCHLS                                                             |
------------------------------------------------------------------------------*/
bool // not static because used by iddecset.cpp during destruction
  IDdeleteElemCHLS ( IDDEClientHotLinkEvent* const& hotLinkEvent,
                     void*                          item )
{
   int rc;
   if (item != 0)
   {
      IString tmpStr = IString::upperCase(hotLinkEvent->item());
      rc = strcmp(tmpStr, (char*)item);
   }
   if (item == 0 || rc == 0)
   {
      delete (IDDEHotLinkXEvent*)hotLinkEvent;
      return true;
   }
   return false;
}

/*------------------------------------------------------------------------------
| IDdeleteElemTQ                                                               |
------------------------------------------------------------------------------*/
static bool
  IDdeleteElemTQ ( IDDEClientAcknowledgeEvent* const& event,
                   void* )
   { delete (IDDEClientAcknowledgeEvent*)event;
     return true;  }

/*------------------------------------------------------------------------------
| IDdeleteElemCCS                                                              |
------------------------------------------------------------------------------*/
static bool
  IDdeleteElemCCS ( IDDEClosedConversation* const& conversation,
                    void* )
   { ITRACE_DEVELOP( conversation->application() +
        IString(" server application never responded to WM_DDE_TERMINATE "));
     delete (IDDEClosedConversation*)conversation;
     return true;  }


/*------------------------------------------------------------------------------
| IDDEClientConversation::IDDEClientConversation                               |
|                                                                              |
| Setting useEventThread will cause a thread to be used for the dispatching    |
| of handlers. A queue is also set up for dispatching events.                  |
------------------------------------------------------------------------------*/
IDDEClientConversation :: IDDEClientConversation ( bool useEventThread )
                            : wndhClServer(0),
                              fClBrdcstInPrgrs(false),
                              fClCaseSensitive(false),
                              fClPostMsgFail(false),
                              fClHdrActive(false),
                              strClTopic(),
                              strClApplication(),
                              pActServSetCl(0),
                              pThreadCl(0)
#ifdef   IC_WIN
                            , hFinish(0)
#endif
{
   IMODTRACE_DEVELOP("DDEClntConv::ctor");

#ifdef IC_WIN
   // create the private data class
   fDDEClientConversationData = new IDDEClientConversationData( );
   useEventThread = false;  /* now in W32 platform, multithread doesn't work */
#endif

   if (useEventThread)
   {
#ifdef IC_PM
      PPIB ppib;
      PTIB ptib;
      unsigned long ulRc = DosCreateEventSem(0,
                                             &ulClSemaphore,
                                             0,
                                             0);
      if (ulRc)
         ITHROWSYSTEMERROR(ulRc,"DosCreateEventSem",
             IBaseErrorInfo::outOfSystemResource, IException::recoverable);
      DosGetInfoBlocks( &ptib, &ppib );
      // ensure we have a unique queue handle by using PID
      IString tmp1((unsigned long)this);
      IString tmp2(ppib->pib_ulpid);
      IString strQueueName = IString("\\QUEUES\\") + tmp1 +
          IString("\\") + tmp2 + IString("\\.QUE");
      ITRACE_DEVELOP("Queue name is: " + strQueueName);
      ulRc = DosCreateQueue(&ulClQHandle,
                            0,
                            (char*)strQueueName);
      ITRACE_DEVELOP("DosCreateQueue rc =: " + IString(ulRc));
      if (ulRc)
         ITHROWSYSTEMERROR(ulRc,"DosCreateQueue",
             IBaseErrorInfo::outOfSystemResource, IException::recoverable);
      IThreadMemberFn<IDDEClientConversation> *myDispatcherFn = new
          IThreadMemberFn<IDDEClientConversation>
            (*this, &IDDEClientConversation::dispatchEventFromQueue);
      pThreadCl = new IThread(myDispatcherFn);
#endif  /* IC_PM */

#ifdef IC_WIN
   DWORD ulRc;

   hFinish = CreateEvent(NULL, TRUE, FALSE, NULL);

   if ( !CreatePipe(&hReadPipe, &hWritePipe, NULL, 0))
     { 
       delete fDDEClientConversationData;
       ulRc = GetLastError();
       ITHROWSYSTEMERROR(ulRc,"CreatPipe",
           IBaseErrorInfo::outOfSystemResource, IException::recoverable);
     }

   IThreadMemberFn<IDDEClientConversation> *myDispatcherFn = new
       IThreadMemberFn<IDDEClientConversation>
            (*this, &IDDEClientConversation::dispatchEventFromQueue);
   pThreadCl = new IThread(myDispatcherFn, IThread::defaultAutoInitGUI());
#endif  /* IC_WIN */
   }

   pwndClClient = new IObjectWindow(IObjectWindow::noStyle);
   pClsdConvSetCl = new IDDEClosedConversationSet;
   pHLSetCl = new IDDEClientHotLinkSet;
   pTransQCl = new IDDETransactionQueue;
#ifdef IC_PM
   pFormatSetCl = new IDDEFormatSet;
#endif
#ifdef IC_WIN
   pItemAtomSetCl = new IDDEItemAtomSet;
#endif
   wndhClClient = pwndClClient->handle();
   handleEventsFor((IWindow*)pwndClClient);
   ((IWindow*)pwndClClient)->setParent(IWindow::objectWindow());
}

/*------------------------------------------------------------------------------
| IDDEClientConversation::IDDEClientConversation                               |
|                                                                              |
| This constructor will also begin the conversation.                           |
------------------------------------------------------------------------------*/
IDDEClientConversation :: IDDEClientConversation  ( const char* application,
                                                    const char* topic,
                                                    bool     useEventThread )
                            : wndhClServer(0),
                              fClBrdcstInPrgrs(false),
                              fClCaseSensitive(false),
                              fClPostMsgFail(false),
                              fClHdrActive(false),
                              strClTopic(),
                              strClApplication(),
                              pActServSetCl(0),
                              pThreadCl(0)
#ifdef   IC_WIN
                            , hFinish(0)
#endif
{
   IMODTRACE_DEVELOP("DDEClntConv::ctor");

#ifdef IC_WIN
   // create the private data class
   fDDEClientConversationData = new IDDEClientConversationData( );
   useEventThread = false;  /* now in W32 platform, multithread doesn't work */
#endif

   if (useEventThread)
   {
#ifdef IC_PM
      PPIB ppib;
      PTIB ptib;
      unsigned long ulRc = DosCreateEventSem(0,
                                             &ulClSemaphore,
                                             0,
                                             0);
      if (ulRc)
         ITHROWSYSTEMERROR(ulRc,"DosCreateEventSem",
             IBaseErrorInfo::outOfSystemResource, IException::recoverable);
      // ensure we have a unique queue handle by using PID
      DosGetInfoBlocks( &ptib, &ppib );
      IString tmp1((unsigned long)this);
      IString tmp2(ppib->pib_ulpid);
      IString strQueueName = IString("\\QUEUES\\") + tmp1 +
          IString("\\") + tmp2 + IString("\\.QUE");
      ITRACE_DEVELOP("Queue name is: " + strQueueName);
      ulRc = DosCreateQueue(&ulClQHandle,
                            0,
                            (char*)strQueueName);
      ITRACE_DEVELOP("DosCreateQueue rc =: " + IString(ulRc));
      if (ulRc)
         ITHROWSYSTEMERROR(ulRc,"DosCreateQueue",
             IBaseErrorInfo::outOfSystemResource, IException::recoverable);
      IThreadMemberFn<IDDEClientConversation> *myDispatcherFn = new
          IThreadMemberFn<IDDEClientConversation>
            (*this, &IDDEClientConversation::dispatchEventFromQueue);
      pThreadCl = new IThread(myDispatcherFn);
#endif  /* IC_PM */

#ifdef IC_WIN
   DWORD ulRc;

   hFinish = CreateEvent(NULL, TRUE, FALSE, NULL);

   if ( !CreatePipe(&hReadPipe, &hWritePipe, NULL, 0))
     { 
       delete fDDEClientConversationData;
       ulRc = GetLastError();
       ITHROWSYSTEMERROR(ulRc,"CreatPipe",
           IBaseErrorInfo::outOfSystemResource, IException::recoverable);
     }

   IThreadMemberFn<IDDEClientConversation> *myDispatcherFn = new
       IThreadMemberFn<IDDEClientConversation>
            (*this, &IDDEClientConversation::dispatchEventFromQueue);
   pThreadCl = new IThread(myDispatcherFn, IThread::defaultAutoInitGUI());
#endif  /* IC_WIN */
   }

   pwndClClient = new IObjectWindow(IObjectWindow::noStyle);
   pClsdConvSetCl = new IDDEClosedConversationSet;
   pHLSetCl = new IDDEClientHotLinkSet;
   pTransQCl = new IDDETransactionQueue;
#ifdef IC_PM
   pFormatSetCl = new IDDEFormatSet;
#endif
#ifdef IC_WIN
   pItemAtomSetCl = new IDDEItemAtomSet;
#endif
   wndhClClient = pwndClClient->handle();
   handleEventsFor((IWindow*)pwndClClient);
   ((IWindow*)pwndClClient)->setParent(IWindow::objectWindow());

   try {
      begin(application, topic);
   }
   catch (IException& excp)
   {
      stopHandlingEventsFor((IWindow*)pwndClClient);
      delete pwndClClient;
      delete &closedConversations();
      delete &hotLinksForUpdate();
      delete &transactions();
      if (pThreadCl) 
         delete pThreadCl;
#ifdef IC_PM
      delete pFormatSetCl;
#endif
#ifdef IC_WIN
      delete pItemAtomSetCl;
      delete fDDEClientConversationData;
#endif
      IRETHROW(excp);
   }
}

/*------------------------------------------------------------------------------
| IDDEClientConversation::~IDDEClientConversation                              |
------------------------------------------------------------------------------*/
IDDEClientConversation :: ~IDDEClientConversation()
{
   IMODTRACE_DEVELOP("DDEClntConv::dtor");
   if (inConversation())
      end();

   // iterate all sets & queues; remove, and delete the elements,
   // delete the set/q
   // if threads were used stop the thread and close the queue
   if (pThreadCl)
   {
#ifdef IC_PM
   // wait for the secondary thread to finish
      unsigned long ulPostCount;
      unsigned long ulRc = DosCloseQueue(queueHandle());
      ITRACE_DEVELOP("DosCloseQueue rc =: " + IString(ulRc));
      ulRc = DosWaitEventSem(ulClSemaphore,
                             3000);
      if (ulRc == ERROR_TIMEOUT)
         pThreadCl->stop();
      delete pThreadCl;
#endif

#ifdef IC_WIN
   // wait for the secondary thread to finish
      unsigned long ulRc;

      if ( !CloseHandle(hWritePipe))
        { 
          ulRc = GetLastError();
          ITRACE_RUNTIME("CloseHandle rc =: " + IString(ulRc));
        }

      if ( !CloseHandle(hReadPipe))
        { 
          ulRc = GetLastError();
          ITRACE_RUNTIME("CloseHandle rc =: " + IString(ulRc));
        }

      if (hFinish) {
         ulRc = WaitForSingleObject(hFinish, 3000);
         if (ulRc == WAIT_TIMEOUT)
            pThreadCl->stop();

         if ( !CloseHandle(hFinish))
           { 
             ulRc = GetLastError();
             ITRACE_RUNTIME("CloseHandle rc =: " + IString(ulRc));
           }
      }

      delete pThreadCl;
#endif
   }

   closedConversations().removeAll(&IDdeleteElemCCS);
   delete &closedConversations();
   hotLinksForUpdate().removeAll(&IDdeleteElemCHLS);
   delete &hotLinksForUpdate();
   transactions().allElementsDo(&IDdeleteElemTQ);
   transactions().removeAll();
   delete &transactions();
#ifdef IC_PM
   delete &formats();
#endif
#ifdef IC_WIN
   delete &itemAtoms();

   // delete the private data class
   delete fDDEClientConversationData;
#endif

   stopHandlingEventsFor((IWindow*)pwndClClient);
   delete pwndClClient;
}

/*------------------------------------------------------------------------------
| IDDEClientConversation::begin                                                |
|                                                                              |
| Try to begin a conversation with the server that supports the application    |
| name with the requested topic name.                                          |
|                                                                              |
| Notes:                                                                       |
|   The broadcast in progress flag (fClBrdcstInPrgrs) is used to get request   |
|   information about the server. Multiple messages may be received by         |
|   the handle methods in response to these broadcasted messages. When         |
|   broadcast in progress is set the application name and/or the topic         |
|   name can be zero length strings ( see supportingTopics and                 |
|   supportingApplications).                                                   |
------------------------------------------------------------------------------*/
bool IDDEClientConversation :: begin ( const char* applicationName,
                                          const char* topicName )
{
   IMODTRACE_DEVELOP("DDEClntConv::begin");
   IASSERTPARM(applicationName != 0 && topicName != 0);

   if (!fClBrdcstInPrgrs)
   {
      IASSERTPARM(applicationName[0] != '\0' && topicName[0] != '\0');
      IASSERTSTATE(!inConversation());

      strClApplication = applicationName;
      strClTopic = topicName;
   }

#ifdef IC_PM
   CONVCONTEXT contxt = {0,0,0,0,0,0};
   contxt.cb = sizeof(CONVCONTEXT);
   bool bSuccess = WinDdeInitiate((HWND)clientHandle(),
                                     (PSZ)applicationName,
                                     (PSZ)topicName,
                                     &contxt);
   if (!bSuccess)
   {
      if (!inConversation() && !fClBrdcstInPrgrs)
         ITHROWLIBRARYERROR(IC_DDE_WINDDEINITIATE,IBaseErrorInfo::accessError,
             IException::recoverable);
      ITRACE_DEVELOP("WinDdeInitiate error, no exception thrown because \
          a conversation was successfully initiated.");
   }
#endif  /* IC_PM */
#ifdef IC_WIN
   ATOM    aApp(0), aTopic(0);  //if broadcast allow appl & topic == ""
   bool bAtomAdded(false);
   if (!fClBrdcstInPrgrs || applicationName[0])
   {
      aApp = (ATOM)IDDEInfo__atomFromString( applicationName, &bAtomAdded );
      if ( bAtomAdded )
      {
         itemAtoms().add( aApp );
         ITRACE_DEVELOP("Added atom to item list.");
      }
   }
   if (!fClBrdcstInPrgrs || topicName[0])
   {
      aTopic = (ATOM)IDDEInfo__atomFromString( topicName, &bAtomAdded );
      if ( bAtomAdded )
      {
         itemAtoms().add( aTopic );
         ITRACE_DEVELOP("Added atom to item list.");
      }
   }

   // set the wait flag, it is for work around of missing WM_DDE_INITIATEACK
   fDDEClientConversationData->fClWaitInitAck = true;
   LRESULT rc = SendMessage( (HWND)0xFFFF,       // -1 for boardcast to all servers
                             WM_DDE_INITIATE,
                             (WPARAM)(HWND)clientHandle(),
                             MAKELPARAM( aApp, aTopic ));
// TTD                             PackDDElParam( WM_DDE_INITIATE, aApp, aTopic ) );
   // wait is over, reset the flag
   fDDEClientConversationData->fClWaitInitAck = false;

   if ( rc != 0 )
   {
      if (!inConversation() && !fClBrdcstInPrgrs)
         ITHROWLIBRARYERROR( IC_DDE_WINDDEINITIATE,IBaseErrorInfo::accessError,
                             IException::recoverable);
      ITRACE_DEVELOP("SendMessage error, no exception thrown because \
                      a conversation was successfully initiated.");
   }
#endif  /* IC_WIN */

   if (!inConversation())
   {
      strClApplication = "";
      strClTopic = "";
   }

   // all applications have responded!
   fClBrdcstInPrgrs = false;
   return inConversation();
}

/*------------------------------------------------------------------------------
| IDDEClientConversation::begin                                                |
|                                                                              |
| Begin a conversation with the specified server handle.                       |
------------------------------------------------------------------------------*/
IDDEClientConversation& IDDEClientConversation :: begin (
                            const IWindowHandle& serverHandle )
{
   IMODTRACE_DEVELOP("DDEClntConv::begin");
   IASSERTPARM(serverHandle.isValid());
   IASSERTSTATE(!inConversation());

   wndhClServer = serverHandle;
   return *this;
}

/*------------------------------------------------------------------------------
| IDDEClientConversation::end                                                  |
|                                                                              |
| End the client's conversation with a server. All of the hot links with the   |
| server are ended, and all queued transactions are removed.                   |
------------------------------------------------------------------------------*/
IDDEClientConversation& IDDEClientConversation :: end ( )
{
   IMODTRACE_DEVELOP("DDEClntConv::end");
   if ( !(inConversation()) )
      ITHROWLIBRARYERROR1(IC_DDE_CLIENT_NOT_IN_CONVERSATION,
          IBaseErrorInfo::invalidRequest, IException::recoverable, "end()");
   IDDEClosedConversation* pConv = new IDDEClosedConversation(application(),
                                                 topic(), serverHandle(), true);

   // clear the instance data
   IWindowHandle tmpwndh = serverHandle();
   wndhClServer = (IWindowHandle)0;
   fClCaseSensitive = false;
   strClApplication = "";
   strClTopic = "";

   // clear the hotlink set and transaction queue
   hotLinksForUpdate().semaphor().lock();  // serialize access to the set
   hotLinksForUpdate().removeAll(&IDdeleteElemCHLS);
   hotLinksForUpdate().semaphor().unlock();
   transactions().semaphor().lock();  // serialize access to the set
   transactions().allElementsDo(&IDdeleteElemTQ);
   transactions().removeAll();
   transactions().semaphor().unlock();

   // Inform the server that the client wishes to terminate the conversation.
#ifdef IC_PM
   bool bSuccess = WinDdePostMsg((HWND)tmpwndh,
                                    (HWND)clientHandle(),
                                    WM_DDE_TERMINATE,
                                    0,
                                    DDEPM_RETRY);
#endif  /* IC_PM */
#ifdef IC_WIN
   bool bSuccess = PostMessage( (HWND)tmpwndh,
                                   WM_DDE_TERMINATE,
                                   (WPARAM)(HWND)clientHandle(),
                                   0L );
#endif  /* IC_WIN */
   if (bSuccess && !fClPostMsgFail)
   {
      closedConversations().semaphor().lock();  // serialize access to the set
      closedConversations().add(pConv);
      closedConversations().semaphor().unlock();
   }
   else
   {
      ITRACE_DEVELOP(IString("WM_DDE_TERMINATE failure on attempt to initate") +
              IString("end of conversation, server application is ") +
              pConv->application() );
      delete pConv;
   }
   return *this;
}


/*------------------------------------------------------------------------------
| IDDEClientConversation::requestData                                          |
|                                                                              |
| Allows client to request data from server. This is a one time request for    |
| data, as opposed to a hot link. The data returned is posted to the callback  |
| method IDDEClientConversation::handleData through the dispatcher.            |
------------------------------------------------------------------------------*/
IDDEClientConversation& IDDEClientConversation :: requestData (
                                                         const char* item,
                                                         const char* format )
{
   IMODTRACE_DEVELOP("DDEClntConv::requestData");
   IASSERTSTATE(inConversation());
   IASSERTPARM(item != 0 && format != 0);
   IASSERTPARM(item[0] != '\0' && format[0] != '\0');

#ifdef IC_PM
   PDDESTRUCT pddes = (PDDESTRUCT)buildDDEStruct (item,
                                                 format,
                                                 0,
                                                 0,
                                                 0);

// build the event before posting the message, as OS/2 will give the shared
// memory associated with PDDESTRUCT on the Post
   IEvent myEvt(serverHandle(),
                (unsigned long)WM_DDE_REQUEST,
                IEventParameter1((unsigned long)clientHandle()),
                IEventParameter2((void*)pddes));
   IDDEClientAcknowledgeEvent* pevt = new IDDEClientAcknowledgeEvent(myEvt);
   bool bSuccess = WinDdePostMsg((HWND)serverHandle(),
                                    (HWND)clientHandle(),
                                    WM_DDE_REQUEST,
                                    pddes,
                                    DDEPM_RETRY);
   if (bSuccess)
   {
      transactions().semaphor().lock();  // serialize access to the set
      // add the requestData transaction to the queue
      transactions().add(pevt);
      transactions().semaphor().unlock();
   }
   else
   {
      delete pevt;
      IDDEInfo__freeMemory( pddes );
      ITHROWLIBRARYERROR1(IC_DDE_WINDDEPOSTMESSAGE_USER,
          IBaseErrorInfo::accessError, IException::recoverable,
          "WinDdePostMsg (WM_DDE_REQUEST)");
   }
#endif  /* IC_PM */
#ifdef IC_WIN
   bool bAtomAdded;
   ATOM aItem = IDDEInfo__atomFromString( item, &bAtomAdded );
   if ( bAtomAdded )
   {
      itemAtoms().add( aItem );
      ITRACE_DEVELOP("Added atom to item list.");
   }
   unsigned short cfFormat = IDDEInfo__formatFromString( format );

   // build the event before posting the message, as system will release the shared
   // memory associated with struct
   IEvent myEvt( serverHandle(),
                 (unsigned long)WM_DDE_REQUEST,
                 IEventParameter1((unsigned long)(void *)clientHandle()),
                 IEventParameter2((unsigned long)MAKELPARAM( cfFormat, aItem )));
   IDDEClientAcknowledgeEvent* pevt = new IDDEClientAcknowledgeEvent( myEvt );

   bool bSuccess = PostMessage( (HWND)serverHandle(),
                                   WM_DDE_REQUEST,
                                   (WPARAM)(HWND)clientHandle(),
                                   MAKELPARAM( cfFormat, aItem ) );
   if (bSuccess)
   {
      transactions().semaphor().lock();  // serialize access to the set
      // add the requestData transaction to the queue
      transactions().add(pevt);
      transactions().semaphor().unlock();
   }
   else
   {
      delete pevt;
      ITHROWLIBRARYERROR1( IC_DDE_WINDDEPOSTMESSAGE_USER,
                           IBaseErrorInfo::accessError, IException::recoverable,
                           "PostMessage (WM_DDE_REQUEST)" );
   }
#endif  /* IC_WIN */

   return *this;
}

/*------------------------------------------------------------------------------
| IDDEClientConversation::pokeData                                             |
|                                                                              |
| Build the data structure with the data for an item in a specific format and  |
| post the message to the server to poke data.                                 |
------------------------------------------------------------------------------*/
IDDEClientConversation& IDDEClientConversation :: pokeData (
                                                      const char* item,
                                                      const void* data,
                                                      unsigned long dataLength,
                                                      const char* format )
{
   IMODTRACE_DEVELOP("DDEClntConv::pokeData");
   IASSERTSTATE(inConversation());
   // allow an empty string but not zero pointer
   IASSERTPARM(item != 0 && format != 0 && data != 0);
   IASSERTPARM(item[0] != '\0' && format[0] != '\0');

#ifdef IC_PM
   PDDESTRUCT pddes = (PDDESTRUCT)buildDDEStruct (item,
                                                  format,
                                                  0,
                                                  data,
                                                  dataLength);

   // build the event before posting the message,
   // as OS/2 will free the shared memory on us
   IEvent myEvt(serverHandle(),
                (unsigned long)WM_DDE_POKE,
                IEventParameter1((unsigned long)clientHandle()),
                IEventParameter2((void*)pddes));
   IDDEClientAcknowledgeEvent* pevt = new IDDEClientAcknowledgeEvent(myEvt);
   bool bSuccess = WinDdePostMsg((HWND)serverHandle(),
                                    (HWND)clientHandle(),
                                    WM_DDE_POKE,
                                    pddes,
                                    DDEPM_RETRY);
   if (bSuccess)
   {
      transactions().semaphor().lock();  // serialize access to the set
      // add the pokeData transaction to the queue
      transactions().add(pevt);
      transactions().semaphor().unlock();
   }
   else
   {
      delete pevt;
      IDDEInfo__freeMemory( pddes );
      ITHROWLIBRARYERROR1(IC_DDE_WINDDEPOSTMESSAGE_USER,IBaseErrorInfo::accessError,
                        IException::recoverable, "WinDdePostMsg (WM_DDE_POKE)");
   }
#endif  /* IC_PM */
#ifdef IC_WIN
   // make sure the server will release the data
   unsigned short usStatus = IDDEInfo::releaseData;
   HGLOBAL hDdePoke = buildDDEStruct( IDDEPoke,
                                      format,
                                      usStatus,
                                      data,
                                      dataLength);
   bool bAtomAdded;
   ATOM aItem = IDDEInfo__atomFromString( item, &bAtomAdded );
   if ( bAtomAdded )
   {
      itemAtoms().add( aItem );
      ITRACE_DEVELOP("Added atom to item list.");
   }

   LPARAM lParam = PackDDElParam( WM_DDE_POKE, (UINT)hDdePoke, aItem );

   // build the event before posting the message,
   // as system will free the shared memory on us
   IEvent myEvt( serverHandle(),
                 (unsigned long)WM_DDE_POKE,
                 IEventParameter1((unsigned long)(void *)clientHandle()),
                 IEventParameter2((unsigned long)lParam) );
   IDDEClientAcknowledgeEvent* pevt = new IDDEClientAcknowledgeEvent(myEvt);

   bool bSuccess = PostMessage( (HWND)serverHandle(),
                                   WM_DDE_POKE,
                                   (WPARAM)(HWND)clientHandle(),
                                   lParam );
   if (bSuccess)
   {
      transactions().semaphor().lock();  // serialize access to the set
      // add the pokeData transaction to the queue
      transactions().add(pevt);
      transactions().semaphor().unlock();
   }
   else
   {
      delete pevt;
      IDDEInfo__freeMemory( hDdePoke );
      ITHROWLIBRARYERROR1(IC_DDE_WINDDEPOSTMESSAGE_USER,IBaseErrorInfo::accessError,
                          IException::recoverable, "PostMessage(WM_DDE_POKE)");
   }
#endif  /* IC_WIN */

   return *this;
}

/*------------------------------------------------------------------------------
| IDDEClientConversation::beginHotLink                                         |
|                                                                              |
| Begin a hot link on an item. First make sure that the client does not already|
| have a hot link for the item in the specified format. Also make sure that a  |
| request for this hot link is not pending in the transactions queue.          |
------------------------------------------------------------------------------*/
IDDEClientConversation& IDDEClientConversation :: beginHotLink (
                                                        const char* item,
                                                        const char* format,
                                                        bool sendData,
                                                        bool pacing )
{
   IMODTRACE_DEVELOP("DDEClntConv::beginHotLink");
   IASSERTSTATE(inConversation());
   IASSERTPARM(item != 0 && format != 0);
   IASSERTPARM(item[0] != '\0' && format[0] != '\0');

   // ensure this is a new hotlink
   IString inItem = IString::upperCase(IString(item));
   IString inFormat = IString::upperCase(IString(format));
   IString myItem;
   IString myFormat;
   // first check the hotLink set
   IDDEClientHotLinkSet::Cursor myCurs(hotLinksForUpdate());
   IDDEClientHotLinkEvent* pEvt = 0;
   ITRACE_DEVELOP(
       "Getting ready to check for previously active hotLink match.");
   ITRACE_DEVELOP(IString("for item ") + IString(inItem) ) ; // TTD
   ITRACE_DEVELOP(IString("for format") + IString(inFormat) ) ; // TTD
   hotLinksForUpdate().semaphor().lock();  // serialize access to the set
   forCursor(myCurs)
   {
      pEvt = hotLinksForUpdate().elementAt(myCurs);
      myItem = IString::upperCase(pEvt->item());
      myFormat = IString::upperCase(pEvt->format());
      // TTD
      ITRACE_DEVELOP(IString("currentItem ")+ IString(myItem)) ;
      ITRACE_DEVELOP(IString("currentFormat ")+ IString(myFormat)) ;
      // TTD
      if ( ( inItem == myItem) && ( inFormat == myFormat) )
      {
         hotLinksForUpdate().semaphor().unlock();
         ITHROWLIBRARYERROR(IC_DDE_HOTLINK_ACTIVE,IBaseErrorInfo::invalidRequest,
             IException::recoverable);
      }
   }  // end for loop
   hotLinksForUpdate().semaphor().unlock();
   ITRACE_DEVELOP(IString("out of search loop")) ;  // TTD
   // next check the transaction queue for a pending beginHotLink
   IDDETransactionQueue::Cursor myCurs1(transactions());
   IDDEClientAcknowledgeEvent* pEvt1 = 0;
   transactions().semaphor().lock();  // serialize access to the set
   forCursor(myCurs1)
   {
      pEvt1 = transactions().elementAt(myCurs1);
      myItem = IString::upperCase(pEvt1->item());
      myFormat = IString::upperCase(pEvt1->format());
      if ( ( myItem == inItem ) && ( myFormat == inFormat ) &&
           ( pEvt1->transactionType() == WM_DDE_ADVISE ) )
      {
         transactions().semaphor().unlock();
         ITHROWLIBRARYERROR(IC_DDE_HOTLINK_PENDING,IBaseErrorInfo::invalidRequest,
             IException::recoverable);
      }
   }  // end for loop
   transactions().semaphor().unlock();

#ifdef IC_PM
   // construct the status field
   unsigned short usStatus = 0;
   if (!sendData)
      usStatus = (unsigned short)(usStatus | DDE_FNODATA);
   if (pacing)
      usStatus = (unsigned short)(usStatus | DDE_FACKREQ);
   PDDESTRUCT pddes = (PDDESTRUCT)buildDDEStruct (item,
                                                  format,
                                                  usStatus,
                                                  0,
                                                  0);

   // add the beginHotLink transaction to the Queue
   // build the event before posting the message,
   // as OS/2 will free the shared memory on us
   IEvent myEvt(serverHandle(),
                (unsigned long)WM_DDE_ADVISE,
                IEventParameter1((unsigned long)clientHandle()),
                IEventParameter2((void*)pddes));
   IDDEClientAcknowledgeEvent* pEvt2 = new
       IDDEClientAcknowledgeEvent(myEvt);
   bool bSuccess = WinDdePostMsg((HWND)serverHandle(),
                                    (HWND)clientHandle(),
                                    WM_DDE_ADVISE,
                                    pddes,
                                    DDEPM_RETRY);
   if (bSuccess)
   {
      transactions().semaphor().lock();  // serialize access to the set
      transactions().add(pEvt2);
      transactions().semaphor().unlock();
   }
   else
   {
      delete pEvt2;
      IDDEInfo__freeMemory( pddes );
      ITHROWLIBRARYERROR1(IC_DDE_WINDDEPOSTMESSAGE_USER,IBaseErrorInfo::accessError,
                      IException::recoverable, "WinDdePostMsg (WM_DDE_ADVISE)");
   }
#endif  /* IC_PM */

#ifdef IC_WIN
   ITRACE_DEVELOP(IString("right before ic-win stuff")) ; // TTD
   // construct the status field
   unsigned short usStatus = 0;
   if (!sendData)
      usStatus |= IDDEInfo::noData;
   if (pacing)
      usStatus |= IDDEInfo::acknowledgeRequested;
   HGLOBAL hDdeAdvise = buildDDEStruct( IDDEAdvise,
                                        format,
                                        usStatus,
                                        0,
                                        0 );
   bool bAtomAdded;
   ATOM aItem = IDDEInfo__atomFromString( item, &bAtomAdded );
   if ( bAtomAdded )
   {
      itemAtoms().add( aItem );
      ITRACE_DEVELOP("Added atom to item list.");
   }

   LPARAM lParam = PackDDElParam( WM_DDE_ADVISE, (UINT)hDdeAdvise, aItem );

   // add the beginHotLink transaction to the Queue
   // build the event before posting the message,
   // as system will free the shared memory on us
   IEvent myEvt( serverHandle(),
                 (unsigned long)WM_DDE_ADVISE,
                 IEventParameter1((unsigned long)(void *)clientHandle()),
                 IEventParameter2((unsigned long)lParam) );
   IDDEClientAcknowledgeEvent* pEvt2 = new IDDEClientAcknowledgeEvent(myEvt);

   bool bSuccess = PostMessage( (HWND)serverHandle(),
                                   WM_DDE_ADVISE,
                                   (WPARAM)(HWND)clientHandle(),
                                   lParam );
   if (bSuccess)
   {
      transactions().semaphor().lock();  // serialize access to the set
      transactions().add(pEvt2);
      transactions().semaphor().unlock();
   }
   else
   {
      delete pEvt2;
      IDDEInfo__freeMemory( hDdeAdvise );
      ITHROWLIBRARYERROR1(IC_DDE_WINDDEPOSTMESSAGE_USER,IBaseErrorInfo::accessError,
                          IException::recoverable, "PostMessage (WM_DDE_ADVISE)");
   }
#endif  /* IC_WIN */

   return *this;
}

/*------------------------------------------------------------------------------
| IDDEClientConversation::endHotLink                                           |
|                                                                              |
| The client sends a message to the server to end the specified hot link. If   |
| the client does not have the hot link with the server then an exception is   |
| thrown.  An exception is also thrown if the end hot link is pending from     |
| a previous request to end the hot link.                                      |
------------------------------------------------------------------------------*/
IDDEClientConversation& IDDEClientConversation :: endHotLink (
                                                            const char* item,
                                                            const char* format )
{
   IMODTRACE_DEVELOP("DDEClntConv::endHotLink");
   IASSERTSTATE(inConversation());
   IASSERTPARM(item != 0 && format != 0);
   IASSERTPARM(item[0] != '\0' && format[0] != '\0');

   IString inItem = IString::upperCase(IString(item));
   IString inFormat = IString::upperCase(IString(format));
   IString myItem;
   IString myFormat;
   // ensure the hotlink exists
   bool bSuccess = 0;
   IDDEClientHotLinkSet::Cursor myCurs(hotLinksForUpdate());
   IDDEHotLinkXEvent* pEvt = 0;
   hotLinksForUpdate().semaphor().lock();  // serialize access to the set
   for(myCurs.setToFirst();
       myCurs.isValid() && bSuccess == 0;
       myCurs.setToNext())
   {
      pEvt = (IDDEHotLinkXEvent*)hotLinksForUpdate().elementAt(myCurs);
      myItem = IString::upperCase(pEvt->item());
      myFormat = IString::upperCase(pEvt->format());
      if ( ( inItem == myItem) && ( inFormat == myFormat) )
         {
            if ( pEvt->isCloseInProgress() )
            {
               hotLinksForUpdate().semaphor().unlock();
               ITHROWLIBRARYERROR(IC_DDE_END_HOTLINK_PENDING,
                   IBaseErrorInfo::invalidRequest,IException::recoverable);
            }
            ((IDDEHotLinkXEvent*)pEvt)->setCloseInProgress(true);
            bSuccess = true;
         }
   }  // end for loop
   hotLinksForUpdate().semaphor().unlock();
   if (!bSuccess)
      ITHROWLIBRARYERROR1(IC_DDE_NO_HOTLINK,IBaseErrorInfo::invalidRequest,
                          IException::recoverable, "endHotLink()");

#ifdef IC_PM
   PDDESTRUCT pddes = (PDDESTRUCT)buildDDEStruct (item,
                                                  format,
                                                  0,
                                                  0,
                                                  0);

   // build the event before posting the message,
   // as OS/2 will free the shared memory on us
   IEvent myEvt(serverHandle(),
                (unsigned long)WM_DDE_UNADVISE,
                IEventParameter1((unsigned long)clientHandle()),
                IEventParameter2((void*)pddes));
   IDDEClientAcknowledgeEvent* pevt1 = new
                         IDDEClientAcknowledgeEvent(myEvt);
   bSuccess = WinDdePostMsg((HWND)serverHandle(),
                            (HWND)clientHandle(),
                            WM_DDE_UNADVISE,
                            pddes,
                            DDEPM_RETRY);
   if (bSuccess)
   {
      transactions().semaphor().lock();  // serialize access to the set
      // add the endHotLink transaction to the Queue
      transactions().add(pevt1);
      transactions().semaphor().unlock();
   }
   else
   {
      delete pevt1;
      IDDEInfo__freeMemory( pddes );
      ((IDDEHotLinkXEvent*)pEvt)->setCloseInProgress(false);
      ITHROWLIBRARYERROR1(IC_DDE_WINDDEPOSTMESSAGE_USER,
         IBaseErrorInfo::accessError, IException::recoverable,
         "WinDdePostMsg (WM_DDE_UNADVISE)");
   }
#endif   /* IC_PM */

#ifdef IC_WIN
   bool bAtomAdded;
   ATOM aItem = IDDEInfo__atomFromString( item, &bAtomAdded );
   if ( bAtomAdded )
   {
      itemAtoms().add( aItem );
      ITRACE_DEVELOP("Added atom to item list.");
   }
   unsigned short cfFormat = IDDEInfo__formatFromString( format );

//mkb   LPARAM lParam = PackDDElParam( WM_DDE_UNADVISE, cfFormat, aItem );

   // build the event before posting the message,
   // as OS/2 will free the shared memory on us
   IEvent myEvt( serverHandle(),
                 (unsigned long)WM_DDE_UNADVISE,
                 IEventParameter1((unsigned long)(VOID *)clientHandle()),
                 IEventParameter2((unsigned long)MAKELPARAM( cfFormat, aItem )) );
   IDDEClientAcknowledgeEvent* pevt1 = new IDDEClientAcknowledgeEvent(myEvt);

   bSuccess = PostMessage( (HWND)serverHandle(),
                           WM_DDE_UNADVISE,
                           (WPARAM)(HWND)clientHandle(),
                           MAKELPARAM( cfFormat, aItem ));
   if (bSuccess)
   {
      transactions().semaphor().lock();  // serialize access to the set
      // add the endHotLink transaction to the Queue
      transactions().add(pevt1);
      transactions().semaphor().unlock();
   }
   else
   {
      delete pevt1;
      ((IDDEHotLinkXEvent*)pEvt)->setCloseInProgress(false);
      ITHROWLIBRARYERROR1( IC_DDE_WINDDEPOSTMESSAGE_USER,
                           IBaseErrorInfo::accessError, IException::recoverable,
                           "PostMessage (WM_DDE_UNADVISE)" );
   }
#endif  /* IC_WIN */

   return *this;
}

/*------------------------------------------------------------------------------
| IDDEClientConversation::endHotLinks                                          |
|                                                                              |
| If an item is specified then end all hot links on that item with the server. |
| If no item is specified then end all hot links with the server.              |
|                                                                              |
| Notes:                                                                       |
|   There can be several hot links on a single item. A hot link can be set up  |
|   for many different formats.                                                |
------------------------------------------------------------------------------*/
IDDEClientConversation& IDDEClientConversation :: endHotLinks (
                                                              const char* item )
{
   IMODTRACE_DEVELOP("DDEClntConv::endHotLinks");
//   IASSERTSTATE(inConversation());

   if (inConversation()) {
      if (item == 0)
        endAllHotLinks();
      else
        endAllHotLinks(item);
   }

   return *this;
}

/*------------------------------------------------------------------------------
| IDDEClientConversation::executeCommands                                      |
|                                                                              |
| The client can request the server to execute a set of commands.  The         |
| commands are sent as a character array with the length specified.            |
------------------------------------------------------------------------------*/
IDDEClientConversation& IDDEClientConversation :: executeCommands (
                                                   const void* commands,
                                                   unsigned long commandLength )
{
   IMODTRACE_DEVELOP("DDEClntConv::executeCommands");
   IASSERTSTATE(inConversation());
   IASSERTPARM(commands != 0);
   IASSERTPARM(commandLength != 0);

#ifdef IC_PM
   PDDESTRUCT pddes = (PDDESTRUCT)buildDDEStruct (0,
                                                  0,
                                                  0,
                                                  commands,
                                                  commandLength);

   // build the event before posting the message,
   // as OS/2 will free the shared memory on us
   IEvent myEvt(serverHandle(),
                (unsigned long)WM_DDE_EXECUTE,
                IEventParameter1((unsigned long)clientHandle()),
                IEventParameter2((void*)pddes));
   IDDEClientAcknowledgeEvent* pevt = new IDDEClientAcknowledgeEvent(myEvt);
   bool bSuccess = WinDdePostMsg((HWND)serverHandle(),
                                    (HWND)clientHandle(),
                                    WM_DDE_EXECUTE,
                                    pddes,
                                    DDEPM_RETRY);
   if (bSuccess)
   {
      transactions().semaphor().lock();  // serialize access to the set
      // add the executeCommands transaction to the Queue
      transactions().add(pevt);
      transactions().semaphor().unlock();
    }
   else
   {
      delete pevt;
      IDDEInfo__freeMemory( pddes );
      ITHROWLIBRARYERROR1(IC_DDE_WINDDEPOSTMESSAGE_USER,
           IBaseErrorInfo::accessError, IException::recoverable,
           "WinDdePostMsg (WM_DDE_EXECUTE)");
   }
#endif  /* IC_PM */

#ifdef IC_WIN
   // allocate the memory needed for commands
   HGLOBAL hCommands = buildDDEStruct ( IDDECommands,
                                        0,
                                        0,
                                        commands,
                                        commandLength );
   ITRACE_DEVELOP( "DBug: in ExecuteCommand, hCommands="
                 + IString( (unsigned long) hCommands));
//mkb   LPARAM lParam = PackDDElParam( WM_DDE_EXECUTE, 0, (UINT)hCommands );

   // build the event before posting the message,
   // as system will free the shared memory on us
   IEvent myEvt( serverHandle(),
                 (unsigned long)WM_DDE_EXECUTE,
                 IEventParameter1((unsigned long)(void *)clientHandle()),
                 IEventParameter2((unsigned long)hCommands));
   IDDEClientAcknowledgeEvent* pevt = new IDDEClientAcknowledgeEvent(myEvt);

   bool bSuccess = PostMessage( (HWND)serverHandle(),
                                   WM_DDE_EXECUTE,
                                   (WPARAM)(HWND)clientHandle(),
                                   (LPARAM)hCommands );
   if (bSuccess)
      {
         transactions().semaphor().lock();  // serialize access to the set
         // add the executeCommands transaction to the Queue
         transactions().add(pevt);
         transactions().semaphor().unlock();
#ifdef  DEBUG
      IDDEClientAcknowledgeEvent* pevt = transactions().lastElement();
      ITRACE_DEVELOP( "DBug: post OK, transaction().last().lParam()="
                    + IString( pevt->parameter2().asUnsignedLong()));
#endif
      }
   else
   {
      delete pevt;
      IDDEInfo__freeMemory( hCommands );
      ITHROWLIBRARYERROR1( IC_DDE_WINDDEPOSTMESSAGE_USER,
                           IBaseErrorInfo::accessError, IException::recoverable,
                           "PostMessage (WM_DDE_EXECUTE)" );
   }
#endif  /* IC_WIN */

   return *this;
}

/*------------------------------------------------------------------------------
| IDDEClientConversation::hotLinkInform                                        |
|                                                                              |
| This method is used to determine whether a positive or negative              |
| acknowledgement is sent to the server in response to the server message that |
| hot link data has changed.                                                   |
|                                                                              |
| Notes :                                                                      |
|   Default behavior is to return true which corresponds to a positive         |
|   acknowledgement                                                            |
------------------------------------------------------------------------------*/
bool IDDEClientConversation :: hotLinkInform ( IDDEClientHotLinkEvent& event)
{
   return true;
}

/*------------------------------------------------------------------------------
| IDDEClientConversation::acknowledged                                         |
|                                                                              |
| This method should be overridden by the receiver to interrogate the          |
| acknowledge event.                                                           |
------------------------------------------------------------------------------*/
void IDDEClientConversation :: acknowledged (
                                   IDDEClientAcknowledgeEvent& event)
{ }

/*------------------------------------------------------------------------------
| IDDEClientConversation::executeAcknowledged                                  |
|                                                                              |
| This method should be overridden by the receiver to interrogate the          |
| acknowledge execute event.                                                   |
------------------------------------------------------------------------------*/
void IDDEClientConversation :: executeAcknowledged (
                                   IDDEAcknowledgeExecuteEvent& event)
{ }

/*------------------------------------------------------------------------------
| IDDEClientConversation::pokeAcknowledged                                     |
|                                                                              |
| This method should be overridden by the receiver to interrogate the          |
| acknowledge poke event.                                                      |
------------------------------------------------------------------------------*/
void IDDEClientConversation :: pokeAcknowledged (
                                   IDDEAcknowledgePokeEvent& event)
{ }

/*------------------------------------------------------------------------------
| IDDEClientConversation::conversationEnded                                    |
|                                                                              |
| Informs the receiver that the conversation has ended.                        |
------------------------------------------------------------------------------*/
void IDDEClientConversation :: conversationEnded ( IDDEClientEndEvent& event )
{ }

/*------------------------------------------------------------------------------
| IDDEClientConversation::hotLinks                                             |
|                                                                              |
| Returns a set of the current hot links established with the server.          |
|                                                                              |
| Notes:                                                                       |
|   The caller has to create the hot link set that is filled by this method.   |
|   Returning a pointer to this object's hot link set would have had           |
|   detrimental side effects because the receivers cursor could be             |
|   invalidated by the addition or removal of hot links.                       |
------------------------------------------------------------------------------*/
IDDEClientConversation& IDDEClientConversation :: hotLinks (
                                              IDDEClientHotLinkSet& hotLinkSet )
{
   IDDEClientHotLinkSet::Cursor myCurs(*pHLSetCl);
   IDDEClientHotLinkEvent* pEvt = 0;
   IDDEClientHotLinkEvent* pEvt1 = 0;
   hotLinksForUpdate().semaphor().lock();  // serialize access to the set
   forCursor(myCurs)
   {
      pEvt1 = (*pHLSetCl).elementAt(myCurs);
      pEvt = new IDDEClientHotLinkEvent(*pEvt1);
      hotLinkSet.add(pEvt);
   }  // end for loop
   hotLinksForUpdate().semaphor().unlock();

   return *this;
}

/*------------------------------------------------------------------------------
| IDDEClientConversation::outstandingTransactionCount                          |
|                                                                              |
| Returns the number transactions that are still outstanding in the            |
| transaction queue.                                                           |
------------------------------------------------------------------------------*/
unsigned long IDDEClientConversation :: outstandingTransactionCount ( ) const
{
   return transactions().numberOfElements();
}

/*------------------------------------------------------------------------------
| IDDEClientConversation::supportedTopics                                      |
|                                                                              |
| This method is used to query an application or all applications to respond   |
| with the topics that are supported. If an application is specified then      |
| only that application will respond. If no application is specified then all  |
| applications will get this message and respond to the request. Beginning a   |
| conversation with no topic name asks the application(s) to respond with all  |
| supported topics. HandleInitiateAck will detect that the broadcast message   |
| is in progress (fClBrdcstInPrgrs is set) and add the responding servers in   |
| the active server set pointed to by pActServSetCl.                           |
|                                                                              |
| If the current application is not in the set then add it as well.            |
------------------------------------------------------------------------------*/
IDDEClientConversation& IDDEClientConversation :: supportedTopics (
    IDDEActiveServerSet& activeServerSet,
    const char* applicationName )
{
   IMODTRACE_DEVELOP("DDEClntConv::supportedTopics");
   fClBrdcstInPrgrs = true;
   pActServSetCl = &activeServerSet;

   if (!applicationName)
      begin("","");
   else
      begin(applicationName, "");
   if (inConversation())  // add the current conversation if not already added
   {
      IDDEActiveServerSet::Cursor myCurs(*pActServSetCl);
      IDDEActiveServer* pServ = 0;
      bool bFound = false;
      forCursor(myCurs)
      {
         pServ = pActServSetCl->elementAt(myCurs);
         if ( (pServ->application() == this->application()) &&
              (pServ->topic() ==this->topic()) )
            bFound = true;
      }
      if (!bFound)
      {
         pServ = new IDDEActiveServer(application(),
                                      topic(),
                                      isCaseSensitive());
         pActServSetCl->add(pServ);
      }
   }
   return *this;
}

/*------------------------------------------------------------------------------
| IDDEClientConversation::supportingApplications                               |
|                                                                              |
| This method is used to query all applications to respond if they support the |
| specified topic. This message is sent to all applications by beginning a     |
| conversation with an empty string as the application name. HandleInitiateAck |
| will detect that the broadcast message is in progress (fClBrdcstInPrgrs is   |
| set) and add the responding servers in the active server set pointed to by   |
| pActServSetCl. If the current application is not in the set then add it      |
| as well.                                                                     |
------------------------------------------------------------------------------*/
IDDEClientConversation& IDDEClientConversation :: supportingApplications (
    IDDEActiveServerSet& activeServerSet,
    const char* topicName )
{
   IMODTRACE_DEVELOP("DDEClntConv::supportingApplications");
   IASSERTPARM(topicName != 0);
   fClBrdcstInPrgrs = true;
   pActServSetCl = &activeServerSet;

   begin("",topicName);
   if (inConversation())  // add the current conversation if not already added
   {
      IDDEActiveServerSet::Cursor myCurs(*pActServSetCl);
      IDDEActiveServer* pServ = 0;
      bool bFound = false;
      forCursor(myCurs)
      {
         pServ = pActServSetCl->elementAt(myCurs);
         if ( (pServ->application() == this->application()) &&
              (pServ->topic() ==this->topic()) )
            bFound = true;
      }
      if (!bFound)
      {
         pServ = new IDDEActiveServer(application(),
                                      topic(),
                                      isCaseSensitive());
         pActServSetCl->add(pServ);
      }
   }
   return *this;
}

/*------------------------------------------------------------------------------
| IDDEClientConversation::dispatchHandlerEvent                                 |
|                                                                              |
| Overloaded virtual dispatch function. Dispatches the DDE events to the       |
| virtual handle methods of this class.                                        |
|                                                                              |
| Notes:                                                                       |
|   if a WM_DDE message is received while one is being serviced then           |
|   throw an exception that DDE synchronization has been violated.             |
|   This situation can occur when useEventThread is set false (single          |
|   threaded) on the class constructor and the receiver's handle... method     |
|   puts up a dialog box.                                                      |
|                                                                              |
| Notes: Since Windows does not have WM_DDE_INITATEACK, when a WM_DDE_ACK is   |
|        received, first check is the initiate process completed. If not,      |
|        route the ack event to handleInitiateAck                              |
------------------------------------------------------------------------------*/
bool IDDEClientConversation :: dispatchHandlerEvent ( IEvent& evt )
{
   IMODTRACE_DEVELOP("DDEClntConv::dispatchHandlerEvent");

::CCNVasDebugInfo( &evt );

   if (!pThreadCl)
   {
      switch (evt.eventId())
      {
         case WM_DDE_ACK:
         {
#ifdef IC_WIN
            if ( fDDEClientConversationData->fClWaitInitAck )
            {
               handleInitiateAck(evt);
               evt.setResult(IEventResult(1));
            }
            else
#endif
            if (!fClHdrActive) {
               fClHdrActive = true;
               handleAck(evt);
            }
            else
               ITHROWLIBRARYERROR(IC_DDE_SYNCHRONIZATION,
                   IBaseErrorInfo::accessError, IException::unrecoverable);
            fClHdrActive = false;
            break;
         }
         case WM_DDE_DATA:
         {
            if (!fClHdrActive) {
               fClHdrActive = true;
               handleData(evt);
            }
            else
               ITHROWLIBRARYERROR(IC_DDE_SYNCHRONIZATION,
                   IBaseErrorInfo::accessError, IException::unrecoverable);
            fClHdrActive = false;
            break;
         }
#ifdef IC_PM
         case WM_DDE_INITIATEACK:
         {
            handleInitiateAck(evt);
            evt.setResult(IEventResult(1));
            unsigned long j = 0;
            unsigned long rc = 0;
            do {
                 rc = DosFreeMem((void*)evt.parameter2().asUnsignedLong());
            } while ((rc == ERROR_INTERRUPT) && (++j <= 3));
            if (rc)
               ITHROWSYSTEMERROR(rc,"DosFreeMem",IBaseErrorInfo::accessError,
                 IException::recoverable);
            break;
         }
#endif  /* IC_PM */
         case WM_DDE_TERMINATE:
         {
            if (!fClHdrActive) {
               fClHdrActive = true;
               handleTerminate(evt);
            }
            else
               ITHROWLIBRARYERROR(IC_DDE_SYNCHRONIZATION,
                   IBaseErrorInfo::accessError, IException::unrecoverable);
            fClHdrActive = false;
            break;
         }
         default:
         {
            return false;
         }

      } /* endswitch */
   }
#ifdef IC_PM
   else      // dispatch the event on a separate thread
   {
      switch (evt.eventId())
      {
         case WM_DDE_ACK:
         case WM_DDE_DATA:
         case WM_DDE_TERMINATE:
         {
            unsigned long ulRc = 0;
            unsigned long ulSize(sizeof(IEvent));
            IEvent* pEvt = new IEvent(evt);
            ulRc = DosWriteQueue(queueHandle(),
                                 (unsigned long)0,
                                 ulSize,
                                 (void*)pEvt,
                                 (unsigned long)0);
            ITRACE_DEVELOP("DosWriteQueue rc =: " + IString(ulRc));
            if (ulRc) {  // no queue memory
               delete pEvt;
               ITHROWSYSTEMERROR(ulRc,"DosWriteQueue",
                   IBaseErrorInfo::outOfSystemResource, IException::recoverable);
            }
            break;
         }

         case WM_DDE_INITIATEACK:
         {
            handleInitiateAck(evt);
            evt.setResult(IEventResult(1));
            unsigned long j = 0;
            unsigned long rc = 0;
            do {
                 rc = DosFreeMem((void*)evt.parameter2().asUnsignedLong());
            } while ((rc == ERROR_INTERRUPT) && (++j <= 3));
            if (rc)
               ITHROWSYSTEMERROR(rc,"DosFreeMem",IBaseErrorInfo::accessError,
                 IException::recoverable);
            break;
         }

         default:
         {
            return false;
         }

      } /* endswitch */
   }
#endif  /* IC_PM */

#ifdef IC_WIN
   else      // dispatch the event on a separate thread
   {
      switch (evt.eventId())
      {
         unsigned long ulRc;
         unsigned long ulSize;

         case WM_DDE_ACK:
         {
            if ( fDDEClientConversationData->fClWaitInitAck )
            {
               handleInitiateAck(evt);
               evt.setResult(IEventResult(1));
            }
            else
            {
               IEvent* pEvt = new IEvent(evt);

               if ( !WriteFile(hWritePipe, &pEvt, sizeof(IEvent*), &ulSize, NULL))
                 { 
                   delete pEvt;
                   ulRc = GetLastError();
                   ITHROWSYSTEMERROR(ulRc,"WriteFile",
                       IBaseErrorInfo::outOfSystemResource, IException::recoverable);
                 }
            }
            break;
         }
         case WM_DDE_DATA:
         case WM_DDE_TERMINATE:
         {
            IEvent* pEvt = new IEvent(evt);

            if ( !WriteFile(hWritePipe, &pEvt, sizeof(IEvent*), &ulSize, NULL))
              { 
                delete pEvt;
                ulRc = GetLastError();
                ITHROWSYSTEMERROR(ulRc,"WriteFile",
                    IBaseErrorInfo::outOfSystemResource, IException::recoverable);
              }
            break;
         }

         default:
         {
            return false;
         }

      } /* endswitch */
   }
#endif  /* IC_WIN */

   return true;
}

/*------------------------------------------------------------------------------
| IDDEClientConversation::handleAck                                            |
|                                                                              |
| HandleAck will take the acknowledgement returned from the server.            |
| The event is checked to see if it is in the transactions queue.              |
| Depending on the transaction type, call the appropriate acknowledge method.  |
|                                                                              |
| Notes: Due to the wrapper of IDDEEvent class cannot cover WM_DDE_ACK         |
|        as other DDE message ( In Windows, Ack contains different values      |
|        in reply to WM_DDE_INITATE, WM_DDE_EXECUTE and other messages )       |
|        Even this method does not need to handle INITATE message, the         |
|        data and item part of IDDEEvent base class will not be filled in      |
|        until the transaction it reply is confirmed.                          |
------------------------------------------------------------------------------*/
void IDDEClientConversation :: handleAck ( const IEvent& evt )
{
   IMODTRACE_DEVELOP("DDEClntConv::handleAck");

#ifdef IC_PM
   PDDESTRUCT pddes = (_DDESTRUCT*)(void*)evt.parameter2();
   transactions().semaphor().lock();  // serialize access to the set
   if ( transactions().numberOfElements() == 0 ) {
      transactions().semaphor().unlock();
      ITRACE_DEVELOP("WM_DDE_ACK received, no matching transactions!");
   }
   else
   {
      transactions().semaphor().lock();  // serialize access to the set
      bool bFound;
      IDDEEvent evtInbound(evt);
      IString inItem = IString::upperCase(evtInbound.item());
      IString inFormat = IString::upperCase(evtInbound.format());
      IString myItem;
      IString myFormat;
      IDDEClientAcknowledgeEvent* pEvt = transactions().firstElement();
      transactions().semaphor().unlock();
      myItem = IString::upperCase(pEvt->item());
      myFormat = IString::upperCase(pEvt->format());
      if ((( myItem != inItem ) || ( myFormat != inFormat && inFormat != "")) &&
           ( pEvt->transactionType() != WM_DDE_EXECUTE ))
      //  check to see if ill behaved server is not sending positive acks!
         bFound = findTransaction(evt);
      else bFound = true;
      if (!bFound)
      {
         ITRACE_DEVELOP("WM_DDE_ACK received, no matching transaction!");
         ITRACE_DEVELOP(IString("Looking for item/format =  ") +
             evtInbound.item() + "  " + evtInbound.format());
         ITRACE_DEVELOP(IString("1st element in Q item/format =  ") +
            pEvt->item() + "  " + pEvt->format());
      }
      else
      {
         transactions().semaphor().lock();  // serialize access to the set
         // reset in case findTransaction deleted elements
         pEvt = transactions().firstElement();
         // copy the status field from the ack
         pEvt->setStatus(evtInbound.status());
         switch (pEvt->transactionType())
         {
            case WM_DDE_ADVISE:
            {
               ITRACE_DEVELOP("Ack received to a beginHotLink");
               if ( pEvt->isAckPositive() )
               {
                  // Add hot link to hot link set
                  IDDEHotLinkXEvent* pHLEvt = new
                       IDDEHotLinkXEvent(evt);
                  ITRACE_ALL(IString(
                     (unsigned long)hotLinksForUpdate().numberOfElements()) +
                     "elements in the HL set");
                  hotLinksForUpdate().semaphor().lock();
                  hotLinksForUpdate().add(pHLEvt);
                  hotLinksForUpdate().semaphor().unlock();
                  ITRACE_ALL(IString(
                     (unsigned long)hotLinksForUpdate().numberOfElements()) +
                     "elements in the HL set");
               }

               transactions().removeFirst();
               transactions().semaphor().unlock();
               this->acknowledged(*pEvt);
               break;
            }

            case WM_DDE_UNADVISE:
            {
               bool bRemove = false;
               ITRACE_DEVELOP("Ack received to endHotLink");
               if ( pEvt->isAckPositive() )
                  bRemove = true;
               IDDEClientHotLinkSet::Cursor myCurs(hotLinksForUpdate());
               IDDEHotLinkXEvent* pEvt1 = 0;
               // serialize access to the set
               hotLinksForUpdate().semaphor().lock();
               if (pEvt->item() == "" )
               {
                  // remove and delete all hotlink's
                  if (bRemove)
                  {
                     ITRACE_DEVELOP("Removing all hotlinks!");
                     hotLinksForUpdate().removeAll(&IDdeleteElemCHLS);
                  }
                  else
                     for( myCurs.setToFirst();
                          myCurs.isValid();
                          myCurs.setToNext())
                        ((IDDEHotLinkXEvent*)pEvt1)->setCloseInProgress(false);

               }
               else if (pEvt->format() == "")
                  {
                     // remove and delete all hotlink's for the item
                     if (bRemove)
                     {
                        ITRACE_DEVELOP(
                           "Removing all hotlinks for a given item");
                        hotLinksForUpdate().removeAll(
                            &IDdeleteElemCHLS, (char*)inItem);
                     }
                     else
                     {
                        for( myCurs.setToFirst();
                             myCurs.isValid();
                             myCurs.setToNext())
                        {
                           pEvt1 = (IDDEHotLinkXEvent*)
                              hotLinksForUpdate().elementAt(myCurs);
                           myItem = IString::upperCase(pEvt1->item());
                           if ( inItem == myItem )
                              ((IDDEHotLinkXEvent*)
                                 pEvt1)->setCloseInProgress(false);
                        }
                     }
                  }
                  else
                  {
                     // remove and delete the hotlink
                     if (bRemove)
                        ITRACE_DEVELOP("Removing a specific hotlink");
                     bool bSuccess = 0;
                     for(myCurs.setToFirst();myCurs.isValid() && bSuccess == 0;)
                     {
                        pEvt1 = (IDDEHotLinkXEvent*)
                           hotLinksForUpdate().elementAt(myCurs);
                        myItem = IString::upperCase(pEvt1->item());
                        myFormat = IString::upperCase(pEvt1->format());
                        if ( ( myItem == inItem ) && ( myFormat == inFormat ) )
                        {
                           bSuccess = true;
                           if (bRemove)
                           {
                              ITRACE_ALL(IString((unsigned long)
                                 hotLinksForUpdate().numberOfElements()) +
                                 "elements in the HL set");
                              hotLinksForUpdate().removeAt(myCurs);
                              ITRACE_ALL(IString((unsigned long)
                                 hotLinksForUpdate().numberOfElements()) +
                                 "elements in the HL set");
                              delete (IDDEHotLinkXEvent*)pEvt1;
                           }
                           else ((IDDEHotLinkXEvent*)pEvt1)->
                              setCloseInProgress(false);
                        }
                        else myCurs.setToNext();
                     }  // end for loop
                  }

               hotLinksForUpdate().semaphor().unlock();
               transactions().removeFirst();
               transactions().semaphor().unlock();
               this->acknowledged(*pEvt);
               break;
            }

            case WM_DDE_REQUEST:
            {
               ITRACE_DEVELOP("Ack received to requestData");
               transactions().removeFirst();
               transactions().semaphor().unlock();
               this->acknowledged(*pEvt);
               break;
            }

            case WM_DDE_EXECUTE:
            {
               ITRACE_DEVELOP("Ack received to executeCommands");
               IDDEAcknowledgeExecuteEvent* pEvt1 =
                       (IDDEAcknowledgeExecuteEvent*)transactions().firstElement();
               pEvt1->setStatus(pddes->fsStatus);
               transactions().removeFirst();
               transactions().semaphor().unlock();
               this->executeAcknowledged(*pEvt1);
               break;
            }

            case WM_DDE_POKE:
            {
               ITRACE_DEVELOP("Ack received to pokeData");
               IDDEAcknowledgePokeEvent* pEvt1 =
                     (IDDEAcknowledgePokeEvent*)transactions().firstElement();
               pEvt1->setStatus(pddes->fsStatus);
               transactions().removeFirst();
               transactions().semaphor().unlock();
               this->pokeAcknowledged(*pEvt1);
               break;
            }

            default:
            {
                transactions().removeFirst();
                transactions().semaphor().unlock();
            }

         } /* endswitch */

         delete pEvt;
      }  // end else
   }   // end else

      IDDEInfo__freeMemory(pddes);
#endif  /* IC_PM */

#ifdef IC_WIN
   long lParam = (long)(void*)evt.parameter2();

   transactions().semaphor().lock();  // serialize access to the set
   if ( transactions().numberOfElements() == 0 ) {
      transactions().semaphor().unlock();
      ITRACE_DEVELOP("WM_DDE_ACK received, no matching transactions!");
   }
   else
   {
      bool bFound = false;
      IString inItem;
      IString myItem;
      IString myFormat;

      IDDEEvent evtInbound(evt);
      IDDEClientAcknowledgeEvent* pEvt;

      // since the ack contains different types of param for different
      // types of reply, therefore the IDDEEvent class private data has
      // to be loaded explicly
      evtInbound.loadStatus( );

      //Always assume the Ack is a result of an element of the transaction
      //queue, so -loop through the queue looking for a match
      //-can't this be? check if first matches else findTransaction ??

      ITRACE_DEVELOP( "DBug: transactions().numberOfElements()="
                    + IString( transactions().numberOfElements()));
      bool   exception;
      UINT  ackLow, ackHigh(0);
      IString  command;
      IDDETransactionQueue::Cursor cursor(transactions());
      for(cursor.setToFirst(); cursor.isValid() && bFound == false; )
      {
         exception = false;
         pEvt = transactions().elementAt(cursor);
         switch ( pEvt->transactionType())
         {
             case WM_DDE_ADVISE:
             case WM_DDE_POKE:
             case WM_DDE_REQUEST:
             case WM_DDE_UNADVISE:
                if ( evtInbound.item() == "" )
                {
                   evtInbound.loadItem();
                   inItem = IString::upperCase(evtInbound.item());
                }
                bFound = inItem == IString::upperCase(pEvt->item());
                break;
             case WM_DDE_EXECUTE:
                if ( evtInbound.buffer() == "" )
                {
                   try { evtInbound.loadBuffer(); }
                   catch ( IAccessError& error ) { exception = true; }
                }
                if ( exception )
                   ITRACE_DEVELOP( "DBug: WM_DDE_EXECUTE case exception, skipping." );
                else
                {
                   ITRACE_DEVELOP( "DBug: evtInbound.buffer()=" + evtInbound.buffer());

                   HGLOBAL hCommands = (void *)pEvt->parameter2().asUnsignedLong();
                   char FAR *lpCommands = (char FAR *)GlobalLock( hCommands );
                   if ( lpCommands != NULL )
                   {
                      ITRACE_DEVELOP( "DBug: transaction().Command()=" + IString( lpCommands ));

                      bFound = evtInbound.buffer() == (const char*)lpCommands;
                      GlobalUnlock( hCommands );
                   }
                }
                break;
         } /* endswitch */
         if ( !bFound )
            cursor.setToNext();
         ITRACE_DEVELOP( "DBug: pEvt->transactionType()="
                       + IString( pEvt->transactionType()));
      }

      ITRACE_DEVELOP( "DBug: bFound=" + IString( bFound?"true":"false"));
      if ( pEvt != transactions().firstElement())
      {
         transactions().semaphor().unlock();
         bFound = findTransaction(evt);
      }
      else transactions().semaphor().unlock();


      if (!bFound)
      {
         ITRACE_DEVELOP("WM_DDE_ACK received, no matching transaction!");
         ITRACE_DEVELOP( "Searching for match where item=" + evtInbound.item()
                       + ", format=" + evtInbound.format()
                       + ", data=" + evtInbound.buffer());
// TTD         ITRACE_DEVELOP(IString("1st element in Q item/format =  ") +
// TTD            pEvt->item() + "  " + pEvt->format());
      }
      else
      {
         // reset in case findTransaction deleted elements
         transactions().semaphor().lock();  // serialize access to the set
         pEvt = transactions().firstElement();

         // copy the status field from the ack for callback, but keep the
         //   original status in temp
         unsigned short usQEvtStatus = pEvt->status();
         pEvt->setStatus(evtInbound.status());

         switch (pEvt->transactionType())
         {
            case WM_DDE_ADVISE:
            {
               ITRACE_DEVELOP("Ack received to a beginHotLink");
               if ( pEvt->isAckPositive() )
               {
                  // Add hot link to hot link set
                  IDDEHotLinkXEvent* pHLEvt = new IDDEHotLinkXEvent(evt);
                  pHLEvt->loadStatus();
                  pHLEvt->loadItem();
                  pHLEvt->loadFormat() ;  // TTD

                  ITRACE_ALL(IString(
                       (unsigned long)hotLinksForUpdate().numberOfElements()) +
                       "elements in the HL set");
                  ITRACE_DEVELOP(IString(
                       (unsigned long)hotLinksForUpdate().numberOfElements()) +
                       "elements in the HL set");     // TTD
                  ITRACE_DEVELOP(IString("Adding HotLink")) ;
                  ITRACE_DEVELOP(IString("topic ")+IString(pHLEvt->item()) ) ;
                  ITRACE_DEVELOP(IString(" format ")+IString(pHLEvt->format()) ) ;
                  hotLinksForUpdate().semaphor().lock();
                  hotLinksForUpdate().add(pHLEvt);
                  hotLinksForUpdate().semaphor().unlock();
                  ITRACE_ALL(IString(
                       (unsigned long)hotLinksForUpdate().numberOfElements()) +
                       "elements in the HL set");
               }
               else    // -ve ack, client should free the hOption(DDEADVISE) memory
               {
                  ITRACE_DEVELOP("negative ack to dde_advise") ;
// TTD nothing to free
//                  IDDEInfo__freeMemory( (HGLOBAL)IDDEInfo__loWord(WM_DDE_ADVISE,
//                                                                  pEvt->parameter2()) );
               }

               transactions().removeFirst();
               transactions().semaphor().unlock();
               this->acknowledged(*pEvt);
               break;
            }

            case WM_DDE_UNADVISE:
            {
               bool bRemove = false;
               ITRACE_DEVELOP("Ack received to endHotLink");
               if ( pEvt->isAckPositive() )
                  bRemove = true;
               IDDEClientHotLinkSet::Cursor myCurs(hotLinksForUpdate());
               IDDEHotLinkXEvent* pEvt1 = 0;
               // serialize access to the set
               hotLinksForUpdate().semaphor().lock();
               if (pEvt->item() == "" )
               {
                  // remove and delete all hotlink's
                  if (bRemove)
                  {
                     ITRACE_DEVELOP("Removing all hotlinks!");
                     hotLinksForUpdate().removeAll(&IDdeleteElemCHLS);
                  }
                  else
                     for( myCurs.setToFirst();
                          myCurs.isValid();
                          myCurs.setToNext())
                        ((IDDEHotLinkXEvent*)pEvt1)->setCloseInProgress(false);
               }
               else if (pEvt->format() == "")
               {
                  // remove and delete all hotlink's for the item
                  if (bRemove)
                  {
                     ITRACE_DEVELOP(
                        "Removing all hotlinks for a given item");
                     hotLinksForUpdate().removeAll(
                         &IDdeleteElemCHLS, (char*)inItem);
                  }
                  else
                  {
                     for( myCurs.setToFirst();
                          myCurs.isValid();
                          myCurs.setToNext())
                     {
                        pEvt1 = (IDDEHotLinkXEvent*)
                           hotLinksForUpdate().elementAt(myCurs);
                        myItem = IString::upperCase(pEvt1->item());
                        if ( inItem == myItem )
                           ((IDDEHotLinkXEvent*)
                              pEvt1)->setCloseInProgress(false);
                     }
                  }
               }
               else
               {
                  // remove and delete the hotlink
                  if (bRemove)
                     ITRACE_DEVELOP("Removing a specific hotlink");
                  bool bSuccess = 0;
                  for(myCurs.setToFirst();myCurs.isValid() && bSuccess == 0;)
                  {
                     pEvt1 = (IDDEHotLinkXEvent*)
                        hotLinksForUpdate().elementAt(myCurs);
                     myItem = IString::upperCase(pEvt1->item());
                     myFormat = IString::upperCase(pEvt1->format());
                     // no needs for compare in-bound format, ack in Windows
                     // does not pass format
                     if ( myItem == inItem )
                     {
                        bSuccess = true;
                        if (bRemove)
                        {
                           ITRACE_ALL(IString((unsigned long)
                              hotLinksForUpdate().numberOfElements()) +
                              "elements in the HL set");
                           hotLinksForUpdate().removeAt(myCurs);
                           ITRACE_ALL(IString((unsigned long)
                              hotLinksForUpdate().numberOfElements()) +
                              "elements in the HL set");
                           delete (IDDEHotLinkXEvent*)pEvt1;
                        }
                        else ((IDDEHotLinkXEvent*)pEvt1)->
                                                  setCloseInProgress(false);
                     }
                     else myCurs.setToNext();
                  }  // end for loop
               }

               hotLinksForUpdate().semaphor().unlock();
               transactions().removeFirst();
               transactions().semaphor().unlock();
               this->acknowledged(*pEvt);
               break;
            }

            // for Windows, only -ve ack will be returned in this case
            case WM_DDE_REQUEST:
            {
               ITRACE_DEVELOP("Ack received to requestData");
               // call client callback to handle the ack
               transactions().removeFirst();
               transactions().semaphor().unlock();
               this->acknowledged(*pEvt);
               break;
            }

            case WM_DDE_EXECUTE:
            {
               ITRACE_DEVELOP("Ack received to executeCommands");
               IDDEAcknowledgeExecuteEvent* pEvt1 =
                       (IDDEAcknowledgeExecuteEvent*)transactions().firstElement();
               pEvt1->setStatus( evtInbound.status() );

               // call the client callback
               transactions().removeFirst();
               transactions().semaphor().unlock();
               this->executeAcknowledged(*pEvt1);

               // free the commands memory sent back with the ack
//mkb               IDDEInfo__freeMemory( (HGLOBAL)IDDEInfo__hiWord(WM_DDE_EXECUTE, lParam) );
               IDDEInfo__freeMemory( (HGLOBAL)IDDEInfo__hiWord(WM_DDE_ACK, lParam) );

               break;
            }

            case WM_DDE_POKE:
            {
               ITRACE_DEVELOP("Ack received to pokeData");
               IDDEAcknowledgePokeEvent* pEvt1 =
                     (IDDEAcknowledgePokeEvent*)transactions().firstElement();
               pEvt1->setStatus( evtInbound.status() );

               ITRACE_DEVELOP(IString("poke status ") + IString(evtInbound.status()) ) ; // TTD

               // TTD Ack for a Poke does not contain global memory handle
               // clean the poke data buffer (hData)
               //if ( !(pEvt1->isAckPositive()) ||
               //     !(usQEvtStatus & IDDEInfo::releaseData) )
               //{
               //   IDDEInfo__freeMemory( (HGLOBAL)IDDEInfo__loWord(WM_DDE_POKE, pEvt->parameter2()) );
               //}
               // TTD

               // call the client callback
               transactions().removeFirst();
               transactions().semaphor().unlock();
               this->pokeAcknowledged(*pEvt1);
               break;
            }

            default:
            {
                transactions().removeFirst();
                transactions().semaphor().unlock();
            }

         } /* endswitch */

         delete pEvt;
      }  // end else
   }   // end else
   FreeDDElParam( WM_DDE_ACK, lParam ); //mkb
#endif  /* IC_WIN */

}

/*------------------------------------------------------------------------------
| IDDEClientConversation::handleData                                           |
|                                                                              |
| This method is called from the dispatchHandler in response to the            |
| WM_DDE_DATA message. If the data message is in response to requestData       |
| then pass the data to receiver via the data method                           |
------------------------------------------------------------------------------*/
void IDDEClientConversation :: handleData ( const IEvent& evt )
{
   IMODTRACE_DEVELOP("DDEClntConv::handleData");

#ifdef IC_PM
   PDDESTRUCT pddes = (_DDESTRUCT*)(void*)evt.parameter2();
   IDDEEvent evtInbound(evt);
   IString inItem = IString::upperCase(evtInbound.item());
   IString inFormat = IString::upperCase(evtInbound.format());
   IString myItem;
   IString myFormat;
   unsigned short usStatus = 0;
   bool bPosAck = false;
   if ( pddes->fsStatus & DDE_FRESPONSE )         // response to requestData?
   {
      transactions().semaphor().lock();  // serialize access to the set
      if ( transactions().numberOfElements() != 0 )
      {
         IDDEClientAcknowledgeEvent* pEvt = transactions().firstElement();
         transactions().semaphor().unlock();
         myItem = IString::upperCase(pEvt->item());
         myFormat = IString::upperCase(pEvt->format());
         if ( (pEvt->transactionType() != WM_DDE_REQUEST) ||
                       ( myItem != inItem ) || ( myFormat != inFormat ) )
    //  check to see if ill behaved server is not sending positive acks!
            bPosAck = findTransaction(evt);
         else bPosAck = true;
         if (bPosAck)
         {
            // ensure we have the correct event
            transactions().semaphor().lock();  // serialize access to the set
            pEvt = transactions().firstElement();
            ITRACE_DEVELOP("WM_DDE_DATA from server matches request in queue");
            transactions().removeFirst();
            transactions().semaphor().unlock();
            delete pEvt;
            IDDEDataEvent dataevt(evt);
            bPosAck = this->data(dataevt);   // callback the user
            usStatus = dataevt.status();
         }
         else
         {
            ITRACE_DEVELOP("WM_DDE_DATA received, no matching transaction!");
            ITRACE_DEVELOP(IString("Looking for item/format =  ") +
               evtInbound.item() + "  " + evtInbound.format());
            ITRACE_DEVELOP(IString("1st element in Q item/format =  ") +
               pEvt->item() + "  " + pEvt->format());
         }
      }
      else {
         transactions().semaphor().unlock();
         ITRACE_DEVELOP("WM_DDE_DATA received, no outstanding transactions!");
      }
   }
   else             // data or inform from hotlink
   {
      ITRACE_ALL("Trying to find hotLinkTrans, looking for item and format of" );
      ITRACE_ALL(evtInbound.item() + "  " + evtInbound.format());
      IDDEClientHotLinkSet::Cursor myCurs(hotLinksForUpdate());
      const IDDEHotLinkXEvent* pEvt1 = 0;
      hotLinksForUpdate().semaphor().lock();  // serialize access to the set
      for(myCurs.setToFirst(); myCurs.isValid() && bPosAck == false;)
      {
         pEvt1 = (IDDEHotLinkXEvent*)hotLinksForUpdate().elementAt(myCurs);
         myItem = IString::upperCase(pEvt1->item());
         myFormat = IString::upperCase(pEvt1->format());
         if ( ( myItem == inItem ) && ( myFormat == inFormat ) )
            bPosAck = true;
         else myCurs.setToNext();
      }  // end for loop
      hotLinksForUpdate().semaphor().unlock();
      if (!bPosAck)
         bPosAck = findTransaction(evt, true);
      if (bPosAck)
      {
         if ( pddes->fsStatus & DDE_FNODATA ) // hotlink inform
         {
            ITRACE_DEVELOP("Hot Link Inform matches active link");
            IDDEClientHotLinkEvent hlevt(evt);
            bPosAck = this->hotLinkInform(hlevt);
            usStatus = hlevt.status();
         }
         else
         {
            ITRACE_DEVELOP("Hot Link Data matches active link");
            IDDEDataEvent hlevt(evt);
            bPosAck = this->data(hlevt);
            usStatus = hlevt.status();
         }
      }
      else
      {
         ITRACE_DEVELOP("WM_DDE_DATA received, no matching hotlink!");
         ITRACE_DEVELOP(IString("Looking for item/format =  ") +
            evtInbound.item() + "  " + evtInbound.format());
      }
   }  // end data or inform from hotLink

  // Send an ack if one has been requested
   if (pddes->fsStatus & DDE_FACKREQ )
   {
      if (bPosAck)
      {
         usStatus |=  DDE_FACK;
         // ensure none of the negative flags are on
         usStatus &= ~(DDE_FBUSY | DDE_NOTPROCESSED);
      }
      PDDESTRUCT pddest = (PDDESTRUCT)buildDDEStruct (
                             (char*)DDES_PSZITEMNAME(pddes),
                             0,
                             usStatus,
                             0,
                             0);
      pddest->usFormat = pddes->usFormat;
      bool fError = WinDdePostMsg((HWND)serverHandle(),
                                     (HWND)clientHandle(),
                                     WM_DDE_ACK,
                                     pddest,
                                     DDEPM_RETRY);
      if (!fError)
      {
         // don't throw exception as server will also crash
         fClPostMsgFail = true;
         IEvent myEvt(clientHandle(),        // create dummy event for callback
                      (unsigned long)WM_DDE_TERMINATE,
                      IEventParameter1((unsigned long)clientHandle()),
                      IEventParameter2((void*)0));
         IDDEClientEndEvent endEvt(myEvt, IDDEEndEvent::error, application(),
            topic());
         bool bEnded = true;
         try {
            this->end();
         }
         catch (IInvalidRequest& excReq) {
            bEnded = false;
         }
         if (bEnded)
            this->conversationEnded(endEvt);
         this->end();
         this->conversationEnded(endEvt);
         fClPostMsgFail = false;
      }
   }

   IDDEInfo__freeMemory(pddes);
#endif  /* IC_PM */

#ifdef IC_WIN
   unsigned long lParam = evt.parameter2().asUnsignedLong() ;  // TTD
   IDDEEvent evtInbound(evt);

   IString inItem = IString::upperCase(evtInbound.item());
   IString inFormat = IString::upperCase(evtInbound.format());
   IString myItem;
   IString myFormat;
   unsigned short usStatus = 0;
   bool bPosAck = false;
   IDDEClientAcknowledgeEvent* pEvt(0) ;

   // 1 - check to see if it's a response to a previous request
   // 2 - if not, check if it's a hot link inform
   // 3 - if not that either, punt
//   if ( evtInbound.status() & IDDEInfo::responseFromReq )
//   {
   transactions().semaphor().lock();  // serialize access to the set
   if ( transactions().numberOfElements() != 0 ) {
      pEvt = transactions().firstElement();
      transactions().semaphor().unlock();
      myItem = IString::upperCase(pEvt->item());
      myFormat = IString::upperCase(pEvt->format());

      if ( (pEvt->transactionType() != WM_DDE_REQUEST) ||
           ( myItem != inItem ) || ( myFormat != inFormat ) )
         //  check to see if ill behaved server is not sending positive acks!
         bPosAck = findTransaction(evt);
      else
         bPosAck = true;
   }
   else
      transactions().semaphor().unlock();

   if (bPosAck) {
      // ensure we have the correct event
      transactions().semaphor().lock();  // serialize access to the set
      pEvt = transactions().firstElement();
      ITRACE_DEVELOP("WM_DDE_DATA from server matches request in queue");
      transactions().removeFirst();
      transactions().semaphor().unlock();
      delete pEvt;
      IDDEDataEvent dataevt(evt);

      bPosAck = this->data(dataevt);   // callback the user

      usStatus = dataevt.status();
   }
   else {
      ITRACE_DEVELOP( "Trying to find hotLinkTrans, looking for item and format of" );
      ITRACE_DEVELOP( evtInbound.item() + "  " + evtInbound.format());

      IDDEClientHotLinkSet::Cursor myCurs(hotLinksForUpdate());
      const IDDEHotLinkXEvent* pEvt1 = 0;
      hotLinksForUpdate().semaphor().lock();  // serialize access to the set

      for(myCurs.setToFirst(); myCurs.isValid() && bPosAck == false;)
      {
         pEvt1 = (IDDEHotLinkXEvent*)hotLinksForUpdate().elementAt(myCurs);
         myItem = IString::upperCase(pEvt1->item());
         myFormat = IString::upperCase(pEvt1->format());
         ITRACE_DEVELOP(IString("HotListItem ")+IString(myItem)+
                        IString(" hotListFormat ")+IString(myFormat)) ;
         if ( ( myItem == inItem ) && ( myFormat == inFormat ) )
            bPosAck = true;
         else myCurs.setToNext();
      }

      hotLinksForUpdate().semaphor().unlock();
      if (!bPosAck)
         bPosAck = findTransaction(evt, true);
      if (bPosAck)
      {
         // warmlink inform ?
         if ( IDDEInfo__loWord(WM_DDE_DATA, lParam) == NULL )
         {
            ITRACE_DEVELOP("Hot Link Inform matches active link");
            IDDEClientHotLinkEvent hlevt(evt);

            // call client callback
            bPosAck = this->hotLinkInform(hlevt);

            usStatus = hlevt.status();
         }
         else     // data is here
         {
            ITRACE_DEVELOP("Hot Link Data matches active link");
            IDDEDataEvent hlevt(evt);

            // call client callback
            bPosAck = this->data(hlevt);

            // may contains app specific rc
            usStatus = hlevt.status();
         }
      }
      else {
         ITRACE_DEVELOP("WM_DDE_DATA received, no matching hotlink!");
         ITRACE_DEVELOP(IString("Looking for item/format =  ") +
                        evtInbound.item() + "  " + evtInbound.format());
      }
   }  // end data or inform from hotLink

   // finished with the data, clean the data buffer as request
   if ( (evtInbound.status() & IDDEInfo::releaseData) && (bPosAck) )
   {
      IDDEInfo__freeMemory( (HGLOBAL)IDDEInfo__loWord(WM_DDE_DATA, lParam) );
   }

   // Send an ack if one has been requested
   if ( evtInbound.status() & IDDEInfo::acknowledgeRequested )
   {
      if (bPosAck)
      {
         usStatus |=  IDDEInfo::acknowledge;
         // ensure none of the negative flags are on
         usStatus &= ~(IDDEInfo::busy | IDDEInfo::notProcessed);
      }
      else
         usStatus = 0;      // set status as -ve

      UINT ackBuffer = IDDEInfo__buildDDEAck(usStatus) ;

      UINT aItem = IDDEInfo__hiWord( WM_DDE_DATA, lParam );

      ITRACE_DEVELOP( "DBug: postMessage WM_DDE_ACK first" );
      bool fError = PostMessage( (HWND)serverHandle(),
                                    WM_DDE_ACK,
                                    (WPARAM)(HWND)clientHandle(),
                                    PackDDElParam( WM_DDE_ACK, ackBuffer, aItem ) );
      if (!fError)
      {
         // don't throw exception as server will also crash
         fClPostMsgFail = true;
//       IDDEInfo__freeMemory( hDdeAck );
         IEvent myEvt(clientHandle(),        // create dummy event for callback
                      (unsigned long)WM_DDE_TERMINATE,
                      IEventParameter1((unsigned long)(void *)clientHandle()),
                      IEventParameter2((void*)0));
         IDDEClientEndEvent endEvt( myEvt, IDDEEndEvent::error, application(),
                                    topic());
         bool bEnded = true;
         try {
            this->end();
         }
         catch (IInvalidRequest& excReq) {
            bEnded = false;
         }
         if (bEnded)
            this->conversationEnded(endEvt);
         this->end();
         this->conversationEnded(endEvt);
         fClPostMsgFail = false;
      }
   }
   else    // no ack requested, free the item atom
   {
//       IDDEInfo__freeAtom( IDDEInfo__hiWord(WM_DDE_DATA, lParam) );
   }
   FreeDDElParam( WM_DDE_DATA, evt.parameter2().asUnsignedLong()); //mkb
#endif  /* IC_WIN */
}

/*------------------------------------------------------------------------------
| IDDEClientConversation::handleInitiateAck                                    |
|                                                                              |
| The initiateAck is sent by the server in response to the initiate message.   |
| If fClBrdcstInPrgrs is set then add the active server to the server set      |
| pointed to by pActServSetCl. SupportingTopics and SupportingApplications     |
| use this to add servers to the server list that support the broadcast        |
| message.                                                                     |
------------------------------------------------------------------------------*/
void IDDEClientConversation :: handleInitiateAck ( const IEvent& evt )
{
   IMODTRACE_DEVELOP("DDEClntConv::handleInitiateAck");
   bool bTerminate = false;
   bool bCaseSensitive = false ;
   IString strEvtApplication, strEvtTopic ;   // TTD

   IDDEBeginEvent initevt(evt);
   strEvtApplication = initevt.application() ;
   strEvtTopic       = initevt.topic() ;
   bCaseSensitive    = initevt.isCaseSensitive() ;

   if (fClBrdcstInPrgrs)
   {
      IDDEActiveServer* pServ = new IDDEActiveServer(strEvtApplication,
                                                     strEvtTopic,
                                                     bCaseSensitive);
      pActServSetCl->add(pServ);
      bTerminate = true;
   }
   else
   {
      if (!inConversation())
      {
         IString myapp = IString::upperCase(application());
         IString mytop = IString::upperCase(topic());
         IString inapp = IString::upperCase(strEvtApplication);
         IString intop = IString::upperCase(strEvtTopic);
         if ( (myapp == inapp) && (mytop == intop) )
         {
            wndhClServer = (IWindowHandle)(evt.parameter1());
            if (bCaseSensitive)
               fClCaseSensitive = true;
         }
         else
         {
            ITRACE_DEVELOP(
               "Application and Topic don't match, conversation discarded");
            bTerminate = true;
         }
      }
      else
      {
         ITRACE_DEVELOP(
            "More than one server responded, conversation discarded");
         bTerminate = true;
      }
   }
   // terminate the conversation if necessary
   if (bTerminate)
   {
#ifdef IC_PM
      bool bSuccess = WinDdePostMsg((HWND)evt.parameter1(),
                                       (HWND)clientHandle(),
                                       WM_DDE_TERMINATE,
                                       0,
                                       DDEPM_RETRY);
#endif
#ifdef IC_WIN
      bool bSuccess = PostMessage( (HWND)evt.parameter1(),
                                      WM_DDE_TERMINATE,
                                      (WPARAM)(HWND)clientHandle(),
                                      0L );
#endif
      if (!bSuccess)
         ITRACE_DEVELOP(
            IString("WM_DDE_TERMINATE failure on attempt to initate end of ") +
            IString("conversation, server application is ") +
            strEvtApplication );
      else
      {
         IDDEClosedConversation* pConv = new
            IDDEClosedConversation(strEvtApplication,
                                   strEvtTopic,
                                   (HWND)evt.parameter1());
         closedConversations().semaphor().lock();  // serialize access to the set
         closedConversations().add(pConv);
         closedConversations().semaphor().unlock();
      }
   }
}

/*------------------------------------------------------------------------------
| IDDEClientConversation::handleTerminate                                      |
|                                                                              |
| When the terminate message is received from the server the client must       |
| respond with a terminate message if initiated from the server. If the        |
| terminate was initiated by the client then the terminate message from        |
| server is in response to the client and the client should not send another   |
| terminate message.                                                           |
|                                                                              |
| If the client initiated the closing of the conversation then the             |
| conversation will be in the closed conversation set. This is used to         |
| determine that a WM_DDE_TERMINATE message should not be sent back to the     |
| server. The receiver is notified of the closing of the conversation through  |
| the method conversationEnded only if the closing is not the result of a      |
| broadcast message.                                                           |
|                                                                              |
| If the conversation is not in the closed conversation set then the closing   |
| was initiated by the server and the client must respond with the             |
| WM_DDE_TERMINATE message.                                                    |
------------------------------------------------------------------------------*/
void IDDEClientConversation :: handleTerminate ( const IEvent& evt )
{
   IMODTRACE_DEVELOP("DDEClntConv::handleTerminate");

// iterate the closed list first
   IDDEClosedConversationSet::Cursor myCurs(closedConversations());
   IDDEClosedConversation* pConv = 0;
   bool bSuccess = false;

#ifdef IC_PM
   IEvent myEvt(clientHandle(),        // create dummy event for callbacks
                (unsigned long)WM_DDE_TERMINATE,
                IEventParameter1((unsigned long)clientHandle()),
                IEventParameter2((void*)0));
#endif
#ifdef IC_WIN
   IEvent myEvt(clientHandle(),        // create dummy event for callbacks
                (unsigned long)WM_DDE_TERMINATE,
                IEventParameter1((unsigned long)(void *)clientHandle()),
                IEventParameter2((void*)0));
#endif

   closedConversations().semaphor().lock();  // serialize access to the set
   for(myCurs.setToFirst(); myCurs.isValid() && bSuccess == false;)
   {
      pConv = closedConversations().elementAt(myCurs);
      if ( pConv->serverHandle().asUnsigned() == evt.parameter1() )
      {
         bSuccess = true;
         closedConversations().removeAt(myCurs);
         closedConversations().semaphor().unlock();
// check flag here and callback if necessary (not from broadcast)
         if ( pConv->userClosed() )
         {
            IDDEClientEndEvent endEvt(myEvt, IDDEEndEvent::client,
                                      pConv->application(), pConv->topic());
            this->conversationEnded(endEvt);
         }
         delete pConv;
      }
      else myCurs.setToNext();
   }  // end for loop

   if (!bSuccess)
   {
      closedConversations().semaphor().unlock();
      if (evt.parameter1() == serverHandle().asUnsigned())
      {
         IString tmpapp = application();
         IString tmptop = topic();
         fClCaseSensitive = false;
         strClApplication = "";
         strClTopic = "";
#ifdef IC_PM
         bool fError = WinDdePostMsg((HWND)serverHandle(),
                                        (HWND)clientHandle(),
                                        WM_DDE_TERMINATE,
                                        0,
                                        DDEPM_RETRY);
#endif  /* IC_PM */
#ifdef IC_WIN
         bool fError = PostMessage( (HWND)serverHandle(),
                                       WM_DDE_TERMINATE,
                                       (WPARAM)(HWND)clientHandle(),
                                       0L );
#endif  /* IC_WIN */

         if (!fError)
            ITRACE_DEVELOP(
               "Failure on attempt to respond to WM_DDE_TERMINATE.");
         wndhClServer = (IWindowHandle)0;
      // clear the hotlink set and transaction queue
         hotLinksForUpdate().semaphor().lock();  // serialize access to the set
         hotLinksForUpdate().removeAll(&IDdeleteElemCHLS);
         hotLinksForUpdate().semaphor().unlock();
         transactions().semaphor().lock();  // serialize access to the set
         transactions().allElementsDo(&IDdeleteElemTQ);
         transactions().removeAll();
         transactions().semaphor().unlock();

         IDDEClientEndEvent endEvt1(myEvt, IDDEEndEvent::server, tmpapp,
            tmptop);
         this->conversationEnded(endEvt1);
      }
      else
        ITRACE_DEVELOP("Unknown server sent WM_DDE_TERMINATE");
   }
}

/*------------------------------------------------------------------------------
| IDDEClientConversation::endAllHotLinks                                       |
|                                                                              |
| End the hot links for the specified item in all formats. If no hot links     |
| for the requested item exist then an exception is thrown. An exception is    |
| also thrown if a request to end all hot links on this item has already been  |
| requested and is pending.                                                    |
------------------------------------------------------------------------------*/
void IDDEClientConversation :: endAllHotLinks ( const char* item )
{
   IMODTRACE_DEVELOP("DDEClntConv::endAllHotLinks");
   IASSERTPARM(strlen(item));
   IString inItem = IString::upperCase(IString(item));
   IString myItem;

// ensure at least one hotlink exists for this item
   ITRACE_DEVELOP("Getting ready to check for active hotLink match.");
   if (hotLinksForUpdate().numberOfElements() == 0)
      ITHROWLIBRARYERROR(IC_DDE_NO_HOTLINKS,IBaseErrorInfo::invalidRequest,
         IException::recoverable);
   bool bSuccess = 0;
   bool bFound = 0;
   IDDEClientHotLinkSet::Cursor myCurs(hotLinksForUpdate());
   IDDEHotLinkXEvent* pEvt = 0;
   hotLinksForUpdate().semaphor().lock();  // serialize access to the set
   forCursor(myCurs)
   {
      pEvt = (IDDEHotLinkXEvent*)hotLinksForUpdate().elementAt(myCurs);
      myItem = IString::upperCase(pEvt->item());
      if ( inItem == myItem )
      {
         bFound = true;
         if ( !(pEvt->isCloseInProgress()) )
         {
            bSuccess = true;
            ((IDDEHotLinkXEvent*)pEvt)->setCloseInProgress(true);
         }
      }
   }
   hotLinksForUpdate().semaphor().unlock();
   if (!bFound)
      ITHROWLIBRARYERROR(IC_DDE_NO_HOTLINKS_ITEM,IBaseErrorInfo::invalidRequest,
         IException::recoverable);
   if (!bSuccess)
      ITHROWLIBRARYERROR(IC_DDE_END_HOTLINKS_ITEM_PENDING,
         IBaseErrorInfo::invalidRequest,IException::recoverable);

#ifdef IC_PM
   PDDESTRUCT pddes = (PDDESTRUCT)buildDDEStruct (item,
                                                  0,
                                                  0,
                                                  0,
                                                  0);
// build the event before posting the message,
// as OS/2 will free the shared memory on us
   IEvent myEvt(serverHandle(),
                (unsigned long)WM_DDE_UNADVISE,
                IEventParameter1((unsigned long)clientHandle()),
                IEventParameter2((void*)pddes));
   IDDEClientAcknowledgeEvent* pevt = new IDDEClientAcknowledgeEvent(myEvt);

   bSuccess = WinDdePostMsg((HWND)serverHandle(),
                            (HWND)clientHandle(),
                            WM_DDE_UNADVISE,
                            pddes,
                            DDEPM_RETRY);
   if (bSuccess)
   {
      // add the endHotLink transaction to the Queue
      transactions().semaphor().lock();  // serialize access to the set
      transactions().add(pevt);
      transactions().semaphor().unlock();
   }
   else
   {
      delete pevt;
      IDDEInfo__freeMemory( pddes );
      ITHROWLIBRARYERROR1(IC_DDE_WINDDEPOSTMESSAGE_USER,
         IBaseErrorInfo::accessError, IException::recoverable,
         "WinDdePostMsg (WM_DDE_UNADVISE)");
   }
#endif   /* IC_PM */

#ifdef IC_WIN
   bool bAtomAdded;
   ATOM aItem = IDDEInfo__atomFromString( IString(item), &bAtomAdded );
   if ( bAtomAdded )
   {
      itemAtoms().add( aItem );
      ITRACE_DEVELOP("Added atom to item list.");
   }

//mkb   LPARAM lParam = PackDDElParam( WM_DDE_UNADVISE, 0, aItem );

   // build the event before posting the message,
   // as system will free the shared memory on us
   IEvent myEvt( serverHandle(),
                 (unsigned long)WM_DDE_UNADVISE,
                 IEventParameter1((unsigned long)(void *)clientHandle()),
                 IEventParameter2((unsigned long)MAKELPARAM( 0, aItem )) );
   IDDEClientAcknowledgeEvent* pevt = new IDDEClientAcknowledgeEvent(myEvt);

   bSuccess = PostMessage( (HWND)serverHandle(),
                           WM_DDE_UNADVISE,
                           (WPARAM)(HWND)clientHandle(),
                           MAKELPARAM( 0, aItem) );
   if (bSuccess)
   {
      // add the endHotLink transaction to the Queue
      transactions().semaphor().lock();  // serialize access to the set
      transactions().add(pevt);
      transactions().semaphor().unlock();
   }
   else
   {
      delete pevt;
      ITHROWLIBRARYERROR1( IC_DDE_WINDDEPOSTMESSAGE_USER,
                           IBaseErrorInfo::accessError, IException::recoverable,
                           "PostMessage (WM_DDE_UNADVISE)");
   }
#endif   /* IC_WIN */

}

/*------------------------------------------------------------------------------
| IDDEClientConversation::endAllHotLinks                                       |
------------------------------------------------------------------------------*/
void IDDEClientConversation :: endAllHotLinks ( )
{
   IMODTRACE_DEVELOP("DDEClntConv::endAllHotLinks");
// ensure at least one hotlink exists
   ITRACE_DEVELOP("Getting ready to check for active hotLink match.");
   if (hotLinksForUpdate().numberOfElements() == 0)
      ITHROWLIBRARYERROR(IC_DDE_NO_HOTLINKS,IBaseErrorInfo::invalidRequest,
         IException::recoverable);

   bool bFound = 0;
   IDDEClientHotLinkSet::Cursor myCurs(hotLinksForUpdate());
   IDDEHotLinkXEvent* pEvt = 0;
   hotLinksForUpdate().semaphor().lock();  // serialize access to the set
   forCursor(myCurs)
   {
      pEvt = (IDDEHotLinkXEvent*)hotLinksForUpdate().elementAt(myCurs);
      if ( !(pEvt->isCloseInProgress()) )
      {
         bFound = true;
         ((IDDEHotLinkXEvent*)pEvt)->setCloseInProgress(true);
      }
   }
   hotLinksForUpdate().semaphor().unlock();
   if (!bFound)
      ITHROWLIBRARYERROR(IC_DDE_END_HOTLINKS_PENDING,
         IBaseErrorInfo::invalidRequest,IException::recoverable);

#ifdef IC_PM
   PDDESTRUCT pddes = (PDDESTRUCT)buildDDEStruct (0,
                                                  0,
                                                  0,
                                                  0,
                                                  0);

// add the endHotLink transaction to the Queue
// build the event before posting the message,
// as OS/2 will free the shared memory on us
   IEvent myEvt(serverHandle(),
                (unsigned long)WM_DDE_UNADVISE,
                IEventParameter1((unsigned long)clientHandle()),
                IEventParameter2((void*)pddes));
   IDDEClientAcknowledgeEvent* pevt = new
     IDDEClientAcknowledgeEvent(myEvt);
   bool bSuccess = WinDdePostMsg((HWND)serverHandle(),
                                    (HWND)clientHandle(),
                                    WM_DDE_UNADVISE,
                                    pddes,
                                    DDEPM_RETRY);
   if (bSuccess)
   {
      transactions().semaphor().lock();  // serialize access to the set
      transactions().add(pevt);
      transactions().semaphor().unlock();
   }
   else
   {
      delete pevt;
      IDDEInfo__freeMemory( pddes );
      ITHROWLIBRARYERROR1(IC_DDE_WINDDEPOSTMESSAGE_USER,IBaseErrorInfo::accessError,
                    IException::recoverable, "WinDdePostMsg (WM_DDE_UNADVISE)");
   }
#endif  /* IC_PM */
#ifdef IC_WIN
   // add the endHotLink transaction to the Queue
   // build the event before posting the message,
   // as OS/2 will free the shared memory on us
   IEvent myEvt( serverHandle(),
                 (unsigned long)WM_DDE_UNADVISE,
                 IEventParameter1((unsigned long)(void *)clientHandle()),
                 IEventParameter2((void*)0) );
   IDDEClientAcknowledgeEvent* pevt = new IDDEClientAcknowledgeEvent(myEvt);

   bool bSuccess = PostMessage( (HWND)serverHandle(),
                                   WM_DDE_UNADVISE,
                                   (WPARAM)(HWND)clientHandle(),
                                   0L );
   if (bSuccess)
   {
      transactions().semaphor().lock();  // serialize access to the set
      transactions().add(pevt);
      transactions().semaphor().unlock();
   }
   else
   {
      delete pevt;
      ITHROWLIBRARYERROR1(IC_DDE_WINDDEPOSTMESSAGE_USER,IBaseErrorInfo::accessError,
                    IException::recoverable, "PostMessage (WM_DDE_UNADVISE)");
   }
#endif  /* IC_WIN */

}

/*------------------------------------------------------------------------------
| IDDEClientConversation::findTransaction                                      |
------------------------------------------------------------------------------*/
bool IDDEClientConversation :: findTransaction ( const IEvent& evt,
                                                    bool       removeMatch )
{
   IMODTRACE_DEVELOP("DDEClntConv::findTransaction");

#ifdef IC_PM
   PDDESTRUCT pddes = (_DDESTRUCT*)(void*)evt.parameter2();
   IEvent myEvt(clientHandle(),
                (unsigned long)WM_DDE_UNADVISE,
                IEventParameter1((unsigned long)serverHandle()),
                IEventParameter2((void*)pddes));

   IDDEEvent evtInbound(myEvt);
   IString inItem = IString::upperCase(evtInbound.item());
   IString inFormat = IString::upperCase(evtInbound.format());
   IString myItem;
   IString myFormat;
   bool bOK = true;
   bool bFound = false;
   unsigned long ulCount = 0;
   if (removeMatch)
      ulCount = 1;
   IDDETransactionQueue::Cursor myCurs(transactions());
   IDDEClientAcknowledgeEvent* pEvt = 0;
   transactions().semaphor().lock();  // serialize access to the set
   for(myCurs.setToFirst();myCurs.isValid() && (bFound == false)
             && (bOK == true);)
   {
      pEvt = transactions().elementAt(myCurs);
      myItem = IString::upperCase(pEvt->item());
      myFormat = IString::upperCase(pEvt->format());
      if ( ( myItem == inItem ) && ( myFormat == inFormat ) )
         bFound = true;
      else
      {
         ulCount += 1;
         myCurs.setToNext();
         if ( pEvt->transactionType() == WM_DDE_REQUEST )  //mkb, what's this about???
            // quit walking the queue
            bOK = false;
      }
   }  // end for loop
   transactions().semaphor().unlock();
#endif  /* IC_PM */

#ifdef IC_WIN
      // Expect only two possible evt types ACKs and Data
      //
      BOOL      bOK( true );
      BOOL      bFound( false );
      UINT      ulCount(0);
      IDDEClientAcknowledgeEvent* pEvt( 0 );
      if (removeMatch)
         ++ulCount;
      IDDEEvent evtInbound(evt);

      ITRACE_DEVELOP( "DBug: transactions().numberOfElements()="
                    + IString( transactions().numberOfElements()));

      UINT  ackLow, ackHigh(0);
      IString  inItem;
      IDDETransactionQueue::Cursor cursor(transactions());
      transactions().semaphor().lock();  // serialize access to the set
      for(cursor.setToFirst(); cursor.isValid() && bFound == false; )
      {
         pEvt = transactions().elementAt(cursor);
         switch ( pEvt->transactionType())
         {
             case WM_DDE_ADVISE:
             case WM_DDE_POKE:
             case WM_DDE_REQUEST:
             case WM_DDE_UNADVISE:
                if ( evtInbound.item() == "" )
                {
                   evtInbound.loadItem();
                   inItem = IString::upperCase(evtInbound.item());
                }
                bFound = inItem == IString::upperCase(pEvt->item());
                break;
             case WM_DDE_EXECUTE:
                if ( evtInbound.buffer() == "" )
                {
                   try { evtInbound.loadBuffer(); }
                   catch ( IAccessError& error ) { }
                }
                ITRACE_DEVELOP( "DBug: evtInbound.buffer()="
                              + evtInbound.buffer());
                HGLOBAL hCommands = (void *)pEvt->parameter2().asUnsignedLong();
                char FAR *lpCommands = (char FAR *)GlobalLock( hCommands );
                if ( lpCommands != NULL )
                {
                   ITRACE_DEVELOP( "DBug: transaction().Command()=" + IString( lpCommands ));
                   ITRACE_DEVELOP( "DBug: event.buffer()=" + evtInbound.buffer());
                   bFound = evtInbound.buffer() == (const char*)lpCommands;
                   GlobalUnlock( hCommands );
                }
                break;
         } /* endswitch */
         if ( !bFound )
            {
            cursor.setToNext();
            ulCount += 1;
            }
      }
      ITRACE_DEVELOP( "DBug: bFound=" + IString( bFound?"true":"false"));
      transactions().semaphor().unlock();
#endif  /* IC_WIN */

   if (bFound)
   {
      for (unsigned long ulNum = 0;(ulNum < ulCount) && (bOK == true);ulNum++)
      {
         transactions().semaphor().lock();  // serialize access to the set
         pEvt = transactions().firstElement();
         transactions().semaphor().unlock();
         // create a ddestruct, and event to send
#ifdef IC_PM
         PDDESTRUCT pddest = (PDDESTRUCT)buildDDEStruct (pEvt->item(),
                                                         pEvt->format(),
                                                         DDE_FACK,
                                                         0,
                                                         0);
         IEventParameter2 evtprm((void*)pddest);
         IEvent* pmyEvt = new IEvent(evt.handle(),
                                     (unsigned long)WM_DDE_ACK,
                                     evt.parameter1(),
                                     evtprm);
#endif  /* IC_PM */
#ifdef IC_WIN
         // TTD
//mkb         UINT ackBuffer = IDDEInfo__buildDDEAck(IDDEInfo::acknowledge) ;
         UINT ackBuffer = IDDEInfo__buildDDEAck(0);  //shouldn't this be a NACK?

//         HGLOBAL hDdeAck = buildDDEStruct( IDDEAck,
//                                           0,
//                                           IDDEInfo::acknowledge,
//                                           0,
//                                           0);
         // TTD

         bool bAtomAdded;
         ATOM aItem = IDDEInfo__atomFromString( pEvt->item(), &bAtomAdded );
         if ( bAtomAdded )
         {
            itemAtoms().add( aItem );
            ITRACE_DEVELOP("Added atom to item list.");
         }

         IEvent* pmyEvt = new IEvent( evt.handle(),
                                      (unsigned long)WM_DDE_ACK,
                                      evt.parameter1(),
                                      (unsigned long)PackDDElParam(WM_DDE_ACK,
                                                                   ackBuffer,
// TTD                                                                   (UINT)hDdeAck,
                                                                   aItem) );
#endif  /* IC_WIN */
         ITRACE_DEVELOP( "DBug: calling handleAck() to discard a transaction element." );
#ifdef  DEBUG
         Beep(510, 300);Beep(680, 100);Beep(510, 100);
#endif
         handleAck(*pmyEvt);
         delete pmyEvt;
      }
      return true;
   }
   else return false;
}

/*------------------------------------------------------------------------------
| IDDEClientConversation::dispatchEventFromQueue                               |
|                                                                              |
| When threads are used events are queued up. This method dispatches these     |
| events.                                                                      |
------------------------------------------------------------------------------*/
void IDDEClientConversation :: dispatchEventFromQueue ( )
{
   IMODTRACE_DEVELOP("DDEClntConv::dsptchEvtFromQ");

#ifdef IC_PM
   HAB hab = WinInitialize(0);
   REQUESTDATA reqData;
   unsigned long ulSize;
   unsigned long ulRc;
   void* pv;
   IEvent* pEvt;
   BYTE byt;
   IDDEFreeSemaphore safeDtor(ulClSemaphore);
   while (true) {
      ulRc = DosReadQueue(queueHandle(),
                          &reqData,
                          &ulSize,
                          &pv,
                          (unsigned long)0,
                          (unsigned long)0,
                          &byt,
                          (HEV)0);
      if ( ulRc == ERROR_QUE_INVALID_HANDLE )
         break;
      pEvt = (IEvent*)(pv);
      switch (pEvt->eventId())
      {
         case WM_DDE_ACK:
         {
            handleAck(*pEvt);
            break;
         }
         case WM_DDE_DATA:
         {
            handleData(*pEvt);
            break;
         }
         case WM_DDE_TERMINATE:
         {
            handleTerminate(*pEvt);
            break;
         }

      } /* endswitch */
      delete pEvt;
   } /* endwhile */
#endif  /* IC_PM */

#ifdef IC_WIN
   unsigned long ulSize;
   unsigned long ulRc = 0;
   IEvent* pEvt;

   while (true) {
      if ( !ReadFile(hReadPipe, &pEvt, sizeof(IEvent*), &ulSize, NULL))
        { ulRc = GetLastError();
          if ( ulRc == ERROR_BROKEN_PIPE )
            break;
        }

      switch (pEvt->eventId())
      {
         case WM_DDE_ACK:
         {
            handleAck(*pEvt);
            break;
         }
         case WM_DDE_DATA:
         {
            handleData(*pEvt);
            break;
         }
         case WM_DDE_TERMINATE:
         {
            handleTerminate(*pEvt);
            break;
         }

      } /* endswitch */
      delete pEvt;
   } /* endwhile */
   if (hFinish)
      SetEvent(hFinish);
#endif  /* IC_WIN */
}

/*------------------------------------------------------------------------------
| IDDEClientConversation::buildDDEStruct                                       |
------------------------------------------------------------------------------*/
#ifdef IC_PM
void* IDDEClientConversation :: buildDDEStruct ( const char*    itemName,
                                                 const char*    dataFormat,
                                                 unsigned short status,
                                                 const void*    xferData,
                                                 unsigned long  dataLength)
{
   bool bAtomAdded = false;
   void* pStruct = IDDEInfo__buildDDEStruct( itemName,
                                             dataFormat,
                                             status,
                                             xferData,
                                             dataLength,
                                             &bAtomAdded );
   if (bAtomAdded)
   {
      formats().add(((PDDESTRUCT)pStruct)->usFormat);
      ITRACE_DEVELOP("Added atom to format list.");
   }
   return pStruct;
}
#endif  /* IC_PM */

#ifdef IC_WIN
void* IDDEClientConversation :: buildDDEStruct ( int            ddeStructType,
                                                 const char*    dataFormat,
                                                 unsigned short status,
                                                 const void*    xferData,
                                                 unsigned long  dataLength)
{
   bool bAtomAdded = false;
   void* pStruct = IDDEInfo__buildDDEStruct( ddeStructType,
                                             dataFormat,
                                             status,
                                             xferData,
                                             dataLength,
                                             &bAtomAdded );
   return pStruct;
}
#endif  /* IC_WIN */

/*------------------------------------------------------------------------------
| IDDEActiveServer::IDDEActiveServer                                           |
------------------------------------------------------------------------------*/
IDDEActiveServer :: IDDEActiveServer ( const char * appName,
                                       const char * topic,
                                       bool caseSens )
                      : strClApplication(appName),
                        strClTopic(topic),
                        fClCaseSensitive(caseSens)
{ }

/*------------------------------------------------------------------------------
| IDDEActiveServer::~IDDEActiveServer                                          |
------------------------------------------------------------------------------*/
IDDEActiveServer :: ~IDDEActiveServer ( )
{ }



/*------------------------------------------------------------------------------
| IDDEHotLinkXEvent::IDDEHotLinkXEvent                                         |
------------------------------------------------------------------------------*/
IDDEHotLinkXEvent :: IDDEHotLinkXEvent ( IEvent evt )
        : IDDEClientHotLinkEvent(evt),
          fClCloseInPrgrs(0)
{ }

/*------------------------------------------------------------------------------
| IDDEHotLinkXEvent::~IDDEHotLinkXEvent                                        |
------------------------------------------------------------------------------*/
IDDEHotLinkXEvent :: ~IDDEHotLinkXEvent ( )
{ }

/*------------------------------------------------------------------------------
| IDDEClosedConversation::IDDEClosedConversation                               |
------------------------------------------------------------------------------*/
IDDEClosedConversation :: IDDEClosedConversation  (const char * appName,
                                                   const char * topic,
                                                   const IWindowHandle serverId,
                                                   bool userclose )
        : IDDEActiveServer(appName, topic, false), wndhClServer(serverId),
                            fClUsrCls(userclose)
{ }

/*------------------------------------------------------------------------------
| IDDEClosedConversation::~IDDEClosedConversation                              |
------------------------------------------------------------------------------*/
IDDEClosedConversation :: ~IDDEClosedConversation ( )
{ }

/*------------------------------------------------------------------------------
| IDDEClosedConversationSet::IDDEClosedConversationSet                         |
------------------------------------------------------------------------------*/
IDDEClosedConversationSet :: IDDEClosedConversationSet ( )
              : IVPtrSet<IDDEClosedConversation*>(10)
{ }

/*------------------------------------------------------------------------------
| IDDEClosedConversationSet::~IDDEClosedConversationSet                        |
------------------------------------------------------------------------------*/
IDDEClosedConversationSet :: ~IDDEClosedConversationSet ( )
{ }

/*------------------------------------------------------------------------------
| IDDETransactionQueue::IDDETransactionQueue                                   |
------------------------------------------------------------------------------*/
IDDETransactionQueue :: IDDETransactionQueue ( )
     : IVPtrQueue<IDDEClientAcknowledgeEvent*>(5)
{ }

/*------------------------------------------------------------------------------
| IDDETransactionQueue::~IDDETransactionQueue                                  |
------------------------------------------------------------------------------*/
IDDETransactionQueue :: ~IDDETransactionQueue ( )
{ }

IDDEClientHotLinkSet& IDDEClientConversation :: hotLinksForUpdate ( ) const
/*------------------------------------------------------------------------------
| IDDEClientConversation::hotLinksForUpdate                                    |
------------------------------------------------------------------------------*/
{
   return *pHLSetCl;
}

unsigned long IDDEClientConversation :: hotLinkCount ( ) const
/*------------------------------------------------------------------------------
| IDDEClientConversation::hotLinkCount                                         |
------------------------------------------------------------------------------*/
{
   return hotLinksForUpdate().numberOfElements();
}



#endif /* IC_PMWIN  */
