// Revision: 03 1.115 source/ui/baseapp/iwindow1.cpp, basewin, ioc.v400, 990121 
/*******************************************************************************
* FILE NAME: iwindow1.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in iwindow.hpp that are unique to AIX.                                     *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
// d7362 - Increase the priority (to a smaller number) to allow others to
//         use our statics during their static construction/destruction.
// // Priority INT_MIN (-2147483647 - 1) + 1024 + 512
// pragma priority( -2147482112 )
// Priority INT_MIN (-2147483647 - 1) + 1024 + 512 - 20
#pragma priority( -2147482132 )

extern "C"
  {
  #include <iwindefs.h>
  #include <Xm/SashP.h>
  #include <Xm/MainW.h>   // Main window for IFrameWindow
  #include <Xm/RowColumn.h>
  #include <Xm/BulletinB.h>
  #include <Xm/ScrolledW.h>
  #include <Xm/PushB.h>
  #include <Xm/Form.h>
  #include <X11/Core.h>
  #include <X11/IntrinsicP.h>
  #include <X11/CoreP.h>
  #include <X11/CompositeP.h>

  #include <stdlib.h>    // to get arithmetic max function

  #include <canvas.h>
  #include <cnr.h>
  } /* end extern "C" */

#include <icconst.h>

#include <iwindow.hpp>
#include <iapp.hpp>
#include <icolmap.hpp>
#include <icanvas.hpp>
#include <icolor.hpp>
#include <icoordsy.hpp>
#include <icritsec.hpp>
#include <ictlevt.hpp>
#include <iexcept.hpp>
#include <ievent.hpp>
#include <ifont.hpp>
#include <iframe.hpp>
#include <iguilock.hpp>
#include <ihandler.hpp>
#include <ihelp.hpp>
#include <ihelpsta.hpp>
#include <imstring.hpp>
#include <imenubar.hpp>
#include <inotifev.hpp>
#include <iperfset.hpp>
#include <ipoint.hpp>
#include <irect.hpp>
#include <ireslock.hpp>
#include <isizrect.hpp>
#include <istring.hpp>
#include <itrace.hpp>
#include <ithread.hpp>
#include <iwinlsts.hpp>
#include <iwinnhdr.hpp>
#include <iwinpriv.hpp>
#include <imsgtext.hpp>
#include <ixdc.hpp>
#include <iownitem.hpp>
#include <imenuprv.hpp>


// Segment definitions.
#ifdef IC_PAGETUNE
  #define _IWINDOW1_CPP_
  #include <ipagetun.h>
#endif

#ifdef IC_MOTIF
inline void* IQUERYUSERDATA ( IWindowHandle::Value hwnd )
{
  XtPointer valu( 0 );
  XtVaGetValues( hwnd, XmNuserData, &valu, 0 );
  return (void*)valu;
}

inline void ISETUSERDATA( IWindowHandle::Value hwnd, void* valu )
{
  XtVaSetValues( hwnd, XmNuserData, (XtPointer)valu, 0 );
}
#endif

#if 0  // Debug only
class Tracer {
public:
  Tracer() : fnested(0), fnotnested(0) { };
  ~Tracer()
 {
    ITRACE_RUNTIME(IString("Nested dispatches=") + IString(fnested));
    ITRACE_RUNTIME(IString("Not nested dispatches=") + IString(fnotnested));
 };
unsigned fnested;
unsigned fnotnested;
};
static Tracer tracer;
#endif  //Debug only

/*------------------------------------------------------------------------------
| This is a dummy PM style window procedure.                                   |
------------------------------------------------------------------------------*/
extern void* _System _pfnwpICWinProc ( unsigned long, unsigned long,
                                       void*, void* );


/*------------------------------------------------------------------------------
| Convenience function for getting IColor from colormap.                       |
------------------------------------------------------------------------------*/
static IColor getXColor ( Pixel colorArea, Widget w );

/*------------------------------------------------------------------------------
| IWindow::dispatch                                                            |
|                                                                              |
| Dispatch the event. First to the handlers in the list,                       |
| then to handleWindow event, finally returning to Motif so                    |
| any other callbacks for this widget may be called.                           |
------------------------------------------------------------------------------*/
bool IWindow::dispatch(IEvent& evt)

{
  IMODTRACE_ALL("Win::dispatch");

  //---------------------------------------------------------
  // We need to keep track of the top level entry to this
  // function so that we can be sure we have left all nested
  // calls prior to deleted the object on WM_DESTROY.
  //---------------------------------------------------------
  /*---------------------------------------------------------*/
  bool fNested = (pWindowData->state & dispatchInProcess);
  pWindowData->state |= dispatchInProcess;

  bool bStop = false;

  //-----------------------------------------------------------------
  // Message type specific processing.  Handle all message specific
  // processing that must occur before the event is dispatched.
  //-----------------------------------------------------------------
  switch (evt.eventId())
  {
     case xEvent(MapNotify):
         {
           if ( pWindowData->motifState & IWindowPrivateData::neverBeenShown )
           {
             pWindowData->motifState &= ~IWindowPrivateData::neverBeenShown;

             // Set the mouse pointer now if the application set it
             // before the window was realized.
             if ( pWindowData->fMousePtr )
             {
                this->setMousePointer( pWindowData->fMousePtr );
             }
           }
         }
         break;
     case WM_POPUPDESTROY:
         {
           // This message is posted by the menu callback when a popup
           // menu is unmapped and autoDeleteObject is true.  Delete the
           // widget, which will initiate WM_DESTROY.
           if ( XtIsWidget( (Widget)this->hwnd ) )
              XtDestroyWidget( (Widget)this->hwnd );
           bStop = true;               // handled!  Dont destroy owner.
         }
         break;
  } // switch

  //---------------------------------------------------------
  // Dispatch event to Handler.
  //---------------------------------------------------------
  if ( !bStop &&
       pWindowData->handlerList != 0  &&
       this->isHandling( evt.eventId() ) )
  {
      try
      {
         //---------------------------------------------------------
         // Store the handler list in the event.  This is done so that
         // when dispatchRemainingHandlers is called, it will have access
         // to the handler list in which to iterate.
         //---------------------------------------------------------
         evt.setHandlerList(pWindowData->handlerList);
         if (fNested)
         {
             //DEBUG tracer.fnested++;
             //A nested dispatch.  Create a stack cursor object and use it
             //for dispatching the handlers.  The top level cursor position
             //must be preserved.
             IHandlerList::Cursor cursor(*pWindowData->handlerList);
             // Set cursor position to first element and store the cursor
             // in the event.  This is so dispatchRemainingHandlers()
             // will know where to start from.
             cursor.setToFirst();
             evt.setHandlerCursor(&cursor);
             bStop = dispatchRemainingHandlers(evt, false);
         }
         else
         {
             //DEBUG tracer.fnotnested++;
             //Not a nested dispatch.  Use the cursor in the HandlerList
             //object to avoid constructing/destructing the cursor object.

             // Set cursor position to first element and store the cursor
             // in the event.  This is so dispatchRemainingHandlers()
             // will know where to start from.
             pWindowData->handlerList->fcursor.setToFirst();
             evt.setHandlerCursor(&pWindowData->handlerList->fcursor);
             bStop = dispatchRemainingHandlers(evt, false);
         }
      }
      catch (IException &exc)
      {
          // Any exceptions which get to here have not been handled
          // by the handleException() function.  We need to cleanup
          // and get out.
          this->dispatchCleanup( evt, fNested );
          IRETHROW( exc );
      }
  }

   if ((pWindowData->_observerData))
   {
     if (isEnabledForNotification())
     {
       pWindowData->_observerData->notifyHandler->dispatchHandlerEvent(evt);
     }
   }


  //---------------------------------------------------------
  // Decrement the owner levels to control how many levels up the owner
  // chain the event goes.  If there is a possibility that the event may
  // need to go to the owner obtain the owner pointer now...before
  // calling dispatchCleanup which might "delete this" .
  //---------------------------------------------------------
  evt.decrementOwnerLevels();
  IWindow* myOwner(0);
  if (!bStop && evt.passToOwner() )
     myOwner = this->owner();

   // Clean-up before normal termination.
  if ( this->dispatchCleanup( evt, fNested ) )
  {
     bStop = true;
  }
  else if (myOwner)
  {
    //---------------------------------------------------------
    // If appropriate, pass the event to the owner.
    //
    // if the event has the possibility of going up the owner chain call
    // pass event to owner. This will reset the evt.passToOwner value.
    //---------------------------------------------------------
    passEventToOwner( evt );
    if ( evt.passToOwner() )
    {

      if ( myOwner->isValid() )  // owner handle is still valid
      {
        //as in PM, when event arrives at owner it points to owner
        evt.setHandle( myOwner->handle() );
        evt.setDispatchingWindow( myOwner );
        bStop = myOwner->dispatch(evt); // give our owner a chance
      }
    }
  }

  return bStop; // we're done, return to caller
}


/*------------------------------------------------------------------------------
| iwindowXEventCallback                                                        |
|  This function is for X Toolkit Intrinsics EventHandlers                     |
|  which are registered with XtAddEventHandler()                               |
------------------------------------------------------------------------------*/
extern void _System iwindowXEventCallback(
    Widget    handle,
    XtPointer client_data,
    XEvent    *event,
    ::Boolean *continue_to_dispatch )

{
  IMODTRACE_ALL("IWindow::iwindowXEventCallback");

  if( handle->core.being_destroyed )
  {
    *continue_to_dispatch = False; 
    return;
  }

  *continue_to_dispatch = True; // allow other Xt handlers to handle
                                // this event.


  // most events should not be propagate up the owner chain.
  bool passToOwner = false;
  int howFar = -1;

  ITRACE_ALL( IString("client_data = ")+
              IString( (unsigned long)client_data ).d2x() );

  // Retrieve the IWindow associated with the handle (Widget ID )
  IWindow *pwin = (IWindow *) client_data;
  if ( pwin != 0 )
  {

    /*-----------------------------------------------------------------
        The general mapping of Xt event registration events
        to IEvents is the      following:
          handle - the widget parameter on the callback
          eventid      - the type of XEvent
          parameter1 - NULL
          parameter2 - XEvent * from callback
        An exception to this is when the type of event is
        ClientMessage and the message_type atom = ICLUI_MESSAGE.
        In this case eventid, parameter1, and parameter2 are set
        equal to data.l[0], data.l[1], and data.l[2], respectively.
        The field data.l[3] is set to the event result after event dispatch.
     -----------------------------------------------------------------*/
    bool  isICLUIMessage = false;
    unsigned long   eventID = event->xany.type + xEventOffset;
    unsigned long   parm1   = 0;
    unsigned long   parm2   = (unsigned long) event;


    switch (event->xany.type)
    {
      case ClientMessage:
      {
        Display *display = XtDisplay(handle);
        Atom   msgAtom  = XInternAtom(display, ICLUI_MESSAGE, FALSE);
        Atom   msgAtom2 = XInternAtom(display, ICLUI_WMDELETE, FALSE);
        if (event->xclient.message_type == msgAtom)
        {
          eventID      = event->xclient.data.l[0];
          parm1        = event->xclient.data.l[1];
          parm2        = event->xclient.data.l[2];
          isICLUIMessage = true;
          switch (eventID)
          {
            case WM_CONTROL:
              passToOwner = true;
              howFar = 2;
              break;
            case WM_HELP:
              passToOwner = true;
              howFar = -1;
              break;
            case WM_SYSCOMMAND:
            case WM_COMMAND:
              // Don't propagate messages with special IOC flag.
              if ( !(parm2 & 0x8000) )
                 passToOwner = true;
              howFar = -1;
              break;
            case IC_UM_SIZE:
            {
              IRectangle oldRect( IPoint( pwin->pWindowData->oldX,
                                           pwin->pWindowData->oldY ),
                                   ISize ( pwin->pWindowData->oldWidth,
                                           pwin->pWindowData->oldHeight ));
              IRectangle newRect = pwin->rect();
              ISizeRectangle* sizeRect =
                  new ISizeRectangle( oldRect, newRect );
              parm1 = (unsigned long) sizeRect;
              parm2 = (unsigned long) event;
            }
            break;

            case IC_UM_GENERATE_PAINT:
            {

              // if I got this message then it means that someone called refresh
              // and did not want an immediated update. This message was posted so
              // that we check at a later time for an invalidated region. If we have
              // one then post a IC_UM_PAINT message for our paint handlers. This
              /// message is internal use only, do not bother dispatching it to
              // our handlers.
              if (pwin->pWindowData->fInvalidatedRegion != IRegionHandle() )
              {
                pwin->postEvent( IC_UM_PAINT,
                                 0,
                                 0 );
              }
              return;
            }
            break;

            case IC_UM_CR_DECREMENT:
            case IC_UM_CR_INCREMENT:
            case IC_UM_CRPAGE_DECREMENT:
            case IC_UM_CRPAGE_INCREMENT:
            {
              passToOwner = true;
              howFar = -1;
            }
            break;
          }
        }
        else if (event->xclient.data.l[0] == msgAtom2)
        {
          eventID = WM_SYSCOMMAND;
          parm1   = SC_CLOSE;
        }
      break;
      }
      case ConfigureNotify:
      case ConfigureRequest:
      {
        // We need the sizeRectangle so the handlers can decide if a move OR
        // a size change has occurred. We used to try to make that decision here
        // but had to make a choice of whether it was a move or a resizing.
        IRectangle oldRect( IPoint( pwin->pWindowData->oldX,
                                    pwin->pWindowData->oldY),
                            ISize ( pwin->pWindowData->oldWidth,
                                    pwin->pWindowData->oldHeight ));

        Dimension y = event->xconfigure.y;
        if ( ICoordinateSystem::applicationOrientation() !=
               ICoordinateSystem::nativeOrientation() )
        {
          ISize parentSize = pwin->pWindowData->parentSize(pwin);
          y = parentSize.height() -
            event->xconfigure.y - pwin->size().height();
        }
        IRectangle newRect( IPoint(event->xconfigure.x,y),
                            ISize(event->xconfigure.width +
                                2 * event->xconfigure.border_width,
                              event->xconfigure.height  +
                                2*event->xconfigure.border_width));

        ISizeRectangle* sizeRect = new ISizeRectangle( oldRect, newRect );
        parm1 = (unsigned long) sizeRect;
        parm2 = (unsigned long) event;
        break;
      }
      case MapNotify:
      {
        // undocumented but used inside the class libraries.
        parm1   = (pwin->pWindowData->motifState &
                      IWindowPrivateData::neverBeenShown ) ?
                    true : false;
        parm2   = (unsigned long)event;
        // if never been shown then add a WM_SIZE message here!!!
        break;
      }
      case NoExpose:
      {
        // No one wants these events (at this time), they are so frequent
        // when an entry field has focus that they are a performance problem,
        // and we can't shut them off in X. Solution is to not create an
        // IEvent object for them nor dispatch them. Return now.
        return;
        break;
      }
      case Expose:
      {
        if (pwin->pWindowData->fInvalidatedRegion == IRegionHandle())
        {
          pwin->pWindowData->fInvalidatedRegion =
            IRegionHandle( XCreateRegion() );
        }
        // build up the invalidated region. This can be retrieved by a call to
        // IWindow::invalidatedRect or IWindow::invalidatedRegion;
        XtAddExposureToRegion(
          event,
          (Region)(void *)pwin->pWindowData->fInvalidatedRegion.asUnsigned() );
        break;
      }
      case FocusIn:
      case FocusOut:
      {
        switch (event->xfocus.detail)
        {
          case NotifyAncestor:
          case NotifyInferior:
          case NotifyNonlinear:
          {
            // X generates focus events to the entire window hierarchy affected
            // by a focus change.  In the interest of portability and
            // performance, we generate IEvents only for the widget which is
            // actually gaining or losing focus.  The detail values used in
            // this "case" are the only ones which indicate a change to this
            // widget, as opposed to its ancestors or inferiors.
            // In addition, we filter the notifications so that only an event
            // that indicates a change of state is propagated as an IEvent.
            // Several places in IOC (IFocusHandler, notification handlers, etc)
            // rely upon this filtering.
            if (event->xany.type == FocusOut)
            {
              if (pwin->pWindowData->motifState & IWindowPrivateData::hasFocus)
              {  // Focus lost by this widget. Set local indicator.
                pwin->pWindowData->motifState &= ~IWindowPrivateData::hasFocus;
              }
              else
              {  // Redundant notification.
                return;
              }
            }
            else  // (event->xclient.type == FocusIn)
            {
              if ( !(pwin->pWindowData->motifState & IWindowPrivateData::hasFocus) )
              {  // Focus gained by this widget. Set local indicator.
                pwin->pWindowData->motifState |= IWindowPrivateData::hasFocus;  //turn on
              }
              else
              {  // Redundant notification.
                return;
              }
            }
          }
          break;

          default:
            return;      // return now, so we don't create extraneous IEvents
          break;
        } // end switch

        // Montana needs this message to go all the way up the owner chain.
        passToOwner = true;
        howFar = -1;

      }
      break;

      default:
      break;
    }   //end switch .type

    ITRACE_ALL(IString("pwin->handle=") +
               IString( pwin->handle().asUnsigned() ).d2x() +
               IString(" eventID=") + IString( eventID ).d2x() +
               IString(" handle=") + IString( (unsigned)handle ).d2x() );
    // Construct an IEvent from the system data.
    IEvent evt( pwin,
                eventID,
                parm1,
                parm2);

    // set the event propagation
    evt.setPassToOwner( passToOwner );
    evt.setNumberOfLevels( howFar );

    // Dispatch the window's event handler
    pwin->dispatch( evt );

    // set result in ICLUI generated events
    if (isICLUIMessage)
    {
      event->xclient.data.l[3] = evt.result();
      switch (eventID)
      {
        case IC_UM_SIZE:
        {
          IRectangle oldRect = pwin->rect();
          pwin->pWindowData->oldHeight = oldRect.height();
          pwin->pWindowData->oldWidth  = oldRect.width();
          pwin->pWindowData->oldX      = oldRect.minXMinY().x();
          pwin->pWindowData->oldY      = oldRect.minXMinY().y();
          ISizeRectangle *sizeRect = (ISizeRectangle *) parm1;
          delete sizeRect;
        }
        break;

        case IC_UM_PAINT:
        {
          if (pwin->pWindowData->fInvalidatedRegion != IRegionHandle() )
          {
            // on our internal refreshes we need to make them go recursive.
            IWindow::ChildCursor cursor( *pwin );

            // Enumerate all child windows.
            for ( cursor.setToFirst(); cursor.isValid(); cursor.setToNext() )
            {
              // Get the IWindow object for each child found
              IWindowHandle hwndChild = pwin->childAt( cursor );
              IWindow* pwndChild = IWindow::windowWithHandle( hwndChild );
              {
                if (pwndChild)
                {
                  IRectangle fChildRect = ICoordinateSystem::convertToNative(
                                        pwndChild->rect(),
                                        pwin->parentSize());
                  if ( XRectInRegion( (Region)
                        pwin->pWindowData->fInvalidatedRegion.asUnsigned(),
                                      fChildRect.minX(),
                                      fChildRect.minY(),
                                      fChildRect.width(),
                                      fChildRect.height() ) )
                  {
                    pwndChild->refresh(IWindow::paintAllImmediate);
                  }
                }
              }
            }
            XDestroyRegion( (Region)(void *)pwin->pWindowData->fInvalidatedRegion );
            // and free it
            pwin->pWindowData->fInvalidatedRegion = IRegionHandle();
          }
        }
        break;
      }
    }
    else
    {
      switch (event->xany.type)
      {
        case ConfigureNotify:
        {
          // Only save the old width on a configureNotify, not a configureRequest
          // The configureRequest comes first.
          // Save copy of "old" width/height so we
          // can tell later (during next ConfigureNotify) we were actually resized.
          pwin->pWindowData->oldHeight = event->xconfigure.height
                + ( 2 * event->xconfigure.border_width);   //save old height
          pwin->pWindowData->oldWidth = event->xconfigure.width
                + ( 2 * event->xconfigure.border_width);   //save old width
          pwin->pWindowData->oldX = event->xconfigure.x;       // save old x
          if ( ICoordinateSystem::applicationOrientation() !=
                 ICoordinateSystem::nativeOrientation() )
          {
            ISize parentSize = pwin->pWindowData->parentSize(pwin);
            pwin->pWindowData->oldY = parentSize.height() -      // save old y
              event->xconfigure.y - pwin->size().height();
          }
          else
          {
            pwin->pWindowData->oldY = event->xconfigure.y;
          }
          ISizeRectangle *sizeRect = (ISizeRectangle *) parm1;
          delete sizeRect;
          break;
        }
        case ConfigureRequest:
        {
          ISizeRectangle *sizeRect = (ISizeRectangle *) parm1;
          delete sizeRect;
          break;
        }
        case MapNotify:
        {
          // once the map notify has been dispatched set the realize flag
          // in motifState. This flag is used by realPosition to determine
          // whether to use the stored value or actually go to the widget.
          pwin->pWindowData->motifState |= IWindowPrivateData::realized;
          // the map notify has been dispatched, now we need to send the
          // IC_UM_SIZE before we can respond to a configure notify.
          pwin->sendEvent( IC_UM_SIZE,
                           (unsigned long) 0,
                           (unsigned long) 0 );
          break;
        }
        case Expose:
        {
          if (event->xexpose.count == 0)
          {
            if (pwin->pWindowData->fInvalidatedRegion != IRegionHandle() )
            {
              // when the expose count goes to 0 we no longer need the region, so
              // free it up.
              XDestroyRegion(
                (Region)(void *) pwin->pWindowData->fInvalidatedRegion.asUnsigned());
              pwin->pWindowData->fInvalidatedRegion = IRegionHandle();
            }
          }
          break;
        }
      } /* end switch */
    }
  }    // if pwin

} // end iwindowXEventCallback()


/*------------------------------------------------------------------------------
| iwindowMotifCallback                                                         |
| This function is for Motif callbacks that are registered with XtAddCallback()|
------------------------------------------------------------------------------*/
extern void _System iwindowMotifCallback(
               Widget handle,
               XtPointer client_data,
               XtPointer call_data)
{
  IMODTRACE_ALL("IWindow::iwindowMotifCallback");

  // Obtain the IWindow corresponding to widget "handle", which we
  // placed in the widget's client data when we registered the callback.
  IWindow* pwin = (IWindow *) client_data;

   /*-----------------------------------------------------------------
      The general mapping of Motif callback parameters
      to IEvents is the following:
        handle - the widget parameter on the callback
        eventid - the reason of the callback
        parameter1 - the call_data parameter ... typically the
                     callback structure pointer
        parameter2 - XEvent * from callback
   -----------------------------------------------------------------*/
  if ( pwin != 0 )
  {
    XmAnyCallbackStruct *motifEventData = (XmAnyCallbackStruct*) call_data;
    unsigned long eventID = motifEventData->reason + motifEventOffset;
    unsigned long parm1   = (unsigned long) call_data;
    unsigned long parm2   = (unsigned long) motifEventData->event;

    ITRACE_ALL(IString("pwin->handle=") +
               IString( pwin->handle().asUnsigned() ).d2x() +
               IString(" eventID=") + IString( eventID ).d2x() +
               IString(" handle=") + IString( (unsigned)handle ).d2x() );

    // Construct an IEvent from the system data.
    IEvent evt( pwin,
                eventID,
                parm1,
                parm2);

    // In general, we are going to let motif events go up the owner chain
    evt.setPassToOwner( true );

    // Dispatch the window's event handler
    if ( pwin->dispatch( evt ) == true )
    {
      return;
    }
  }    // if pwin

} // end iwindowMotifCallback()

/*------------------------------------------------------------------------------
|  iwindowSashCallback                                                         |
|                                                                              |
|  The Sash widgets callbacks are registered with XtAddCallbacks. The Sash     |
|  call back needs a special callback because the callback struct does not     |
|  match the XmAnyCallbackStruct.                                              |
------------------------------------------------------------------------------*/
extern void _System iwindowSashCallback(
               Widget handle,
               XtPointer client_data,
               XtPointer call_data)
{
  IMODTRACE_ALL("IWindow::iwindowSashCallback");

  // Obtain the IWindow corresponding to widget "handle", which we
  // placed in the widget's client data when we registered the callback.
  IWindow* pwin = (IWindow *) client_data;

  if ( pwin != 0 )
  {
    SashCallDataRec *sashCallData = (SashCallDataRec*) call_data;
    // Note: XEvent type is selected because the event type is used for
    // the event id.
    unsigned long eventID = sashCallData->event->type + xEventOffset;
    unsigned long parm1   = (unsigned long) call_data;
    unsigned long parm2   = (unsigned long) sashCallData->event;

    ITRACE_ALL(IString("pwin->handle=") +
               IString( pwin->handle().asUnsigned() ).d2x() +
               IString(" eventID=") + IString( eventID ).d2x() +
               IString(" handle=") + IString( (unsigned)handle ).d2x() );

    // Construct an IEvent from the system data.
    IEvent evt( pwin,
                eventID,
                parm1,
                parm2);

    // This event should not progagate up the owner chain
    evt.setPassToOwner( false );

    // Dispatch the window's event handler
    if ( pwin->dispatch( evt ) != false )
    {
      return;
    }
  }    // if pwin
} // end iwindowSashCallback()

/*------------------------------------------------------------------------------
| iwindowDestroyCallback                                                       |
|  iwindowDestroyCallback is for the Motif XmNdestroyCallback. We use it       |
|  internally to know when one of "our" widgets is being destroyed. This       |
|  results in a special IEvent being created, which then flows thru the system.|
|  This callback is added and removed in the same places that widget handles   |
|  are added, changed and removed from IWindow objects; in this way, "our"     |
|  widgets are watched but "other" widgets are not (in those places where the  |
|  widget itself is being destroyed, we of course don't bother to remove the   |
|  callback).                                                                  |
------------------------------------------------------------------------------*/
extern void _System iwindowDestroyCallback(
               Widget handle,
               XtPointer client_data,
               XtPointer call_data)
{
  IMODTRACE_ALL("IWindow::iwindowDestroyCallback");

  // Obtain the IWindow corresponding to widget "handle", but don't use the value
  // placed in the widget's client data when we registered the callback. For the
  // destroy callback, this value could be bogus by now. Check our IWindowList only.
  IWindow* pwin = IWindow::windowWithHandle( handle );

  /*-----------------------------------------------------------------
     The destroy callback has no call_data parameters nor a reason code.
     So, we create an IEvent as follows:
       handle - the widget parameter on the callback
       eventid - WM_DESTROY, which is our own private "reason code" modeled after PM
       parameter1 - null
       parameter2 - null
  -----------------------------------------------------------------*/
  unsigned long eventID = WM_DESTROY;
  unsigned long parm1   = 0UL;
  unsigned long parm2   = 0UL;

  if ( pwin != 0 )
  {
    ITRACE_ALL(IString("pwin->handle=") +
               IString( pwin->handle().asUnsigned() ).d2x() +
               IString(" eventID=") + IString( eventID ).d2x() +
               IString(" handle=") + IString( (unsigned)handle ).d2x() );

    // Construct an IEvent from the system data.
    IEvent evt( pwin,
                eventID,
                parm1,
                parm2);

    // This event should not go up the owner chain
    evt.setPassToOwner( false );

    // Dispatch the window's event handler
    if ( pwin->dispatch( evt ) != false )
    {
      return;
    }
  } // if pwin

  return;

} // end iwindowDestroyCallback()


/*------------------------------------------------------------------------------
| IWindow::isValid                                                             |
|                                                                              |
| Is window valid?                                                             |
------------------------------------------------------------------------------*/
bool IWindow::isValid ( ) const
{
  if ( !(pWindowData->motifState & IWindowPrivateData::checkedValidity) )
  {
    //---------------------------------------------------
    // First check to see that the window handle (Widget)
    // is not NULL
    //---------------------------------------------------
    if ( this->hwnd != 0 )
    {
      //------------------------------------------------
      // All valid widgets are subclassed from the CORE
      // widget class.
      //------------------------------------------------
      pWindowData->motifState |= IWindowPrivateData::checkedValidity;
      if ( XtIsWidget( (Widget)this->hwnd ))
        pWindowData->motifState |= IWindowPrivateData::handleValid;
    }
  } // endif

  return (pWindowData->motifState &
          IWindowPrivateData::handleValid) ? true : false;
}

/*------------------------------------------------------------------------------
| IWindow::presSpace                                                           |
|                                                                              |
| Grab the window cache presentation space, a.k.a. graphics context.           |
------------------------------------------------------------------------------*/
IPresSpaceHandle
IWindow::presSpace ( ) const
{
    // no exception required b'cos handle() check for valid
    // window handle
    
    IMODTRACE_DEVELOP("IWindow::presSpace");
    // Note: PS should be released for performance.  Reference counting
    // in IPresSpaceHandle/IXDC takes care of this.
    
    if ((IPresSpaceHandle::Value)pWindowData->gc == 0)
    {
        Widget widget = handle();
        Display* display = XtDisplay(widget);
        Drawable drawable = XtWindow(widget);
        
        // if the widget is not realized (drawable == 0), use the RootWindow's
        // drawable to determine the graphic context.

        if (drawable && this != IWindow::desktopWindow()) {
            IXDC *fXDC = new IXDC(display, drawable);
            GC gc = fXDC->gc();
            
            if (pWindowData->ulStyle & WS_CLIPCHILDREN) {
                XSetSubwindowMode(display, gc, ClipByChildren);
            } else {
                XSetSubwindowMode(display, gc, IncludeInferiors);
            }
            pWindowData->gc = IPresSpaceHandle(fXDC);
        } else {
            pWindowData->gc = IPresSpaceHandle(
                new IXDC(display, RootWindow(display, DefaultScreen(display)) ) );
        }
        
        if ( (IPresSpaceHandle::Value)pWindowData->gc == 0 )
            ITHROWGUIERROR("IXDC");
    }
    
    pWindowData->gcUseCount++;
    return pWindowData->gc;
}

/*------------------------------------------------------------------------------
| IWindow::releasePresSpace                                                    |
|                                                                              |
| Release the window cache presentation space, a.k.a. graphics context         |
------------------------------------------------------------------------------*/
void IWindow::releasePresSpace ( const IPresSpaceHandle& gc ) const
{
  IMODTRACE_DEVELOP("IWindow::releasePresSpace");

  pWindowData->gcUseCount--;
  if ( ((IPresSpaceHandle::Value)pWindowData->gc != 0) &&
       (pWindowData->gcUseCount == 0)   )
  {
    pWindowData->gc = IPresSpaceHandle();
  }
}

/*------------------------------------------------------------------------------
| IWindow::show                                                                |
|                                                                              |
| Make the window visible.                                                     |
------------------------------------------------------------------------------*/
IWindow& IWindow::show ( bool bShow )
{
  IMODTRACE_ALL("Win::show");
  // We need to check to determine if the parent of the widget we
  // propose to manage is a composite.

  Widget w = handle();  // This checks validity and possibly throws exception.

  if (bShow)
  {
    XtVaSetValues( w,
                   XmNmappedWhenManaged, true,
                   NULL );
    if (XtIsManaged(w) && XtIsRealized(w))
    {
        XtMapWidget( w );
        // It appears that all windows below this widget get destroyed so we need
        // to walk down the heirarchy and remap the windows.
    }
    pWindowData->motifState |= IWindowPrivateData::visible;
    this->notifyObservers(INotificationEvent(
        IWindow::visibleId, *this, true, true));
  }
  else
  {
      // If the widget has not been realized yet, then set the mapped when
      // managed resource.
      XtVaSetValues( w,
                     XmNmappedWhenManaged, false,
                     NULL );
      
    if (XtIsManaged(w) && XtIsRealized(w))
          XtUnmapWidget( w );
      
      pWindowData->motifState &= ~IWindowPrivateData::visible;
      this->notifyObservers(INotificationEvent(
          IWindow::visibleId, *this, true, false));
  }
  return *this;
  // no exception required because handle() check for valid
  // window handle
}

/*------------------------------------------------------------------------------
| IWindow::isVisible                                                           |
------------------------------------------------------------------------------*/
bool IWindow::isVisible ( ) const
{
  // NOTE, make sure this function is in sync with IWindow::show()

  // the mapped when manage bit is used to keep track of whether the window is
  // visible or not. If all the windows up to the frame are visible then this
  // window is visible.
  ::Boolean mapIt;
  // now check all the windows up to the frame.
  for ( IWindow *win = (IWindow *) this; win; win=win->parent())
  {
    XtVaGetValues( win->handle(),
                   XmNmappedWhenManaged, &mapIt,
                   NULL );
    if ( !mapIt )
      return false;
    if ( win->isFrameWindow() )
      break;
  }
  return true;
}

/*------------------------------------------------------------------------------
| IWindow::setFocus                                                            |
|                                                                              |
| Make the window the focus window.                                            |
------------------------------------------------------------------------------*/
IWindow& IWindow::setFocus ( )
{
  IMODTRACE_DEVELOP("IWindow::setFocus");

  if ( isVisible() )
  {
    // Before we can use XmProcessTraversal we need to make sure that the
    // right topLevelShell has focus.
    int revert = RevertToNone;
    Window curFocusWindow;

    XGetInputFocus( XtDisplay( (Widget) handle() ),
                    &curFocusWindow,
                    &revert );

    Widget curFocusWidget = XtWindowToWidget(
                                       XtDisplay( (Widget) handle() ),
                                       curFocusWindow );

    Widget curTopLevel = curFocusWidget;
    while ( curTopLevel && !XtIsTopLevelShell( curTopLevel ) )
      curTopLevel = XtParent( curTopLevel ) ;

    Widget newTopLevel = (Widget) handle();
    while ( newTopLevel && !XtIsTopLevelShell( newTopLevel ) )
      newTopLevel = XtParent( newTopLevel ) ;

    if ( newTopLevel != curTopLevel )
      XSetInputFocus( XtDisplay( newTopLevel ),
                     XtWindow( newTopLevel ),
                     RevertToNone,
                     CurrentTime );


    //=========================================================
    // XmProcessTraversal determines which component receives
    // keyboard events when a widget has focus.
    //=========================================================
    XmProcessTraversal( (Widget) handle(),
                        XmTRAVERSE_CURRENT );
  }  // endif

  if ( !this->isFrameWindow() )
  {
    Widget focusWidget = (Widget) this->handle();
    Widget parentWidget = XtParent(focusWidget);
    while ( parentWidget && !XmIsManager( parentWidget ) )
    {
       parentWidget = XtParent(parentWidget);
    }  // * while * //
    if (parentWidget )
    {
      IWindow *win = IWindow::windowWithHandle( parentWidget);
      if (win)
      {
        XtVaSetValues (XtParent( (Widget) win->handleForChildCreation()),
                        XmNinitialFocus, focusWidget,
                        NULL);
      }
    }
  }

  return *this;
  // no exception required because handle() check for valid
  // window handle
}

/*------------------------------------------------------------------------------
| IWindow::hasFocus                                                            |
|                                                                              |
| Is the window the focus window?                                              |
------------------------------------------------------------------------------*/
bool IWindow::hasFocus ( ) const
{
  // if our topLevelShell does not have focus then we can't have focus.
  int revert = RevertToNone;
  Window curFocusWindow;

  XGetInputFocus( XtDisplay( (Widget) handle() ),
                  &curFocusWindow,
                  &revert );

  Widget curFocusWidget = XtWindowToWidget(
                                     XtDisplay( (Widget) handle() ),
                                     curFocusWindow );

  Widget curTopLevel = curFocusWidget;
  while ( curTopLevel && !XtIsTopLevelShell( curTopLevel ) )
    curTopLevel = XtParent( curTopLevel ) ;

  Widget newTopLevel = (Widget) handle();
  while ( newTopLevel && !XtIsTopLevelShell( newTopLevel ) )
    newTopLevel = XtParent( newTopLevel ) ;

  if ( newTopLevel != curTopLevel )
    return false;

  /* Since XmGetFocusWidget on a XmContainer handle returns the XmIconG
   * widget, and since XmGetFocusWidget seems to ALWAYS return the
   * XmIconG widget if hasFocus is called while in IFocusHandler,
   * for XmContainer we use the IWindowPrivateData::hasFocus state which
   * is set by iwindowXEventCallback.
   */
  if ( XmIsContainer( (Widget) handle() ) )
  {
    if (this->pWindowData->motifState & IWindowPrivateData::hasFocus)
      return true;
    else
      return false;
  }
  else
  {
    Widget windowInFocus = XmGetFocusWidget( (Widget) handle() );
    if ( windowInFocus == (Widget) handle() )
      return true;
    else
      return false;
  }
}

/*------------------------------------------------------------------------------
| IWindow::enable                                                              |
|                                                                              |
| Enable the object to accept input.                                           |
------------------------------------------------------------------------------*/
IWindow& IWindow::enable ( bool bEnable )
{
  // First check to see if we need to do anything.  If not, return.
  // - This also has the desired effect of NOT sending redundant
  //   "enable" notification event
  if ( bEnable && isEnabled() )
     return *this;
  else if ( !bEnable && !isEnabled() )
     return *this;

  // Setting sensitivity on the top handle is necessary for our composite
  // controls.  This should handle all cases even scrolled windows since
  // sensitivity is inherited.  However, there is a problem with
  // setting sensitivity on the scrolled window parent; the children
  // get/lose sensitivity but do not gray out when insensitive
  // unless the sensitivity of the area widget is changed directly.

  XtSetSensitive( (Widget) handle(), bEnable);

  this->notifyObservers(INotificationEvent(
    IWindow::enableId, *this, true, (void*)(bEnable)) );
  return *this;
   // no exception required because handle() check for valid
   // window handle
}

/*-----------------------------------------------------------------------------|
| IWindow::isEnabled                                                           |
|                                                                              |
| Is the object enabled?                                                       |
------------------------------------------------------------------------------*/
bool IWindow::isEnabled ( ) const
{
  return ( XtIsSensitive( (Widget) handle() ));
   // no exception required because handle() checks for valid
   // window handle
}

/*------------------------------------------------------------------------------
| IWindow::refresh                                                             |
|                                                                              |
| Redraw the entire window.                                                    |
------------------------------------------------------------------------------*/
IWindow& IWindow::refresh ( RefreshType typeOfRefresh )
{
  IMODTRACE_ALL("Win::refresh");

  // invalidate the entire window.
  IRectangle fRect( rect() );
  fRect = ICoordinateSystem::convertToNative( fRect,
                                              parentSize() );

  // if the rect has size and width
  if (fRect.width() && fRect.height() )
  {
    if (pWindowData->fInvalidatedRegion == IRegionHandle() )
    {
      // if we don't already have a region and an immediate update is requested
      // then we should just return.
      if (typeOfRefresh == IWindow::immediate )
      {
        return *this;
      }
      // create the invalidated region
      pWindowData->fInvalidatedRegion = IRegionHandle( XCreateRegion() );
    }


    XRectangle fXInvalidatedRect;
    fXInvalidatedRect.x      = 0;
    fXInvalidatedRect.y      = 0;
    fXInvalidatedRect.width  = fRect.width();
    fXInvalidatedRect.height = fRect.height();
    XUnionRectWithRegion( &fXInvalidatedRect,
             (Region)(void *)pWindowData->fInvalidatedRegion,
             (Region)(void *)pWindowData->fInvalidatedRegion );

#if 0
    // not convinced yet that we should be refreshing the widget. I left the code
    // here so it will be known how.

    // call the redisplay member of the widget.
    Widget w = (Widget) handle();
    XExposeEvent anEvent;
    anEvent.type = Expose;
    anEvent.send_event = False;
    anEvent.display = XtDisplay( w );
    anEvent.window = XtWindow( w );
    anEvent.x = fXInvalidatedRect.x;
    anEvent.y = fXInvalidatedRect.x;
    anEvent.width = fXInvalidatedRect.width;
    anEvent.height = fXInvalidatedRect.height;
    anEvent.count = 0;
    (w->core.widget_class->core_class.expose)
         (w, (XEvent *)&anEvent, (Region)(void *)pWindowData->fInvalidatedRegion);
#endif
    if ((typeOfRefresh == IWindow::immediate) ||
         typeOfRefresh == IWindow::paintAllImmediate )
    {
      this->sendEvent( IC_UM_PAINT,
                       0,
                       0 );
      // IHandle::sendEvent will delete the region and reset fInvalidatedRegion to null

    }
    else
    {
      // keep building the region until someone asks for an immediate update
      // or an expose message is generated
      // post this message so that we check at a later time to see if a
      // IC_UM_PAINT needs to be generated.
      this->postEvent( IC_UM_GENERATE_PAINT,
                       0,
                       0 );
    }
  }
  // The following code is used to refresh the frame if an extension has been refreshed. This
  // important when a toolbar is hidden and then shown for example.
  IWindow *fFrame( 0 );
  if (this->isFrameWindow() )
  {
    fFrame = this;
  }
  else
  {
    // if this is not a frame then check parent. That is as far as we will go for now.
    if (parent() && parent()->isFrameWindow() )
    {
      fFrame = parent();
    }
  }

  // if we found a frame then request and update. This will reposition extensions and the client.
  if (fFrame && fFrame->isShowing() )
  {
    fFrame->postEvent( IC_UM_UPDATEFRAME );
  }

  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::refresh                                                             |
|                                                                              |
| Redraw a specific window rect.                                               |
------------------------------------------------------------------------------*/
IWindow& IWindow::refresh ( const IRectangle& rectArea, bool immediate )
{
  IMODTRACE_DEVELOP("Win::refresh(rectArea, imm)");

  IRectangle fRect = ICoordinateSystem::convertToNative(
                             rectArea,
                             size() );

  if (fRect.width() && fRect.height() )
  {
    // the invalidated region will be cleared after the event has been sent. If
    // we don't have a region then send it.
    if ( pWindowData->fInvalidatedRegion == IRegionHandle() )
    {
      pWindowData->fInvalidatedRegion = IRegionHandle( XCreateRegion() );
    }

    XRectangle fXInvalidatedRect;
    fXInvalidatedRect.x      = fRect.minX();
    fXInvalidatedRect.y      = fRect.minY();
    fXInvalidatedRect.width  = fRect.width();
    fXInvalidatedRect.height = fRect.height();
    XUnionRectWithRegion( &fXInvalidatedRect,
             (Region)(void *)this->pWindowData->fInvalidatedRegion,
             (Region)(void *)this->pWindowData->fInvalidatedRegion );

#if 0
    // call the redisplay member of the widget.
    Widget w = (Widget) handle();
    XExposeEvent anEvent;
    anEvent.type = Expose;
    anEvent.send_event = False;
    anEvent.display = XtDisplay( w );
    anEvent.window = XtWindow( w );
    anEvent.x = fXInvalidatedRect.x;
    anEvent.y = fXInvalidatedRect.x;
    anEvent.width = fXInvalidatedRect.width;
    anEvent.height = fXInvalidatedRect.height;
    anEvent.count = 0;
    (w->core.widget_class->core_class.expose)
         (w, (XEvent *)&anEvent, (Region)(void *)pWindowData->fInvalidatedRegion);
#endif

    if ( immediate )
    {
      this->sendEvent( IC_UM_PAINT,
                       0,
                       0 );
    }
    else
    {
      // keep building the region until someone asks for an immediate update
      // or an expose message is generated
      // post this message so that we check at a later time to see if a
      // IC_UM_PAINT needs to be generated.
      this->postEvent( IC_UM_GENERATE_PAINT,
                       0,
                       0);
    }
  }
  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::setStyle                                                            |
------------------------------------------------------------------------------*/
IWindow& IWindow::setStyle ( unsigned long flStyle )
{
  // Save the style, we can use it to determine grouping.
  this->pWindowData->ulStyle = flStyle;

  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::convertToArgList                                                    |
|                                                                              |
| Returns arg list for the styles that are requested.                          |
| extended flag (bExtOnly) is set.                                             |
------------------------------------------------------------------------------*/
IArgList IWindow::convertToArgList ( const IBitFlag& style ) const
{
  IArgList theArgList;

  IWindow::Style& bitStyle = (IWindow::Style &) style;

  if (bitStyle & IWindow::visible)
    theArgList.setResource( XmNmappedWhenManaged, true );
  else
    theArgList.setResource( XmNmappedWhenManaged, false );

  // Check for IWindow bidi styles.
  // Note that this code really belongs in
  // IWindow::create(...,const IBitFlag&,...), but it is here
  // for now because not all derived classes call that new
  // version of IWindow::create.
  if ( bitStyle & IWindow::rightToLeft )
  {
     pWindowData->fWindowDirection =
                    IWindowPrivateData::kRightToLeft;
  }
  else if ( bitStyle & IWindow::leftToRight )
  {
     pWindowData->fWindowDirection =
                    IWindowPrivateData::kLeftToRight;
  }
  else
  {
     pWindowData->fWindowDirection =
                    IWindowPrivateData::kDefaultDirection;
  }

  return theArgList;
}

/*------------------------------------------------------------------------------
| IWindow::create                                                              |
|                                                                              |
| Call the presentation system to create the window.                           |
| This function is designed to be used in place of the XmCreate<object>        |
| convenience functions provided by Motif.   This function calls the           |
| XmCreate... function specified with the createFunction argument, but it      |
| also does other things required to make the Widget into an IWindow.          |
| Actions performed include:                                                   |
|  - Setting up initial rectangle                                              |
|  - calling startHandlingEventsFor                                            |
|  - setting the owner to the handle specified                                 |
|  - processing the IWindow defined styles (including visible which            |
|    will manage the widget if appropriate)                                    |
------------------------------------------------------------------------------*/
IWindowHandle IWindow::create( unsigned long        id,
                              const char*           text,
                              unsigned long         style,
                              IXmCreateFunction     createFunction,
                              const IWindowHandle&  parent,
                              const IWindowHandle&  owner,
                              const IRectangle&     initRect,
                              const void*           callerArgList,
                              unsigned int    callerNumberArguments,
                              IWindow::SiblingOrder ordering,
                              unsigned long         extendedStyle )

{
  // assertions on input parms
  IASSERTPARM(parent!=0);
  IASSERTPARM(createFunction!=0);

  // the following flag is used to delay calling setLayoutDistorted in
  // startHandlingEvents and moveSizeTo is show.
  pWindowData->motifState |= IWindowPrivateData::inCreate;

  // Create the argument list of Motif resources to use when creating
  // the window.
  IArgList
    iargList;
  // Start first with any bidi resources, emulating the way a window
  // inherits bidi attributes on OS/2.
  if ( IBidiSettings::isBidiSupported() )
  {
     // A window inherits the bidi attributes of its parent window,
     // unless it is parented to the desktop window, in which case
     // it uses application-wide bidi settings.
     IBidiSettings
       bidiSettings = IBidiSettings::applicationDefaults();
     if ( parent  &&
          parent != IWindow::desktopWindow()->handle() )
     {  // Use bidi attributes from the parent window.
        bidiSettings = IBidiSettings( parent );
     }

     // IWindow bidi styles take precedence over inherited bidi
     // attributes and bidi Motif attributes.  Presumably,
     // IWindow::convertToArgList and convertToGUIStyle have
     // stored the use of an IWindow bidi style in private data.
     if ( pWindowData->fWindowDirection ==
                         IWindowPrivateData::kRightToLeft )
     {
        bidiSettings
         .setWindowLayout( IBidiSettings::layoutRightToLeft )
         .setTextOrientation( IBidiSettings::textRightToLeft );
     }
     else if ( pWindowData->fWindowDirection ==
                              IWindowPrivateData::kLeftToRight )
     {
        bidiSettings
         .setWindowLayout( IBidiSettings::layoutLeftToRight )
         .setTextOrientation( IBidiSettings::textLeftToRight );
     }
     // Else use inherited bidi attributes.

     iargList = bidiSettings.asArgList();
  }

  if (text)
  {
     iargList
      .setResource( XmNlabelString, (long) text );
  }

  iargList
   .setResource( XmNwidth, initRect.width() )
   .setResource( XmNheight, initRect.height() );

  // Now that our argument list is complete, merge it with the
  // caller's arg list to be used on the call.
  ArgList argList = XtMergeArgLists( (ArgList)callerArgList,
                                     callerNumberArguments,
                                     (ArgList) iargList.argList(),
                                     iargList.numberOfArgs() );
  Cardinal
    argCount = callerNumberArguments + iargList.numberOfArgs();

  // Create the widget using the caller specified creation routine
  IWindowHandle
    hwnd= (*createFunction)( parent,
                             (char *)IString(id) ,
                             argList,
                             argCount );

  // Dont leak the argList created by XtMergeArgLists
  XtFree((char *)argList);

  // If creation failed bail now...
  if ( hwnd == 0)
    ITHROWLIBRARYERROR1( IC_XMCREATE_FAILURE,
                         IBaseErrorInfo::invalidRequest,
                         IException::recoverable,
                         "XmCreate<object>");

  // Default in X is that the most recently created window is behind all siblings.
  // Therefore, change it only if onTopOfSiblings is requested.
  if(ordering == IWindow::onTopOfSiblings)
     pWindowData->positionOnSiblings( hwnd );

  // set the owner to specified window.   In Motif we manage "owner chain"
  // the call to setOwner is in startHandlingEventsFor
  pWindowData->fhwndOwner = owner;

  Dimension border;
  XtVaGetValues( hwnd,
    XmNborderWidth, &border,
    NULL );

  pWindowData->windowSize = initRect.size();
//  pWindowData->nativeWindowPosition = initRect.minXMinY();
  pWindowData->windowPosition = initRect.minXMinY();

  // Save these values to be used during startHandlingEventsFor. We can't
  // call enable or show before that time.
  if ( style & WS_VISIBLE )
    pWindowData->motifState |= IWindowPrivateData::visible;
  else
    pWindowData->motifState &= ~IWindowPrivateData::visible;

  if( style & WS_DISABLED )
    pWindowData->motifState |= IWindowPrivateData::disabled;
  else
    pWindowData->motifState &= ~IWindowPrivateData::disabled;

  // Mark that we used IWindow's create function. This will tell
  // startHandlingEvents to look for the visible and disabled flags.

  pWindowData->motifState |= IWindowPrivateData::usedIWindowCreate;

  // We are no longer in create. We used to use this as an performance
  // enhancement so we did not call moveSizeTo twice. We probably no longer
  // need this flag but will leave it for now.
  pWindowData->motifState &= ~IWindowPrivateData::inCreate;

  // save a copy of style, we use it to save group and tab information.
  setStyle( style );
  return hwnd;
  }

/*------------------------------------------------------------------------------
| IWindow::create                                                              |
|                                                                              |
| Call the presentation system to create the window.                           |
| This function is designed to be used in place of the XmCreate<object>        |
| convenience functions provided by Motif.   This function calls the           |
| XmCreate... function specified with the createFunction argument, but it      |
| also does other things required to make the Widget into an IWindow.          |
| Actions performed include:                                                   |
|  - Setting up initial rectangle                                              |
|  - calling startHandlingEventsFor                                            |
|  - setting the owner to the handle specified                                 |
|  - processing the IWindow defined styles (including visible which            |
|    will manage the widget if appropriate)                                    |
------------------------------------------------------------------------------*/
IWindowHandle IWindow::create( unsigned long         id,
                               const char*           text,
                               const IBitFlag&       style,
                               IXmCreateFunction     createFunction,
                               const IWindow*        parent,
                               const IWindow*        owner,
                               const IRectangle&     initRect,
                               IWindow::SiblingOrder ordering )

{
  // assertions on input parms
  IASSERTPARM(parent!=0);
  IASSERTPARM(createFunction!=0);

  IWindow::Style& bitStyle = (IWindow::Style &) style;

  // the following flag is used to delay calling setLayoutDistorted in
  // startHandlingEvents and moveSizeTo is show.
  pWindowData->motifState |= IWindowPrivateData::inCreate;

  // convert the styles into an arglist.
  IArgList fArgs = this->convertToArgList( style );

  // Not sure about this next line...
  if (text)
  {
    //  XtSetArg( args[n], XmNlabelString, text ); n++;
    fArgs.setResource( XmNlabelString, (XtArgVal) text );
  }

  // Determine the Motif bidi resources to use when creating the
  // window, emulating the way a window inherits bidi attributes
  // on OS/2.  (IWindow::convertToArgList would have been the
  // preferred place to put this code, but that routine does not
  // have access to the parent window being used to create the
  // window.)
  IArgList
    bidiArgList;
  if ( IBidiSettings::isBidiSupported() )
  {
     // A window inherits the bidi attributes of its parent window,
     // unless it is parented to the desktop window, in which case
     // it uses application-wide bidi settings.
     IBidiSettings
       bidiSettings = IBidiSettings::applicationDefaults();
     if ( parent  &&     
          parent != IWindow::desktopWindow() )
     {  // Use bidi attributes from the parent window.
        bidiSettings = IBidiSettings( *parent );
     }

     // IWindow bidi styles take precedence over inherited bidi
     // attributes and bidi Motif attributes.
     if ( bitStyle & IWindow::rightToLeft )
     {
        bidiSettings
         .setWindowLayout( IBidiSettings::layoutRightToLeft )
         .setTextOrientation( IBidiSettings::textRightToLeft );
     }
     else if ( bitStyle & IWindow::leftToRight )
     {
        bidiSettings
         .setWindowLayout( IBidiSettings::layoutLeftToRight )
         .setTextOrientation( IBidiSettings::textLeftToRight );
     }
     // Else use inherited bidi attributes.

     bidiArgList = bidiSettings.asArgList();
  }

  // Merge the argument lists.
  ArgList
    argList = XtMergeArgLists( (ArgList) fArgs.argList(),
                               fArgs.numberOfArgs(),
                               (ArgList) bidiArgList.argList(),
                               bidiArgList.numberOfArgs() );
  Cardinal
    argCount = fArgs.numberOfArgs() + bidiArgList.numberOfArgs();

  IWindowHandle parentHandle(0);
  if (parent)
    parentHandle = parent->handleForChildCreation();
  else
    parentHandle = IWindow::desktopWindow()->handle();

  // Create the widget using the caller specified creation routine
  IWindowHandle
    hwnd= (*createFunction)( parent->handleForChildCreation(),
                             (char *)IString(id) ,
                             argList,
                             argCount );

  // Don't leak the argList created by XtMergeArgLists.
  XtFree( (char *) argList );

  // If creation failed, bail now...
  if ( hwnd == 0)
    ITHROWLIBRARYERROR1( IC_XMCREATE_FAILURE,
                         IBaseErrorInfo::invalidRequest,
                         IException::recoverable,
                         "XmCreate<object>");

  // Default in X is that the most recently created window is behind all siblings.
  // Therefore, change it only if onTopOfSiblings is requested.
  if(ordering == IWindow::onTopOfSiblings)
     pWindowData->positionOnSiblings( hwnd );

  // set the owner to specified window.   In Motif we manage "owner chain"
  // the call to setOwner is in startHandlingEventsFor
  IWindowHandle hOwner(0);
  if ( owner )
    hOwner = owner->handle();
  pWindowData->fhwndOwner = hOwner;

  Dimension border;
  XtVaGetValues( hwnd,
    XmNborderWidth, &border,
    NULL );

  pWindowData->windowSize = ISize( initRect.size().width() - 2*border,
                                   initRect.size().height() - 2*border );

//  pWindowData->nativeWindowPosition = initRect.minXMinY();
  pWindowData->windowPosition = initRect.minXMinY();


  // Save these values to be used during startHandlingEventsFor. We can't
  // call enable or show before that time.
  if ( bitStyle & IWindow::visible )
    pWindowData->motifState |= IWindowPrivateData::visible;
  else
    pWindowData->motifState &= ~IWindowPrivateData::visible;

  if( bitStyle & IWindow::disabled )
    pWindowData->motifState |= IWindowPrivateData::disabled;
  else
    pWindowData->motifState &= ~IWindowPrivateData::disabled;

  if( bitStyle & IWindow::tabStop )
    pWindowData->ulStyle |= tabStop.asUnsignedLong();
  else
    pWindowData->ulStyle &= ~tabStop.asUnsignedLong();

  // Mark that we used IWindow's create function. This will tell
  // startHandlingEvents to look for the visible and disabled flags.

  pWindowData->motifState |= IWindowPrivateData::usedIWindowCreate;

  // We are no longer in create. We used to use this as an performance
  // enhancement so we did not call moveSizeTo twice. We probably no longer
  // need this flag but will leave it for now.
  pWindowData->motifState &= ~IWindowPrivateData::inCreate;

  return hwnd;
  }


/*------------------------------------------------------------------------------
| IWindow::cleanUp                                                             |
|                                                                              |
| Remove the window from the window list.  If this is a primary window and     |
| there are no remaining primary windows in the window list, post a WM_QUIT    |
| to the message queue.                                                        |
------------------------------------------------------------------------------*/
IWindow& IWindow::cleanUp()
{
  IMODTRACE_ALL("Win::cleanUp");
  if ( pWindowData->state & addedToList)
  {
    ITRACE_ALL(asString());
    IWindowList* pwinlist = IWindowList::current();
    ITRACE_ALL(IString("Window list entries: ") +
               IString(pwinlist->numberOfElements()));
    try
    {
      //isValid();  // insure window has a valid widget associated with it

      IWindow::removeFromWindowSet( this );
    }
    catch(IException& exc)
    {
      ITRACE_RUNTIME("Attempt to destroy window not in set.");
    }

    IWindowThreadData* data =
       IWindowThreadData::dataForThread(IThread::current().id());
    if ( isBoundToMessageQueue() && data)
    {
       data->removeBoundWindow();
       // insure we don't treat this one as bound again.
       pWindowData->state &= ~(primaryWindow | boundToMessageQueue);
       if (!data->hasBoundWindow() && IThread::current().isProcessingMsgs() )
       {
          ITRACE_DEVELOP("No primary windows, so stop processing msgs (WM_QUIT). ");
          IThread::current().stopProcessingMsgs();
       } // end
    } // end isBoundToMessageQueue

  } // end AddedToList

  return *this;
} // end cleanUp

/*------------------------------------------------------------------------------
| IWindow::mapPoint                                                            |
|                                                                              |
| Remap points from one coordinate space to another.                           |
|                                                                              |
| The specified point is mapped from the IWindow coordinate space for the      |
| IWindow of the from handle to the IWindow coordinate space for the IWindow   |
| of the to handle.                                                            |
|                                                                              |
| The realSizeWidget for each window is used
| to calculate the amount the specified point needs to be adjusted.            |
|                                                                              |
| This algorithm relies on the fact that the handles used represent widgets    |
| whose Motif origins are the same distance (normally zero) from the top left  |
| corners of their IWindow's.                                                  |
------------------------------------------------------------------------------*/
IPoint IWindow::mapPoint ( const IPoint        &aPoint,
                           const IWindowHandle &from,
                           const IWindowHandle &to )
{
  if ( from == to )
    return aPoint;

  if ( from == 0 || to == 0 )
  {
    ITHROWLIBRARYERROR(IC_MAPPOINT_FAILED,
                       IBaseErrorInfo::invalidRequest,
                       IException::recoverable);
  }

  ISize fromSize;
  ISize toSize;
  // This code works around a problem when MBCS are enabled. The input
  // method should not be included in the size of the widget.
  Widget fromHandle = from;
  Widget toHandle = to;

  Dimension width, height, border;

  if ( fromHandle != IWindow::desktopWindow()->handle() )
  {
    IWindow *fromWin = IWindow::windowWithHandle( fromHandle );
    if (fromWin)
      fromHandle = IWindowPrivateData::realSizeWidget(fromWin);
    XtVaGetValues( fromHandle,
                   XmNwidth, &width,
                   XmNheight, &height,
                   XmNborderWidth, &border,
                   NULL );
    fromSize = ISize(width +  2*border, height + 2*border );
  }
  else
    fromSize = IWindow::desktopWindow()->size();

  if ( toHandle != IWindow::desktopWindow()->handle() )
  {
    IWindow *toWin = IWindow::windowWithHandle( toHandle );
    if (toWin)
      toHandle = IWindowPrivateData::realSizeWidget(toWin);
    XtVaGetValues( toHandle,
                   XmNwidth, &width,
                   XmNheight, &height,
                   XmNborderWidth, &border,
                   NULL );
    toSize = ISize(width +  2*border, height + 2*border );
  }
  else
    toSize = IWindow::desktopWindow()->size();

  // We need the point in native coordinates, we'll convert it back
  // to application coords if necessary.
  IPoint pt( aPoint );
  if ( ICoordinateSystem::isConversionNeeded() )
  {
    // get the from size so point can be converted.
    pt = ICoordinateSystem::convertToNative( aPoint, fromSize );
  }


//  IMAPWINDOWPOINTS(from, to, &pt, 1);
  // Map point to the desktop using XtTranslateCoords
  //
  // Get the top left corners of the coresponding widgets in desktop coords.
  // The border widths are not, and should not be, used in this calculation.
  //
  Position from_x = 0;
  Position from_y = 0;
  if ( fromHandle != IWindow::desktopWindow()->handle() )
    XtTranslateCoords(fromHandle, 0, 0, &from_x, &from_y);

  Position to_x = 0;
  Position to_y = 0;
  if ( toHandle != IWindow::desktopWindow()->handle() )
    XtTranslateCoords(toHandle, 0, 0, &to_x, &to_y);
  //
  // Return aPoint adjusted by the difference in their IWindow's origins.
  // from_y and to_y are in Motif style coordinates, so their difference
  // is negated when calculating the IWindow style y coordinate.
  //
  pt =  IPoint( pt.x() + (from_x - to_x),
                pt.y() + (from_y - to_y) );

  if ( ICoordinateSystem::isConversionNeeded() )
  {
     pt = ICoordinateSystem::convertToApplication(
                                IPoint(pt), toSize );
  }

  return pt;
}

/*------------------------------------------------------------------------------
| IWindow::size                                                                |
|                                                                              |
| Get the window size.                                                         |
------------------------------------------------------------------------------*/
ISize IWindow::size() const
{
  if ( XtIsManaged( this->hwnd ) )
  {
    if ( XtIsRealized( this->hwnd ) )
    {
      // if mapped then get the real size.
      pWindowData->windowSize = pWindowData->realSize( this );
    }
    return pWindowData->windowSize;
  }
  else
  {
    // check to see if our parent has been realized. If not then return
    // the stored position, otherwise return our real position.
    IWindow *fParent = parent();
    if ( fParent &&
         ( fParent != IWindow::desktopWindow() ) &&
         !(fParent->pWindowData->motifState & IWindowPrivateData::realized))
    {
      // if we have been realized at some point but now not managed that means
      // we have a size of 0. We could have been unmanaged by frame handler or
      // canvas through IWinPosBuf. If unmanaged and has been realized then
      // return an actual size of 0.
      return ISize(0,0);
    }
  }
  return pWindowData->windowSize;
}

/*------------------------------------------------------------------------------
| IWindow::parentSize                                                          |
------------------------------------------------------------------------------*/
ISize IWindow::parentSize ( ) const
{
//   return parentSize( this->handle() );
   return IWindowPrivateData::parentSize(this);
}

/*------------------------------------------------------------------------------
| IWindow::parentSize                                                          |
------------------------------------------------------------------------------*/
ISize IWindow::parentSize ( const IWindowHandle& windowhandle )
{
   IMODTRACE_ALL("parentSize");
   IWindow *win = IWindow::windowWithHandle( windowhandle );
   return IWindowPrivateData::parentSize( win ) ;
}

/*------------------------------------------------------------------------------
| IWindow::position                                                            |
|                                                                              |
| Gets the object position.                                                    |
------------------------------------------------------------------------------*/
IPoint IWindow::position ( ) const
{
  // If the widget is mapped and realized then use the real size. Note that
  // real size takes care of the coordinate conversion.
  // If the widget is not realized and mapped then use the values stored by
  // moveSizeTo.
  IPoint position = pWindowData->windowPosition;
  if ( XtIsManaged( this->hwnd ) && XtIsRealized( this->hwnd)
         && (pWindowData->motifState & IWindowPrivateData::realized ))
    position = pWindowData->realPosition( this );
  else if ( ICoordinateSystem::applicationOrientation() ==
         ICoordinateSystem::nativeOrientation() )
    position = pWindowData->nativeWindowPosition;
  return position;
}

/*------------------------------------------------------------------------------
| IWindow::rect                                                                |
|                                                                              |
| Gets the object position and size.                                           |
------------------------------------------------------------------------------*/
IRectangle IWindow::rect ( ) const
 {
  return( IRectangle(position(),size()) );
 }

//@@ d5295
//@@ We really want to do this, for performance, but unfortunately this
//@@ would change the behaviour of any classes which may override size()
//@@ and/or position.  (e.g. ITheDesktopWindow)
//@@ {
//@@  if ( pWindowData->useRealCoordinates( this ) )
//@@   {
//@@    // if mapped then get the real position and size.
//@@    return IRectangle( pWindowData->realPosition( this ),
//@@                       pWindowData->realSize( this ) );
//@@   }
//@@  // else
//@@  return IRectangle( pWindowData->windowPosition,
//@@                     pWindowData->windowSize );
//@@ }

/*------------------------------------------------------------------------------
| IWindow::nativeRect                                                          |
------------------------------------------------------------------------------*/
IRectangle IWindow::nativeRect ( ) const
{
  if ( this == IWindow::desktopWindow() )
  {
    return IRectangle( IPoint(0,0), IWindow::desktopWindow()->size());
  }
  else
  {
    // we may need some checks to see if the handle(widget) is managed
    // and realized.
    Position   x, y;
    Dimension width, height, border;

    XtVaGetValues( handle(),
                   XmNx, &x,
                   XmNy, &y,
                   XmNwidth, &width,
                   XmNheight, &height,
                   XmNborderWidth, &border,
                   NULL);
    return IRectangle( IPoint(x,y),
                       ISize( width + 2*border, height + 2*border));
  }
}

/*------------------------------------------------------------------------------
| IWindow::sizeTo                                                              |
|                                                                              |
| Size the window.                                                             |
------------------------------------------------------------------------------*/
IWindow& IWindow::sizeTo ( const ISize& siz )
{
  IMODTRACE_ALL("Win::sizeTo");
  ITRACE_ALL(siz.asString());

  moveSizeTo( IRectangle( position(), siz) );
  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::moveTo                                                              |
|                                                                              |
| Move the object.                                                             |
------------------------------------------------------------------------------*/
IWindow& IWindow::moveTo ( const IPoint& pt )
{
  moveSizeTo(IRectangle( pt, size()) );
  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::moveSizeTo                                                          |
|                                                                              |
| Move and size the object.                                                    |
------------------------------------------------------------------------------*/
IWindow& IWindow::moveSizeTo ( const IRectangle& rect )
{
  IMODTRACE_ALL("IWindow::moveSizeTo");

  Widget theHandle = (Widget)this->hwnd;
  // No handle and we are out of here
  if ( theHandle == 0 )
    return *this;

  // We use parent quite a bit. Save a copy.
  IWindow* parent = this->parent();

  ITRACE_ALL( "moveSizeTo: theHandle "
                  + IString( (int) theHandle ).d2x()
                  + " rect" + rect.asString()
                  + " parent size is "
                  + pWindowData->parentSize( this ).asString()
                  + " oldHeight " + IString(pWindowData->oldHeight)
                  + " oldWidth " + IString(pWindowData->oldWidth)
                  + " windowSize " + pWindowData->windowSize.asString()
                  + " windowPosition " + pWindowData->windowPosition.asString()
                   );

  // Check the coordinate system and convert the rectangle if necessary.
  // Fix parentSize so that if the parent is not managed and realized then it
  // is the size that was set by the user.
  IRectangle nativeRectangle = rect;
  if ( ICoordinateSystem::isConversionNeeded() )
  {
    // if the parentSize is 0 then don't try to convert the rectangle. It just
    // gives us bad results.
    ISize fParentSize = parentSize();
    if (fParentSize != ISize() )
    {
      nativeRectangle = ICoordinateSystem::convertToNative( rect, fParentSize );
    }
  }


  // Save our position and size. If we are not managed and realized then we will
  // need this information later.
  // We may need to store both recoordinated and coord passed in by user.
  pWindowData->windowPosition = rect.minXMinY();
  pWindowData->nativeWindowPosition = nativeRectangle.minXMinY();
  pWindowData->windowSize = rect.size();

  // Look into getting rid of the real size widget. This appears to be for the
  // case where the window manager adds an input method for you.
  Widget theRealSizeWidget = IWindowPrivateData::realSizeWidget(this);

  // We need to know the border width to calculate the width and height for the
  // widget.
  Dimension border;
  XtVaGetValues( theRealSizeWidget,
    XmNborderWidth, &border,
    NULL );

  Dimension theX, theY, theWidth, theHeight;

  theX = nativeRectangle.minX();
  theY = nativeRectangle.minY();
  if ( nativeRectangle.width() >  2*border )
    theWidth = nativeRectangle.width() - 2*border;
  else
    theWidth = 0;
  if ( nativeRectangle.height() >  2*border )
    theHeight = nativeRectangle.height() - 2*border;
  else
    theHeight = 0;

  bool sizeControl = true;
  bool positionControl = true;
  bool fIsFrameWindow = this->isFrameWindow();

  // I don't know why the frame window check is here, but basically this test is
  // saying if my parent is not visible then all we can do for now is set my size.
  // But we can set the position if we are using native coordinate system
  if (    ( parent)
       && ( parent != IWindow::desktopWindow() )
       && ( ICoordinateSystem::applicationOrientation()
            != ICoordinateSystem::nativeOrientation() )
       && (!parent->isVisible() )
       && (!fIsFrameWindow)
      )
  {
    positionControl = false;
  }

  // We can't rely on setting the size of a widget to zero to hide the widget.
  // In general, each widget uses a width and a height of zero to size the widget
  // to its minimum size. In this case we need to unmanage the widget.
  if ( theWidth == 0 || theHeight == 0 )
  {
    // We are having trouble with submenu's so don't unmanage row columns.
    if ( dynamic_cast<MenuWindow*>(this) )
      return *this;

    XtUnmanageChild( theHandle );

    return *this;
  }

  if (fIsFrameWindow)
  {
    // Adjust the height of the frame window shell by the amount the
    // heights of the shell and main window differ.  This is to account
    // for the fact that the specified rectangle is intended to
    // specify the size of the main window, but we are actually sizing
    // the shell.  The window manager somtimes adds an MBCS input
    // method status area to the shell, outside of the main window.
#ifdef IC_TRACE_ALL
    Position realX, realY, topX, topY;
    Dimension realWidth, topWidth;
    XtVaGetValues( theRealSizeWidget,
                   XmNwidth, &realWidth,
                   XmNx, &realX,
                   XmNy, &realY,
                   NULL );
    XtVaGetValues( theHandle,
                   XmNwidth, &topWidth,
                   XmNx, &topX,
                   XmNy, &topY,
                   NULL );
#endif
    Dimension realHeight, topHeight;
    XtVaGetValues( theRealSizeWidget,
                   XmNheight, &realHeight,
                   NULL );
    XtVaGetValues( theHandle,
                   XmNheight, &topHeight,
                   NULL );
    if ( topHeight > realHeight )
       theHeight += (topHeight - realHeight);

    // on a frame window we want to size the main window, but position the
    // top level shell.
    if (positionControl)
    {
      XtVaSetValues( theHandle,
                     XmNx, theX,
                     XmNy, theY,
                     XmNwidth, theWidth,
                     XmNheight, theHeight,
                     NULL );
      XtVaSetValues( XtParent( (Widget)this->handleForChildCreation()),
                     XmNwidth, theWidth,
                     XmNheight, theHeight,
                     NULL );
    }
    if (sizeControl )
    {
      XtVaSetValues( XtParent( (Widget)this->handleForChildCreation()),
                     XmNwidth, theWidth,
                     XmNheight, theHeight,
                     NULL );
    }
  }
  else
  {
    if ( positionControl )
    {
      XtVaSetValues( theHandle,
        XmNx, theX,
        XmNy, theY,
        XmNwidth, theWidth,
        XmNheight, theHeight,
        NULL );
    }
    if ( sizeControl )
    {
      // For children of viewports.
      XtVaSetValues( theHandle,
        XmNwidth, theWidth,
        XmNheight, theHeight,
        NULL );
    }
  }

  // if the widget has a non zero width and height then it should be
  // managed
  if ( !XtIsManaged( (Widget) theHandle ))
  {
    XtManageChild( theHandle );
  }

#ifdef IC_TRACE_ALL
  Position newX, newY;
  Dimension newWidth, newHeight;
  XtVaGetValues( theHandle,
    XmNx, &newX,
    XmNy, &newY,
    XmNwidth, &newWidth,
    XmNheight, &newHeight,
    NULL );
  if ( ( theX      != newX      ) ||
       ( theY      != newY      ) ||
       ( theWidth  != newWidth  ) ||
       ( theHeight != newHeight ) )
  {
    ITRACE_ALL( "Error - moveSizeTo failed, sizeTo failed" );
  }
#endif
  return *this;
}


/*------------------------------------------------------------------------------
| IWindow::positionBehindSiblings                                              |
|                                                                              |
| Put this window in the stacking order behind all of its siblings.            |
------------------------------------------------------------------------------*/
IWindow& IWindow::positionBehindSiblings ( )
{
  IMODTRACE_DEVELOP("Win::positionBehindSiblings");
  Widget childToMove = (Widget)this->hwnd;

  // The childs parent must be a composite widget
  if ( !XtIsComposite(childToMove->core.parent) )
    return *this;

  CompositeWidget parent = (CompositeWidget) childToMove->core.parent;
  // Get the pointer to the list of children for the composite widget.
  WidgetList children = parent->composite.children;

  // find the widget that we want to move to the top
  Cardinal position = parent->composite.num_children;
  for ( int i = 0; i < parent->composite.num_children; i++ )
  {
    if ( children[i] == childToMove )
      position = i;
  }
  // if position is not equal to num_children then the child was found, lets
  // move it.
  if ( position != parent->composite.num_children )
  {
    // move all of the children up so we free up the last slot  for the
    // childToMove
    for ( int i = position; i < parent->composite.num_children; i++)
    {
      children[i] = children[i+1];
    }
    // put the childToMove in the last slot.
    children[parent->composite.num_children - 1] = childToMove;
  }
  if (XtIsRealized(childToMove) && XtIsManaged(childToMove))
      XLowerWindow( XtDisplay( childToMove), XtWindow( childToMove) );
  return *this;
}

/*------------------------------------------------------------------------------
| IWindowPrivateData::positionOnSiblings                                       |
|                                                                              |
| Put this window in the stacking order on top of all of its siblings.         |
| We need this version that takes a IWindowHandle because it is called         |
| during IWindow::create and the hwnd has not yet been added to the handle     |
| list. That is done during startHandlingEventsFor                             |
------------------------------------------------------------------------------*/
void IWindowPrivateData::positionOnSiblings ( IWindowHandle whnd )
{
  Widget childToMove = (Widget) whnd;

  // The childs parent must be a composite widget
  if ( !XtIsComposite(childToMove->core.parent) )
    return;

  CompositeWidget parent = (CompositeWidget) childToMove->core.parent;
  // Get the pointer to the list of children for the composite widget.
  WidgetList children = parent->composite.children;

  // find the widget that we want to move to the top
  Cardinal position = parent->composite.num_children;
  for ( int i = 0; i < parent->composite.num_children; i++ )
  {
    if ( children[i] == childToMove )
      position = i;
  }
  // if position is not equal to num_children then the child was found, lets
  // move it.
  if ( position != parent->composite.num_children )
  {
    // move all of the children down so we free up slot 0 for the
    // childToMove
    for ( int i = position; i > 0; i--)
    {
      children[i] = children[i-1];
    }
    children[0] = childToMove;
  }
  if (XtIsRealized(childToMove) && XtIsManaged(childToMove))
      XRaiseWindow( XtDisplay(childToMove), XtWindow(childToMove) );
}

/*------------------------------------------------------------------------------
| IWindow::positionOnSiblings                                                  |
|                                                                              |
| Put this window in the stacking order on top of all of its siblings.         |
------------------------------------------------------------------------------*/
IWindow& IWindow::positionOnSiblings ( )
{
  IMODTRACE_DEVELOP("Win::positionBehindSiblings");
  IWindowHandle hThis = IWindowHandle((Widget)this->hwnd);
  pWindowData->positionOnSiblings( hThis );

  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::positionBehind                                                      |
|                                                                              |
| Put this window in the stacking order behind the passed window.              |
------------------------------------------------------------------------------*/
IWindow& IWindow::positionBehindSibling ( const IWindowHandle& siblingWindow)
{
  IMODTRACE_DEVELOP("Win::positionBehindSiblings");
  Widget childToMove = (Widget)this->hwnd;

  // if the child and sibling are the same window then there is nothing
  // to do.
  if (childToMove == siblingWindow )
    return *this;

  // The childs parent must be a composite widget
  if ( !XtIsComposite(childToMove->core.parent) )
    return *this;

  CompositeWidget parent = (CompositeWidget) childToMove->core.parent;
  // Get the pointer to the list of children for the composite widget.
  WidgetList children = parent->composite.children;

  // find the widget that we want to move after.
  Cardinal childPosition = parent->composite.num_children;
  Cardinal siblingPosition = parent->composite.num_children;

  for ( int i = 0; i < parent->composite.num_children; i++ )
  {
    if ( children[i] == childToMove )
      childPosition = i;
    if ( children[i] == siblingWindow )
      siblingPosition = i;
  }
  // First make sure both children have been found.
  if ( ( childPosition != parent->composite.num_children ) &&
       ( siblingPosition != parent->composite.num_children ) )
  {
    if ( childPosition < siblingPosition)
    {
      // move the children up below the child window up to and including the
      // sibling up one and place the child
      // in the siblings old position.
      for ( int i = childPosition; i < siblingPosition; i++)
      {
        children[i] = children[i+1];
      }
      children[i] = childToMove;
    }
    else
    {
      // move the children up below the child window up to and including the
      // sibling up one and place the child
      // in the siblings old position.
      for ( int i = childPosition; i > siblingPosition+1; i--)
      {
        children[i] = children[i-1];
      }
      children[siblingPosition+1] = childToMove;
    }
  }

  // Now make the window order match the children list.
  Cardinal numChildren = parent->composite.num_children;
  Window* windows = new Window[numChildren];
  for (i=0;i<numChildren;i++)
  {
    windows[i] = XtWindow(children[i]);
  }
  XRestackWindows( XtDisplay(parent), windows, numChildren);

  delete [] windows;

  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::isShowing                                                           |
|                                                                              |
| Is the window showing?  True if the window not being moved                   |
| and some part of the window is currently on the screen.                      |
------------------------------------------------------------------------------*/
bool IWindow::isShowing ( ) const
{
  IWindowHandle w = handle();

   // no exception required because handle() check for valid
   // window handle
  if ( w )
  {
    // getting the window attributes has the side effect of flushing the x server
    // and windows show up before they are correctly placed by the widgets. This
    // is a side effect seen by Montana ide when refresh is called.

    // Try to check to see if the widget is unmapped instead.
#if 0
    XWindowAttributes windowAttr;

    if (XGetWindowAttributes( XtDisplay((Widget)w),
                              XtWindow((Widget)w),
                              &windowAttr) )
    {
#ifdef IC_TRACE_ALL
      if ( ((windowAttr.map_state == IsViewable ) && !XtIsManaged((Widget)w) ) ||
           ((windowAttr.map_state != IsViewable ) && XtIsManaged((Widget)w) ) )
      {
          ITRACE_ALL(IString("IsViewable != XtIsManaged  map_state=") +
                     IString(windowAttr.map_state) +
                     IString(" XtIsManaged=") + IString(XtIsManaged((Widget)w)) );
      }
#endif
      // choices are IsUnmapped, IsUnviewable, IsViewable
      if (windowAttr.map_state != IsUnmapped )
      {
        return true;
      }
#endif
    // first see if the widget is managed and realized
    if (XtIsManaged((Widget)w) && XtIsRealized((Widget)w) )
    {
      // if the widget is managed and realized then the only way it can not be
      // visible is if someone called hide. We use the mappedWhenManaged flag
      // to indicate if the window should be showing.
      ::Boolean fMapped;
      XtVaGetValues( w,
                     XmNmappedWhenManaged, &fMapped,
                     NULL );
      if (fMapped)
      {
        return true;
      }
    }
  }

  return false;
}


/*------------------------------------------------------------------------------
| IChildCursorData::IChildCursorData
|
------------------------------------------------------------------------------*/
IChildCursorData::IChildCursorData ( IWindowHandle parentHandle )
    : children(NULL)
    , num_children(0)
    , index(0)
    , hwndParent( parentHandle )
{
  // Always get a fresh list when setToFirst is called. Both native PM and Motif work
  // this way, as does IWindow::ChildCursor for OS/2. People expect it.
  num_children = 0;
  index = 0;
  //  note: this->hwndParent is valid widget, since it was initialized via handle()
  //if it can't have children, don't ask
  if (XtIsComposite((Widget)hwndParent) )
  {
    XtVaGetValues( (Widget)hwndParent,
                   XmNchildren    , &children,
                   XmNnumChildren , &num_children,
                   NULL );
  }
}

/*------------------------------------------------------------------------------
| IChildCursorData::~IChildCursorData
|
------------------------------------------------------------------------------*/
IChildCursorData::~IChildCursorData ( )
{ }

/*------------------------------------------------------------------------------
| IChildCursorData::setToFirst
|
------------------------------------------------------------------------------*/
bool IChildCursorData::setToFirst ( IWindowHandle &hwnd )
{
  bool bSuccess(false);
  hwnd = IWindowHandle( 0 );  // Invalidate child cursor.
  for ( int i = 0; !bSuccess && i < num_children; i++ )
  {
    if ( !children[i]->core.being_destroyed )
    {
      bSuccess = true;
      index = i;              // index of first child not being destroyed.
      hwnd = children[index]; // copy the current child into this cursor.
    }
  }
  return bSuccess;
}

/*------------------------------------------------------------------------------
| IChildCursorData::setToNext
|
------------------------------------------------------------------------------*/
bool IChildCursorData::setToNext ( IWindowHandle& hwnd )
{
  bool bSuccess(false);
  hwnd = IWindowHandle( 0 );  // Invalidate child cursor.
  for ( int i = index+1; !bSuccess && i < num_children; i++ )
  {
    if ( !children[i]->core.being_destroyed )
    {
      bSuccess = true;
      index = i;              // index of first child not being destroyed.
      hwnd = children[index]; // copy the current child into this cursor.
    }
  }
  return bSuccess;
}

/*------------------------------------------------------------------------------
| IChildCursorData::invalidate
|
------------------------------------------------------------------------------*/
void IChildCursorData::invalidate ( IWindowHandle& hwnd )
{
  hwnd = IWindowHandle( 0 );
  num_children =  0;
}

/*------------------------------------------------------------------------------
| IWindow::ChildCursor::ChildCursor                                            |
|                                                                              |
| The constructor simply saves the parent handle and initializes the cursor    |
| state to "invalid" (enumHandle = windowHandle == 0).                         |
------------------------------------------------------------------------------*/
IWindow::ChildCursor::ChildCursor ( IWindow &parent, bool onlyIWindowChildren )
    : hwnd( 0 )
    , pCursorData( new IChildCursorData( parent.handleForChildCreation() ))
{ }

/*------------------------------------------------------------------------------
| IWindow::ChildCursor::~ChildCursor                                           |
|                                                                              |
------------------------------------------------------------------------------*/
IWindow::ChildCursor::~ChildCursor ( )
{
  delete pCursorData;
}

/*------------------------------------------------------------------------------
| IWindow::ChildCursor::setToFirst
|
| Always start with a fresh list of child widgets obtained from X.
| If we have at least one child, save the first child window's
| handle in hwnd data member. If we have none, save 0.
------------------------------------------------------------------------------*/
bool IWindow::ChildCursor::setToFirst ( )
{
  return pCursorData->setToFirst( hwnd );
}

/*------------------------------------------------------------------------------
| IWindow::ChildCursor::setToNext
|
| Set the saved window handle to the next child in the list.
------------------------------------------------------------------------------*/
bool IWindow::ChildCursor::setToNext ( )
{
  return pCursorData->setToNext( hwnd );
}

/*------------------------------------------------------------------------------
| IWindow::ChildCursor::isValid                                                |
|                                                                              |
| Return true if this cursor points to a valid child.                          |
------------------------------------------------------------------------------*/
bool IWindow::ChildCursor::isValid ( ) const
{
  // if the handle is bad (note: only our code should cause a 0 handle)
  return hwnd != 0;
}

/*------------------------------------------------------------------------------
| IWindow::ChildCursor::invalidate                                             |
|                                                                              |
| If enum handle is valid, end the enumeration.                                |
------------------------------------------------------------------------------*/
void IWindow::ChildCursor::invalidate ( )
{
  pCursorData->invalidate( hwnd );
}

//==============================================================================
//==============================================================================
//==============================================================================
// MOTIF Unique functions
//==============================================================================
//==============================================================================
//==============================================================================
/*------------------------------------------------------------------------------
| ITheDesktopWindow::size                                                        |
|                                                                                |
| Get the size of the desktop, from X                                            |
------------------------------------------------------------------------------*/
ISize ITheDesktopWindow::size ( ) const
{
  IPair::Coord h=0, w=0;
  IWindowHandle appShell = this->handle();
  h = XHeightOfScreen( XtScreen((Widget)appShell) );
  w = XWidthOfScreen( XtScreen((Widget)appShell) );
  return ISize( w, h );
}

/*------------------------------------------------------------------------------
| ITheDesktopWindow::position                                                  |
|                                                                              |
| Gets the position of the desktop, always 0,0.                                                |
------------------------------------------------------------------------------*/
IPoint ITheDesktopWindow::position ( ) const
{
  return IPoint( 0, 0 );
}

/*------------------------------------------------------------------------------
| IWindow::topHandle                                                           |
|                                                                              |
| Return the top (oldest ancestor) window system control                       |
| of those which this class created in it's ctor (or elsewhere).               |
| Used by show(), the IWindow dtor. Overridden by some compound controls,      |
| default implementation assumes the value determined by the create()          |
| function is the correct one.                                                 |
------------------------------------------------------------------------------*/
IWindowHandle IWindow::topHandle ( ) const
{
  return handle();
}

/*------------------------------------------------------------------------------
| IWindow::prepareForUse                                                       |
|                                                                              |
| Prepare to use the specified widget in this IWindow object. This is the      |
| equivalent of ::create() but is called when you already have the widget      |
| (e.g., from "wrapper" ctors for controls with relatively simple structure).  |
| Note that, since we only have the specified widget AND we don't know for     |
| sure that it's parent is an IWindow or what other widgets may be related     |
| to this one, this function is only useful for IWindows who are not composite |
| (i.e., that only have a single widget associated with them).                 |
------------------------------------------------------------------------------*/
IWindow& IWindow::prepareForUse ( const IWindowHandle& windowHandle )
{
  IMODTRACE_ALL("Win::prepareForUse");
  IASSERTPARM(windowHandle != 0);

  // the following flag is used to delay calling setLayoutDistorted in
  // startHandlingEvents and moveSizeTo is show.
  pWindowData->motifState |= IWindowPrivateData::inCreate;

  // moveSizeTo will map windows so we set mapped when managed to false.
  // Set mapped when managed back to true so that Accelerator translations
  // will work.
  XtVaSetValues( (Widget) windowHandle,
    XmNmappedWhenManaged, true,
    NULL );

  // Get initial size from widget, call moveSizeTo to "tell" IWindow about this size

// d6993
  Position x, y;
  Dimension width, height, border;
  XtVaGetValues( windowHandle,
    XmNx, &x,
    XmNy, &y,
    XmNwidth, &width,
    XmNheight, &height,
    XmNborderWidth, &border,
    NULL );
//  // The following monstrosity is the widget's rect, converted from Motif to PM coords.
//  moveSizeTo( IRectangle(
//   IPoint(x, pWindowData->parentSize( (IWindow *) this ).height() - y - height),
//   ISize(width,height) ) );
//  moveSizeTo( pWindowData->realRect( (IWindow*)this ) );
  pWindowData->nativeWindowPosition = IPoint( x, y );
  pWindowData->windowSize = ISize( width + 2*border, height + 2*border );

  pWindowData->motifState &= ~IWindowPrivateData::inCreate;

  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::isRelatedHandle                                                     |
|                                                                              |
| Verify whether the specified handle is related to this IWindow. This is the  |
| default implementation, which may never be called. IWindow subclasses which  |
| are compound controls (made up of more than one widget) should override this |
| method with an implementation based on knowledge of their own structure.     |
| In the default implementation, only handle() is "related" to this IWindow.   |
------------------------------------------------------------------------------*/
//@@Rob.  But this only seems to be overridden in IFrameWindow....
bool IWindow::isRelatedHandle ( const IWindowHandle& windowHandle ) const
{
  IMODTRACE_DEVELOP( "IWindow::isRelatedHandle" );
  if ( windowHandle == handle() )
    return True;
  else
    return False;
}

/*------------------------------------------------------------------------------
| IWindow::addRelatedHandleToWindowSet                                         |
|                                                                              |
| Add a related handle to the Current Thread's collection of related handle    |
| elements (relating the handle of a secondary widget to its window object).   |
------------------------------------------------------------------------------*/
void IWindow::addRelatedHandleToWindowSet ( IWindow* window,
                                            const IWindowHandle& windowHandle )
{ }

/*------------------------------------------------------------------------------
| IWindow::removeRelatedHandleFromWindowSet                                    |
|                                                                              |
| Remove a related handle from the Current Thread's collection.                |
|                                                                              |
------------------------------------------------------------------------------*/
void IWindow::removeRelatedHandleFromWindowSet(IWindow* window,
                              const IWindowHandle& windowHandle)
{
  // nothing added nothing to return
  return;
}

/*------------------------------------------------------------------------------
| IWindowPrivateData::registerCallbacks                                        |
|                                                                              |
| Add callbacks and X event handlers for events which every IWindow can        |
| experience.                                                                  |
------------------------------------------------------------------------------*/
void IWindowPrivateData::registerCallbacks ( IWindow* win )

{
  IWindowHandle hwnd( win->handle() );
  // destroy callback
  XtAddCallback(
     hwnd,                        // widget
     XmNdestroyCallback,          // callback name
     iwindowDestroyCallback,      // callback routine
     (XtPointer*)win);           // save reference to this IWindow in client data

  // The following check is for object windows which are just a WMShell.
  // The WMShell widget does not have the XmNhelpCallback resource.
  if ( ( XtIsConstraint( (Widget)hwnd ) &&
           XmIsManager( (Widget)hwnd ) ) ||
       (!XtIsConstraint( (Widget)hwnd ) &&
           XmIsPrimitive( (Widget)hwnd) ))
  {
    // help callback
    XtAddCallback(
      (Widget)hwnd,          // widget
      XmNhelpCallback,             // callback name
      ihelpwindowCallback,         // callback routine  (ihelpsta.cpp)
      (XtPointer*)win->id() );    // Pass window ID to help callback
  }

  // X event handler for all unmasked events, which includes nonmaskable events such as
  // client messages (incl. the ones representing ICommandEvents). Also includes
  // events we specifically ask for, such as expose and resize (ConfigureNotify) events.
  XtAddEventHandler(
     (Widget)hwnd ,       // widget
       ExposureMask              // ask for exposure (paint) events
     | VisibilityChangeMask,     // for shows
// d7508
//     | StructureNotifyMask,        // ask for ConfigureNotify events
//     | FocusChangeMask,            // ask for FocusIn and FocusOut events
     True,                       // indicate we also want nonmaskable events
     iwindowXEventCallback,      // event handler routine
     (XtPointer*)win);          // save reference to this IWindow in client data

  // X event handler for focus events, which must be added to the primary handle.
  XtAddEventHandler(
     (Widget)hwnd,         // widget
     FocusChangeMask,            // ask for FocusIn and FocusOut events
     True,                       // indicate we also want nonmaskable events
     iwindowXEventCallback,      // event handler routine
     (XtPointer*)win);          // save reference to this IWindow in client data

  // d7508
  // Ask for position/size changes on the widget used to size/position the
  // iwindow.
  XtAddEventHandler(
     IWindowPrivateData::realSizeWidget( win ), // widget
     StructureNotifyMask,        // ask for ConfigureNotify events
     False,                      // Do not want nonmaskable events
     iwindowXEventCallback,      // event handler routine
     (XtPointer*)win);          // save reference to this IWindow in client data
}

/*------------------------------------------------------------------------------
| IWindow::unregisterCallbacks                                                 |
|                                                                              |
| Remove callbacks and X event handlers added in registerCallbacks().          |
------------------------------------------------------------------------------*/
void IWindowPrivateData::unregisterCallbacks ( IWindow *win )
{
//  if ( !win->deleteIsInProcess() )
//  {
  if (win->isValid() )
  {
    IWindowHandle hwnd( win->handle() );
    if ( !((Widget)hwnd)->core.being_destroyed )
    {
      // destroy callback
      XtRemoveCallback(
         (Widget) hwnd,          // widget
         XmNdestroyCallback,          // callback name
         iwindowDestroyCallback,      // callback routine
         (XtPointer*)win);           // save reference to this IWindow in client
                                      // data
  
      // The following check is for object windows which are just a WMShell.
      // The WMShell widget does not have the XmNhelpCallback resource.
      if ( ( XtIsConstraint( (Widget)hwnd ) &&
               XmIsManager( (Widget)hwnd ) ) ||
           (!XtIsConstraint( (Widget)hwnd ) &&
               XmIsPrimitive( (Widget)hwnd) ))
      {
        // help callback
        XtRemoveCallback(
           (Widget)hwnd,          // widget
           XmNhelpCallback,             // callback name
           ihelpwindowCallback,         // callback routine
           (XtPointer*)win->id());
      }
   }
  
    // X event handler for all unmasked events, which includes client messages such as
    // ones representing ICommandEvents.
    XtRemoveEventHandler(
       (Widget) hwnd,         // widget
         ExposureMask               // ask for exposure (paint) events
       | VisibilityChangeMask,      //
// d7508
//     | StructureNotifyMask,       // ask for ConfigureNotify events
//     | FocusChangeMask,           // ask for FocusIn and FocusOut events
       True,                        // indicate we also want nonmaskable events
       iwindowXEventCallback,       // event handler routine
       (XtPointer*)win);           // save reference to this IWindow in client data

    // X event handler for focus events, which must be added to the primary handle.
    XtRemoveEventHandler(
       (Widget)hwnd,          // widget
       FocusChangeMask,             // ask for FocusIn and FocusOut events
       True,                        // indicate we also want nonmaskable events
       iwindowXEventCallback,       // event handler routine
       (XtPointer*)win);           // save reference to this IWindow in client data

    // d7508
    XtRemoveEventHandler(
       IWindowPrivateData::realSizeWidget( win ), // widget
       StructureNotifyMask,         // ask for ConfigureNotify events
       False,                       // indicate we also want nonmaskable events
       iwindowXEventCallback,       // event handler routine
       (XtPointer*)win);           // save reference to this IWindow in client data
  }
}

/*------------------------------------------------------------------------------
| IWindow::passEventToOwner                                                    |
|                                                                              |
| Returns whether the event should be passed to its owner or not. This will    |
| help simulate PM's behavior.                                                 |
------------------------------------------------------------------------------*/
bool IWindow::passEventToOwner( IEvent& event )
{
  return true;
}

/*------------------------------------------------------------------------------
| IWindow::convertToGUIStyle                                                   |
|                                                                              |
| Returns base/extended style for the underlying GUI.                          |
------------------------------------------------------------------------------*/
unsigned long IWindow::convertToGUIStyle ( const IBitFlag& guiStyle,
                                           bool bExtOnly ) const
{
  unsigned long ulStyle = 0;
  IWindow::Style& bitStyle = (IWindow::Style &) guiStyle;

  if (bExtOnly)
  {
     // Check for IWindow bidi styles.
     // Note that this code really belongs in
     // IWindow::create(...,const IBitFlag&,...), but it is here
     // for now because not all derived classes call that new
     // version of IWindow::create.
     if ( bitStyle & IWindow::rightToLeft )
     {
        pWindowData->fWindowDirection =
                       IWindowPrivateData::kRightToLeft;
     }
     else if ( bitStyle & IWindow::leftToRight )
     {
        pWindowData->fWindowDirection =
                       IWindowPrivateData::kLeftToRight;
     }
     else
     {
        pWindowData->fWindowDirection =
                       IWindowPrivateData::kDefaultDirection;
     }
  }
  else
  {
    if ( bitStyle & IWindow::visible )
      ulStyle |= WS_VISIBLE;
    if ( bitStyle & IWindow::disabled     )
      ulStyle |= WS_DISABLED;
    if ( bitStyle & IWindow::tabStop      )
      ulStyle |= WS_TABSTOP;
//    if ( bitStyle & IWindow::clipChildren )
//      ulStyle |= WS_CLIPCHILDREN;
//    if ( bitStyle & IWindow::clipSiblings )
//      ulStyle |= WS_CLIPSIBLINGS;
//    if ( bitStyle & IWindow::clipToParent )
//      ulStyle |= WS_PARENTCLIP;
//    if ( bitStyle & IWindow::saveBits     )
//      ulStyle |= WS_SAVEBITS;
//    if ( bitStyle & IWindow::group        )
//      ulStyle |= WS_GROUP;
//    if ( bitStyle & IWindow::synchPaint   )
//      ulStyle |= WS_SYNCPAINT;
  }
  return ulStyle;
}


/*------------------------------------------------------------------------------
|IXmMainWindow::getMainWindowChild                                             |
| Return the first child of parent that is a XmMainWindow, or zero.            |
------------------------------------------------------------------------------*/
Widget IXmMainWindow::getMainWindowChild( Widget parent )
{
//@@ typedef struct _MyClassRec
//@@  {
//@@   char* superclass;
//@@   String Class_name;
//@@  } MyClassRec;
//@@ typedef MyClassRec* MyClassPtr;

  Widget mainWindowChild = 0;
  WidgetList children = NULL;
  Cardinal numChildren = 0;
  XtVaGetValues ( parent,
                  XmNchildren, &children,
                  XmNnumChildren, &numChildren,
                  NULL);
  for (unsigned long i = 0; !mainWindowChild && i < numChildren; ++i )
  {
//@@   WidgetClass childClass = XtClass( children[i] );  //@@Rob.  just for debug.
//@@   MyClassPtr myPtr = (MyClassPtr)childClass;

   // d8175 - check for child being destroyed.
   // if ( XmIsMainWindow( children[i] ) )
    if ( !children[i]->core.being_destroyed && XmIsMainWindow( children[i] ) )
      mainWindowChild = children[i];
  }
  return mainWindowChild;
}

/*------------------------------------------------------------------------------
| IXmColor::setColor                                                           |
|                                                                              |
| Optionally set the background color, and then set the foreground color.      |
| See comments for IXmColor::setBackgroundColor.                               |
|                                                                              |
------------------------------------------------------------------------------*/
void IXmColor::setColor( Widget wid,
                         const bool  setBackground,
                         const Pixel backgroundColor,
                         const Pixel foregroundColor )
{
  if ( setBackground )
    XmChangeColor( wid, backgroundColor );
  else  //@@Rob. Remove this else later, as a separate defect.
    XtVaSetValues( wid, XmNforeground, foregroundColor, NULL );
}

/*------------------------------------------------------------------------------
| IXmColor::setBackgroundColor                                                 |
|                                                                              |
| Set the background color, but preserve the foreground color.                 |
| XmChangeColor make reasonable changes to foreground, top shadow,             |
| bottom shadow and select colors.  Our ICLUI interface only implements        |
| foreground and background.  Let the others be changed, but preserve the      |
| current foreground color, no matter how unreasonable, to keep the PM         |
| behaviour.                                                                   |
|                                                                              |
------------------------------------------------------------------------------*/
void IXmColor::setBackgroundColor( Widget wid, const Pixel backgroundColor )
{
  Pixel foregroundColor;
//@@Rob.  Do this later, as a separate defect.
// XtVaGetValues( wid, XmNforeground, &foregroundColor, NULL );
  XmChangeColor( wid, backgroundColor );
//@@Rob.  Do this later, as a separate defect.
// XtVaSetValues( wid, XmNforeground, foregroundColor, NULL );
}

/*------------------------------------------------------------------------------
| static IWindowPrivateData::mapXdt2PM.                                        |
|                                                                              |
| Map from X desktop coordinates to IWindow PM style coordinates.              |
| hWnd is used to determine the IWindow to map to.                             |
------------------------------------------------------------------------------*/
IPoint IWindowPrivateData::mapXdt2PM( const Position& xPos,
                                      const Position& yPos,
                                      const IWindowHandle& hWnd)
{
  //
  // Determine the IWindow the result will be relative to.
  // Treat null hWnd as the desktop.
  //
  Widget fromWidget = (Widget) hWnd;
  IWindow* win = 0;
  if ( fromWidget )
    win = IWindow::windowWithHandle ( hWnd );
  else
    win = IWindow::desktopWindow();
  //
  // Get a widget whose inner lower left corner is the origin of the IWindow.
  //
  Widget toWidget = IWindowPrivateData::realSizeWidget( win );
  //
  // Get its height and Motif origin in desktop coordinates.
  //
  Position toWidgetX=0, toWidgetY=0;
  Dimension toHeight;
  if ( !toWidget )
    toHeight = IWindow::desktopWindow()->size().height();
  else
  {
    XtTranslateCoords( toWidget, 0, 0, &toWidgetX, &toWidgetY );
    XtVaGetValues( toWidget,
                   XmNheight, &toHeight,
                   NULL );
  }
  //
  // Convert the Motif desktop coordinates to IWindow coordinates.
  //
  // d7541 - not yet
  // return IPoint( xPos - toWidgetX,
  //                toHeight-1 - (yPos - toWidgetY) );
  return IPoint( xPos - toWidgetX,
                toHeight - (yPos - toWidgetY) );
}

/*------------------------------------------------------------------------------
| static IWindowPrivateData::realSizeWidget                                    |
------------------------------------------------------------------------------*/
Widget IWindowPrivateData::realSizeWidget(const IWindow *win)
{
  //
  // The size of an IFrameWindow is the size of its main window widget, not
  // the shell.  It makes a difference when the MBCS input method status
  // area is appended to the bottom of the shell by the window manager, making
  // the shell height larger than the main window height.
  // The upper left corners of the shell and the main window must be the
  // same, so that we can get the position from the shell, and the size
  // from the main window.
  //
  Widget result = 0;
  if ( win )
   {
    result = win->handle();
    if ( win->isFrameWindow() )
     {
      Widget mainWindow = IXmMainWindow::getMainWindowChild( result );
      if (mainWindow)
        result = mainWindow;
     }
   }
  return result;
}

/*------------------------------------------------------------------------------
| static IWindowPrivateData::realSize                                          |
------------------------------------------------------------------------------*/
ISize IWindowPrivateData::realSize ( const IWindow *win )
{
  Widget theRealSizeWidget = realSizeWidget( win );
  if ( !theRealSizeWidget )
    return IWindow::desktopWindow()->size();

  Dimension height, width, borderWidth;
  XtVaGetValues( theRealSizeWidget,
               XmNheight, &height,
               XmNwidth,  &width,
               XmNborderWidth,  &borderWidth,
               NULL );
  return ISize( (width + 2*borderWidth), (height + 2*borderWidth) );
}

/*------------------------------------------------------------------------------
| static IWindowPrivateData::realPosition                                      |
|
| Note: this member function is only called after the widget has been realized |
------------------------------------------------------------------------------*/
IPoint IWindowPrivateData::realPosition ( const IWindow *win )
{
  Widget theRealSizeWidget = realSizeWidget( win );
  if ( !theRealSizeWidget )
    return IWindow::desktopWindow()->position();


  // the realized flag is set after we get the mapping notify. We don't
  // check motif XtIsRealized and mapped here because we need a chance
  // to place the control at its suggested location. That is done by the
  // the recohdr. The recohdr will call rect to find out where the control
  // should go. Once the control has been placed then we can use it's real
  // coordinate instead of the one save in window data.

  // There is also a case we need to be concerned with. The recoord
  // handler is added to the canvas and the frame. So we need the stored
  // location until our parent has been realized.
  if (ICoordinateSystem::applicationOrientation() !=
          ICoordinateSystem::nativeOrientation())
  {
    // check to see if our parent has been realized. If not then return
    // the stored position, otherwise return our real position.
    IWindow *fParent = win->parent();
    if ( fParent &&
         ( fParent != IWindow::desktopWindow() ) &&
         !(fParent->pWindowData->motifState & IWindowPrivateData::realized))
    {
      return win->pWindowData->windowPosition;
    }
  }

  Position x, y;
  Dimension height, borderWidth;
  XtVaGetValues( theRealSizeWidget,
                 XmNx, &x,
                 XmNy,  &y,
                 XmNheight, &height,
                 XmNborderWidth,  &borderWidth,
                 NULL );

  ISize parentSize = IWindowPrivateData::parentSize( win );

  if ( ICoordinateSystem::applicationOrientation() !=
         ICoordinateSystem::nativeOrientation() )
    return IPoint( x, parentSize.height() - y - (height+2*borderWidth) );

  return IPoint( x, y);
}

/*------------------------------------------------------------------------------
| static IWindowPrivateData::realRect                                          |
------------------------------------------------------------------------------*/
IRectangle IWindowPrivateData::realRect ( const IWindow *win )
{
  Widget theRealSizeWidget = realSizeWidget( win );
  if ( !theRealSizeWidget )
  {
    IWindow* theDesktop = IWindow::desktopWindow();
    return IRectangle( theDesktop->position(), theDesktop->size() );
  }

  Position x, y;
  Dimension height, width, borderWidth;
  XtVaGetValues( theRealSizeWidget,
               XmNx, &x,
               XmNy,  &y,
               XmNheight, &height,
               XmNwidth,  &width,
               XmNborderWidth,  &borderWidth,
               NULL );
  IRectangle theRealRectangle( IPoint(x,y),
                               ISize( width+2*borderWidth,
                                      height+2*borderWidth));

  if ( ICoordinateSystem::isConversionNeeded() )
  {
    ISize parentSize = IWindowPrivateData::parentSize( win );
    theRealRectangle =
        IRectangle(IPoint( x, parentSize.height() -y -(height+2*borderWidth)),
                   ISize( (width + 2*borderWidth), (height + 2*borderWidth) ));
  }
  return theRealRectangle;
}

/*------------------------------------------------------------------------------
| static IWindowPrivateData::parentSize                                        |
|                                                                              |
| Gets the parents Size.                                                       |
------------------------------------------------------------------------------*/
ISize IWindowPrivateData::parentSize ( const IWindow *win,
                                       bool mustBeReal )
{
  ISize pSize;
  IWindow *parent = win->parent();
  // All frame windows must be placed relative to the desktop
  if ( (parent != IWindow::desktopWindow()) && !win->isFrameWindow() )
  {
    IWindowHandle parentHandle;
    if ( parent )
    {
      if ( parent->isFrameWindow() )
      {
        if ( !XmIsScrollBar( (Widget) win->handle() ) )
// d6993
//          // use handle instead of handle for frame's. This still needs
          // use handle instead of the main window for frame's. This still needs
          // to be fixed. Unless of course the scroll bar is one of the main
          // window's areas.
          parentHandle = parent->handle();
        else
        {
          // if this widgets parent is a frame window and this widget is a
          // scroll bar then we need to check to see if the scroll bar
          // belongs to the main window. If the scroll bar belongs to the
          // belongs to the main window then it's parentSize is the size of
          // the shell, otherwise it's parent size is the size of the form.
          Widget hScroll, vScroll;
          XtVaGetValues( XtParent( (Widget ) parent->handle() ),
            XmNhorizontalScrollBar, &hScroll,
            XmNverticalScrollBar, &vScroll,
            NULL );
          if ( hScroll == win->handle() || vScroll == win->handle() )
            // d6993
            parentHandle = realSizeWidget(parent);
          else
            parentHandle = parent->handle();
        }
      }
      else
      {
          parentHandle = parent->handle();
      }
    }
    else
      parentHandle = XtParent( (Widget) win->handle() );
    if ( mustBeReal || ( parent && parent->isFrameWindow() ))
    {
      Dimension width, height;
      XtVaGetValues( (Widget) parentHandle,
        XmNwidth, &width,
        XmNheight, &height,
        NULL );
      // This size is used to place controls relative to the parent
      //   so don't include the border
      pSize = ISize( width, height );
    }
    else
    {
      if ( parent )
        pSize = parent->size( );
    }
  }
  else
    pSize = IWindow::desktopWindow()->size();
  return pSize;
}

/*------------------------------------------------------------------------------
| static IWindowPrivateData::processPendingMsgs                                |
|                                                                              |
| Process pending X events.                                                    |
------------------------------------------------------------------------------*/
void IWindowPrivateData::processPendingMsgs ( )
{
  IMODTRACE_ALL("IWindowPrivateData::processPendingMsgs");
  bProcessMsgsNoWait = true;
  IThread::current().processMsgs();
}

/*------------------------------------------------------------------------------
| getXColor                                                                    |
|                                                                              |
| Returns an IColor object corresponding to Pixel value colorArea using the    |
| default colormap for the specified widget w.  If w is null, a default color  |
| is returned.                                                                 |
------------------------------------------------------------------------------*/
IColor getXColor ( Pixel colorArea, Widget w )
{
#ifdef IC_TRACE_ALL
   // Debugging code for color map.
   Colormap colormap(0);
   XtVaGetValues( w, XmNcolormap, &colormap, 0);
   Colormap defaultColorMap = IApplication::current().colorMap().nativeColorMap();
   if (colormap != defaultColorMap)
   {
      IString wcname(XtClass( w )->core_class.class_name );
      ITRACE_DEVELOP( IString("Colormap mismatch colormap=") +
                      IString(colormap).d2x() +
                      IString(" defaultColorMap=") +
                      IString(defaultColorMap).d2x() +
                      IString(" class=") + wcname.asString()  );

   }
   XColor xColor;
   xColor.pixel = colorArea;
   Display *display = XtDisplay( w );
   XQueryColor( display, colormap ,&xColor );
   IColor widgetColor( (unsigned char)(xColor.red >> 8),
                       (unsigned char)(xColor.green >> 8),
                       (unsigned char)(xColor.blue >> 8) );
   IColor colorMapColor (colorArea, &IApplication::current().colorMap() );
   if (widgetColor.asRGBLong() != colorMapColor.asRGBLong() )
   {
      ITRACE_DEVELOP( IString("pixel=") +
                      IString(colorArea) +
                      IString(" widgetColor RGB=") +
                      IString( widgetColor.asRGBLong() ).d2x() +
                      IString(" colorMapColor RGB=") +
                      IString( colorMapColor.asRGBLong() ).d2x() );
   }
#endif //IC_TRACE_ALL

  return IColor( colorArea, &IApplication::current().colorMap() );
}

/*------------------------------------------------------------------------------
| IWindow::foregroundColor                                                     |
------------------------------------------------------------------------------*/
IColor IWindow::foregroundColor ( ) const
{
  Pixel colorArea;
  XtVaGetValues( handle(),
                 XmNforeground, &colorArea,
                 NULL );
  return getXColor( colorArea, handle() );
}

/*------------------------------------------------------------------------------
| IWindow::backgroundColor                                                     |
------------------------------------------------------------------------------*/
IColor IWindow::backgroundColor ( ) const
{
  Pixel colorArea;
  XtVaGetValues( handle(),
                 XmNbackground, &colorArea,
                 NULL );
  return getXColor( colorArea, handle() );
}
