// Revision: 28 1.12.1.8 source/ui/basectl/ibmpctl.cpp, staticctls, ioc.v400, 990114 
/*******************************************************************************
* FILE NAME: ibmpctl.cpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in ibmpctl.hpp.                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

// #define IC_TRACE_ALL

#pragma priority( -2147481524 )

extern "C" {
  #define INCL_WINERRORS            // PMERR_HEAP_MAX_SIZE_REACHED
  #define INCL_WINSTATICS           // SS_xxx
  #define INCL_GPIBITMAPS
  #define INCL_WINSYS
  #include <iwindefs.h>
}

#ifdef IC_MOTIF
  #include <Xm/XmStrDefs.h>
#endif

#include <ibase.hpp>
#include <ibmpctl.hpp>
#include <ibmphdr.hpp>
#include <ibmpstat.hpp>
#ifdef IC_MOTIF
  #include <icustbdd.hpp>
#endif //IC_MOTIF
#include <icconst.h>
#include <idefstyl.h>
#include <iexcept.hpp>
#include <ifont.hpp>
#include <ihandle.hpp>
#include <iimage.hpp>
#include <ipoint.hpp>
#include <irect.hpp>
#include <ireslib.hpp>
#include <istring.hpp>
#include <iwcname.hpp>
#include <ithread.hpp>
#include <itrace.hpp>


// Segment definitions
#ifdef IC_PAGETUNE
  #define _IBMPCTL_CPP_
  #include <ipagetun.h>
#endif


/***************************************************************/
/* Public bitmap styles.                                       */
/***************************************************************/
const IBitmapControl::Style
#if (IC_OBSOLETE <= IC_OBSOLETE_3)
  IBitmapControl::sizeToBitmap      (1, IBitmapControl__sizeToBitmap     ),
#endif // IC_OBSOLETE
  IBitmapControl::sizeImageToWindow (1, IBitmapControl__sizeImageToWindow),
  IBitmapControl::sizeWindowToImage (1, IBitmapControl__sizeWindowToImage),
  IBitmapControl::classDefaultStyle (2, IBitmapControl__classDefaultStyle);


/***************************************************************/
/* Default style for new objects (initial value).              */
/***************************************************************/
IBitmapControl::Style
  IBitmapControl::currentDefaultStyle(2, IBitmapControl__classDefaultStyle);

/*------------------------------------------------------------------------------
| Private data for IBitmapControl                                              |
------------------------------------------------------------------------------*/
#pragma enum(4)
#pragma pack(push,4)

class IBitmapControlData {
public:
   IBitmapControlData();
   ~IBitmapControlData();
IBitmapHandler
   fdefaultHandler;
bool
  fsizeImageToWindow,
  fsizeWindowToImage;
};

#pragma pack(pop)
#pragma enum(pop)

/*------------------------------------------------------------------------------
| IBitmapControlData::IBitmapControlData                                       |
------------------------------------------------------------------------------*/
IBitmapControlData::IBitmapControlData()
  : fdefaultHandler(),
    fsizeImageToWindow (false),
    fsizeWindowToImage (false)
{}

/*------------------------------------------------------------------------------
| IBitmapControlData::~IBitmapControlData                                      |
------------------------------------------------------------------------------*/
IBitmapControlData::~IBitmapControlData()
{}


/*------------------------------------------------------------------------------
| IBitmapControl::IBitmapControl                                               |
------------------------------------------------------------------------------*/
IBitmapControl::IBitmapControl(unsigned long      ulId,
                               IWindow*           pwndParent,
                               IWindow*           pwndOwner,
                               const IResourceId& bmpId,
                               const IRectangle&  rectInit,
                               const Style&       bmsStyle)
                    : IStaticText(ulId,pwndParent,pwndOwner, rectInit,
                        IWindow::noStyle),
                     fBitmapControlData( new IBitmapControlData ),
                     bmpHandle(0), returnback(false)
{
  // assertions on input parms
  IASSERTPARM(pwndParent!=0);
  initialize(bmsStyle);
  setBitmap(bmpId);               // load and set bitmap
  if (bmsStyle & IWindow::visible)
  {
     show();
#ifdef IC_PMWIN
     refresh(IWindow::immediate);
#endif //IC_PMWIN
  }
}

/*------------------------------------------------------------------------------
| IBitmapControl::IBitmapControl                                               |
------------------------------------------------------------------------------*/
IBitmapControl::IBitmapControl(unsigned long        ulId,
                               IWindow*             pwndParent,
                               IWindow*             pwndOwner,
                               const IBitmapHandle& bmpId,
                               const IRectangle&    rectInit,
                               const Style&         bmsStyle)
                    : IStaticText(ulId,pwndParent,pwndOwner, rectInit,
                        IWindow::noStyle),
                     fBitmapControlData( new IBitmapControlData ),
                     bmpHandle(0), returnback(false)
{
  // assertions on input parms
  IASSERTPARM(pwndParent!=0);

  initialize(bmsStyle);
  setBitmap(bmpId);               // load and set bitmap
  if (bmsStyle & IWindow::visible)
  {
     show();
#ifdef IC_PMWIN
     refresh(IWindow::immediate);
#endif //IC_PMWIN
  }
}

/*------------------------------------------------------------------------------
| IBitmapControl::IBitmapControl                                               |
------------------------------------------------------------------------------*/
IBitmapControl::IBitmapControl(unsigned long     ulId,
                               IWindow*          pwndParent,
                               IWindow*          pwndOwner,
                               unsigned long     bmpId,
                               const IRectangle& rectInit,
                               const Style&      bmsStyle)
                    : IStaticText(ulId,pwndParent,pwndOwner, rectInit,
                        IWindow::noStyle),
                     fBitmapControlData( new IBitmapControlData ),
                     bmpHandle(0), returnback(false)
{
  // assertions on input parms
  IASSERTPARM(pwndParent!=0);
  initialize(bmsStyle);
  setBitmap(bmpId);               // load and set bitmap
  if (bmsStyle & IWindow::visible)
  {
     show();
#ifdef IC_PMWIN
     refresh(IWindow::immediate);
#endif //IC_PMWIN
  }
}

/*------------------------------------------------------------------------------
| IBitmapControl::IBitmapControl                                               |
------------------------------------------------------------------------------*/
IBitmapControl::IBitmapControl(unsigned long                     ulId,
                                 IWindow*                        pwndParent,
                                 IWindow*                        pwndOwner,
                                 ISystemBitmapHandle::Identifier bmp,
                                 const IRectangle&               rectInit,
                                 const Style&                    bmsStyle)
                    : IStaticText(ulId,pwndParent,pwndOwner,rectInit,
                        IWindow::noStyle),
                      fBitmapControlData( new IBitmapControlData ),
                      bmpHandle(0), returnback(false)
{
  // assertions on input parms
  IASSERTPARM(pwndParent!=0);
  initialize(bmsStyle);
  setBitmap(bmp);                 // associate with control
  if (bmsStyle & IWindow::visible)
  {
     show();
#ifdef IC_PMWIN
     refresh(IWindow::immediate);
#endif //IC_PMWIN
  }
}

/*------------------------------------------------------------------------------
| IBitmapControl::IBitmapControl                                               |
|  Instantiate a bitmap object for a template window.                          |
------------------------------------------------------------------------------*/
IBitmapControl::IBitmapControl(unsigned long ulId,
                               IWindow*      pdlgwndParent)
                    : IStaticText(ulId,pdlgwndParent),
                      fBitmapControlData( new IBitmapControlData ),
                      bmpHandle(0), returnback(true)
{
  unsigned long ulStyle = style();
  IBitmapHandle bmp;
  disableFillBackground();
  enableSizeWindowToImage( true );
  enableSizeImageToWindow( false );

#ifdef IC_PMWIN
  #ifdef IC_PM
    IEventResult evt = handle().sendEvent(SM_QUERYHANDLE,
                                          IEventParameter1(0),
                                          IEventParameter2(0));
    bmp = evt.asUnsignedLong();
    ulStyle &= ~SS_BITMAP;
    ulStyle |=  SS_TEXT;
  #endif

  #ifdef IC_WIN
    IEventResult evt = handle().sendEvent(STM_GETIMAGE,
                                          IEventParameter1(IMAGE_BITMAP),
                                          IEventParameter2(0));
    bmp = (HBITMAP)evt.asUnsignedLong();
    ulStyle &= (unsigned long)~SS_TYPEMASK;
    ulStyle |=  SS_LEFT;          //we paint it ourselves
  #endif

  setStyle(ulStyle);
  // Insure that the base class default handler is added first.  It must
  // be after the IBitmapControl in the handler list for correct function.
  this->addDrawingHandler();
  fBitmapControlData->fdefaultHandler.handleEventsFor(this);
#endif //IC_PMWIN

#ifdef IC_MOTIF
  initialize( IBitmapControl::classDefaultStyle );
  unsigned char labelType;
  Pixmap backgroundPixmap, labelPixmap;
  XtVaGetValues(handle(),
                XmNlabelType, &labelType,
                XmNlabelPixmap, &labelPixmap,
                XmNbackgroundPixmap, &backgroundPixmap,
                NULL);

  if (labelType == XmPIXMAP)
  {
    XtVaSetValues(handle(),
                  XmNlabelType, XmSTRING,
                  0);
  }
  bmp = (labelType == XmPIXMAP) ? labelPixmap : backgroundPixmap;
#endif //IC_MOTIF

  setBitmap(bmp);
}


/*------------------------------------------------------------------------------
| IBitmapControl::IBitmapControl                                               |
|  Constructor to instantiate from an existing bitmap control.                 |
------------------------------------------------------------------------------*/
IBitmapControl::IBitmapControl(const IWindowHandle& wh)
                    : IStaticText(wh),
                      fBitmapControlData( new IBitmapControlData ),
                      returnback(true)
{
  unsigned long ulStyle = style();
  IBitmapHandle bmp;
  disableFillBackground();
  enableSizeWindowToImage( true );
  enableSizeImageToWindow( false );

#ifdef IC_PMWIN
  #ifdef IC_PM
    if (ulStyle & (SS_BITMAP & ~SS_TEXT))
    {
       IEventResult evt = handle().sendEvent(SM_QUERYHANDLE,
                                             IEventParameter1(0),
                                             IEventParameter2(0));
       bmp = (HBITMAP)evt.asUnsignedLong();
    } /* endif */
    ulStyle &= ~SS_BITMAP;
    ulStyle |=  SS_TEXT;
  #endif
  #ifdef IC_WIN
    if ((ulStyle & SS_TYPEMASK) == SS_BITMAP)
    {
       IEventResult evt = handle().sendEvent(STM_GETIMAGE,
                                             IEventParameter1(IMAGE_BITMAP),
                                             IEventParameter2(0));
       bmp=(HBITMAP)evt.asUnsignedLong();
    } /* endif */
    ulStyle &= (unsigned long)~SS_TYPEMASK;
    ulStyle |=  SS_LEFT;
  #endif

  setStyle(ulStyle);
  // Insure that the base class default handler is added first.  It must
  // be after the IBitmapControl in the handler list for correct function.
  this->addDrawingHandler();
  fBitmapControlData->fdefaultHandler.handleEventsFor(this);
#endif //IC_PMWIN

#ifdef IC_MOTIF
  initialize( IBitmapControl::classDefaultStyle );

  unsigned char labelType;
  Pixmap backgroundPixmap, labelPixmap;
  XtVaGetValues(handle(),
                XmNlabelType, &labelType,
                XmNlabelPixmap, &labelPixmap,
                XmNbackgroundPixmap, &backgroundPixmap,
                NULL);
  if (labelType == XmPIXMAP)
  {
    XtVaSetValues(handle(),
                  XmNlabelType, XmSTRING,
                  NULL);
  }
  bmp = (labelType == XmPIXMAP) ? labelPixmap : backgroundPixmap;
#endif  //IC_MOTIF

  setBitmap(bmp);
}

/*------------------------------------------------------------------------------
| IBitmapControl::~IBitmapControl                                              |
------------------------------------------------------------------------------*/
IBitmapControl::~IBitmapControl ( )
{
#ifdef IC_PMWIN
    if (returnback && isValid())
    {
       // Restore styles for unwrappered control.
       try
       {
          unsigned long ulStyle = style();
#ifdef IC_PM
          ulStyle &= (SS_BITMAP | ~SS_TEXT);
          setStyle(ulStyle);
          handle().sendEvent(SM_SETHANDLE, IEventParameter1(bmpHandle),
                                           IEventParameter2(0));
#endif
#ifdef IC_WIN
          ulStyle = (unsigned long)
             ((ulStyle & (unsigned long)~SS_TYPEMASK) | SS_BITMAP) ;
          setStyle(ulStyle);
          handle().sendEvent(STM_SETIMAGE, IEventParameter1(IMAGE_BITMAP),
                                           IEventParameter2(bmpHandle));
#endif
       } catch (IException&) {}
    }
#endif // IC_PMWIN
    fBitmapControlData->fdefaultHandler.stopHandlingEventsFor(this);
    delete  fBitmapControlData;
}

/*------------------------------------------------------------------------------
| IBitmapControl::Style  IBitmapControl::defaultStyle                          |
------------------------------------------------------------------------------*/
IBitmapControl::Style  IBitmapControl::defaultStyle()
{
  return currentDefaultStyle;
}


/*------------------------------------------------------------------------------
| IBitmapControl::setDefaultStyle                                              |
------------------------------------------------------------------------------*/
void  IBitmapControl::setDefaultStyle(const IBitmapControl::Style&
                                                        bmsStyle)
{
  currentDefaultStyle = bmsStyle;
}

/*------------------------------------------------------------------------------
| IBitmapControl::convertToGUIStyle                                            |
|                                                                              |
| Returns base style for the control by default, or extended style if          |
| extended flag (bExtOnly) is set.                                             |
------------------------------------------------------------------------------*/
unsigned long IBitmapControl::convertToGUIStyle(const IBitFlag& guiStyle,
                                                bool bExtOnly) const
{
  // Obtain the style from the class (IStaticText) that we inherit from
  unsigned long ulStyle = Inherited::convertToGUIStyle( guiStyle, bExtOnly );

  if (!bExtOnly)
  {
    // Insure SS_BITMAP is off and add the static text style.
    ulStyle &= ~SS_BITMAP;
#ifdef IC_PM
    ulStyle |= SS_TEXT;
#endif
#ifdef IC_WIN
    // We use SS_LEFT so that text can be placed in the control.  We paint
    // both the bitmap and text.
    ulStyle |= SS_LEFT | WS_CHILD;
#endif
  }

  return( ulStyle );
}


/*------------------------------------------------------------------------------
| IBitmapControl::setBitmap                                                    |
------------------------------------------------------------------------------*/
IBitmapControl& IBitmapControl::setBitmap(const IResourceId& bmpId)
{
  setBitmap(bmpId.resourceLibrary().loadBitmap(bmpId));
  return *this;
}


/*------------------------------------------------------------------------------
| IBitmapControl::setBitmap                                                    |
------------------------------------------------------------------------------*/
IBitmapControl& IBitmapControl::setBitmap(unsigned long bmpId)
{

  setBitmap(IResourceId(bmpId));
  return *this;
}


/*------------------------------------------------------------------------------
| IBitmapControl::setBitmap                                                    |
------------------------------------------------------------------------------*/
IBitmapControl&  IBitmapControl::setBitmap(const IBitmapHandle& bitmapHandle)
{
  IMODTRACE_ALL("IBitmapControl::setBitmap");
  bool needRefresh =
     ((IBitmapHandle::Value)bmpHandle == (IBitmapHandle::Value)bitmapHandle) ?
     false : true;

  ITRACE_ALL(IString("bmpHandle=") +
             IString((unsigned long)(IBitmapHandle::Value)bitmapHandle).d2x() );
  bmpHandle = bitmapHandle;        // set instance variable
  setLayoutDistorted(IWindow::minimumSizeChanged,0);
  if (isSizeWindowToImageEnabled() && needRefresh)
     sizeTo( calcMinimumSize() );

  if (needRefresh)
  {
     refresh();
  }

  return *this;
}


/*------------------------------------------------------------------------------
| IBitmapControl::setBitmap                                                    |
------------------------------------------------------------------------------*/
IBitmapControl& IBitmapControl::setBitmap(ISystemBitmapHandle::Identifier bmp)
{
  setBitmap(ISystemBitmapHandle(bmp));
  return *this;
}



/*------------------------------------------------------------------------------
| IBitmapControl::bitmap                                                       |
------------------------------------------------------------------------------*/
IBitmapHandle  IBitmapControl::bitmap() const
{
  return bmpHandle;
}


/*------------------------------------------------------------------------------
| IBitmapControl::calcMinimumSize                                              |
|  Calculate the minimum screen size needed by the control                     |
|  which is based on the bitmap size.                                          |
------------------------------------------------------------------------------*/
ISize  IBitmapControl::calcMinimumSize() const
{
  ISize minSize = Inherited::calcMinimumSize();

  if ( this->bitmap() )
  {
     IGImage image( this->bitmap() );
     IPoint siz = image.rasterBounds().size();
     minSize = minSize.maximum( ISize( siz.x(), siz.y()) );
  }
  return minSize;
}


/*------------------------------------------------------------------------------
| IBitmapControl::initialize                                                   |
------------------------------------------------------------------------------*/
IBitmapControl&  IBitmapControl::initialize(const Style& style)
{
  // Save the extended style to make sure we have a copy of it stored
  setExtendedStyle( extendedStyle() | style.asExtendedUnsignedLong() );

#ifdef IC_PMWIN
  // Insure that the base class default handler is added first.  It must
  // be after the IBitmapControl in the handler list for correct function.
  this->addDrawingHandler();
#endif //IC_PMWIN
#ifdef IC_MOTIF
  // Install window data for use by the default handler.
  this->adoptWindowData( ICustomButtonDrawData::dataHandle(),
                         new ICustomButtonDrawData );
#endif //IC_MOTIF

  fBitmapControlData->fdefaultHandler.handleEventsFor( this );

  if (style & IBitmapControl::sizeImageToWindow)
     enableSizeImageToWindow( true );
  if ((style & IBitmapControl::sizeWindowToImage)
#if (IC_OBSOLETE <= IC_OBSOLETE_3)
      || (style & IBitmapControl::sizeToBitmap)
#endif // IC_OBSOLETE
      )
     enableSizeWindowToImage( true );

#ifdef IC_PMWIN
  unsigned long ulStyle = convertToGUIStyle( style );
 #ifdef IC_PM
  // fillBackground is an extended style in Win ... don't need this
  if (ulStyle & IStaticText::fillBackground.asUnsignedLong())
     ulStyle &= (~IStaticText::fillBackground.asUnsignedLong());
 #endif
  if (ulStyle & IWindow::visible.asUnsignedLong())
     ulStyle &= (~IWindow::visible.asUnsignedLong());

  setStyle(ulStyle);
#endif //IC_PMWIN

  return( *this );
}

/*------------------------------------------------------------------------------
| IBitmapControl::setLayoutDistorted                                           |
------------------------------------------------------------------------------*/
IBitmapControl& IBitmapControl::setLayoutDistorted
                                  ( unsigned long layoutAttributesOn,
                                    unsigned long layoutAttributesOff )
{
#ifdef IC_PM
  if (( layoutAttributesOn &  IWindow::colorChanged ) && this->parent())
  {

    IWindowClassName cname(this->parent()->handle());
    if ( cname == WC_BUTTON )
    {
       // We must be on a graphic push button, so propagate the color
       // change to the button
       if ( this->backgroundColor() != parent()->backgroundColor() )
         parent()->setBackgroundColor(this->backgroundColor());
    }
  }
  if (( layoutAttributesOn &  IWindow::fontChanged ) && this->parent())
  {
    IWindowClassName cname(this->parent()->handle());
    if ( cname == WC_BUTTON )
    {
       // We must be on a graphic push button, so propagate the font
       // change to the button
       IFont fnt(this);
       IFont fnt2(parent());
       if (( fnt.name() !=  fnt2.name() ) ||
           ( fnt.pointSize() != fnt2.pointSize() ))
       {
         parent()->setFont(fnt);
       }
    }
  }
#endif
  Inherited::setLayoutDistorted(layoutAttributesOn,layoutAttributesOff);
  return *this;
}

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IBitmapControl::moveSizeTo                                                   |
------------------------------------------------------------------------------*/
IBitmapControl& IBitmapControl::moveSizeTo ( const IRectangle& aRectangle )
{
  // Override no longer needed.
  Inherited::moveSizeTo (aRectangle);
  return *this;
}
#endif

/*------------------------------------------------------------------------------
| IBitmapControl::enableSizeImageToWindow                                      |
------------------------------------------------------------------------------*/
IBitmapControl& IBitmapControl::enableSizeImageToWindow  ( bool enable )
{
   bool needRefresh (
      ( this->fBitmapControlData->fsizeImageToWindow && !enable ) ||
      ( !this->fBitmapControlData->fsizeImageToWindow && enable ) );
   this->fBitmapControlData->fsizeImageToWindow = enable;
   if (needRefresh)
      this->refresh();
   return *this;
}

/*------------------------------------------------------------------------------
| IBitmapControl::disableSizeImageToWindow                                     |
------------------------------------------------------------------------------*/
IBitmapControl& IBitmapControl::disableSizeImageToWindow ( )
{
   return this->enableSizeImageToWindow( false );
}

/*------------------------------------------------------------------------------
| IBitmapControl::isSizeImageToWindowEnabled                                   |
------------------------------------------------------------------------------*/
bool  IBitmapControl::isSizeImageToWindowEnabled( ) const
{
  return this->fBitmapControlData->fsizeImageToWindow;
}

/*------------------------------------------------------------------------------
| IBitmapControl::enableSizeWindowToImage                                      |
------------------------------------------------------------------------------*/
IBitmapControl& IBitmapControl::enableSizeWindowToImage  ( bool enable )
{
   // Do not do a refresh here because this setting only affects subsequent
   // image changes.
   this->fBitmapControlData->fsizeWindowToImage = enable;
   return *this;
}

/*------------------------------------------------------------------------------
| IBitmapControl::disableSizeWindowToImage                                     |
------------------------------------------------------------------------------*/
IBitmapControl& IBitmapControl::disableSizeWindowToImage ( )
{
   return this->enableSizeWindowToImage( false );
}

/*------------------------------------------------------------------------------
| IBitmapControl::isSizeWindowToImageEnabled                                   |
------------------------------------------------------------------------------*/
bool  IBitmapControl::isSizeWindowToImageEnabled( ) const
{
   return this->fBitmapControlData->fsizeWindowToImage;
}

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IBitmapControl::enable                                                       |
|                                                                              |
| Enable the object to accept input.  This override provided to force a        |
| refresh of the graphic image.                                                |
------------------------------------------------------------------------------*/
IWindow& IBitmapControl::enable ( bool bEnable )
{
  // First check to see if we need to do anything.  If not, return.
  // This has the effect of NOT performing unnecessary drawing.
  if ( bEnable && isEnabled() )
     return *this;
  else if ( !bEnable && !isEnabled() )
     return *this;

  // Set the enabled state in the usual way.
  Inherited::enable( bEnable );

  // Refresh the image.
  refresh();
  return *this;
}
#endif //IC_MOTIF
