// Revision: 51 1.32.1.42 source/ui/basectl/icombobs.cpp, listctls, ioc.v400, 990114 
/*******************************************************************************
* FILE NAME: icombobs.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in icombobs.hpp.                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#pragma priority( -2147481524 )

/**********************************************************************/
/* Need IC_USE_CB defined before iwindefs since Windows macros are    */
/* different if processing listboxes that are part of comboboxes      */
/**********************************************************************/
extern "C" {
  #define INCL_WINENTRYFIELDS       // ES_xxx, CBS_xxx, CBID_EDIT
  #define INCL_WINERRORS            // PMERR_HEAP_MAX_SIZE_REACHED
  #define INCL_WININPUT
  #define INCL_WINLISTBOXES         // LS_HORZSCROLL
  #define INCL_WINMESSAGEMGR        // For WM_PRESPARAMCHANGED.
  #define INCL_NLS                  // ES_ANY, ES_SBCS, ES_DBCS, ES_MIXED
  #define INCL_WINWINDOWMGR         // WinQueryClassName
  #define INCL_WINSYS               // SV_CYBORDER, PP_FONTNAMESIZE, etc.
  #define INCL_GPICONTROL           // From ILISTBX2.HPP
  #define INCL_GPILCIDS             //
  #define INCL_GPILOGCOLORTABLE     //
  #define INCL_GPIPRIMITIVES        //

  #include <iwindefs.h>
  #include <icombobx.h>
  #include <stdlib.h>            // atoi
  #include <string.h>
}

#ifdef IC_MOTIF
  #include <X11/IntrinsicP.h>     // for CoreP.h
  #include <X11/CoreP.h>          // for core.being_destroyed
  #include <Xm/List.h>
  #include <Xm/Form.h>
  #include <Xm/Text.h>
  #include <Xm/ArrowB.h>
  #include <Xm/ScrolledW.h>
#endif

#include <inotifev.hpp>
#include <icombobs.hpp>
#include <icmbxprv.hpp>

#include <iapp.hpp>
#include <ibidiset.hpp>
#include <icconst.h>
#include <icolor.hpp>
#include <icoordsy.hpp>
#include <ictlevt.hpp>
#include <iexcept.hpp>
#include <ifont.hpp>
#include <ihandle.hpp>
#include <iinhratt.hpp>
#include <ilistbox.hpp>
#include <imphdr.hpp>
#include <iplatfrm.hpp>
#include <ireslib.hpp>
#include <istring.hpp>
#include <itrace.hpp>
#include <iwcname.hpp>
#include <ilanglvl.hpp>

#ifdef IC_MOTIF
  #include <iedithdr.hpp>
  #include <ikeyhdr.hpp>
  #include <iselhdr.hpp>
  #include <ilistprv.hpp>
  #include <isizrect.hpp>
  #include <isizehdr.hpp>
  #include <ixdc.hpp>
#endif

// Segment definitions
#ifdef IC_PAGETUNE
  #define _ICOMBOBS_CPP_
  #include <ipagetun.h>
#endif

#ifdef IC_MOTIF
void _System icbShellCallback(Widget w,
			   XtPointer pClientData,
			   XEvent *event,
			   bool *ContDispatch);

bool _System icbDelayedFocusOutWorkProc(XtPointer pClientData);

/*------------------------------------------------------------------------------
| Convenience function for getting IColor from colormap.                       |
------------------------------------------------------------------------------*/
static IColor getXColor ( Pixel colorArea, Widget w );
#endif //IC_MOTIF

/******************************************************************************/
/* Public combobox styles.                                                    */
/******************************************************************************/
const IBaseComboBox::Style
  IBaseComboBox::simpleType           = CBS_SIMPLE,
  IBaseComboBox::dropDownType         = CBS_DROPDOWN,
  IBaseComboBox::horizontalScroll     = LS_HORZSCROLL,
#ifdef IC_MOTIF
  IBaseComboBox::border3D             ( 0 ),
#endif
#ifdef IC_PMWIN
  IBaseComboBox::border3D             ( 0, IWS_BORDER3D ),
#endif
#ifdef IC_WIN
  IBaseComboBox::readOnlyDropDownType ( 0, ICBS_DROPDOWNLIST ),
  IBaseComboBox::oemData              = CBS_OEMCONVERT,
  IBaseComboBox::autoScroll           = CBS_AUTOHSCROLL,
#endif
#ifdef IC_PM
  IBaseComboBox::readOnlyDropDownType = CBS_DROPDOWNLIST,
  IBaseComboBox::anyData              ( 0, IES_ANYDATA ),
  IBaseComboBox::sbcsData             = ES_SBCS,
  IBaseComboBox::dbcsData             = ES_DBCS,
  IBaseComboBox::mixedData            ( 0, IES_MIXEDDATA ),
  IBaseComboBox::autoScroll           ( 0 ),
#endif
#ifdef IC_MOTIF
  IBaseComboBox::readOnlyDropDownType (CBS_DROPDOWNLIST),
  IBaseComboBox::anyData              (0, IES_ANYDATA),
  IBaseComboBox::sbcsData             (ES_SBCS),
  IBaseComboBox::dbcsData             (ES_DBCS),
  IBaseComboBox::mixedData            (0, IES_MIXEDDATA),
#endif
#ifdef IC_PM
  IBaseComboBox::classDefaultStyle ( (WS_VISIBLE | CBS_SIMPLE),
				     IES_ANYDATA | IWS_BORDER3D );
#endif
#ifdef IC_WIN
  IBaseComboBox::classDefaultStyle ( (WS_VISIBLE | CBS_SIMPLE | CBS_AUTOHSCROLL),
				     IES_ANYDATA | IWS_BORDER3D );
#endif
#ifdef IC_MOTIF
  IBaseComboBox::classDefaultStyle( (WS_VISIBLE | CBS_SIMPLE ),
				     IES_ANYDATA );
#endif

const unsigned long    IBaseComboBox::notFound = (unsigned long)ULONG_MAX;
const unsigned long    IBaseComboBox::first    = (unsigned long)ULONG_MAX;

/******************************************************************************/
/* Default style for new objects (initial value)                              */
/******************************************************************************/
#ifdef IC_PM
IBaseComboBox::Style
  IBaseComboBox::currentDefaultStyle ( (WS_VISIBLE | CBS_SIMPLE),
				       IES_ANYDATA | IWS_BORDER3D );
#endif
#ifdef IC_WIN
IBaseComboBox::Style
  IBaseComboBox::currentDefaultStyle ( (WS_VISIBLE | CBS_SIMPLE | CBS_AUTOHSCROLL),
				       IES_ANYDATA | IWS_BORDER3D );
#endif
#ifdef IC_MOTIF
IBaseComboBox::Style
  IBaseComboBox::currentDefaultStyle( (WS_VISIBLE | CBS_SIMPLE ),
				      IES_ANYDATA );
#endif


#ifdef IC_WIN
#pragma enum(4)
#pragma pack(push,4)

class IBaseComboHandler : public IHandler {
typedef IHandler
  Inherited;
public:

/*------------------------------- Constructors -------------------------------*/
  IBaseComboHandler ( );

virtual
  ~IBaseComboHandler ( );

/*----------------------------- Event Processing -----------------------------*/
virtual bool
  dispatchHandlerEvent ( IEvent& event );

}; // class IBaseComboHandler

#pragma pack(pop)
#pragma enum(pop)
#endif //IC_WIN

#ifdef IC_MOTIF
#pragma enum(4)
#pragma pack(push,4)
class IBaseComboHandler : public IEditHandler,
			 public IKeyboardHandler,
			 public ISelectHandler,
			 public IResizeHandler
{
public:
/*------------------------------- Constructor ----------------------------------
| The only way to construct instances of this class is to use the default      |
| constructor, which does not take any arguments.                              |
------------------------------------------------------------------------------*/

  IBaseComboHandler();
  virtual ~IBaseComboHandler();


  /*----------------------------- Event Processing -----------------------------*/
  virtual bool
    dispatchHandlerEvent ( IEvent& event );

protected:
/*-------------------------------- Overrides -----------------------------------
| These inherited functions are overridden:                                    |
|   enter -             Process the enter events for the listbox.              |
|   selected -          Process the selection events for the listbox.          |
|   virtualKeyPress -   Process the virtual up and down keys for the entry     |
|                       field.                                                 |
|   edit -              Process the entry field keystrokes for a prefix match  |
|                       in the listbox.                                        |
/   windowResize -      Process the resize of the combobox                     /
------------------------------------------------------------------------------*/
virtual bool
  enter (IControlEvent& event),
  selected (IControlEvent& event),
  virtualKeyPress (IKeyboardEvent& event),
  edit (IControlEvent& event);
  windowResize (IResizeEvent& event);

private:
#if IC_EXTENDED_RTTI_ENABLED
  IBaseComboHandler (const IBaseComboHandler&) {};
#else
  IBaseComboHandler (const IBaseComboHandler&);
#endif // IC_EXTENDED_RTTI_ENABLED
  IBaseComboHandler& operator= (const IBaseComboHandler&);
}; // class IComboBoxHandler

#pragma pack(pop)
#pragma enum(pop)

#endif //IC_MOTIF

/*------------------------------------------------------------------------------
| IBaseComboBoxData::IBaseComboBoxData                                         |
|                                                                              |
------------------------------------------------------------------------------*/
IBaseComboBoxData::IBaseComboBoxData ( )
    : minimumRows (4)
    , minimumCharacters (25)
#ifdef IC_MOTIF
    , listBox (0)
    , comboBoxType (IBaseComboBox::simple)
    , comboHeight (0)
    , entryHeight (0)
    , listShowing (false)
    , efHandle (0)
    , shell (0)
    , workProcId (0)
    , ignoreFocusOut (false)
    , pendingFocusOut (false)
#endif
#ifdef IC_MOTIFWIN
    , pdefaultHandler( new IBaseComboHandler )
#endif
#ifdef IC_PM
    , pdefaultHandler( 0 )
#endif
#ifdef IC_WIN
    , fBrushHandler( )
    , bChangedFlag (false)
#endif
{
#ifdef IC_WIN
  charLimit = 30000;
#endif
#ifdef IC_MOTIF
  itemHandlesList = new IItemHandlesList( );
#endif
}


/*------------------------------------------------------------------------------
| IBaseComboBoxData::~IBaseComboBoxData                                        |
------------------------------------------------------------------------------*/
IBaseComboBoxData::~IBaseComboBoxData ( )
{
#ifdef IC_MOTIFWIN
    delete pdefaultHandler;
#endif
#ifdef IC_MOTIF
  delete itemHandlesList;
#endif
}

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IBaseComboBoxData::listBoxHandle                                             |
|                                                                              |
| Returns the handle of the XmList widget.                                     |
------------------------------------------------------------------------------*/
IWindowHandle IBaseComboBoxData :: listBoxHandle (const IBaseComboBox& comboBox)
{
  return comboBox.fBaseComboBoxData->listBox;
}

/*------------------------------------------------------------------------------
| IBaseComboBoxData::textHandle                                                |
|                                                                              |
| Returns the handle of the XmText widget.                                     |
------------------------------------------------------------------------------*/
IWindowHandle IBaseComboBoxData :: textHandle (const IBaseComboBox& comboBox)
{
  return comboBox.fBaseComboBoxData->efHandle;
}

/*------------------------------------------------------------------------------
| IBaseComboBoxData::registerCallbacks                                         |
------------------------------------------------------------------------------*/
void IBaseComboBoxData :: registerCallbacks (IBaseComboBox* comboBox)
{

  if (comboBoxType != IBaseComboBox::simple)
  {
     XtAddCallback ((Widget) efHandle,
		    XmNlosingFocusCallback,
		    icbLosingFocusCallback,
		    (XtPointer) this);

     XtAddCallback (arrowButton,
		    XmNactivateCallback,
		    icbDropDownCallback,
		    (XtPointer) this);
  }

  XtAddCallback (listBox,
		 XmNbrowseSelectionCallback,
		 iwindowMotifCallback,
		 (XtPointer) comboBox);

  XtAddCallback (listBox,
		 XmNdefaultActionCallback,
		 iwindowMotifCallback,
		 (XtPointer) comboBox);

  // Explicitly add X event handler for combobox focus events
  XtAddEventHandler(
     (Widget)efHandle,               // widget
     FocusChangeMask,                // ask for FocusIn and FocusOut events
     True,                           // indicate we also want nonmaskable events
     iwindowXEventCallback,          // event handler routine
     (XtPointer) comboBox);          // save reference to this IWindow in client data

  return;
}


/*------------------------------------------------------------------------------
| IBaseComboBoxData::unregisterCallbacks                                       |
------------------------------------------------------------------------------*/
void IBaseComboBoxData :: unregisterCallbacks (IBaseComboBox* comboBox)
{
  if (comboBox->isValid())
  {
    Widget wHandle = (Widget)comboBox->handle();
    // Only unregister callbacks if widget not to be destroyed
    if (!wHandle->core.being_destroyed)
    {
      if (comboBoxType != IBaseComboBox::simple)
      {
	 XtRemoveCallback ((Widget) efHandle,
			   XmNlosingFocusCallback,
			   icbLosingFocusCallback,
			   (XtPointer) this);

	 XtRemoveCallback (arrowButton,
			   XmNactivateCallback,
			   icbDropDownCallback,
			   (XtPointer) this);
      }

      XtRemoveCallback (listBox,
			XmNbrowseSelectionCallback,
			iwindowMotifCallback,
			(XtPointer) comboBox);

      XtRemoveCallback (listBox,
			XmNdefaultActionCallback,
			iwindowMotifCallback,
			(XtPointer) comboBox);

      XtRemoveEventHandler(
	 (Widget)efHandle,               // widget
	 FocusChangeMask,                // ask for FocusIn and FocusOut events
	 True,                           // indicate we also want nonmaskable events
	 iwindowXEventCallback,          // event handler routine
	 (XtPointer) comboBox);          // save reference to this IWindow in client data
    }
  }
  return;
}

#endif

#ifdef IC_WIN
/*------------------------------------------------------------------------------
| IBaseComboHandler::IBaseComboHandler                                         |
|                                                                              |
| Empty constructor here for page tuning.                                      |
------------------------------------------------------------------------------*/
IBaseComboHandler::IBaseComboHandler()
{ }

/*------------------------------------------------------------------------------
| IBaseComboHandler::~IBaseComboHandler                                        |
|                                                                              |
| Empty destructor here for page tuning.                                       |
------------------------------------------------------------------------------*/
IBaseComboHandler::~IBaseComboHandler()
{ }

/*------------------------------------------------------------------------------
| IBaseComboHandler::dispatchHandlerEvent                                      |
|                                                                              |
| Intercepts control color event                                               |
|    This handler returns false for all other events.                          |
------------------------------------------------------------------------------*/
bool IBaseComboHandler::dispatchHandlerEvent( IEvent& event )
{
  bool
    result = false;

  switch( event.eventId() )
  {
    case WM_CONTROL:
    {
      IControlEvent ctlevt( event );
      IBaseComboBox *comboBox =
	    (IBaseComboBox*)(ctlevt.controlWindow());
      if (comboBox)
      {
	 unsigned long subMsg = ctlevt.parameter1().number2();
	 IWindowHandle hwndControl = comboBox->handle();
	 IWindowHandle hwndParent = IPARENTOF( hwndControl );
	 if (subMsg == CBN_SELENDOK)
	 {
	    // Windows generates a CBN_SELENDOK notification in response to
	    // a selection change in the combobox list.  It will not generate
	    // a CBN_EDITCHANGE following the entry field update.  In order for
	    // IEditHandler::dispatchHandlerEvents to call the edit function
	    // following the entry field update, we post a notification event.
	    hwndParent.postEvent( WM_COMMAND,
		  IEventParameter1( (short)IIDOF( hwndControl ), IC_UM_CBN_EFCHANGE),
		  IEventParameter2( hwndControl.asUnsigned()) );
	    result = true;
	 }
	 else if (subMsg == CBN_SELCHANGE)
	 {
	    comboBox->fBaseComboBoxData->bChangedFlag = true;
	 }
	 else if (subMsg == CBN_CLOSEUP)
	 {
	    // Ensure ISelectHandler::enter processed after edit field updated.
	    hwndParent.postEvent( WM_COMMAND,
		  IEventParameter1( (short)IIDOF( hwndControl ), IC_UM_CBN_ENTER),
		  IEventParameter2( hwndControl.asUnsigned()) );
	    result = true;
	 }
      }
      break;
    }

    case WM_PAINT:
    {
      // The following corrects a Windows problem that is
      // documented in MSDN Article #Q128110 - CBS_SIMPLE ComboBox
      // if platform uses Windows program manager shell
      if (!(IPlatform::isWin9x() || IPlatform::isNTNewShell()))
      {
	HPEN hOldPen;
	HBRUSH hOldBrush;
	RECT comboRect, entryfdRect, listboxRect;
	HWND hEntryfd, hListbox;

	HWND hWnd = event.handle();
	if (hWnd)
	{
	  HDC comboDC = GetDC(hWnd);
	  IBaseComboBox* combo = (IBaseComboBox*)event.window();

	  if ( (combo->fBaseComboBoxData->fentryHandle) &&
	     (combo->type() == IBaseComboBox::simple) )
	  {
	    // Create a pen and brush for painting the unpainted area
	    HBRUSH hBrush = CreateSolidBrush(GetSysColor(COLOR_WINDOW));
	    HPEN hPen = CreatePen (PS_SOLID, 1, GetSysColor(COLOR_WINDOW));
	    hOldBrush = SelectObject(comboDC, hBrush);
	    hOldPen = SelectObject(comboDC, hPen);

	    // Get the sizes of the combobox and its child windows
	    hEntryfd = combo->fBaseComboBoxData->fentryHandle;
	    hListbox = GetWindow(hWnd, GW_CHILD);
	    if (hListbox == hEntryfd)
	      hListbox = GetWindow(hWnd, GW_HWNDNEXT);
	    GetClientRect(hWnd, &comboRect);
	    GetClientRect(hEntryfd, &entryfdRect);
	    GetClientRect(hListbox, &listboxRect);

	    // Paint the area to the left of the listbox
	    Rectangle (comboDC,
		       (int)comboRect.left,
		       (int)entryfdRect.bottom,
		       (int)(comboRect.right - listboxRect.right),
		       (int)comboRect.bottom);

	    // Paint the area under the listbox
	    Rectangle (comboDC,
		       (int)(comboRect.right - listboxRect.right),
		       (int)(entryfdRect.bottom + listboxRect.bottom),
		       (int)comboRect.right,
		       (int)comboRect.bottom);

	    // Clean up GDI resources allocated
	    DeleteObject(SelectObject(comboDC, hOldBrush));
	    DeleteObject(SelectObject(comboDC, hOldPen));
	  }
	  ReleaseDC(hWnd, comboDC);
	  // This handler does not do the complete paint for the
	  // IComboBox; therefore, we must return false so that
	  // the remaining painting gets done.
	  result = false;
	}  // if (hWnd)
      }
    break;
    }

    case WM_CHAR:
    {
      // If read only type, then process character and return true so that
      // the character is not propagated up the owner chain.  For other combo
      // types, the characters are handled by the entryfield subclass.
      
       if ((event.parameter1() != VK_TAB) && (event.parameter1() != VK_ESC) && 
	   (event.parameter1() != VK_ENTER))
      {
	IBaseComboBox* comboBox = (IBaseComboBox*)event.window();
	if ( comboBox && (comboBox->type() == IBaseComboBox::readOnlyDropDown))
	{
	  this->defaultProcedure( event );
	  result = true;
	}
      }
      break;
    }

  case WM_SYSKEYUP:
  case WM_SYSKEYDOWN:
  case WM_SYSCHAR:
   {
    // Need to send Alt-mnemonic events to combobox owner or parent.
    IBaseComboBox* combobox = (IBaseComboBox*)event.window();
    IWindow *owner = combobox->owner();
    if (!owner)
       owner = combobox->parent();
    if (owner) {
       owner->sendEvent( event);
       return true;
     }
   }
   break;


#ifdef IC_WIN
    case EM_QUERYSEL:   // same as EM_GETSEL on Windows
    {
      IEventResult res = event.window()->sendEvent( CB_GETEDITSEL,
						    IEventParameter1(0),
						    IEventParameter2(0) );
      event.setResult( res );
      result = true;
    }
    break;
    case EM_SETSEL:
    {
      IEventResult res;
      unsigned short low  = (unsigned short) event.parameter1().asUnsignedLong();
      unsigned short high = (unsigned short) event.parameter2().asUnsignedLong();

      res = event.window()->sendEvent( CB_SETEDITSEL,
				       IEventParameter1(),
				       IEventParameter2( low, high ) );
      event.setResult( res );
      result = true;
    }
    break;
    case EM_SETTEXTLIMIT:   // same as EM_LIMITTEXT on Windows
    {
      IEventResult res;

      res = event.window()->sendEvent( CB_LIMITTEXT, 
				       IEventParameter1(0),
				       IEventParameter2(0) );
      event.setResult( res );
      result = true;
    }
    break;
    case EM_SETREADONLY:
    case EM_QUERYFIRSTCHAR: // same as EM_GETFIRSTVISIBLELINE on Windows
    case EM_CHARFROMPOS:
    case EM_LINESCROLL:
      if ( event.handle().isValid() )
      {
	IBaseComboBox* combo = (IBaseComboBox*)event.window();

	if ( (combo->fBaseComboBoxData->fentryHandle.isValid()) &&
	     (combo->type() != IBaseComboBox::readOnlyDropDown) )
	{
	  IWindowHandle editHwnd = combo->fBaseComboBoxData->fentryHandle;

	  IEventResult eResult =
	  editHwnd.sendEvent( event.eventId(),
			      event.parameter1(), event.parameter2() );

	  event.setResult( eResult );
	  result = true;
	}
      }
      break;
    case EM_SETMODIFY:
    {
    IBaseComboBox* combo = (IBaseComboBox*)event.window();
      if( combo )
      {
	  if( event.parameter1() != 0 )
	      combo->fBaseComboBoxData->bChangedFlag = true;
	  else
	      combo->fBaseComboBoxData->bChangedFlag = false;
	  if ( (combo->fBaseComboBoxData->fentryHandle.isValid()) &&
	       (combo->type() != IBaseComboBox::readOnlyDropDown) )
	  {
	    IWindowHandle editHwnd = combo->fBaseComboBoxData->fentryHandle;

	    IEventResult eResult = 
	    editHwnd.sendEvent( event.eventId(),
				combo->fBaseComboBoxData->bChangedFlag,
				event.parameter2() );

	    event.setResult( eResult );
	  }
	  result = true;
      }
    }
    break;
    case EM_QUERYCHANGED:   // same as EM_GETMODIFY on Windows
    {
    IBaseComboBox* combo = (IBaseComboBox*)event.window();
    if ( combo )
    {
      if( combo->fBaseComboBoxData->bChangedFlag == true )
      {
	 event.setResult( true );
      }
      else
      {
	  if ( (combo->fBaseComboBoxData->fentryHandle.isValid()) &&
	       (combo->type() != IBaseComboBox::readOnlyDropDown) )
	  {
	  IWindowHandle editHwnd = combo->fBaseComboBoxData->fentryHandle;
    
	  IEventResult eResult =
	  editHwnd.sendEvent( event.eventId(),
			      event.parameter1(), event.parameter2() );
	  event.setResult( eResult );
	  }
	  else 
	    event.setResult(false);
      }
      result = true;
    }
  }
  break;
#endif
    
  case IC_UM_IS_AGGREGATE_CTRL:
	{
	event.setResult(true);
	result = true;
	}
	break;

    default:
      break;
  }
  return result;
}

#endif //IC_WIN

#ifdef IC_MOTIF

/*------------------------------------------------------------------------------
| IBaseComboHandler::IComboBoxHandler                                          |
------------------------------------------------------------------------------*/
IBaseComboHandler :: IBaseComboHandler() {;}

/*------------------------------------------------------------------------------
| IBaseComboHandler::~IBaseComboHandler                                        |
------------------------------------------------------------------------------*/
IBaseComboHandler :: ~IBaseComboHandler() {;}

/*------------------------------------------------------------------------------
| IBaseComboHandler::enter                                                     |
|                                                                              |
| Process the enter for the XmList widget in the IBaseComboBox.                |
------------------------------------------------------------------------------*/
bool IBaseComboHandler :: enter (IControlEvent& event)
{
  IBaseComboBox* comboBox =     (IBaseComboBox*) event.controlWindow();

  // Get text widget from handle
  Widget text = IBaseComboBoxData::textHandle(*comboBox);

  if (comboBox->type() != IBaseComboBox::readOnlyDropDown)
     XmTextSetInsertionPosition (text,
			 XmTextGetLastPosition (text));

  if (comboBox->type() == IBaseComboBox::simple)
     XmProcessTraversal (text,
			 XmTRAVERSE_CURRENT);
  else
     comboBox->hideList();

  // Note:  Default handler should be the last handler.  Current design does
  //        not permit this since owner attached handlers will be invoked
  //        after the default handler.  For now return false to allow owner
  //        attached handlers to process the event.  When design is modified,
  //        this should return true.
  return false;
}

/*------------------------------------------------------------------------------
| IBaseComboHandler::selected                                                  |
|                                                                              |
| Process the select for the XmList widget in the IBaseComboBox.               |
------------------------------------------------------------------------------*/
bool IBaseComboHandler :: selected (IControlEvent& event)
{
  IBaseComboBox* comboBox =     (IBaseComboBox*) event.controlWindow();

  // Get text widget from handle
  Widget text = IBaseComboBoxData::textHandle(*comboBox);

  if (event.eventId() == motifEvent(XmCR_BROWSE_SELECT))
  {
     comboBox->setText (comboBox->itemText (comboBox->selection()));

     // Position insertion cursor at end of text.
     // Commented for fixing defect # 27656
//     if (comboBox->type() != IBaseComboBox::readOnlyDropDown)
//        XmTextSetInsertionPosition (text,
//                          XmTextGetLastPosition (text));

     // Force focus back to entry field.
     if (comboBox->type() == IBaseComboBox::simple)
	XmProcessTraversal (text,
			    XmTRAVERSE_CURRENT);
     else
     {
	// If the selection was due to mouse click, hide the list.
	XEvent* xEvent = (XEvent*) event.parameter2().asUnsignedLong();
	if ( xEvent && xEvent->type == ButtonRelease )
	{
	  comboBox->sendEvent( WM_COMMAND,
	    IEventParameter1( (short)comboBox->id(), IC_UM_CBN_ENTER ),
	    IEventParameter2( 0 ));

	  comboBox->hideList();
	}
     }
  }

  // Note:  Default handler should be the last handler.  Current design does
  //        not permit this since owner attached handlers will be invoked
  //        after the default handler.  For now return false to allow owner
  //        attached handlers to process the event.  When design is modified,
  //        this should return true.
  return false;
}

/*------------------------------------------------------------------------------
| IBaseComboHandler::virtualKeyPress                                           |
|                                                                              |
| Process the up and down virtual keys for the XmText widget in the            |
| IBaseComboBox.                                                               |
------------------------------------------------------------------------------*/
bool IBaseComboHandler :: virtualKeyPress (IKeyboardEvent& event)
{
  IBaseComboBox* comboBox =     (IBaseComboBox*) event.controlWindow();
  unsigned long curSelection = comboBox->selection();
  IKeyboardEvent::VirtualKey keyPressed = event.virtualKey();

  switch (keyPressed)
  {
    case IKeyboardEvent::up:
      // If no current selection exists, select first item in the list;
      // otherwise, move selection to previous item.
      if (comboBox->count() > 0)
	if (comboBox->numberOfSelections() == 0)
	   comboBox->select (0);
	else if (curSelection > 0)
	   comboBox->select (curSelection - 1);
      break;

    case IKeyboardEvent::down:
      // If no current selection exists, select first item in the list;
      // otherwise, move selection to next item.
      if (comboBox->count() > 0)
	if (comboBox->numberOfSelections() == 0)
	   comboBox->select (0);
	else if (curSelection < comboBox->count() - 1)
	  comboBox->select (curSelection + 1);
      break;

     case IKeyboardEvent::pageUp:
      {
	 // If there is no current selection, select the first item in the
	 // list; otherwise, page up by the number of visible items.

	 int visibleCount;

	 // Get the number of visible items in the list.
	 XtVaGetValues ((Widget)(comboBox->fBaseComboBoxData->listBox),
			XmNvisibleItemCount, &visibleCount,
			NULL);
      if (comboBox->count() > 0)
	 if (comboBox->numberOfSelections() == 0 ||
	     curSelection < visibleCount)
	    comboBox->select (0);
	 else
	    comboBox->select (curSelection - visibleCount);
      }
      break;

    case IKeyboardEvent::pageDown:
      {
	 // If there is no current selection, select the first item in the
	 // list; otherwise, page down by the number of visible items.

	 int           visibleCount;
	 unsigned long listCount = comboBox->count();

	 XtVaGetValues ((Widget) (comboBox->fBaseComboBoxData->listBox),
			XmNvisibleItemCount, &visibleCount,
			NULL);
      if (comboBox->count() > 0)
	 if (comboBox->numberOfSelections() == 0 ||
	     curSelection >= listCount - visibleCount)
	    comboBox->select (listCount - 1);
	 else
	    comboBox->select (curSelection + visibleCount);
      }
      break;

    case IKeyboardEvent::enter:
      {
      if (comboBox->type() != IBaseComboBox::simple)
	 comboBox->hideList();

      // Only send enter event for listbox processing.  Let enter events
      // on text widget be passed up
      if ( comboBox->numberOfSelections() != 0 )
	comboBox->sendEvent( WM_COMMAND,
	   IEventParameter1( (short)comboBox->id(), IC_UM_CBN_ENTER ),
	   IEventParameter2( 0 ));
      }
      break;

    default:
      // Handle the case where the entry field is cleared.
      if (comboBox->IBaseComboBox::text() == IString (""))
	 comboBox->IBaseComboBox::deselectAll();
  }

  // Note:  Default handler should be the last handler.  Current design does
  //        not permit this since owner attached handlers will be invoked
  //        after the default handler.  For now return false to allow owner
  //        attached handlers to process the event.  When design is modified,
  //        this should return true.
  return false;
}

/*------------------------------------------------------------------------------
| IBaseComboHandler::edit                                                      |
|                                                                              |
| Process the prefix match in the list.                                        |
------------------------------------------------------------------------------*/
bool IBaseComboHandler :: edit (IControlEvent& event)
{
  IBaseComboBox*        comboBox = (IBaseComboBox*)event.controlWindow();
  unsigned long matchIndex;

  matchIndex = comboBox->locateText (IString (comboBox->text()),
				     true,
				     IBaseComboBox::prefix,
				     comboBox->selection()-1);

  if (matchIndex == IBaseComboBox::notFound)
  {
     comboBox->deselectAll();
  }
  else
  {
     int visibleCount;

     XmListSelectPos (IBaseComboBoxData::listBoxHandle(*comboBox),
		      matchIndex + 1,
		      false);
     XtVaGetValues (IBaseComboBoxData::listBoxHandle (*comboBox),
		    XmNvisibleItemCount, &visibleCount,
		    NULL);
     if (comboBox->top() > matchIndex ||
	 (comboBox->top() + visibleCount) <= matchIndex)
	comboBox->setTop (matchIndex);
  }

  // Note:  Default handler should be the last handler.  Current design does
  //        not permit this since owner attached handlers will be invoked
  //        after the default handler.  For now return false to allow owner
  //        attached handlers to process the event.  When design is modified,
  //        this should return true.
  return false;
}

/*------------------------------------------------------------------------------
| IBaseComboHandler::windowResize                                              |
------------------------------------------------------------------------------*/
bool  IBaseComboHandler::windowResize(IResizeEvent& event)
{

  if ( event.eventId() == xEvent(ConfigureNotify) )
  {

    ISizeRectangle *sizeRect =
      (ISizeRectangle *) event.parameter1().asUnsignedLong();

    // if the size has changed
    if ( sizeRect->sizeChanged() )
    {
      IBaseComboBox *comboBox = (IBaseComboBox*)event.controlWindow();
      IRectangle adjustedRect = sizeRect->newRectangle();


//      comboBox->fBaseComboBoxData->comboHeight = adjustedRect.height();

      // If the drop-down isn't showing, adjust the height and y-coordinate
      // of the rectangle to include only down to the bottom of the entry field.
      if (!comboBox->isListShowing()
	&& comboBox->fBaseComboBoxData->comboHeight >
	   comboBox->fBaseComboBoxData->entryHeight)
      {
	  adjustedRect.sizeTo (IPair (adjustedRect.width(),
				      comboBox->fBaseComboBoxData->entryHeight));
	  adjustedRect.moveTo (IPair (adjustedRect.left(), adjustedRect.bottom() +
				     ( comboBox->fBaseComboBoxData->comboHeight
				     - comboBox->fBaseComboBoxData->entryHeight)));
      }

    }

  }

  return false;
}


/*------------------------------------------------------------------------------
| IBaseComboHandler::dispatchHandlerEvent                                      |
------------------------------------------------------------------------------*/
bool IBaseComboHandler::dispatchHandlerEvent( IEvent& event )
{
  bool
    eventProcessed = false;

  switch( event.eventId() )
  {

    case LM_INSERTITEM:
    {
      ITRACE_DEVELOP("In IBaseListHandler --- LM_INSERTITEM");

      IBaseComboBox *comboBox = (IBaseComboBox*)(event.controlWindow());
      Widget listWidget = comboBox->fBaseComboBoxData->listBox;

      XmString string;
      char* replaceItem;
      char* text = (char*)event.parameter2();
      int position = (int)event.parameter1() + 1;

      // Create compound string.
      replaceItem = XtMalloc (strlen (text) + 1);
      sprintf (replaceItem, "%s", text);
      string = XmStringCreateLocalized (replaceItem);

      XmListAddItemUnselected(listWidget,
			      (XmString) string,
			      position);

      XmStringFree (string);
      XtFree (replaceItem);

      eventProcessed = true;
      break;
    }

    case LM_DELETEITEM:
    {
      IBaseComboBox *comboBox = (IBaseComboBox*)(event.controlWindow());
      Widget listWidget = comboBox->fBaseComboBoxData->listBox;

      int position = (int)event.parameter1() + 1;
      XmListDeleteItemsPos(listWidget,
			   1,
			   position);
      eventProcessed = true;
      break;
    }

    case LM_DELETEALL:
    {

      IBaseComboBox *comboBox = (IBaseComboBox*)(event.controlWindow());
      Widget listWidget = comboBox->fBaseComboBoxData->listBox;

      XmListDeleteAllItems(listWidget);

      eventProcessed = true;
      break;
    }

    default:
      break;
  }


  // Give inherited dispatchers a chance if necessary
  if (!eventProcessed)
    {
      if (IEditHandler::dispatchHandlerEvent(event))
	return true;
      if (IKeyboardHandler::dispatchHandlerEvent(event))
	return true;
      if (ISelectHandler::dispatchHandlerEvent(event))
	return true;
      if (IResizeHandler::dispatchHandlerEvent(event))
	return true;
    }

  return eventProcessed;
}
#endif

/*------------------------------------------------------------------------------
| IBaseComboBox::IBaseComboBox                                                 |
|                                                                              |
| Construct an IBaseComboBox on an IWindow.                                    |
------------------------------------------------------------------------------*/
IBaseComboBox::IBaseComboBox(unsigned long id,
		     IWindow* pParent,
		     IWindow* pOwner,
		     const IRectangle& rectInit,
		     const Style& style)
		   : fBaseComboBoxData( 0 )
{
#ifdef IC_PMWIN
  // assertions on input parms
  IASSERTPARM(pParent!=0);
  IASSERTPARM((style & (simpleType | dropDownType | readOnlyDropDownType))
	       !=0);
  // Save the extended style to make sure we have a copy of it stored
  setExtendedStyle( extendedStyle() | style.asExtendedUnsignedLong() );

  unsigned long cbStyle = style.asUnsignedLong();
  unsigned long extCbStyle = style.asExtendedUnsignedLong();

  // Check for valid style combination.
  if (((cbStyle &  CBS_SIMPLE)    &&  (cbStyle & CBS_DROPDOWN))      ||
#ifdef IC_WIN
      ((cbStyle &  CBS_SIMPLE)    &&  (extCbStyle & ICBS_DROPDOWNLIST))  ||
      ((cbStyle &  CBS_DROPDOWN)  &&  (extCbStyle & ICBS_DROPDOWNLIST)))
#endif //IC_WIN
#ifdef IC_PM
     ((cbStyle &  CBS_SIMPLE)    &&  (cbStyle & CBS_DROPDOWNLIST))  ||
     ((cbStyle &  CBS_DROPDOWN)  &&  (cbStyle & CBS_DROPDOWNLIST)))
#endif //IC_PM
  {                                   // Mutually exclusive styles
     ITHROWLIBRARYERROR(IC_INVALIDSTYLE,
		       IBaseErrorInfo::invalidParameter,
		       IException::recoverable);
  }

  // Create a private data object.
  fBaseComboBoxData = new IBaseComboBoxData;

  IWindowHandle ownerHandle  = (pOwner == 0) ?
				  IWindowHandle(0) :
				  pOwner->handle();
  IWindowHandle parentHandle = (pParent == 0) ?
				  IWindow::desktopWindow()->handle() :
				  pParent->handleForChildCreation();

  IWindowHandle whComboBox =
      this -> create( id,
		      0,
		      convertToGUIStyle( style ),
		      WC_COMBOBOX,
		      parentHandle,
		      ownerHandle,
		      rectInit,
		      0,
		      0,
		      defaultOrdering(),
		      convertToGUIStyle( style, true ) );

#ifdef IC_WIN
  fBaseComboBoxData->pdefaultHandler->handleEventsFor( this );
  fBaseComboBoxData->fBrushHandler.handleEventsFor( this );
#endif
  startHandlingEventsFor(whComboBox);
  IMousePointerHandler::defaultHandler()->handleEventsFor(this);

  // Subclass the entry field in the combo box so that we can get
  // navigation keys.
  fBaseComboBoxData->fentryHandle =
     IBaseComboBoxData::handleOfEntryField( whComboBox );
  if (fBaseComboBoxData->fentryHandle)
     {
     // setup our procedure in the window.
     fBaseComboBoxData->fdefaultEntryProc = (IWinProc*)
	ISUBCLASSWINDOW(fBaseComboBoxData->fentryHandle,
			icomboboxEntryWinProc);
     if ( fBaseComboBoxData->fdefaultEntryProc == 0 )
	{
	// throw now rather than trap later.
	ITHROWGUIERROR( "ISUBCLASSWINDOW" );
	}
     }

#ifdef IC_WIN
  // The horizontal extend must be set for Windows to
  // display the horizontal scroll bar.  Temp fix is to set it to the
  // screen width.  Real fix could be to monitor adds/deletes and set
  // it to the widest string in current font.
  // Note:  Due to a Windows bug, horizontal scrollbars are only supported
  //        for simple comboboxes.
  if ((style & IBaseComboBox::horizontalScroll)
     && (IPlatform::isWin9x()
     || (IPlatform::isNTNewShell()
	 && !(style & IBaseComboBox::dropDownType)
	 && !(style & IBaseComboBox::readOnlyDropDownType))))
  {
     whComboBox.sendEvent(CB_SETHORIZONTALEXTENT,
			  (unsigned long)IWindow::desktopWindow()->size().width(),
			  0);

     // Windows doesn't keep the WS_VSCROLL style with the combobox so store
     // it as an extended style for querying later.
     setExtendedStyle( extendedStyle() | LS_HORZSCROLL );
  }
#endif
#endif  //IC_PMWIN

#ifdef IC_MOTIF
  int    n;
  Arg    args[5];
  Widget entryField, entryArrowForm, verticalScroll, workArea;
// d6979 - no need to remember and later XtDestroy horizontalScroll.
  Widget horizontalScroll;

  unsigned long cbStyle = style.asUnsignedLong();

  // Check for valid style combination.
  if (((cbStyle &  CBS_SIMPLE)    &&  (cbStyle & CBS_DROPDOWN))      ||
      ((cbStyle &  CBS_SIMPLE)    &&  (cbStyle & CBS_DROPDOWNLIST))  ||
      ((cbStyle &  CBS_DROPDOWN)  &&  (cbStyle & CBS_DROPDOWNLIST)))
  {                                   // Mutually exclusive styles
     ITHROWLIBRARYERROR(IC_INVALIDSTYLE,
		       IBaseErrorInfo::invalidParameter,
		       IException::recoverable);
  } /* endif */

  // Create a private data object.
  fBaseComboBoxData = new IBaseComboBoxData();

  // Determine the combo box type.
  if ((cbStyle & CBS_SIMPLE) | (cbStyle & IWindow::noStyle.asUnsignedLong()))
     fBaseComboBoxData->comboBoxType = simple;
  else if (cbStyle & CBS_DROPDOWN)
     fBaseComboBoxData->comboBoxType = dropDown;
  else
     fBaseComboBoxData->comboBoxType = readOnlyDropDown;

  // Save initial height information.
  fBaseComboBoxData->comboHeight = rectInit.height();

  // Create top level XmForm widget, and set it up to be an IWindow.
  IWindowHandle cbForm =
     Inherited::create(
	id,
	NULL,
	style.asUnsignedLong(),
	(IXmCreateFunction)XmCreateForm,
	pParent->handleForChildCreation(),
	pOwner ? pOwner->handle() : desktopWindow()->handle(),
	rectInit,
	0,
	0);

  // Check if the combo box is left-to-right (the entry field is left
  // of the drop-down arrow) or right-to-left (the entry field is
  // right of the drop-down arrow).
  bool
    leftToRight = true;
  if ( IBidiSettings::isBidiSupported() )
  {
     // IWindow bidi styles take precedence over inherited bidi
     // attributes.
     if ( style & IWindow::rightToLeft )
     {
	leftToRight = false;
     }
     else if ( ! ( style & IWindow::leftToRight ) )
     {
	IBidiSettings
	  bidiSettings( cbForm );
	if ( bidiSettings.windowLayout() == IBidiSettings::layoutRightToLeft )
	{
	   leftToRight = false;
	}
     }
  }

  // Create a form to contain the entry field and the arrow button.
  // By using this form, the arrow button will remain the same height as
  // the entry field.  If this is a simple combo box, the entryArrowForm
  // will have only one child, the entry field.
  entryArrowForm = XtVaCreateWidget (IString (id),
				     xmFormWidgetClass,
				     cbForm,
				     XmNresizePolicy,     XmRESIZE_NONE,
				     XmNborderWidth,      0,
				     XmNleftAttachment,   XmATTACH_FORM,
				     XmNrightAttachment,  XmATTACH_FORM,
				     XmNtopAttachment,    XmATTACH_FORM,
				     NULL);
  if ((unsigned long) entryArrowForm == 0)
     ITHROWLIBRARYERROR1 (IC_XMCREATE_FAILURE,
			  IBaseErrorInfo::accessError,
			  IException::recoverable,
			  "combo box entry field form");
  XtManageChild (entryArrowForm);

  // Create the entry field as an XmText widget.  Attach it to the form
  // at the top and left (right for bidi).  Leave the bottom unattached.
  entryField = XtVaCreateWidget (IString (id),
				 xmTextWidgetClass,
				 entryArrowForm,
				 XmNeditMode,         XmSINGLE_LINE_EDIT,
				 leftToRight ?
				   XmNleftAttachment : XmNrightAttachment,
						      XmATTACH_FORM,
				 XmNtopAttachment,    XmATTACH_FORM,
				 XmNbottomAttachment, XmATTACH_FORM,
				 NULL);
  if ((unsigned long) entryField == 0)
     ITHROWLIBRARYERROR1 (IC_XMCREATE_FAILURE,
			  IBaseErrorInfo::accessError,
			  IException::recoverable,
			  "combo box entry field");

  if (fBaseComboBoxData->comboBoxType == readOnlyDropDown)
  {
     XtVaSetValues (entryField,
		    XmNeditable,              False,
		    XmNcursorPositionVisible, False,
		    NULL);
  }

  XtManageChild (entryField);
  XtVaSetValues (entryArrowForm,
		 XmNinitialFocus, entryField,
		 NULL);

  // Create an XmArrowButton to control the drop-down list.  Attach it to
  // the form at the top and right.  Leave the left and bottom unattached.
  // Attach the XmText widget to the left (right for bidi) of the
  // XmArrowButton.
  if ( (fBaseComboBoxData->comboBoxType == dropDown) ||
       (fBaseComboBoxData->comboBoxType == readOnlyDropDown) )
  {
     fBaseComboBoxData->arrowButton = XtVaCreateManagedWidget (
			     IString (id),
			     xmArrowButtonWidgetClass,
			     entryArrowForm,
			     XmNarrowDirection,     XmARROW_DOWN,
			     XmNtraversalOn,        False,
			     XmNleftAttachment,     leftToRight ?
						    XmATTACH_NONE : XmATTACH_FORM,
			     XmNrightAttachment,    leftToRight ?
						    XmATTACH_FORM : XmATTACH_NONE,
			     XmNtopAttachment,      XmATTACH_FORM,
			     XmNbottomAttachment  , XmATTACH_FORM,
			     // d7293 - calcMinimumSize requires no border.
			     XmNborderWidth,        0,
			     NULL);
     if ( fBaseComboBoxData->arrowButton == 0)
	ITHROWLIBRARYERROR1 (IC_XMCREATE_FAILURE,
			     IBaseErrorInfo::accessError,
			     IException::recoverable,
			     "combo box arrow button");

     if ( leftToRight )
     {  // The drop-down arrow is to the right of the entry field.
	XtVaSetValues( entryField,
		       XmNrightAttachment, XmATTACH_WIDGET,
		       XmNrightWidget,     fBaseComboBoxData->arrowButton,
		       NULL );
     }
     else
     {  // The drop-down arrow is to the left of the entry field.
	XtVaSetValues( entryField,
		       XmNleftAttachment, XmATTACH_WIDGET,
		       XmNleftWidget,     fBaseComboBoxData->arrowButton,
		       NULL );
     }
  }
  else
  {
     fBaseComboBoxData->arrowButton = 0;

     // If this is a simple combo box, attach both sides of the XmText
     // to the form.
     XtVaSetValues (entryField,
		    XmNleftAttachment,  XmATTACH_FORM,
		    XmNrightAttachment, XmATTACH_FORM,
		    NULL);
  }

  if ( fBaseComboBoxData->comboBoxType != simple )
  {
    Arg args[5];
    n=0;
//    XtSetArg (args[n], XmNoverrideRedirect, True); n++;
//    XtSetArg (args[n], XmNsaveUnder, False); n++;
//    XtSetArg (args[n], XmNallowShellResize, True); n++;
    fBaseComboBoxData->shell = XtCreatePopupShell( "Combobox",
      overrideShellWidgetClass /* vendorShellWidgetClass */, cbForm,
      args, n );

    XtAddEventHandler(fBaseComboBoxData->shell,
      FocusChangeMask,
      False, (XtEventHandler) icbShellCallback,
      (XtPointer) fBaseComboBoxData);
  }

  // Create the scrolled list.  Attach it the the form on its left, right, and
  // bottom.  Attach it the the XmText on top.
  n = 0;
  XtSetArg (args[n], XmNscrollBarDisplayPolicy, XmSTATIC); n++;
  XtSetArg (args[n], XmNlistSizePolicy, XmCONSTANT); n++;
  XtSetArg (args[n], XmNselectionPolicy, XmBROWSE_SELECT); n++;
  XtSetArg (args[n], XmNborderWidth, 0); n++;
  XtSetArg (args[n], XmNhighlightThickness, 0); n++;

  if ( fBaseComboBoxData->comboBoxType != simple )
  {
    fBaseComboBoxData->listBox = XmCreateScrolledList (
					 fBaseComboBoxData->shell,
					 IString (id),
					 args,
					 n);
  }
  else
  {
    fBaseComboBoxData->listBox = XmCreateScrolledList (cbForm,
					 IString (id),
					 args,
					 n);
  }

  if ( fBaseComboBoxData->listBox == 0)
     ITHROWLIBRARYERROR1 (IC_XMCREATE_FAILURE,
			  IBaseErrorInfo::accessError,
			  IException::recoverable,
			  "combo box scrolled list");

  XtVaSetValues (XtParent ((Widget)fBaseComboBoxData->listBox),
		 XmNtraversalOn,         False,
		 XmNleftAttachment,      XmATTACH_FORM,
		 XmNrightAttachment,     XmATTACH_FORM,
		 XmNtopAttachment,       XmATTACH_WIDGET,
		 XmNtopWidget,           entryArrowForm,
		 XmNbottomAttachment,    XmATTACH_FORM,
		 XmNresizable,           False,
		 NULL);

  // If only vertical scroll bar requested, remove horizontal one from the
  // scrolled window children.
  XtVaGetValues (XtParent ((Widget)fBaseComboBoxData->listBox),
// d6979 - no need to remember and later XtDestroy horizontalScroll.
//                 XmNhorizontalScrollBar, &(fBaseComboBoxData->horizontalScroll),
		 XmNhorizontalScrollBar, &horizontalScroll,
		 XmNverticalScrollBar, &verticalScroll,
		 XmNworkWindow, &workArea,
		 NULL);
  if ( !(cbStyle & IWindow::noStyle.asUnsignedLong()) &&
       !(cbStyle & LS_HORZSCROLL) )
  {
     XmScrolledWindowSetAreas (XtParent ((Widget)fBaseComboBoxData->listBox),
			       NULL,
			       verticalScroll,
			       workArea);
  }

  XtManageChild (fBaseComboBoxData->listBox);
  if (fBaseComboBoxData->comboBoxType == simple)
     fBaseComboBoxData->listShowing = true;

  // Stash away edit widget handle
  fBaseComboBoxData->efHandle = entryField;

  startHandlingEventsFor (cbForm);

  // Register appropriate callbacks for combobox
  fBaseComboBoxData->registerCallbacks(this);

  initialize (cbStyle, entryField);

  setOwner (pOwner);

  if (style != IWindow::noStyle)
  {
     IEntryField::CharType charType = any;
     if (cbStyle & ES_SBCS)
	charType = IEntryField::sbcs;
     else if (cbStyle & ES_DBCS)
	charType = IEntryField::dbcs;

     setCharType (charType);

     setStyle (cbStyle);
  }

  // Attach default handler.  It is derived from ISelectHandler (for
  // list selection events), IKeyboardHandler (for up and down arrows,
  // pageUp and pageDown, and IEditHandler (for prefix matching).

  // Only attach handle once and then handle all inherited handlers in
  // dispatch override
  fBaseComboBoxData->pdefaultHandler->IEditHandler::handleEventsFor (this);
//  fBaseComboBoxData->pdefaultHandler->ISelectHandler::handleEventsFor (this);
//  fBaseComboBoxData->pdefaultHandler->IKeyboardHandler::handleEventsFor (this);
//  fBaseComboBoxData->pdefaultHandler->IResizeHandler::handleEventsFor(this);

  // Ensure that the windows distorted flag is set.
  setLayoutDistorted (windowCreated | colorChanged | fontChanged, 0);
#endif
#ifdef IC_WIN
  // the background color of the entry field is dialog independant.
  setColor( PP_BACKGROUNDCOLOR, IColor::kEntryFieldBgnd);
#endif // IC_WIN

}

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IBaseComboBox::IBaseComboBox                                                 |
|                                                                              |
| Construct an IBaseComboBox on a dialog.                                      |
------------------------------------------------------------------------------*/
IBaseComboBox::IBaseComboBox( unsigned long id, IWindow* parent)
			    : fBaseComboBoxData( 0 )
{
   // Create a private data object.
   fBaseComboBoxData = new IBaseComboBoxData;

   setAutoDestroyWindow(false);
#ifdef IC_WIN
  fBaseComboBoxData->pdefaultHandler->handleEventsFor( this );
  fBaseComboBoxData->fBrushHandler.handleEventsFor( this );
#endif
   reserveUserWindowWord( false );
   startHandlingEventsFor(id, parent);
   IMousePointerHandler::defaultHandler()->handleEventsFor(this);

   // Subclass the entry field in the combo box so that we can get
   // navigation keys.
   fBaseComboBoxData->fentryHandle =
      IBaseComboBoxData::handleOfEntryField( this->handle() );
   if (fBaseComboBoxData->fentryHandle)
      {
      // setup our procedure in the window.
      fBaseComboBoxData->fdefaultEntryProc = (IWinProc*)
	 ISUBCLASSWINDOW(fBaseComboBoxData->fentryHandle,
			 icomboboxEntryWinProc);
      if ( fBaseComboBoxData->fdefaultEntryProc == 0 )
	 {
	 // throw now rather than trap later.
	 ITHROWGUIERROR( "ISUBCLASSWINDOW" );
	 }
      }

#ifdef IC_WIN
  // add the inheritColor attribute to the window. ComboBox does
  // not inherit background color.
  IInheritColorAttribute
    inheritColor( IInheritColorAttribute::kForegroundColor );
  this->addOrReplaceAttribute( IAttributeName("IInheritColorAttribute"),
			       inheritColor );
#endif
}
#endif

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IBaseComboBox::IBaseComboBox                                                 |
|                                                                              |
| Construct an IBaseComboBox from an existing IBaseComboBox.                   |
------------------------------------------------------------------------------*/
IBaseComboBox::IBaseComboBox( const IWindowHandle& handle )
			    : fBaseComboBoxData( 0 )
{
   // Create a private data object.
   fBaseComboBoxData = new IBaseComboBoxData;

   setAutoDestroyWindow(false);
#ifdef IC_WIN
  fBaseComboBoxData->pdefaultHandler->handleEventsFor( this );
  fBaseComboBoxData->fBrushHandler.handleEventsFor( this );
#endif
   reserveUserWindowWord( false );
   startHandlingEventsFor(handle);
   IMousePointerHandler::defaultHandler()->handleEventsFor(this);

   // Subclass the entry field in the combo box so that we can get
   // navigation keys.
   fBaseComboBoxData->fentryHandle =
      IBaseComboBoxData::handleOfEntryField( handle );
   if (fBaseComboBoxData->fentryHandle)
      {
      // setup our procedure in the window.
      fBaseComboBoxData->fdefaultEntryProc = (IWinProc*)
	 ISUBCLASSWINDOW(fBaseComboBoxData->fentryHandle,
			 icomboboxEntryWinProc);
      if ( fBaseComboBoxData->fdefaultEntryProc == 0 )
	 {
	 // throw now rather than trap later.
	 ITHROWGUIERROR( "ISUBCLASSWINDOW" );
	 }
      }

#ifdef IC_WIN
  // add the inheritColor attribute to the window. ComboBox does
  // not inherit background color.
  IInheritColorAttribute
    inheritColor( IInheritColorAttribute::kForegroundColor );
  this->addOrReplaceAttribute( IAttributeName("IInheritColorAttribute"),
			       inheritColor );
#endif
}
#endif

/*------------------------------------------------------------------------------
| IBaseComboBox::~IBaseComboBox                                                |
|                                                                              |
| Reomve the default mouse pointer handler.                                    |
------------------------------------------------------------------------------*/
IBaseComboBox :: ~IBaseComboBox()
{

#ifdef IC_PMWIN
#ifdef IC_WIN
   // Remove the default Handler
   fBaseComboBoxData->pdefaultHandler->stopHandlingEventsFor( this );
   fBaseComboBoxData->fBrushHandler.stopHandlingEventsFor( this );
#endif
   // Remove the subclass of the entry field
   if ( (fBaseComboBoxData->fentryHandle) &&
	IISWINDOW(0, fBaseComboBoxData->fentryHandle) )
      {
      ISUBCLASSWINDOW(fBaseComboBoxData->fentryHandle,
		      fBaseComboBoxData->fdefaultEntryProc);
      }
  IMousePointerHandler::defaultHandler()->stopHandlingEventsFor(this);
  if ( fBaseComboBoxData != 0 )
    delete fBaseComboBoxData;
#endif  //IC_PMWIN

#ifdef IC_MOTIF
  XtRemoveWorkProc(fBaseComboBoxData->workProcId);
  fBaseComboBoxData->pdefaultHandler->IEditHandler::stopHandlingEventsFor (this);
//  fBaseComboBoxData->pdefaultHandler->ISelectHandler::stopHandlingEventsFor (this);
//  fBaseComboBoxData->pdefaultHandler->IKeyboardHandler::stopHandlingEventsFor (this);
//  fBaseComboBoxData->pdefaultHandler->IResizeHandler::stopHandlingEventsFor (this);

  fBaseComboBoxData->unregisterCallbacks(this);
  delete fBaseComboBoxData;
#endif  //IC_MOTIF
}

/*------------------------------------------------------------------------------
| IBaseComboBox::type                                                          |
------------------------------------------------------------------------------*/
IBaseComboBox::ControlType  IBaseComboBox::type() const
{
#ifdef IC_PMWIN
  unsigned long ulType =
	   style() & (simpleType.asUnsignedLong()  |
		      dropDownType.asUnsignedLong() |
		      readOnlyDropDownType.asUnsignedLong());
  ControlType eReturn = simple;

#ifdef IC_WIN
  if ((ulType & simpleType.asUnsignedLong())  &&
      (ulType & dropDownType.asUnsignedLong()))
  {
    return( dropDownList );
  }
#endif

  switch (ulType)
  {
     case CBS_SIMPLE:
	break;
     case CBS_DROPDOWN:
	eReturn = dropDown;
	break;
     case CBS_DROPDOWNLIST:
	eReturn = dropDownList;
	break;
     default:
	break;
  }

  return eReturn;
#endif //IC_PMWIN
#ifdef IC_MOTIF
  return fBaseComboBoxData->comboBoxType;
#endif //IC_MOTIF
}

/*------------------------------------------------------------------------------
| IBaseComboBox::defaultStyle                                                      |
------------------------------------------------------------------------------*/
IBaseComboBox::Style  IBaseComboBox::defaultStyle()
{
  return currentDefaultStyle;
}

/*------------------------------------------------------------------------------
| IBaseComboBox::setDefaultStyle                                               |
------------------------------------------------------------------------------*/
void IBaseComboBox::setDefaultStyle(const Style& style)
{
  currentDefaultStyle = style;
}

/*------------------------------------------------------------------------------
| IBaseComboBox::convertToGUIStyle                                             |
|                                                                              |
| Returns base style for the control by default, or extended style if          |
| extended flag (bExtOnly) is set.                                             |
------------------------------------------------------------------------------*/
unsigned long IBaseComboBox::convertToGUIStyle(const IBitFlag& guiStyle,
					   bool bExtOnly) const
{
  // We don't get the IEntryField GUI styles since IEntryField styles are not
  // used by combo boxes.  Instead, get the ITextControl style.
  unsigned long ulStyle = ITextControl::convertToGUIStyle( guiStyle, bExtOnly );

  if (bExtOnly)
  {
    // Use mask to only return extended styles that we don't overlap with our
    // extended styles.
    ulStyle |= guiStyle.asExtendedUnsignedLong() & ICBS_EXTGUIMASK;
  }
  else
  {
    // Let the clean CBS_ styles, flow thru
    ulStyle |= guiStyle.asUnsignedLong() & ICBS_MASK;

#ifdef IC_WIN
    unsigned long ulTmp = guiStyle.asExtendedUnsignedLong() & ICBS_EXTMASK;

    // Add CBS_DROPDOWNLIST style if the corresponding extended bit is set
    if (ulTmp & readOnlyDropDownType.asExtendedUnsignedLong())
    {
       ulStyle |= CBS_DROPDOWNLIST;
    }

    ulStyle |= WS_CHILD | CBS_HASSTRINGS
	       | WS_VSCROLL | CBS_NOINTEGRALHEIGHT;
#endif
  }

  return( ulStyle );
}

/*------------------------------------------------------------------------------
| IBaseComboBox::isListShowing                                                 |
------------------------------------------------------------------------------*/
bool   IBaseComboBox::isListShowing() const
{
#ifdef IC_PMWIN
  if (type() != simple)
  {
     IEventResult evt = handle().sendEvent(CBM_ISLISTSHOWING,
				IEventParameter1(0),
				IEventParameter2(0));
     if (evt.asUnsignedLong())
	return true;
     else
	return false;
  }
  else
     return true;
#endif
#ifdef IC_MOTIF
   return fBaseComboBoxData->listShowing;
#endif
}

/*------------------------------------------------------------------------------
| IBaseComboBox::showList                                                          |
------------------------------------------------------------------------------*/
IBaseComboBox&  IBaseComboBox::showList(bool show)
{
#ifdef IC_PMWIN
  bool stateChanged = false;

  if (type() != simple)
  {
    if (show)
    {
      if (!isListShowing())
      {
	stateChanged = true;
      }
    }
    else if (isListShowing())
    {
      stateChanged = true;
    }

    if (stateChanged)
    {
      handle().sendEvent(CBM_SHOWLIST, IEventParameter1(show),
				       IEventParameter2(0));
    }
  }
#endif
#ifdef IC_MOTIF
  if (type() != simple)
  {
     if (show)
     {
	unsigned long curSel = selection();
      int visibleCount;
      int lCount = count();
      XtVaGetValues (IBaseComboBoxData::listBoxHandle (*this),
		    XmNvisibleItemCount, &visibleCount,
		    NULL);

	if (curSel != IBaseComboBox::notFound)
         if((lCount - curSel) > visibleCount)
            setTop (curSel);
         else setTop (lCount - visibleCount);

	fBaseComboBoxData->listShowing = true;
	Dimension width;
	XtVaGetValues( handle(),
	  XmNwidth, &width,
	  NULL);
	Position x_root, y_root;
	XtTranslateCoords( handle(), 0, fBaseComboBoxData->entryHeight, &x_root, &y_root );

	XtVaSetValues( fBaseComboBoxData->shell,
	  XmNx, x_root,
	  XmNy, y_root,
	  XmNheight, fBaseComboBoxData->comboHeight,
	  XmNwidth, width,
	  NULL );

	XtPopup( fBaseComboBoxData->shell, XtGrabNone );
     }
     else
     {
	fBaseComboBoxData->listShowing = false;
	XtPopdown( fBaseComboBoxData->shell);
     }

     // Set the input focus to the XmText widget if it does not already
     // have focus.
     if (XmGetFocusWidget (handle()) != fBaseComboBoxData->efHandle)
	XmProcessTraversal ((Widget) fBaseComboBoxData->efHandle, XmTRAVERSE_CURRENT);
  }
#endif
  return *this;
}

/*------------------------------------------------------------------------------
| IBaseComboBox::hideList                                                      |
------------------------------------------------------------------------------*/
IBaseComboBox&  IBaseComboBox::hideList()
{
  showList(false);
  return *this;
}

/*------------------------------------------------------------------------------
| IBaseComboBox::hasFocus                                                      |
------------------------------------------------------------------------------*/
bool IBaseComboBox::hasFocus() const
{
#ifdef IC_PMWIN
   if ( extendedStyle() & readOnlyDropDownType.asExtendedUnsignedLong())
     return Inherited::hasFocus();      // static text type combobox
   else
   {                                    // has an Edit window
     HWND hwndCombo = handle();
     HWND hwndEdit = IBaseComboBoxData::handleOfEntryField( hwndCombo );
     HWND hwndFocus = IQUERYFOCUS( HWND_DESKTOP );
     // Check both combobox and entryfield.  If either has focus, then true.
     return (( hwndCombo == hwndFocus ) || ( hwndEdit == hwndFocus ));
   }
#endif //IC_PMWIN
#ifdef IC_MOTIF
   Widget windowInFocus = XmGetFocusWidget( (Widget) handle() );
   return ( (windowInFocus == (Widget)fBaseComboBoxData->efHandle) ||
	    (windowInFocus == (Widget)fBaseComboBoxData->listBox) );
#endif //IC_MOTIF
}


#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IBaseComboBox::setFocus                                                      |
|                                                                              |
| Give text widget of combobox the focus                                       |
------------------------------------------------------------------------------*/
IBaseComboBox& IBaseComboBox::setFocus ( )
{
  if ( isVisible() )
     XmProcessTraversal ((Widget) fBaseComboBoxData->efHandle, XmTRAVERSE_CURRENT);


  if ( !XtIsRealized(handle()) )
  {
    Widget focusWidget = (Widget) fBaseComboBoxData->efHandle;
    Widget parentWidget = XtParent(focusWidget);
    while ( parentWidget && !XtIsTopLevelShell( parentWidget ) )
    {
       parentWidget = XtParent(parentWidget);
    }  // * while * //
    if (parentWidget )
    {
      IWindow *win = IWindow::windowWithHandle( parentWidget);
      if (win)
      {
	XtVaSetValues (XtParent( (Widget) win->handleForChildCreation()),
			XmNinitialFocus, focusWidget,
			NULL);
      }
    }
  }

  return *this;
}
#endif //IC_MOTIF

#ifdef IC_WIN
/*------------------------------------------------------------------------------
| IBaseComboBox::setLimit                                                      |
|                                                                              |
| Sets the maximum number of characters allowed in the entry field portion of  |
| the combo box.                                                               |
------------------------------------------------------------------------------*/
IBaseComboBox& IBaseComboBox::setLimit( unsigned long ulLimit )
{
  IASSERTSTATE(text().length() <= ulLimit);

  if (this->limit() != ulLimit)
  {
    /*************************************************************/
    /* Now set the new edit limit for the entry field.           */
    /*************************************************************/
    handle().sendEvent(CB_LIMITTEXT,
		       IEventParameter1(ulLimit),
		       IEventParameter2(0));
    fBaseComboBoxData->charLimit = ulLimit;
    setLayoutDistorted(IWindow::minimumSizeChanged, 0);
  }

  return( *this );
}
#endif


#ifdef IC_WIN
/*------------------------------------------------------------------------------
| IBaseComboBox::setLimit                                                      |
|                                                                              |
| Sets the maximum number of characters allowed in the entry field given a     |
| string resource-id that defines the limit.                                   |
------------------------------------------------------------------------------*/
IBaseComboBox& IBaseComboBox::setLimit( const IResourceId& residTextLimit )
{
  IString strTextLimit =
     residTextLimit.resourceLibrary().loadString(residTextLimit);
  setLimit(strTextLimit.asInt());
  return( *this );
}
#endif


#ifdef IC_WIN
/*------------------------------------------------------------------------------
| IBaseComboBox::limit                                                         |
|                                                                              |
| Return the maximum number of characters allowed in the entry field portion   |
| of the combo box.                                                            |
------------------------------------------------------------------------------*/
unsigned long IBaseComboBox::limit( ) const
{
  return( fBaseComboBoxData->charLimit );
}
#endif

/*------------------------------------------------------------------------------
| IBaseComboBox::calcMinimumSize                                               |
|                                                                              |
| Calculate the minimum size needed by the control.  The height is based on    |
| the font height and the width is based on the average font width multiplied  |
| by the text limit.                                                           |
------------------------------------------------------------------------------*/
ISize  IBaseComboBox::calcMinimumSize() const
{
  ISize sizMin = Inherited::calcMinimumSize();

#ifdef IC_PMWIN
  IBaseComboBox::ControlType comboType = type();

  // If we aren't a drop-down, add room for minimum rows
  if ( comboType != dropDown && comboType != dropDownList)
  {
    sizMin.setHeight ( sizMin.height() +
		       IQUERYSYSVALUE(SV_CYBORDER) +
		       minimumRows() * IFont(this).maxCharHeight());
     // Note: Only the bottom border is added to the height since the
     // listbox top border overlaps the entry field bottom border
     if ( ( extendedStyle() & border3D.asExtendedUnsignedLong() ) &&
	  ( IPlatform::isWin9x() || IPlatform::isNTNewShell() ))
     {
	sizMin += ISize(0,2);
     }
  }

  // Add size for the entry field border (doesn't seem to happen
  // via entry field calculation)
  sizMin += ISize((3 * IQUERYSYSVALUE(SV_CXBORDER) + 2),
#ifdef IC_WIN
		     (2 * IQUERYSYSVALUE(SV_CYBORDER)));
#else
		     (3 * IQUERYSYSVALUE(SV_CYBORDER) + 2));
#endif

#ifdef IC_WIN
  // If this is a drop down, add room for button.
  if (comboType == dropDown || comboType == dropDownList)
  {
     // Use the width of a vertical scrollbar arrow button for
     // button width.
     sizMin.setWidth( sizMin.width() +
		      GetSystemMetrics( SM_CXVSCROLL ));
  }
#endif

  if (isHorizontalScroll() && comboType != dropDown &&
      comboType != dropDownList)
  {
     sizMin.setHeight (sizMin.height() + IQUERYSYSVALUE(SV_CYHSCROLL));
  }
#endif
#ifdef IC_MOTIF
  if (fBaseComboBoxData->comboBoxType == simple)
  {
     Dimension listMarginHeight, listSpacing,
	       shadowThickness, borderWidth;
     XtVaGetValues (fBaseComboBoxData->listBox,
		    XmNlistMarginHeight,   &listMarginHeight,
		    XmNlistSpacing,        &listSpacing,
		    XmNshadowThickness,    &shadowThickness,
		    XmNborderWidth,        &borderWidth,
		    NULL);
     // Note that the highlight thickness was set to zero during construction.
     sizMin.setHeight (sizMin.height() +
		      fBaseComboBoxData->minimumRows * characterSize().height() +
		      (fBaseComboBoxData->minimumRows  - 1) * listSpacing +
		      2 * (borderWidth + shadowThickness));

     // Account for horizontal scroll bar.
     if (isHorizontalScroll())
     {
	Dimension scrollHeight, spacing;
	XtVaGetValues (XtNameToWidget (XtParent ((Widget)fBaseComboBoxData->listBox),
				       "HorScrollBar"),
		       XmNheight, &scrollHeight,
		       NULL);
	XtVaGetValues (XtParent ((Widget)fBaseComboBoxData->listBox),
		       XmNspacing, &spacing,
		       NULL);
	sizMin.setHeight (sizMin.height() + spacing +
			  (scrollHeight ? scrollHeight : 15));
     }
  }
  else
  {
     Dimension arrowWidth;
     XtVaGetValues (fBaseComboBoxData->arrowButton,
		    XmNwidth, &arrowWidth,
		    NULL);
     sizMin.setWidth (sizMin.width() + (arrowWidth ? arrowWidth : 20));
  }
#endif
  return sizMin;
}

/*------------------------------------------------------------------------------
| IBaseComboBox::layoutAdjustment                                              |
|                                                                              |
| Calculate the size and distance a dropDown Combination box should be         |
| adjusted after layout.                                                       |
------------------------------------------------------------------------------*/
IRectangle  IBaseComboBox::layoutAdjustment() const
{
#ifdef IC_PMWIN
  IBaseComboBox::ControlType comboType = type();

  if ( comboType == dropDown || comboType == dropDownList)
  {
     // Adjust position so that minimum rows of text will fit in the
     // drop down listbox
     unsigned long height = minimumRows() * IFont( this ).maxCharHeight() +
			    IQUERYSYSVALUE( SV_CYBORDER );
     if (isHorizontalScroll())
	height += IQUERYSYSVALUE( SV_CYHSCROLL );
     return IRectangle( 0, -height, 0, 0);
  }
  else
    return Inherited::layoutAdjustment();
#endif
#ifdef IC_MOTIF
  IRectangle adjustRect;
  if (fBaseComboBoxData->comboBoxType != simple)
  {
     Dimension     listMarginHeight, listSpacing,
		   shadowThickness, borderWidth, spacing, scrollHeight;
     unsigned long listHeight;
     XtVaGetValues (fBaseComboBoxData->listBox,
		    XmNlistMarginHeight,   &listMarginHeight,
		    XmNlistSpacing,        &listSpacing,
		    XmNshadowThickness,    &shadowThickness,
		    XmNborderWidth,        &borderWidth,
		    NULL);
     // Note that the highlight thickness was set to zero during construction.
     listHeight = fBaseComboBoxData->minimumRows * characterSize().height() +
		  (fBaseComboBoxData->minimumRows - 1) * listSpacing +
		  2 * (borderWidth + shadowThickness);

     // Account for horizontal scroll bar.
     if (isHorizontalScroll())
     {
	XtVaGetValues (XtParent ((Widget)fBaseComboBoxData->listBox),
		       XmNspacing,            &spacing,
		       NULL);
	XtVaGetValues (XtNameToWidget (XtParent ((Widget)fBaseComboBoxData->listBox),
				       "HorScrollBar"),
		       XmNheight, &scrollHeight,
		       NULL);
	listHeight += spacing + (scrollHeight ? scrollHeight : 15);
     }

     // Store comboheight as listHeight+entryHeight
     fBaseComboBoxData->comboHeight = listHeight + fBaseComboBoxData->entryHeight;

     // Only adjust rectangle if dropdown list showing
     // However, still need to compute the comboheight above for the resize
     if (isListShowing())
     {
       adjustRect.sizeTo (IPair (0, listHeight));
       adjustRect.moveTo (IPair (0, -listHeight));
     }
  }
  return adjustRect;
#endif
}


/*------------------------------------------------------------------------------
| IBaseComboBox::visibleRectangle                                              |
|                                                                              |
| Calculate the actual displayed (painted) ares of the combo box.              |
------------------------------------------------------------------------------*/
IRectangle  IBaseComboBox::visibleRectangle() const
{
#ifdef IC_PM
  IRectangle    trueRect = nativeRect();
  SWP           swp;

  IBaseComboBox::ControlType comboType = type();
  if ( comboType == dropDown || comboType == dropDownList)
  {
    IQUERYWINDOWPOS(IWINDOWFROMID(handle(),CBID_EDIT),&swp);
    unsigned long cyBorder = IQUERYSYSVALUE(SV_CYBORDER);
    trueRect = IRectangle ( IPoint(trueRect.left(),
				   trueRect.bottom()+swp.y-(2*cyBorder)),
			    trueRect.topRight() );
  }
  else
  {
    IQUERYWINDOWPOS(IWINDOWFROMID(handle(),CBID_LIST),&swp);
    trueRect = IRectangle ( IPoint(trueRect.left(),
			    trueRect.bottom()+swp.y),
			    trueRect.topRight() );
  }
  return ICoordinateSystem::convertToApplication( trueRect, parentSize() );
#endif
#ifdef IC_WIN
  RECT   rect;
  IQUERYWINDOWRECT(handle(), &rect);
  MapWindowPoints( HWND_DESKTOP, IPARENTOF( handle() ), (POINT*)&rect, 2);
  return ICoordinateSystem::convertToApplication( IRectangle( rect ),
						  parentSize() );
#endif
#ifdef IC_MOTIF
  IRectangle visibleRect(position(), size());
  if (!isListShowing()
    && fBaseComboBoxData->comboHeight > fBaseComboBoxData->entryHeight)
  {
     unsigned long listHeight = fBaseComboBoxData->comboHeight
					- fBaseComboBoxData->entryHeight;
     visibleRect.moveBy (IPair(0, listHeight));

     ISize TempSizeVar = size();                     // 27813
     long TempW = TempSizeVar.width();
     long TempH = TempSizeVar.height();
     visibleRect.moveBy (IPair(0, listHeight));
     visibleRect.sizeTo (IPair(TempW, TempH - listHeight));
  }
  return visibleRect;
#endif
}

#ifdef IC_WIN
/*------------------------------------------------------------------------------
| IBaseComboBox::nativeRect                                                    |
------------------------------------------------------------------------------*/
IRectangle IBaseComboBox::nativeRect ( ) const
{
   if (type() == simple)
      return Inherited::nativeRect();

   RECT rect;
   handle().sendEvent( CB_GETDROPPEDCONTROLRECT,
		       IEventParameter1( 0 ),
		       IEventParameter2( &rect ));

   MapWindowPoints( HWND_DESKTOP, IPARENTOF( handle() ), (POINT*)&rect, 2);
   return IRectangle( rect );
}
#endif

/*------------------------------------------------------------------------------
| IBaseComboBox::setMinimumRows                                                |
|                                                                              |
| Sets the number of rows in a minimum size combobox.                          |
------------------------------------------------------------------------------*/
IBaseComboBox&  IBaseComboBox :: setMinimumRows (unsigned long minimumRows)
{
  fBaseComboBoxData->minimumRows = minimumRows;
  setLayoutDistorted (minimumSizeChanged, 0);
  return *this;
}

/*------------------------------------------------------------------------------
| IBaseComboBox::minimumRows                                                   |
|                                                                              |
| Returns the number of rows in a minimum size combobox.                       |
------------------------------------------------------------------------------*/
unsigned long  IBaseComboBox :: minimumRows () const
{
  return fBaseComboBoxData->minimumRows;
}



#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IBaseComboBox::setAlignment                                                  |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IBaseComboBox& IBaseComboBox::setAlignment(IEntryField::Alignment alignment)
{
   ITHROWLIBRARYERROR1(IC_MEMBER_ACCESS_ERROR,
		       IBaseErrorInfo::invalidRequest,
		       IException::recoverable,
		       "IBaseComboBox");
   return *this;
}

/*------------------------------------------------------------------------------
| IBaseComboBoxData::handleOfEntryField                                        |
------------------------------------------------------------------------------*/
IWindowHandle IBaseComboBoxData::handleOfEntryField(
					 const IWindowHandle& combobox )
{
#ifdef IC_PM
   // Retrieve the edit control child of the combobox.
   IWindowHandle hwndChild = IWINDOWFROMID( combobox, CBID_EDIT );
#endif
#ifdef IC_WIN
   // Find the edit control child of the combobox.
   IWindowHandle hwndChild = GetWindow(combobox, GW_CHILD);
   while ( (hwndChild) && (IWindowClassName(hwndChild) != WC_ENTRYFIELD))
      hwndChild = GetWindow(hwndChild, GW_HWNDNEXT);
#endif
   return hwndChild;
}

/*------------------------------------------------------------------------------
| icomboboxEntryWinProc                                                        |
| Window procedure for the entryfield part of a combo box.  This procedure     |
| intercepts the messages used for keyboard navigation and sends them to       |
| the combobox owner.  Other messages are sent on to the original procedure    |
| for the combobox entryfield.                                                 |
------------------------------------------------------------------------------*/
#ifdef IC_WIN
long  __stdcall icomboboxEntryWinProc(void*         hwnd,
				      unsigned int  msg,
				      unsigned int  mp1,
				      long          mp2)
#endif
#ifdef IC_PM
void*   _System icomboboxEntryWinProc( unsigned long hwnd,
				       unsigned long msg,
				       void*         mp1,
				       void*         mp2 )
#endif
{
   IWindowHandle  efParent   = IPARENTOF(hwnd);
   IBaseComboBox* combobox = (IBaseComboBox*)
      IWindow::windowWithHandle( efParent, false );
   if (combobox)
      {
#ifdef IC_WIN
      switch( msg )
	 {
	 case WM_CHAR:
	    if (mp1 == VK_ENTER)
	    {
	       if (combobox->type() == IBaseComboBox::simple ||
		   (combobox->type() != IBaseComboBox::simple && !combobox->isListShowing()))
	       {
		  IWindowHandle hwndParent = IPARENTOF( efParent );
		  hwndParent.sendEvent( WM_COMMAND,
		     IEventParameter1( (short)combobox->id(), IC_UM_CBN_ENTER),
		     IEventParameter2( efParent.asUnsigned() ));

		  // Need to pass Enter on if combo is not dropped down
		  IWindow* owner = combobox->owner();
		  if (!owner)
		     owner = combobox->parent();
		  owner->sendEvent((unsigned long)msg,
				   (unsigned long)mp1,
				   (unsigned long)mp2);
		  return false;
	       }
	       // Return code on old shell does not reflect that the
	       // combobox has processed the enter message and closed the
	       // list.  This causes us to propagate it up the chain and
	       // incorrectly select default buttons.
	       if (!(IPlatform::isWin9x() || IPlatform::isNTNewShell()))
	       {
		 if (combobox->type() != IBaseComboBox::simple)
		   combobox->sendEvent( CB_SHOWDROPDOWN );
		 return false;
	       }
	    }
	    else if ((mp1 == VK_TAB) || (mp1 == VK_ESC ))
	    {
	       // send these to the combobox owner or parent.  We need
	       // VK_TAB to handle keyboard navigation.  We need to pass on
	       // VK_ESC for correct dialog behavior.
	       IWindow* owner = combobox->owner();
	       if (!owner)
		  owner = combobox->parent();
	       owner->sendEvent((unsigned long)msg,
				(unsigned long)mp1,
				(unsigned long)mp2);
	       return false;
	    }
	    else if ( (mp1 != VK_BACKSPACE) && (mp1 != VK_NEWLINE) && (mp1 != VK_BREAK) )
	    {
	    // test send to text change handler
	    IEventResult result = combobox->sendEvent((unsigned long) IC_UM_WM_CHAR,
					      (unsigned long)mp1,
					      (unsigned long)mp2);

	    if (result.asUnsignedLong())
	      return true;
	    }

	    break;

      case EM_PASTE:
	  {
	    // send paste to the text change handler (if attached)
	    IEventResult result = efParent.sendEvent((unsigned long)IC_UM_EM_PASTE,
						     (unsigned long)mp1,
						     (unsigned long)mp2);
	    if (result.asUnsignedLong())
	      return true;
	  }
	  break;

	 default:
	    break;
	 }

      return CallWindowProc(
		(FARPROC)combobox->fBaseComboBoxData->fdefaultEntryProc,
		hwnd, msg, mp1, mp2 );
      }
#endif //IC_WIN
#ifdef IC_PM
      switch( msg )
	 {
	 case WM_PRESPARAMCHANGED:
	 {
	   char fontName[120];   // Use same size as in IFont ctor
	   unsigned long fontNameLen =
	       WinQueryPresParam( hwnd, PP_FONTNAMESIZE, 0, 0,
			      sizeof( fontName ), &fontName,
			      QPF_NOINHERIT );
	   if ( fontNameLen )
	   {
	     if (( ((long)mp1) == PP_FONTNAMESIZE) ||
				      (((long)mp1) == PP_FONTHANDLE))
	     {
	       WinSetPresParam( combobox->handle(), PP_FONTNAMESIZE,
				fontNameLen+1, (char*)fontName );
	       WinRemovePresParam( hwnd, PP_FONTNAMESIZE );
	     }
	   }
	 }
	 break;

	 default:
	    break;
	 }

     return combobox->fBaseComboBoxData->fdefaultEntryProc(
						  hwnd, msg, mp1, mp2 );
     }

#endif //IC_PM
   else
     {
     // We are basically busted if we can't find our parent IWindow.  We do
     // what is probably the most reasonable thing and call the
     // default procedure.
     return IDEFWINDOWPROC( hwnd, msg, mp1, mp2 );
     }
}
#endif //IC_PMWIN

#ifdef IC_WIN
/*------------------------------------------------------------------------------
| IBaseComboBox::enableDataUpdate                                              |
------------------------------------------------------------------------------*/
IBaseComboBox& IBaseComboBox::enableDataUpdate( bool update )
{
  if (update)
  {
    if ( !(this->isWriteable()) )
    {
      fBaseComboBoxData->fentryHandle.sendEvent(EM_SETREADONLY,
			 IEventParameter1(false),
			 IEventParameter2(0));
    }
  }
  else if ( this->isWriteable() )
  {
    fBaseComboBoxData->fentryHandle.sendEvent(EM_SETREADONLY,
		       IEventParameter1(true),
		       IEventParameter2(0));
  }
  return( *this );
}


/*------------------------------------------------------------------------------
| IBaseComboBox::isWriteable                                                   |
------------------------------------------------------------------------------*/
bool IBaseComboBox::isWriteable() const
{
  if ( ISTYLEOF(fBaseComboBoxData->fentryHandle) & ES_READONLY )
    return( false );
  else
    return( true );
}

#endif  //IC_WIN

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IBaseComboBox::select                                                        |
|                                                                              |
| Select (or deselect) an item in the list.                                    |
------------------------------------------------------------------------------*/
IBaseComboBox& IBaseComboBox::select(unsigned long lIndex, bool turnOn)
{
   // See if the index is valid.
   if (lIndex >= count())
   {
      ITHROWLIBRARYERROR1 (IC_INVALID_INDEX,
			   IBaseErrorInfo::invalidParameter,
			   IException::recoverable,
			   IString (lIndex));
   }

   if (turnOn)
   {
      // If it is already selected, leave it alone.  Do not want to toggle it.
      if (!isSelected (lIndex))
	 // Invoke the selection callback for the item.  The default handler
	 // will process the selection and call setText there.
	 XmListSelectPos (fBaseComboBoxData->listBox, lIndex + 1, true);
   }
   else
     XmListDeselectPos (fBaseComboBoxData->listBox, lIndex + 1);

   return *this;
}

/*------------------------------------------------------------------------------
| getXColor                                                                    |
|                                                                              |
| Returns an IColor object corresponding to Pixel value colorArea using the    |
| default colormap for the specified widget w.  If w is null, a default color  |
| is returned.                                                                 |
------------------------------------------------------------------------------*/
IColor getXColor ( Pixel colorArea, Widget w )
{
  // Currently, the defaultColorMap is used for all widgets and also by
  // IColor so the Widget argument is ignored.
  return IColor((unsigned long)colorArea);
}

/*------------------------------------------------------------------------------
| IBaseComboBox::foregroundColor                                                     |
------------------------------------------------------------------------------*/
IColor IBaseComboBox::foregroundColor ( ) const
{
  Pixel colorArea;
  XtVaGetValues( fBaseComboBoxData->efHandle,
		 XmNforeground, &colorArea,
		 NULL );
  return getXColor( colorArea, fBaseComboBoxData->efHandle );
}

/*------------------------------------------------------------------------------
| IBaseComboBox::backgroundColor                                                     |
------------------------------------------------------------------------------*/
IColor IBaseComboBox::backgroundColor ( ) const
{
  Pixel colorArea;
  XtVaGetValues( fBaseComboBoxData->efHandle,
		 XmNbackground, &colorArea,
		 NULL );
  return getXColor( colorArea, fBaseComboBoxData->efHandle );
}

/*------------------------------------------------------------------------------
| IBaseComboBox :: setForegroundColor                                          |
------------------------------------------------------------------------------*/
IBaseComboBox& IBaseComboBox :: setForegroundColor(const IColor& color)
{
  // Need to set the foreground color for the XmText and the XmList widgets.
  Inherited::setForegroundColor (color);
  XtVaSetValues (fBaseComboBoxData->listBox,
		 XmNforeground, color.index(),
		 NULL);
  XtVaSetValues (fBaseComboBoxData->efHandle,
		 XmNforeground, color.index(),
		 NULL);
  return *this;
}

/*------------------------------------------------------------------------------
| IBaseComboBox :: setBackgroundColor                                          |
------------------------------------------------------------------------------*/
IBaseComboBox& IBaseComboBox :: setBackgroundColor(const IColor& color)
{
  // Set the background color of the combobox form to the color of its parent
  // This is a work-around for the case where a combobox is on a multicell with
  // an explicit row height.  Because the combobox doesn't size to the height of the
  // row, there are cases where the color of the combo form can show through.  We
  // account for this by setting the color of the form to its parent's background color.
  Inherited::setBackgroundColor(parent()->backgroundColor());

  return *this;
}

/*------------------------------------------------------------------------------
| IBaseComboBox :: setColor                                                   |
------------------------------------------------------------------------------*/
IBaseComboBox& IBaseComboBox :: setColor( unsigned long colorArea,
					  const IColor& color)
{
  Inherited::setColor( colorArea, color);
  return *this;
}


/*------------------------------------------------------------------------------
| IBaseComboBox::size                                                          |
|                                                                              |
| Get the window size.                                                         |
------------------------------------------------------------------------------*/
ISize   IBaseComboBox :: size() const
{
  // Return the stored height of the combo box which includes both the entry
  // field height and the drop-down height.

  ISize sz = Inherited::size();
// d7293
//  if ( !isListShowing())
//      sz.setHeight (fBaseComboBoxData->comboHeight);
  if ( !isListShowing()
    && fBaseComboBoxData->comboHeight > fBaseComboBoxData->entryHeight)
     sz.setHeight ( sz.height()
		  + fBaseComboBoxData->comboHeight
		  - fBaseComboBoxData->entryHeight );
  return sz;
} // end size ()

/*------------------------------------------------------------------------------
| IBaseComboBox::position                                                      |
|                                                                              |
| Get the object position.                                                     |
------------------------------------------------------------------------------*/
IPoint  IBaseComboBox :: position() const
{
  // Return the lower left position including the list box even if it is not
  // dropped down.

  IPoint comboPosition = Inherited::position();
// d7293
//  if (!isListShowing())
//  if (!isListShowing()
//    && fBaseComboBoxData->comboHeight > fBaseComboBoxData->entryHeight){
//#ifdef IC_MOTIF
//     comboPosition.setY (comboPosition.y() + fBaseComboBoxData->comboHeight
//                                + fBaseComboBoxData->entryHeight);
//#endif  //IC_MOTIF
//#ifdef IC_PMWIN
//     comboPosition.setY (comboPosition.y() - fBaseComboBoxData->comboHeight
//                                + fBaseComboBoxData->entryHeight);
//#endif  //IC_PMWIN
//  }
  return comboPosition;
} // end position ()


/*------------------------------------------------------------------------------
| IBaseComboBox::setLayoutDistorted                                            |
------------------------------------------------------------------------------*/
IBaseComboBox&  IBaseComboBox :: setLayoutDistorted(
					unsigned long layoutAttributeOn,
					unsigned long layoutAttributeOff )
{
  // Let entry field know it may need to recalculate its minimum size.
  Inherited::setLayoutDistorted (layoutAttributeOn, layoutAttributeOff);

  // If the font changed, set the listbox font to the entry field font.
  if (layoutAttributeOn & fontChanged)
  {
     XmFontList fontList;
     XtVaGetValues (fBaseComboBoxData->efHandle,
		    XmNfontList, &fontList,
		    NULL);
     XtVaSetValues (fBaseComboBoxData->listBox,
		    XmNfontList, fontList,
		    NULL);
  }

// d7293
//  if ((layoutAttributeOn &
//       (fontChanged | minimumSizeChanged | windowCreated)) &&
//      fBaseComboBoxData->comboBoxType != simple)
  if ((layoutAttributeOn &
       (fontChanged | minimumSizeChanged | windowCreated)) )
  {
     // Set visible height to minimum entry field height + fudge factor
     fBaseComboBoxData->entryHeight = Inherited::calcMinimumSize().height() + 2;

     // d7293
     if ( fBaseComboBoxData->comboBoxType != simple )
       XtVaSetValues (handle(),
		      XmNheight, fBaseComboBoxData->entryHeight,
		      NULL);
     // d7293 - Need to set the height of the arrowEntry form too.
     XtVaSetValues( XtParent( (Widget)fBaseComboBoxData->efHandle ),
		    XmNheight, fBaseComboBoxData->entryHeight,
		    NULL);
  }

  return *this;
}

#pragma options info=nouse
/*------------------------------------------------------------------------------
|  icbDropDownCallback is the callback invoked when the user presses the       |
|  arrow button to show or hide the listbox.                                   |
------------------------------------------------------------------------------*/
extern void _System icbDropDownCallback (Widget w,
					 XtPointer client_data,
					 XtPointer call_data)
{
  IBaseComboBox *comboBox;

  // Get the window related to this XmArrowButton widget.
  comboBox = (IBaseComboBox*) IWindow::windowWithHandle(XtParent(XtParent(w)));

  // Get private data pointer from client data.
  IBaseComboBoxData* fBaseComboBoxData = (IBaseComboBoxData*) client_data;

  if (comboBox->isListShowing())
  {
     comboBox->showList (False);
  }
  else
  {
     comboBox->sendEvent (IWindow::control,
		  IEventData ((unsigned short)comboBox->id(), CBN_SHOWLIST),
		  IEventData ((Widget)fBaseComboBoxData->efHandle));
     if (comboBox->text() == IString("") && comboBox->count())
	comboBox->select (0);
     comboBox->showList (True);
  }
  return;
}
#pragma options info=reset

#pragma options info=nouse
/*------------------------------------------------------------------------------
|  icbLosingFocusCallback is the callback invoked when the entry field is      |
|  losing focus in a dropDown or a dropDownList combo box.                     |
------------------------------------------------------------------------------*/
extern void _System icbLosingFocusCallback (Widget w,
					    XtPointer client_data,
					    XtPointer call_data)
{
  // Get the window related to this listbox widget
  IBaseComboBox* comboBox =
	     (IBaseComboBox*) IWindow::windowWithHandle(XtParent(XtParent(w)));

  // Get private data pointer from client data.
  IBaseComboBoxData* fBaseComboBoxData = (IBaseComboBoxData*) client_data;

  if ( comboBox->isListShowing() )
  {
    fBaseComboBoxData->pendingFocusOut = true;

    // Add work procedure to handle hiding the listbox if necessary.
    if(fBaseComboBoxData->workProcId == 0 ){
     fBaseComboBoxData->workProcId = XtAppAddWorkProc(
		   XtWidgetToApplicationContext((Widget) XtParent(XtParent(w))),
		   (XtWorkProc) icbDelayedFocusOutWorkProc,
		   (XtPointer) fBaseComboBoxData);
    }
  }

  return;
}

/*------------------------------------------------------------------------------
|  icbShellCallback is the callback called on focus changes for the popup      |
|  shell containing the list widget.                                           |
------------------------------------------------------------------------------*/
extern void _System icbShellCallback(Widget w,
				     XtPointer pClientData,
				     XEvent *event,
				     bool *ContDispatch)
{
  // Get private data pointer from client data.
  IBaseComboBoxData* fBaseComboBoxData = (IBaseComboBoxData*) pClientData;

  switch ( event->type )
  {
    case FocusIn:
      fBaseComboBoxData->ignoreFocusOut = true;
      break;
    case FocusOut:
      fBaseComboBoxData->pendingFocusOut = false;
      fBaseComboBoxData->ignoreFocusOut = false;
      break;
  }

  *ContDispatch = true;

  return;
}

/*------------------------------------------------------------------------------
/ The work procedure allows the focusIn/losingFocus/focusOut events to occur   /
/ in the proper order to determine if the listbox should be hidden.  The       /
/ losingFocusCallback was called when attempting to scroll the list widget     /
/ prior to this change, causing the list to be hidden erroneously.             /
/ Now ignoreFocusOut and pendingFocusOut booleans are used to determine if     /
/ the list widget should be hidden.                                            /
------------------------------------------------------------------------------*/
extern bool _System icbDelayedFocusOutWorkProc(XtPointer pClientData)
{
    IBaseComboBoxData* fBaseComboBoxData = (IBaseComboBoxData*) pClientData;

    Widget comboWidget = XtParent(XtParent((Widget)fBaseComboBoxData->efHandle));
    IBaseComboBox* comboBox = (IBaseComboBox*)IWindow::windowWithHandle(comboWidget);

    if ( !fBaseComboBoxData->ignoreFocusOut  &&
	  fBaseComboBoxData->pendingFocusOut )
    {
      comboBox->showList(false);
      fBaseComboBoxData->pendingFocusOut = false;
      fBaseComboBoxData->ignoreFocusOut = false;
    }

    return false;
}

#pragma options info=reset
#endif

#include <ilistbx3.hpp>

