// Revision: 35 1.14.1.15 source/ui/extapp/iflyhhdr.cpp, staticctls, ioc.v400, 990114 
/*******************************************************************************
* FILE NAME: iflyhhdr.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in iflyhhdr.hpp                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#pragma priority( -2147481524 )

extern "C" {
  #define INCL_WIN
  #define INCL_WINMESSAGEMGR
  #define INCL_WINWINDOWMGR
  #define INCL_WINPOINTERS
  #define INCL_WININPUT
  #define WINVER 0x0400
  #include <iwindefs.h>
  #ifdef IC_WIN
    #include <commctrl.h>
  #endif
  #include <string.h>
}

#include <iflyhhdr.hpp>
#include <iflytext.hpp>
#include <iflypriv.hpp>
#include <iapp.hpp>
#include <ibidiset.hpp>
#include <icconst.h>
#include <icoordsy.hpp>
#include <ictlevt.hpp>
#include <iexcept.hpp>
#include <iprimlck.hpp>
#include <irect.hpp>
#include <ithread.hpp>
#include <itrace.hpp>

// Segment definitions.
#ifdef IC_PAGETUNE
  #define _IFLYHHDR_CPP_
  #include <ipagetun.h>
#endif

#ifdef IC_MOTIF
void _System IFlyHelpTimeoutProc( XtPointer client_data, XtIntervalId* timerId );
#endif

#define CHECK_MOTION_DELAY 333          // interval to recheck pointer motion

/*------------------------------------------------------------------------------
| Static Data.                                                                 |
| The IFlyHelpHandlerStatics class manages construction/destruction of         |
| static objects for IFlyHelpHandler.                                          |
------------------------------------------------------------------------------*/
#pragma enum(4)
#pragma pack(push,4)

class IFlyHelpHandlerStatics {
public:
  IFlyHelpHandlerStatics ( )
   { }
 ~IFlyHelpHandlerStatics ( );
static IHandleStringSet
 &handleStringSet        ( );
private:
static IHandleStringSet
 *fgHandleStringSet;
}; // IFlyHelpHandlerStatics

#pragma pack(pop)
#pragma enum(pop)

static IFlyHelpHandlerStatics flyHelpStatics;
IHandleStringSet*    IFlyHelpHandlerStatics::fgHandleStringSet = 0;
IWindow::DataHandle  IFlyOverWindowData::fgDataHandle = 0;


/*------------------------------------------------------------------------------
| IFlyHelpHandlerStatics::~IFlyHelpHandlerStatics                              |
------------------------------------------------------------------------------*/
IFlyHelpHandlerStatics::~IFlyHelpHandlerStatics( )
{
   IMODTRACE_DEVELOP("IFlyHelpHandlerStatics::~IFlyHelpHandlerStatics");
#if IC_STATIC_PRIORITY_SUPPORTED
   // Delete is safe only when the order of static object init can be controlled.
   if (fgHandleStringSet)
      delete fgHandleStringSet;
#endif
}

/*------------------------------------------------------------------------------
| IFlyHelpHandlerStatics::handleStringSet                                      |
------------------------------------------------------------------------------*/
IHandleStringSet& IFlyHelpHandlerStatics::handleStringSet( )
{
   if (!fgHandleStringSet)
   {
       IPrimalLock lock;
       if (!fgHandleStringSet)
          fgHandleStringSet = new IHandleStringSet;
   }
   return *fgHandleStringSet;
}

/*------------------------------------------------------------------------------
| IHandleStringElement::IHandleStringElement                                   |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IHandleStringElement::IHandleStringElement( unsigned long      handle,
                                            const IString&     flyText,
                                            const IString&     longText )
:  handleKey(handle)
 , flyStr(flyText)
 , longStr(longText)
 , flyResId(0)
 , longResId(0)
 , fStrings(true)
#ifdef IC_WIN
 , subclassProc(0)
 , flyData(0)
#endif
{ }

/*------------------------------------------------------------------------------
| IHandleStringElement::IHandleStringElement                                   |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IHandleStringElement::IHandleStringElement( unsigned long      handle,
                                            const IResourceId& flyText,
                                            const IResourceId& longText )
:  handleKey(handle)
 , flyStr()
 , longStr()
 , flyResId(flyText)
 , longResId(longText)
 , fStrings(false)
#ifdef IC_WIN
 , subclassProc(0)
 , flyData(0)
#endif
{ }

/*------------------------------------------------------------------------------
| IHandleStringElement::~IHandleStringElement                                  |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IHandleStringElement::~IHandleStringElement( )
{ }

/*------------------------------------------------------------------------------
| IHandleStringSet::IHandleStringSet                                           |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IHandleStringSet::IHandleStringSet()
: IKeySortedSetAsTable  < IHandleStringElement*, unsigned long > (10)
{ }

/*------------------------------------------------------------------------------
| IHandleStringSet::~IHandleStringSet                                          |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IHandleStringSet::~IHandleStringSet()
{
  // Delete all the elements in the set and remove them.
  IHandleStringSet::Cursor cursor(*this);
  forCursor (cursor)
  {
    delete this->elementAt( cursor );
  }
  this->removeAll();
}

/*------------------------------------------------------------------------------
| IHandleStringSet::~IHandleStringSet                                          |
------------------------------------------------------------------------------*/
IFlyOverWindowData::IFlyOverWindowData( IFlyOverHelpHandler* handler) :
  fHandler(handler),
  fEventMask(0)
{ }

IFlyOverWindowData::~IFlyOverWindowData()
{ }


#ifdef IC_WIN

// The following window proc is used to subclass child windows of
// aggregate controls such as combo boxes and spin buttons.  These
// child windows are subclassed so that we can catch the notify messages
// from the tool tip control.  This allows tool
// tip messages for all immediate child windows in an aggregate control.
/*------------------------------------------------------------------------------
| fFlyHelpSubclassProc                                                         |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
unsigned long __stdcall fFlyHelpSubclassProc(HWND hwnd, unsigned long ulMsg,
                                             WPARAM mp1, LPARAM mp2)
{
  IHandleStringElement *element(0);
  // Get the handle string element from the hwnd.
  if ( flyHelpStatics.handleStringSet().containsElementWithKey( (unsigned long)hwnd ))
  {
    element = (IHandleStringElement*)
        flyHelpStatics.handleStringSet().elementWithKey( (unsigned long)hwnd );
  }
  else
  {
    // We should never get here!
    return 0;
  }

  switch (ulMsg)
  {
    case WM_NOTIFY         :
       element->flyData->notifyEvent((NMHDR*)mp2);
       break;

    case WM_DESTROY:
       // Un-subclass the window and remove the window from the
       // handle string set.
       SetWindowLong( hwnd, GWL_WNDPROC, (long)element->subclassProc );
       flyHelpStatics.handleStringSet().removeElementWithKey((unsigned long)hwnd);
       break;

    case WM_MOUSEMOVE:
    case WM_LBUTTONDOWN:
    case WM_LBUTTONUP:
    case WM_RBUTTONDOWN:
    case WM_RBUTTONUP:
    case WM_MBUTTONDOWN:
    case WM_MBUTTONUP:
    case WM_NCMOUSEMOVE:
    case WM_NCLBUTTONDOWN:
    case WM_NCLBUTTONUP:
    case WM_NCRBUTTONDOWN:
    case WM_NCRBUTTONUP:
    case WM_NCMBUTTONDOWN:
    case WM_NCMBUTTONUP:
       if (element->flyData->fFlytxt)
          {
          MSG msg;
          msg.lParam = mp2;
          msg.wParam = mp1;
          msg.message = ulMsg;
          msg.hwnd = hwnd;
          element->flyData->fFlytxt->sendEvent( TTM_RELAYEVENT,0, &msg);
          }
       break;
  }
  return (unsigned long)
           CallWindowProc((FARPROC)element->subclassProc, hwnd, ulMsg, mp1, mp2);
}

/*------------------------------------------------------------------------------
| IFlyOverData::setHelpText                                                    |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IFlyOverData& IFlyOverData::setHelpText( const IWindowHandle& handle,
                                         IHandleStringElement& element )
{
  TOOLINFO  toolinfo;
  toolinfo.cbSize   = sizeof(TOOLINFO);
  toolinfo.uFlags   = TTF_IDISHWND ;
  toolinfo.hwnd     = handle;
  toolinfo.uId      = (UINT)handle.asUnsigned();
  toolinfo.lpszText = LPSTR_TEXTCALLBACK;    // want TTN_NEEDTEXT message

  IWindow* child(IWindow::windowWithHandle( handle ));

  if (!child)
  {
    element.subclassProc = (unsigned long (* __stdcall)
                            (HWND hwnd, unsigned long ulMsg,
                             WPARAM mp1, LPARAM mp2))

                            SetWindowLong( handle, GWL_WNDPROC,
                                           (long)fFlyHelpSubclassProc );
    element.flyData = this;

    if (!fFlytxt->sendEvent( TTM_ADDTOOL,
                             0,
                             IEventData( &toolinfo) ).asUnsignedLong())
       ITHROWGUIERROR("TTM_ADDTOOL");
  }
  else
  {
    if (child->sendEvent( IC_UM_IS_AGGREGATE_CTRL ).asUnsignedLong())
    {
      // If the window is an aggregate control (such as native container)
      // set the text of the child windows to be the same as the aggregate
      IWindow::ChildCursor aggregateCursor( *child );
      forCursor (aggregateCursor)
      {
        IWindowHandle childHandle(child->childAt( aggregateCursor ));
        if ( flyHelpStatics.handleStringSet().containsElementWithKey( childHandle.asUnsigned() ))
        {
          IHandleStringElement*
            childElement(flyHelpStatics.handleStringSet().elementWithKey( childHandle.asUnsigned()));

          if (element.fStrings)
          {
            childElement->flyStr    = element.flyStr;
            childElement->longStr   = element.longStr;
            childElement->flyResId  = 0;
            childElement->longResId = 0;
            childElement->fStrings  = true;
          }
          else
          {
            childElement->flyStr    = IString();
            childElement->longStr   = IString();
            childElement->flyResId  = element.flyResId;
            childElement->longResId = element.longResId;
            childElement->fStrings  = false;
          }
        }
      }
    }
  }
  return *this;
}

#endif

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IFlyHelpTimeoutProc                                                          |
| The fly help handler uses XtAppAddTimeout to get a callback when the         |
| time has expired.  This is the callback function.                            |
|                                                                              |
------------------------------------------------------------------------------*/
void _System IFlyHelpTimeoutProc( XtPointer client_data, XtIntervalId* timerId )
{
  IMODTRACE_DEVELOP("IFlyHelpTimeoutProc");
  if (client_data)
     {
     IFlyOverData* flydata = (IFlyOverData*)client_data;
     // Only process timer events which match the one expected.  This is
     // to eliminate problems with queued timeouts.
     if (*timerId == flydata->fTimer)
        {
        flydata->fTimer = 0;     // clear out timer id since it popped
        flydata->timerpop( IFlyOverData::timerExpired );
        }
     }
}

/*------------------------------------------------------------------------------
| IFlyHelpDestroyCallback                                                      |
| Remove entries from string set when widget is destroyed.                     |
------------------------------------------------------------------------------*/
void _System IFlyHelpDestroyCallback(
               Widget    widget,
               XtPointer client_data,
               XtPointer call_data)
{
  IMODTRACE_DEVELOP("IFlyHelpDestroyCallback");
  IWindowHandle handle(widget);
  if ( flyHelpStatics.handleStringSet().containsElementWithKey( handle.asUnsigned() ))
    {
    IHandleStringElement *oldElement((IHandleStringElement*)
       flyHelpStatics.handleStringSet().elementWithKey( handle.asUnsigned() ));
    flyHelpStatics.handleStringSet().removeElementWithKey( handle.asUnsigned() );
    delete oldElement;
    }
}

#endif //IC_MOTIF

/*------------------------------------------------------------------------------
| IFlyOverData::IFlyOverData                                                   |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IFlyOverData::IFlyOverData( IFlyText* flyText, ITextControl* longText,
                            unsigned long delay, unsigned long initialDelay,
                            IFlyOverHelpHandler* flyHelp )
: fFlytxt(flyText), fLongtxt(longText),
  fLongOffset(0), fFlyOffset(0),
#ifdef IC_PM
  fTimer(),
#endif
#ifdef IC_MOTIF
  fTimer(0),
#endif
#ifdef IC_MOTIFPM
  fHandle(0),
  fPrevPos(),
#endif
#ifdef IC_PM
  fPrevHandle(0),
  fControlWindow(0),
#endif
  fDefault(),
  fControlHandle(0),
  fFly(flyHelp),
  fResLib(0),
  fTimerDelay(delay),            // Save the original timer value.
  fInitialTimerDelay(initialDelay)
{
  // Initialize a token for using IWindowData
  if (!IFlyOverWindowData::fgDataHandle)
     {
     IFlyOverWindowData::fgDataHandle =
       IWindow::dataHandleWithKey( "IFlyOverWindowData::fgDataHandle" );
     }

#ifdef IC_WIN
  // Initialize the delays in the tooltips control
  if (fFlytxt)
     {
     fFlytxt->sendEvent( TTM_SETDELAYTIME,
                         IEventData( TTDT_INITIAL),
                         IEventData( fInitialTimerDelay ) );
     fFlytxt->sendEvent( TTM_SETDELAYTIME,
                         IEventData( TTDT_RESHOW ),
                         IEventData( fTimerDelay ) );
     // This is supposed to keep the help displayed.  Does not
     // seem to work.   Goes away after maybe 10 seconds.
     fFlytxt->sendEvent( TTM_SETDELAYTIME,              //stays as long as
                         IEventData( TTDT_AUTOPOP),     //mouse does
                         IEventData( INT_MAX ) );
     }
#endif

}

/*------------------------------------------------------------------------------
| IFlyOverData::~IFlyOverData                                                  |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IFlyOverData::~IFlyOverData()
{
  delete fResLib;
  // Make sure the text is hidden and stop the timer
  if (fLongtxt)
    setLongText( fDefault );
#ifdef IC_MOTIFPM
  if ( fFlytxt && fFlytxt->isValid() )
    fFlytxt->hide();
#endif

#ifdef IC_PM
  fTimer.stop();
#endif
#ifdef IC_MOTIF
  if (fTimer)
     XtRemoveTimeOut(fTimer);
#endif

}

/*------------------------------------------------------------------------------
| IFlyOverHelpHandler::IFlyOverHelpHandler                                     |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IFlyOverHelpHandler::IFlyOverHelpHandler( IFlyText* flyText,
                                          unsigned long initialDelay,
                                          unsigned long delay )
: fFlyOverData( new IFlyOverData(flyText, 0, delay, initialDelay, this))
{ }

/*------------------------------------------------------------------------------
| IFlyOverHelpHandler::IFlyOverHelpHandler                                     |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IFlyOverHelpHandler::IFlyOverHelpHandler( ITextControl* longText,
                                          unsigned long initialDelay,
                                          unsigned long delay )
: fFlyOverData( new IFlyOverData(0, longText, delay, initialDelay, this))
{ }

/*------------------------------------------------------------------------------
| IFlyOverHelpHandler::IFlyOverHelpHandler                                     |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IFlyOverHelpHandler::IFlyOverHelpHandler( IFlyText* flyText,
                                          ITextControl* longText,
                                          unsigned long initialDelay,
                                          unsigned long delay )
: fFlyOverData( new IFlyOverData(flyText, longText, delay, initialDelay, this))
{ }

/*------------------------------------------------------------------------------
| IFlyOverHelpHandler::~IFlyOverHelpHandler                                    |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IFlyOverHelpHandler::~IFlyOverHelpHandler()
{
  delete fFlyOverData;

#ifndef IC_MOTIF
  // Cannot reliably use IISWINDOW in Motif because it requires a valid
  // pointer to a potential Widget.  We use IFlyTextDestroyCallback instead
  // to clean up this collection.
  IHandleStringSet::Cursor cursor(flyHelpStatics.handleStringSet());
  for (cursor.setToFirst(); cursor.isValid();)
  {
    IHandleStringElement* element((IHandleStringElement*)flyHelpStatics.handleStringSet().elementAt( cursor ));
    if (IISWINDOW(IThread::current().anchorBlock(),
                 (IWindowHandle::Value)element->handleKey ))
      cursor.setToNext();
    else
    {
      flyHelpStatics.handleStringSet().removeAt( cursor );
      delete element;
      cursor.setToFirst();
    }
  }
#endif
}

/*------------------------------------------------------------------------------
| IFlyOverHelpHandler::flyTextControl                                          |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IFlyText* IFlyOverHelpHandler::flyTextControl( ) const
{
  return fFlyOverData->fFlytxt;
}

/*------------------------------------------------------------------------------
| IFlyOverHelpHandler::longTextControl                                         |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
ITextControl* IFlyOverHelpHandler::longTextControl( ) const
{
  return fFlyOverData->fLongtxt;
}

/*------------------------------------------------------------------------------
| IFlyOverHelpHandler::setFlyTextControl                                       |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IFlyOverHelpHandler& IFlyOverHelpHandler::setFlyTextControl(IFlyText* flyText)
{
  fFlyOverData->fFlytxt = flyText;
  return *this;
}

/*------------------------------------------------------------------------------
| IFlyOverHelpHandler::setLongTextControl                                      |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IFlyOverHelpHandler& IFlyOverHelpHandler::setLongTextControl(
                                                        ITextControl* longText )
{
  fFlyOverData->fLongtxt = longText;
  return *this;
}

/*------------------------------------------------------------------------------
| IFlyOverHelpHandler::resourceLibrary                                         |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IResourceLibrary& IFlyOverHelpHandler::resourceLibrary( ) const
{
  // If we've got our own, return it, else use the current user default.
  if ( fFlyOverData->fResLib )
    return *fFlyOverData->fResLib;
  else
    return IApplication::current().userResourceLibrary();
}
#ifndef IC_MOTIF
/*------------------------------------------------------------------------------
| IFlyOverHelpHandler::setResourceLibrary                                      |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IFlyOverHelpHandler& IFlyOverHelpHandler::setResourceLibrary(
                                                   const IModuleHandle &resMod )
{
  // Construct a DLL from the input handle.

  delete fFlyOverData->fResLib;
  fFlyOverData->fResLib = 0;
  if ( resMod )
    fFlyOverData->fResLib = new IDynamicLinkLibrary( resMod );
  else
    fFlyOverData->fResLib = new IResourceLibrary();

  return *this;
}
#endif
/*------------------------------------------------------------------------------
| IFlyOverHelpHandler::setResourceLibrary                                      |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IFlyOverHelpHandler& IFlyOverHelpHandler::setResourceLibrary
                          ( const char *resDLLName,
                          IDynamicLinkLibrary::ESearchLocation searchLocation )
{
  // Construct a DLL from the input dll name.

  delete fFlyOverData->fResLib;
  fFlyOverData->fResLib = 0;
  if ( resDLLName )
    fFlyOverData->fResLib = new IDynamicLinkLibrary( resDLLName, 
                                                           searchLocation );
  else
    fFlyOverData->fResLib = new IResourceLibrary();

  return *this;
}

/*------------------------------------------------------------------------------
| IFlyOverHelpHandler::setFlyStringTableOffset                                 |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IFlyOverHelpHandler& IFlyOverHelpHandler::setFlyTextStringTableOffset(
                                                                long newOffset )
{
  fFlyOverData->fFlyOffset = newOffset;
  return *this;
}

/*------------------------------------------------------------------------------
| IFlyOverHelpHandler::setLongStringTableOffset                                |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IFlyOverHelpHandler& IFlyOverHelpHandler::setLongStringTableOffset(
                                                                long newOffset )
{
  fFlyOverData->fLongOffset = newOffset;
  return *this;
}

/*------------------------------------------------------------------------------
| IFlyOverHelpHandler::flyTextStringTableOffset                                |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
long IFlyOverHelpHandler::flyTextStringTableOffset ( ) const
{
  return fFlyOverData->fFlyOffset;
}

/*------------------------------------------------------------------------------
| IFlyOverHelpHandler::longStringTableOffset                                   |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
long IFlyOverHelpHandler::longStringTableOffset  ( ) const
{
  return fFlyOverData->fLongOffset;
}

/*------------------------------------------------------------------------------
| IFlyOverHelpHandler::defaultText                                             |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IString IFlyOverHelpHandler::defaultText ( ) const
{
  return fFlyOverData->fDefault;
}

/*------------------------------------------------------------------------------
| IFlyOverHelpHandler::setDefaultText                                          |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IFlyOverHelpHandler& IFlyOverHelpHandler::setDefaultText( unsigned long id )
{
  fFlyOverData->fDefault = this->resourceLibrary().loadString( id );
  return *this;
}

/*------------------------------------------------------------------------------
| IFlyOverHelpHandler::setDefaultText                                          |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IFlyOverHelpHandler& IFlyOverHelpHandler::setDefaultText( const IString &id )
{
  fFlyOverData->fDefault = id;
  return *this;
}

/*------------------------------------------------------------------------------
| IFlyOverHelpHandler::flyHelpText                                             |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IString IFlyOverHelpHandler::flyHelpText(const IWindowHandle& handle ) const
{
  if ( flyHelpStatics.handleStringSet().containsElementWithKey( handle.asUnsigned() ))
  {
    IHandleStringElement*
      elementWithHandle(
         flyHelpStatics.handleStringSet().elementWithKey( handle.asUnsigned() ));
    return elementWithHandle->flyStr;
  }
  else
  {
    return IString();
  }
}

/*------------------------------------------------------------------------------
| IFlyOverHelpHandler::longHelpText                                            |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IString IFlyOverHelpHandler::longHelpText(const IWindowHandle& handle ) const
{
  if ( flyHelpStatics.handleStringSet().containsElementWithKey( handle.asUnsigned() ))
  {
    IHandleStringElement*
      elementWithHandle(flyHelpStatics.handleStringSet().elementWithKey(
         handle.asUnsigned() ));
    return elementWithHandle->longStr;
  }
  else
  {
    return IString();
  }
}

/*------------------------------------------------------------------------------
| IFlyOverHelpHandler::setHelpText                                             |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IFlyOverHelpHandler& IFlyOverHelpHandler::setHelpText
                                               ( const IWindowHandle& handle,
                                                 const IString&       flyText,
                                                 const IString&       longText )
{
  IHandleStringElement* element(0);
  if ( flyHelpStatics.handleStringSet().containsElementWithKey( handle.asUnsigned() ))
  {
    element = (IHandleStringElement*)flyHelpStatics.handleStringSet().elementWithKey( handle.asUnsigned() );
    element->flyStr    = flyText;
    element->longStr   = longText;
    element->flyResId  = 0;
    element->longResId = 0;
    element->fStrings  = true;
  }
  else
  {
    element = new IHandleStringElement(handle.asUnsigned(),flyText,longText);
    flyHelpStatics.handleStringSet().add(element);
#ifdef IC_MOTIF
    // Need to know when widget is destroyed to clean up static string list.
    XtAddCallback(
       handle,                     // widget
       XmNdestroyCallback,         // callback name
       IFlyHelpDestroyCallback,    // callback routine
       (XtPointer*)this);          // save reference to this handler in client data
#endif
  }

#ifdef IC_WIN
  fFlyOverData->setHelpText( handle, *element );
#endif
  return *this;
}

/*------------------------------------------------------------------------------
| IFlyOverHelpHandler::setHelpText                                             |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IFlyOverHelpHandler& IFlyOverHelpHandler::setHelpText
                                               ( const IWindowHandle& handle,
                                                 const IResourceId&   flyText,
                                                 const IResourceId&   longText )
{
  IHandleStringElement* element(0);
  if ( flyHelpStatics.handleStringSet().containsElementWithKey( handle.asUnsigned() ))
  {
    element = (IHandleStringElement*)flyHelpStatics.handleStringSet().elementWithKey( handle.asUnsigned() );
    if (element->fStrings)
    {
      element->flyStr  = IString();
      element->longStr = IString();
    }
    element->flyResId  = flyText;
    element->longResId = longText;
    element->fStrings  = false;
  }
  else
  {
    element = new IHandleStringElement(handle.asUnsigned(),flyText,longText);
    flyHelpStatics.handleStringSet().add(element);
#ifdef IC_MOTIF
    // Need to know when widget is destroyed to clean up static string list.
    XtAddCallback(
       handle,                     // widget
       XmNdestroyCallback,         // callback name
       IFlyHelpDestroyCallback,    // callback routine
       (XtPointer*)this);          // save reference to this handler in client data
#endif
  }

#ifdef IC_WIN
  fFlyOverData->setHelpText( handle, *element );
#endif
  return *this;
}

/*------------------------------------------------------------------------------
| IFlyOverHelpHandler::removeHelpText                                          |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IFlyOverHelpHandler& IFlyOverHelpHandler::removeHelpText
                                                 ( const IWindowHandle& handle )
{
  if ( flyHelpStatics.handleStringSet().containsElementWithKey( handle.asUnsigned() ))
  {
    IHandleStringElement *oldElement((IHandleStringElement*)
       flyHelpStatics.handleStringSet().elementWithKey( handle.asUnsigned() ));
    flyHelpStatics.handleStringSet().removeElementWithKey( handle.asUnsigned() );

#ifdef IC_WIN
    IWindow* oldWindow(IWindow::windowWithHandle( handle ));
    if (!oldWindow && oldElement->subclassProc != 0)
    {
      SetWindowLong( handle, GWL_WNDPROC, (long)oldElement->subclassProc );

      TOOLINFO  toolinfo;
      toolinfo.cbSize = sizeof(TOOLINFO);
      toolinfo.hwnd   = handle;
      toolinfo.uId    = (UINT)handle.asUnsigned();

      fFlyOverData->fFlytxt->sendEvent( TTM_DELTOOL,
                                        0,
                                        IEventData( &toolinfo) );
    }
#endif
#ifdef IC_MOTIF
    // Remove the destroy callback.
    XtRemoveCallback(
       handle,                     // widget
       XmNdestroyCallback,         // callback name
       IFlyHelpDestroyCallback,    // callback routine
       (XtPointer*)this);          // save reference to this handler in client data
#endif
    delete oldElement;
  }
  return *this;
}

/*------------------------------------------------------------------------------
| IFlyOverHelpHandler::setDelayTime                                            |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IFlyOverHelpHandler& IFlyOverHelpHandler::setDelayTime( unsigned long milliseconds )
{
#ifdef IC_WIN
  IFlyText* flytext = this->flyTextControl();
  if (flytext)
     {
     flytext->sendEvent( TTM_SETDELAYTIME,
                         IEventData( TTDT_RESHOW ),
                         IEventData( milliseconds ) );
     }
#endif
#ifdef IC_PM
  fFlyOverData->fTimer.setInterval( milliseconds/2 );
#endif
  // Save the new timer delay.
  fFlyOverData->fTimerDelay = milliseconds;
  return *this;
}

/*------------------------------------------------------------------------------
| IFlyOverHelpHandler::delayTime                                               |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
unsigned long IFlyOverHelpHandler::delayTime( ) const
{
  // Return the last set time delay.
  // return fFlyOverData->fTimer.interval();
  return fFlyOverData->fTimerDelay;
}

/*------------------------------------------------------------------------------
| IFlyOverHelpHandler::setInitialDelayTime                                     |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IFlyOverHelpHandler& IFlyOverHelpHandler::setInitialDelayTime( unsigned long milliseconds )
{
#ifdef IC_WIN
  IFlyText* flytext = this->flyTextControl();
  if (flytext)
     {
     flytext->sendEvent( TTM_SETDELAYTIME,
                         IEventData( TTDT_INITIAL ),
                         IEventData( milliseconds ) );
     }
#endif
  // Save the new timer delay.
  fFlyOverData->fInitialTimerDelay = milliseconds;
  return *this;
}

/*------------------------------------------------------------------------------
| IFlyOverHelpHandler::initialDelayTime                                        |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
unsigned long IFlyOverHelpHandler::initialDelayTime( ) const
{
  // Return the last set time delay.
  // return fFlyOverData->fTimer.interval();
  return fFlyOverData->fInitialTimerDelay;
}


/*------------------------------------------------------------------------------
| IFlyOverHelpHandler::startHandlingEventsFor                                  |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IFlyOverHelpHandler& IFlyOverHelpHandler::handleEventsFor( IWindow* window )
{
  IASSERTPARM(window != 0);
  IFlyOverHelpHandler::Inherited::handleEventsFor( window );

  // See if this handler is installed on the window.  If not, allocate
  // a window data block and attach it so we know we have been there.
  IFlyOverWindowData* flyWindowData = (IFlyOverWindowData*)
     window->windowData( IFlyOverWindowData::fgDataHandle );
  if (!flyWindowData)
     {
     // Window does not have any fly help handler.  Install this one.
     flyWindowData = new IFlyOverWindowData(this);
     window->adoptWindowData(IFlyOverWindowData::fgDataHandle, flyWindowData);
     }

#ifdef IC_WIN
  // Register the new control with the tooltips control.  Arrange
  // to have WM_NOTIFY (TTN_NEEDTEXT) sent to the window we are handling
  // events for.  We deal with this message in dispatchHandlerEvents.
  // If IWindow is changed to do WM_NOTIFY like WM_CONTROL, we
  // will need to change the hwnd value to be the owner.
  IFlyText* flytext = this->flyTextControl();
  if (flytext)
     {
     TOOLINFO  toolinfo;
     toolinfo.cbSize = sizeof(TOOLINFO);
     toolinfo.uFlags = TTF_IDISHWND ;
     toolinfo.hwnd   = window->handle();  // sends WM_NOTIFY to this window
     toolinfo.uId    = (UINT)window->handle().asUnsigned();
                                         // window for which help applies
     toolinfo.lpszText = LPSTR_TEXTCALLBACK;    // want TTN_NEEDTEXT message
     
     // TOOLINFO fields rect and hinst not needed
     IFUNCTRACE_DEVELOP();
     ITRACE_DEVELOP
       ( IString("TTM_ADDTOOL") +
         IString(" uFlags="  ) +
         IString((unsigned long)toolinfo.uFlags).d2x() +
         IString(" hwnd="    ) +
         IString((unsigned long)toolinfo.hwnd).d2x() +
         IString(" uId="     ) +
         IString((unsigned long)toolinfo.uId).d2x() +
         IString(" lpszText=") +
         IString((unsigned long)toolinfo.lpszText).d2x() );
     if (!flytext->sendEvent( TTM_ADDTOOL,
                              0,
                              IEventData( &toolinfo) ).asUnsignedLong())
        ITHROWGUIERROR("TTM_ADDTOOL");

     bool windowIsAggregate((bool)window->sendEvent( IC_UM_IS_AGGREGATE_CTRL ).asUnsignedLong());

     //
     // Perform a similar registration of child IWindows
     IWindow::ChildCursor cursor( *window );
     for (cursor.setToFirst(); cursor.isValid(); cursor.setToNext() )
        {
        IWindow* child = IWindow::windowWithHandle( window->childAt( cursor ));
        if (child)
           {
           // See if there is fly help window data on the child indicating
           // this handler is installed on the child.  If so,
           // don't install it again.
           if ( !child->windowData( IFlyOverWindowData::fgDataHandle ) )
              {
              this->handleEventsFor( child );
              }
           }
        if (windowIsAggregate)
           {
           // handle non-IWindow children and set the fly text for all
           // children to be the same as this window
           setHelpText( window->childAt( cursor ),
                        IResourceId( window->id() + flyTextStringTableOffset() ),
                        IResourceId( window->id() + longStringTableOffset() ));
           }
        }
     }

#endif
#ifdef IC_PM
  if (!fFlyOverData->fTimer.isStarted())
  {
    fFlyOverData->fTimer.setInterval( fFlyOverData->fInitialTimerDelay/2 );
    fFlyOverData->fTimer.start(
      new ITimerMemberFn<IFlyOverData>(*fFlyOverData, &IFlyOverData::timerpop));

    fFlyOverData->fPrevPos = IWindow::pointerPosition();
  }
#endif
#ifdef IC_MOTIF
  // Ensure that we will get EnterNotify and LeaveNotify events. 
    window->startHandling( IWindow::mouseEntersLeaves );

  XtAddEventHandler(
     (IWindowHandle::Value)window->handle(),    // widget
     ButtonPressMask | ButtonReleaseMask,         // want button events
     False,                   // do not need nonmaskable events
     iwindowXEventCallback,   // event handler routine
     (XtPointer*)window);     // save reference to this IWindow in client data

  IWindowHandle createHandle = window->handleForChildCreation();
  if (createHandle)
     {
     // Find IWindow children of the createHandle and install handler
     // for them.
     if ( XtIsComposite( (IWindowHandle::Value)createHandle ) )
        {
        Cardinal   numChildren;
        WidgetList children;
        XtVaGetValues( ( IWindowHandle::Value) createHandle,
                         XmNnumChildren, &numChildren,
                         XmNchildren, &children,
                         0 );
        for ( int i = 0; i < numChildren; i++ )
           {
           IWindow* child = IWindow::windowWithHandle( children[i] );
           // We do not worry about non-IWindow children.  For purposes
           // of fly help we treat them as part of this window.
           if (child)
              {
              // See if there is fly help window data on the child indicating
              // this handler is installed on the child.  If so,
              // don't install it again.
              if (!child->windowData( IFlyOverWindowData::fgDataHandle ))
                 {
                 this->handleEventsFor( child );
                 }
              }
           }  // for children
        }  // if is composite
     }  // use create handle

#endif
  return *this;
}

/*------------------------------------------------------------------------------
| IFlyOverHelpHandler::stopHandlingEventsFor                                   |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IFlyOverHelpHandler& IFlyOverHelpHandler::stopHandlingEventsFor( IWindow* window )
{
  IASSERTPARM(window != 0);
  IFlyOverHelpHandler::Inherited::stopHandlingEventsFor( window );
#ifdef IC_WIN
  IFlyText* flytext = this->flyTextControl();
  if ( flytext && flytext->isValid() )
     {
     TOOLINFO  toolinfo;
     toolinfo.cbSize = sizeof(TOOLINFO);
     toolinfo.hwnd   = window->handle();  // sends WM_NOTIFY to this window
     toolinfo.uId    = (UINT)window->handle().asUnsigned();
                                         // window for which help applies
     // other TOOLINFO fields not needed
     flytext->sendEvent( TTM_DELTOOL,
                         0,
                         IEventData( &toolinfo) );

     bool windowIsAggregate((bool)window->sendEvent( IC_UM_IS_AGGREGATE_CTRL ).asUnsignedLong());
     //
     // Perform a similar deregistration of child IWindows
     IWindow::ChildCursor cursor( *window );
     for (cursor.setToFirst(); cursor.isValid(); cursor.setToNext() )
        {
        IWindow* child = IWindow::windowWithHandle( window->childAt( cursor ));
        if (child)
           {
           // Check to see if the child has the handler installed and
           // it is this instance.  If so, remove it.
           IFlyOverWindowData* childFlyWindowData = (IFlyOverWindowData*)
              child->windowData( IFlyOverWindowData::fgDataHandle );
           if ( childFlyWindowData &&
                (childFlyWindowData->fHandler == this) )
              {
              this->stopHandlingEventsFor( child );
              }
           }
        if (windowIsAggregate)
           {
           removeHelpText( window->childAt( cursor ));
           }
        }
     }
#endif
#ifdef IC_MOTIF
  IWindowHandle createHandle = window->handleForChildCreation();
  if (createHandle)
     {
     // Find IWindow children of the createHandle and remove handler
     // from them.
     if ( XtIsComposite( (IWindowHandle::Value)createHandle ) )
        {
        Cardinal   numChildren;
        WidgetList children;
        XtVaGetValues( ( IWindowHandle::Value) createHandle,
                         XmNnumChildren, &numChildren,
                         XmNchildren, &children,
                         0 );
        for ( int i = 0; i < numChildren; i++ )
           {
           IWindow* child = IWindow::windowWithHandle( children[i] );
           // We do not worry about non-IWindow children.  For purposes
           // of fly help we treat them as part of this window.
           if (child)
              {
              IFlyOverWindowData* childFlyWindowData = (IFlyOverWindowData*)
                 child->windowData( IFlyOverWindowData::fgDataHandle );
              if ( childFlyWindowData &&
                   (childFlyWindowData->fHandler == this) )
                 {
                 window->stopHandling( IWindow::mouseEntersLeaves );
                 this->stopHandlingEventsFor( child );
                 }
              }
           }  // for children
        }  // if is composite
     }  // use create handle
#endif

  // hide long text
  if (fFlyOverData->fLongtxt)
    fFlyOverData->setLongText( fFlyOverData->fDefault );

  // Make sure the text is hidden and stop the timer
#ifdef IC_PM
  fFlyOverData->fPrevHandle = 0;
  fFlyOverData->fTimer.stop();
#endif
  if (fFlyOverData->fFlytxt)
    fFlyOverData->fFlytxt->hide();
#ifdef IC_MOTIF
  if (fFlyOverData->fTimer)
     {
     XtRemoveTimeOut(fFlyOverData->fTimer);
     fFlyOverData->fTimer = 0;
     }
  // Reset the event mask.
  // XtRemoveEventHandler will probably remove IWindow's
  // as well.
#endif

  // Remove the data we attached to the IWindow.  IWindow handles
  // deleting the object.
  window->adoptWindowData(IFlyOverWindowData::fgDataHandle, 0);
  return *this;
}

/*------------------------------------------------------------------------------
| IFlyOverHelpHandler::dispatchHandlerEvent                                    |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
bool IFlyOverHelpHandler::dispatchHandlerEvent( IEvent& event )
{
#ifdef IC_WIN
  ITRACE_ALL(IString("FlyHelpHandler: HWND=") + IString(event.handle().asUnsigned()).d2x()+
             IString(", Msg=") + IString(event.eventId()).d2x()+
             IString(", MP1=") + IString((unsigned long)event.parameter1()).d2x()+
             IString(", MP2=") + IString((unsigned long)event.parameter2()).d2x());

  switch (event.eventId())
     {
     case WM_NOTIFY         :
        {
        NMHDR*  nmhdr = (NMHDR*)(event.parameter2().asUnsignedLong());
        fFlyOverData->notifyEvent( nmhdr );
        }  // case WM_NOTIFY

        break;

     case WM_PARENTNOTIFY   :
        // Detect the creation of child windows.   Deletion of child
        // windows is handled by stopHandlingEvents.
        {
        if ( event.parameter1().lowNumber() == WM_CREATE )
           {
           // We use the user message IC_UM_FLY_PAINT to notify ourselves
           // of the creation of a child window.  We need to post it
           // to ourselves so that IWindow will have done its creation
           // logic when we process it.  WM_PARENTNOTIFY is sent
           // by CreateWindowEx, and therefore windowWithHandle will
           // always return 0.
           event.handle().postEvent(
               IC_UM_FLY_PAINT,
               IEventData( event.parameter1().highNumber() ),
               event.parameter2() );
           event.setResult(0);   // required by Win32
           return true;          // stop handlers
           }
        }  // case WM_PARENTNOTIFY

        break;

     case IC_UM_FLY_PAINT   :
        // The message name is a misnomer in Windows.   We don't need
        // this message for painting in Windows, so it is reused.
        // A more appropriate name is IC_UM_FLY_HANDLER
        //
        // IC_UM_FLY_PAINT is used to arrange for this handler to get
        // attached to all IWindow children of a window with the
        // handler attached.  This is needed so that we can process the
        // tooltips control request for text.   There are 2 flavors:
        // Query and Set
        //  Query:   lParam == 0.  True is returned by this handler.
        //           in the message result.  This is used to detect the
        //           existance of this handler (or a derived one) on a
        //           control.  Performance optimization to avoid >1 handler
        //           per control doing the same thing.
        //  Set:     lParam == HWND of a control to start handling
        //           events for.   If the control is an IWindow,
        //           install this handler for the control.
        //
        // We use the user message IC_UM_FLY_PAINT to notify ourselves
        // of the creation of a child window.  We need to post it
        // to ourselves so that IWindow will have done its creation
        // logic when we process it.  WM_PARENTNOTIFY is sent
        // by CreateWindowEx, and therefore windowWithHandle will
        // always return 0.
        {
        IWindowHandle childHwnd = (HWND)event.parameter2().asUnsignedLong();
        if (childHwnd != 0)
           {
           // Set.  Add the handler.
           IWindow*      child = IWindow::windowWithHandle(childHwnd);
           if (child)
              {
              // See if there is fly help window data on the child indicating
              // this handler is installed on the child.  If so,
              // don't install it again.  We need this check here since
              // WM_PARENTNOTIFY goes to all ancestor windows.
              if ( !child->windowData( IFlyOverWindowData::fgDataHandle ) )
                 {
                 this->handleEventsFor( child );
                 event.setResult(1);
                 }
              }         // is IWindow

           // handle the case where this is an aggregate control
           if (event.handle().sendEvent( IC_UM_IS_AGGREGATE_CTRL ).asUnsignedLong())
              {
              if ( flyHelpStatics.handleStringSet().containsElementWithKey(
                                        event.handle().asUnsigned() ))
                {
                // We got a hit in the handle set.
                IHandleStringElement*
                   parentElement(flyHelpStatics.handleStringSet().elementWithKey(
                                     event.handle().asUnsigned()));

                if ( parentElement->fStrings )
                   {
                   setHelpText( childHwnd,
                                parentElement->flyStr,
                                parentElement->longStr );
                   }
                else
                   {
                   setHelpText( childHwnd,
                                IResourceId(parentElement->flyResId),
                                IResourceId(parentElement->longResId) );
                   }
                 }  // parent in string set
              else
                 {
                 // parent not in string set...use ID of parent
                 unsigned long parentId ( IIDOF( event.handle()) );
                 setHelpText( childHwnd,
                              IResourceId(parentId),
                              IResourceId(parentId) );

                 }
              }   // parent of new control is aggregate
           }    // is set
        else
           {
           // Query.  Just set result to indicate we are here.
           event.setResult(1);
           }    // is query
        }  // case IC_UM_FLY_PAINT

        return true;       // done ... stop handlers

     case WM_MOUSEMOVE:
     case WM_LBUTTONDOWN:
     case WM_LBUTTONUP:
     case WM_RBUTTONDOWN:
     case WM_RBUTTONUP:
     case WM_MBUTTONDOWN:
     case WM_MBUTTONUP:
     case WM_NCMOUSEMOVE:
     case WM_NCLBUTTONDOWN:
     case WM_NCLBUTTONUP:
     case WM_NCRBUTTONDOWN:
     case WM_NCRBUTTONUP:
     case WM_NCMBUTTONDOWN:
     case WM_NCMBUTTONUP:
        if (fFlyOverData->fFlytxt)
           {
           MSG msg;
           msg.lParam = event.parameter2();
           msg.wParam = event.parameter1();
           msg.message = event.eventId();
           msg.hwnd = event.handle();
           fFlyOverData->fFlytxt->sendEvent( TTM_RELAYEVENT,0, &msg);
           }
        break;

     default:
        break;
     }
#endif
#ifdef IC_PM
  if (event.eventId() == WM_CONTROLPOINTER || event.eventId() == WM_MOUSEMOVE)
  {
    if (!fFlyOverData->fTimer.isStarted() &&
        IISCHILD( event.handle(),
                  IQUERYACTIVEWINDOW( IWindow::desktopWindow()->handle() )))
    {
      // Kick the timer off.
      // Note: the interval is divided by two becuase it takes to timer pops
      //       in order to show fly over help for a window.
      fFlyOverData->fTimer.setInterval( fFlyOverData->fInitialTimerDelay/2 );
      fFlyOverData->fTimer.start(
        new ITimerMemberFn<IFlyOverData>(*fFlyOverData, &IFlyOverData::timerpop));
      fFlyOverData->fPrevPos = IWindow::pointerPosition();
    }
    if (event.eventId() == WM_CONTROLPOINTER)
    {
      IControlEvent controlEvent(event);
      // If the mouse is of the fly-over text control then do NOT change
      // the fHandle data member
      if ( fFlyOverData->fFlytxt &&
         ( fFlyOverData->fFlytxt->handle() == controlEvent.controlHandle() ))
      {
         // Just do nothing for this case (in other words, leave the
         // fHandle data member at it's previous value)
      }
      else
      {
        fFlyOverData->fHandle = controlEvent.controlHandle();
        if (!fFlyOverData->fHandle)
          fFlyOverData->fHandle = event.handle();
      }
    }
    else
      fFlyOverData->fHandle = event.handle();
  }
  // If the window the handler is attached to is moving,
  // stop the timer and hide the flytext control.
  else if (event.eventId() == WM_ADJUSTWINDOWPOS)
  {
    PSWP pswp((PSWP)event.parameter1().asUnsignedLong());
    if (pswp->fl & SWP_MOVE)
    {
      if ( fFlyOverData->fFlytxt )
      {
         fFlyOverData->fFlytxt->hide();
      }
      fFlyOverData->fPrevHandle = 0;
    }
  }
#endif
#ifdef IC_MOTIF
  switch (event.eventId())
     {
     case IC_UM_FLY_PAINT :
     //  This message is used in AIX to detect when child windows are added.  The
     //  name is not an accurate description, but we'll reuse it anyway.
        {
        IWindow* child = (IWindow*)event.parameter1().asUnsignedLong();
        if (child)  
              this->handleEventsFor( child );
        }
        break;
     case xEvent(KeyPress) :
     case xEvent(KeyRelease) :
//  Some controls seem to eat the mouse xEvents, so we'll check for the
//  synthesized ones as well.
     case WM_BUTTON1DOWN:
     case WM_BUTTON2DOWN:
     case WM_BUTTON3DOWN:
     case xEvent(ButtonPress) :
     case xEvent(ButtonRelease) :
        {
        // Any of these user input events result in dismissal of the
        // fly help. Call the timer pop routine to clean up.
        fFlyOverData->fHandle = 0;
        fFlyOverData->timerpop( IFlyOverData::flytextInvalid );
        }
        break;
     case xEvent(EnterNotify) :
        {
        XCrossingEvent *xevt = (XCrossingEvent*)
           event.parameter2().asUnsignedLong();
        if (xevt->mode == NotifyNormal)  // not grab/ungrab
           {
           IWindowHandle::Value handle = XtWindowToWidget(
                                            xevt->display,xevt->window);
           fFlyOverData->timerpop( IFlyOverData::pointerMoved );

#ifdef IC_TRACE_ALL
           IPoint cursorPos(xevt->x_root, xevt->y_root);
           IWindowHandle::Value subhandle = (xevt->subwindow == None) ?
                  0 : XtWindowToWidget(xevt->display,xevt->subwindow);
           IString str("EnterNotify ");
           IWindow* subWindow = subhandle ?
                  IWindow::windowWithHandle( subhandle ) : 0;
           switch (xevt->detail)
              {
               // moved from ancestor of this window to this window
              case NotifyAncestor:
                 str += "NotifyAncestor ";
                 break;
               // moved from ancestor to child of this window
              case NotifyVirtual:
                 str += "NotifyVirtual ";
                 break;
              // moved from child of this window to this window
              case NotifyInferior:
                 str += "NotifyInferior ";
                 break;
               // entering this window from nonrelated/sibling
              case NotifyNonlinear:
                 str += "NotifyNonlinear ";
                 break;
               // entering some child of this window from nonrelated/sibling
              case NotifyNonlinearVirtual:
                 str += "NotifyNonlinearVirtual ";
                 break;
              }
           str += IString("handle=") + IString((unsigned long)handle).d2x();
           str += IString(" subhandle=") + IString((unsigned long)subhandle).d2x();
           str += IString(" cursor=") + cursorPos.asString();
           str += IString(" serial=") + IString( (unsigned long)xevt->time );
           ITRACE_ALL(str);
#endif
           // For all entering scenarios, we start the initial delay
           // timer for showing the fly help.  However, if fHandle
           // is already set to this window it is ignored because the
           // event has to do with movement across composite children.
           if (fFlyOverData->fHandle != handle)
              {
              // if there is already a timer, kill it.  If the timer is
              // for the previous value of fHandle we need to restart the
              // timer.  Processing of LeaveNotify will handle fly text
              // that is showing.
              if (!fFlyOverData->fTimer)
                 {
                 ITRACE_ALL("Removing timer");
                 XtRemoveTimeOut(fFlyOverData->fTimer);
                 fFlyOverData->fTimer = 0;
                 }

              // Set up fHandle to be our proposed window to show fly help
              // for.  Then kick off the initial delay timer.
              fFlyOverData->fHandle = handle;
              fFlyOverData->fPrevPos = IPoint(xevt->x_root, xevt->y_root);
              fFlyOverData->fTimer =
                XtAppAddTimeOut( XtWidgetToApplicationContext( handle ),
                                 fFlyOverData->fInitialTimerDelay,
                                 IFlyHelpTimeoutProc,
                                 (XtPointer)fFlyOverData);
              }

           return true;         // Do not propogate event
           }  // enter notify
        }  // enter event
        break;
     case xEvent(LeaveNotify) :
        {
        XCrossingEvent *xevt = (XCrossingEvent*)
           event.parameter2().asUnsignedLong();
        if (xevt->mode == NotifyNormal)  // not grab/ungrab
           {
           IWindowHandle::Value handle = XtWindowToWidget(
                                            xevt->display,xevt->window);

#ifdef IC_TRACE_ALL
           IString str("LeaveNotify ");
           IPoint cursorPos(xevt->x_root, xevt->y_root);
           fFlyOverData->fPrevPos = cursorPos;
           IWindowHandle::Value subhandle = (xevt->subwindow == None) ?
                  0 : XtWindowToWidget(xevt->display,xevt->subwindow);
           IWindow* subWindow = subhandle ?
                  IWindow::windowWithHandle( subhandle ) : 0;
           switch (xevt->detail)
              {
               // moved from this window to ancestor of this window
              case NotifyAncestor:
                 str += "NotifyAncestor ";
                 break;
               // moved from child to ancestor of this window
              case NotifyVirtual:
                 str += "NotifyVirtual ";
                 break;
              // moved from this window to child of this window
              case NotifyInferior:
                 str += "NotifyInferior ";
                 break;
               // leaving this window to nonrelated/sibling
              case NotifyNonlinear:
                 str += "NotifyNonlinear ";
                 break;
               // leaving some child of this window to nonrelated/sibling
              case NotifyNonlinearVirtual:
                 str += "NotifyNonlinearVirtual ";
                 break;
              }
           str += IString("handle=") + IString((unsigned long)handle).d2x();
           str += IString(" subhandle=") + IString((unsigned long)subhandle).d2x();
           str += IString(" cursor=") + cursorPos.asString();
           str += IString(" serial=") + IString( (unsigned long)xevt->time );
           ITRACE_ALL(str);
#endif
           // For leaving scenarios, we kill the fly help if we are
           // leaving for a parent or sibling, but not if leaving for
           // a child.  If the child is a composite part of this IWindow
           // we want to not disturb the help text.  If it has a separate
           // attachement of this handler (it is itself an IWindow), it
           // will process the enter event and replace the text.
           if (xevt->detail != NotifyInferior)
              {
              // Call the timer pop routine as if the timer had expired to
              // clean up.
              fFlyOverData->fHandle = 0;
              fFlyOverData->timerpop( IFlyOverData::flytextInvalid );
              }
           return true;         // Do not propogate event
           }
        }
        break;
     }
#endif
  return false;
}

#ifdef IC_WIN
/*------------------------------------------------------------------------------
| IFlyOverData::notifyEvent                                                    |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
void IFlyOverData::notifyEvent( tagNMHDR* notifyHeader )
{
   IMODTRACE_ALL("IFlyOverData::notifyEvent");
   switch (notifyHeader->code)
      {
      // The Common controls appear to use NEEDTEXTW...other controls
      // use NEEDTEXTA.
      case TTN_NEEDTEXTA :
      case TTN_NEEDTEXTW :
         {
         // The control is asking for text
         char*   textPtr(0);
         bool useWideChar( (notifyHeader->code==TTN_NEEDTEXTW) ? true : false);
         unsigned int
          *flags = 0;
         if (useWideChar)
            {
            TOOLTIPTEXTW* textHdr = (TOOLTIPTEXTW*)notifyHeader;
            // insure fields are initialized.
            textHdr->hinst = 0;
            textHdr->lpszText = textHdr->szText;
            textPtr = (char*) textHdr->lpszText;

            if (textHdr->uFlags & TTF_IDISHWND )
               fControlHandle = (HWND)textHdr->hdr.idFrom;
            else
               fControlHandle = 0;   // should not happen
            flags = &( textHdr->uFlags );
            }
         else
            {
            TOOLTIPTEXTA* textHdr = (TOOLTIPTEXTA*)notifyHeader;
            // insure fields are initialized.
            textHdr->hinst = 0;
            textHdr->lpszText = textHdr->szText;
            textPtr = (char*) textHdr->lpszText;

            if (textHdr->uFlags & TTF_IDISHWND )
               fControlHandle = (HWND)textHdr->hdr.idFrom;
            else
               fControlHandle = 0;   // should not happen
            flags = &( textHdr->uFlags );
            }

         // Ensure the fly-over help window stays in front of
         // floating tool bars and other siblings created after
         // it.
         fFlytxt->positionOnSiblings();

         this->setFlyTextForHandle( fControlHandle, textPtr,
                                    useWideChar, flags );
         break;
         } //case TTN_NEEDTEXT
      case TTN_POP :
         {
         // Fly help is being hidden
         if (fLongtxt)
           setLongText( fDefault );
         }
         break;

      default:
         break;
      }  // switch
   return;
}
#endif

#ifdef IC_PM
/*------------------------------------------------------------------------------
| IFlyOverData::timerpop                                                       |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
void IFlyOverData::timerpop( unsigned long timerId )
{
  // Get the mouse location.

  POINTL pt;
  IQUERYPOINTERPOSITION(pt.x,pt.y);

  // If either of the controls is no longer valid, return.

  if (fFlytxt && !fFlytxt->isValid())
    return;
  if (fLongtxt && !fLongtxt->isValid())
    return;

  // Get the handle of the control that is under the mouse.
  // Note:  controls that are disabled will not be returned since
  //        they do not respond to hit-test.
  fControlHandle = IWINDOWFROMPOINT( IWindow::desktopWindow()->handle(), &pt, true );

  // If the control that is under the mouse is a descendant of the
  // handle that was in the control pointer or mousemove event or
  // the mouse is over the fly text control (this prevents the fly text
  // control from being removed once displayed for a window) and
  // the control is a child of the active window then proceed to show
  // fly over help.

  bool overFlyTextWindow(fFlytxt && (fFlytxt->handle() == fControlHandle));

  if (( IISCHILD( fControlHandle, fHandle ) &&
        IISCHILD( fControlHandle, IQUERYACTIVEWINDOW( IWindow::desktopWindow()->handle() ))) ||
        overFlyTextWindow )
  {
    if (overFlyTextWindow)
      return;
    if (pt.x == fPrevPos.x() && pt.y == fPrevPos.y())  // If the mouse has been
                                                       // at the same location.
    {
      fControlWindow = IWindow::windowWithHandle( fControlHandle );
      IWindowHandle parentHandle(fControlHandle);      // Collection search done with
                                                       // parentHandle.
      // If the controlWindow is null, then we are dealing with
      // an aggregate control that is not wrappered.

      if (!fControlWindow)
      {
        // Query the handle's parent and then try to get the
        // IWindow pointer that corresponds to the parent handle.

        parentHandle = IPARENTOF(fControlHandle);
        fControlWindow = IWindow::windowWithHandle( parentHandle );
      }

      if (fControlWindow && (fControlWindow != fFlytxt))
      {
         this->setFlyTextForHandle( parentHandle, 0, false, 0 );
      }

      // Set the previous handle to the current handle for the next timerpop.
      fPrevHandle = fControlHandle;

      // set the interval to 1/3 second so we can tell "quickly" if we've
      // moved off of the window.
      fTimer.setInterval(CHECK_MOTION_DELAY);
    }
    else // The mouse has moved.
    {
      // If we are no longer over the same control.
      if (fPrevHandle != fControlHandle)
      {
        // Reset previous handle to null and reset the interval.
        fPrevHandle = 0;
        fTimer.setInterval(fTimerDelay/2);
        if (fFlytxt)
          fFlytxt->hide();
        if (fLongtxt)
          setLongText( fDefault );
      }
    }
    // Update the previous point to the current point.
    fPrevPos.setX( pt.x ).setY( pt.y );
  }
  else
  {
    // Mouse is no longer over a window that is a child of the
    // window the flyOverHelpHandler what attached to.

    if (fFlytxt)
    {
      fFlytxt->hide();
    }
    if (fLongtxt)
    {
      setLongText( fDefault );
    }
    fPrevHandle = 0;
    fTimer.stop();
  }
}
#endif

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IFlyOverData::timerpop                                                       |
| This function is the controller for display of the fly help text.            |
| It relies on the state data of the IFlyOverData object as follows:           |
|    fTimer         - non 0 if an XtAppAddTimeout timer is active              |
|                     Reset to 0 by this routine after removing timeout.       |
|    fHandle        - contains window handle for a widget for which fly help   |
|                     is proposed or is active.  0 if no such widget.          |
|                     Not modified by this member.                             |
|    fControlHandle - contains window handle for widget for which fly help     |
|                     is being shown.  0 if fly help not showing.              |
|                     Is modified by this member.                              |
|    fPrevPos       - Last recorded pointer position, in root coordinates.     |
|    fFlytxt        - The IFlyText window                                      |
|    fLongtxt       - The long text window.                                    |
------------------------------------------------------------------------------*/
void IFlyOverData::timerpop( IFlyOverData::ChangeCode code )
{
   IMODTRACE_ALL("IFlyOverData::timerpop");

   bool bHide = ((this->fHandle == 0) || (code == flytextInvalid));

   if (this->fTimer != 0)
      {
      // Handle case where we are called from handler and timer still
      // active.
      ITRACE_ALL("Removing timer");
      XtRemoveTimeOut(this->fTimer);
      // clear out timer id
      this->fTimer = 0;
      }

   if (!bHide)
      {
      // Determine whether we need to show, hide, or continue to show
      // fly help.
      if (( this->fControlHandle == 0 ) && (code == timerExpired) )
         {
         // Initial delay has expired.  Display the fly help.
         Window   root, child;
         int      rootx, rooty, childx, childy;
         unsigned int mask;
         if (XQueryPointer( XtDisplay( this->fHandle ),
                            XtWindow( this->fHandle ),
                            &root, &child,
                            &rootx, &rooty,
                            &childx, &childy,
                            &mask))
            {
            // Pointer is still in window or child of it.
            // Record current mouse position and show flyhelp.
            this->fPrevPos.setX( rootx );
            this->fPrevPos.setY( rooty );
            this->setFlyTextForHandle( this->fHandle, 0, false, 0 );
            this->fControlHandle = this->fHandle;
            EventMask eventmask = XtBuildEventMask( this->fHandle );
            if ( !(eventmask & (PointerMotionMask | PointerMotionHintMask)) )
               {
               // Widget not enabled for pointer motion.  Use timer
               // to check for motion.
               this->fTimer =
                  XtAppAddTimeOut( XtWidgetToApplicationContext( this->fHandle ),
                                   CHECK_MOTION_DELAY,
                                   IFlyHelpTimeoutProc,
                                   (XtPointer)this);
               }
            }
         }
      else if ( this->fControlHandle != 0 )
         {
         // Fly help is showing.  Decide if we should keep it showing.
         bHide = true;     // hide it unless proven otherwise
         Window   root, child;
         int      rootx, rooty, childx, childy;
         unsigned int mask;
         if (XQueryPointer( XtDisplay( this->fHandle ),
                            XtWindow( this->fHandle ),
                            &root, &child,
                            &rootx, &rooty,
                            &childx, &childy,
                            &mask))
            {
            if (code == pointerMoved) 
               {
               ITRACE_ALL("Pointer moved in window");
               // Pointer moved but still in window or child.  Set the timer
               // to the delayTime to check again.  Hide for now.
               this->fPrevPos.setX(rootx);
               this->fPrevPos.setY(rooty);
               this->fTimer =
                  XtAppAddTimeOut( XtWidgetToApplicationContext( this->fHandle ),
                                   this->fTimerDelay,
                                   IFlyHelpTimeoutProc,
                                   (XtPointer)this);
               }
            else if (code == timerExpired)
               {
               ITRACE_ALL("Pointer did not move");
               // Pointer has not moved at all.  Reset timer for next check.
               this->fTimer =
                  XtAppAddTimeOut( XtWidgetToApplicationContext( this->fHandle ),
                                   CHECK_MOTION_DELAY,
                                   IFlyHelpTimeoutProc,
                                   (XtPointer)this);
               bHide = false;   // do not hide it
               }
            }  // XQueryPointer
         }  // controlHandle not 0
      }  // not bHide

   if (bHide)
      {
      // Need to hide the fly text, either because the pointer moved or
      // left the window.
      if (this->fControlHandle != 0)
         {
         // Fly help is showing.
         if (this->fFlytxt)
           {
           fFlytxt->hide();
           }
         if (this->fLongtxt)
           {
           setLongText( fDefault );
           }
         }
      this->fControlHandle = 0;
      }
}
#endif

/*------------------------------------------------------------------------------
| IFlyOverData::setFlyTextForHandle                                            |
|                                                                              |
| Finds the flytext for a specified window, and sets it.                       |
------------------------------------------------------------------------------*/
IFlyOverData& IFlyOverData::setFlyTextForHandle( IWindowHandle controlHandle,
                                                 char*         textPtr,
                                                 bool          useWideChar,
                                                 unsigned int* flags )
{
   // Look through the handle string set to see if we have
   // a hit based on the window handle.

   if ( flyHelpStatics.handleStringSet().containsElementWithKey(
                             controlHandle.asUnsigned() ))
     {
     // We go a hit in the handle set.
     IHandleStringElement*
              mouseOverElement(flyHelpStatics.handleStringSet().elementWithKey(
                                         controlHandle.asUnsigned()));

     if ( mouseOverElement->fStrings )
       {
       if (fFlytxt)
         {
         this->setFlyText( mouseOverElement->flyStr,
                           textPtr,
                           useWideChar,
                           flags );
         }
       if (fLongtxt)
         setLongText(mouseOverElement->longStr);
       }
     else
       {
       if ( fFlytxt )
         {
         unsigned long id(mouseOverElement->flyResId);
         IString flyInfo = IString();
         flyInfo = fFly->resourceLibrary().tryToLoadString(id);
         if (flyInfo.length() == 0)  //if id = 0 or an invalid resource id
           {
           this->setFlyText( fFly->defaultText(),
                             textPtr,
                             useWideChar,
                             flags );
           }
         else
           {
           this->setFlyText( flyInfo,
                             textPtr,
                             useWideChar,
                             flags );
           }
         }

       if ( fLongtxt )
         {
         unsigned long id(mouseOverElement->longResId);
         IString longInfo = IString();
         longInfo = fFly->resourceLibrary().tryToLoadString(id);
         if (longInfo.length() == 0)  //if id = 0 or an invalid resource id
           setLongText(fFly->defaultText());
         else
           setLongText(longInfo);
         }
       }
     }
   else
     {
#ifdef IC_PM
     unsigned long controlId(fControlWindow->id());
#endif
#ifdef IC_WIN
     unsigned long controlId = IIDOF(controlHandle) ;
#endif
#ifdef IC_MOTIF
     unsigned long controlId = IWindow::windowWithHandle(controlHandle)->id();
#endif
     if ( fFlytxt )
       {
       IString flyInfo = IString();
       flyInfo = fFly->resourceLibrary().tryToLoadString(controlId + fFlyOffset);
       if (flyInfo.length() == 0)
         {
         this->setFlyText( fFly->defaultText(),
                           textPtr,
                           useWideChar,
                           flags );
         }
       else
         {
         this->setFlyText( flyInfo,
                           textPtr,
                           useWideChar,
                           flags );
         }
       }

     if ( fLongtxt )
       {
       IString longInfo = IString();
       longInfo = fFly->resourceLibrary().tryToLoadString(controlId + fLongOffset);
       if (longInfo.length() == 0)
         setLongText(fFly->defaultText());
       else
         setLongText(longInfo);
       }
     }
    return *this;
}

/*------------------------------------------------------------------------------
| IFlyOverData::setFlyText                                                     |
|                                                                              |
| Copys the specified helpText into the szText buffer.  Max length: 79 bytes   |
------------------------------------------------------------------------------*/
IFlyOverData& IFlyOverData::setFlyText( const IString& helpText,
                                        char*          szText,
                                        bool           useWideChar,
                                        unsigned int*  flags )
{
  // Replace new line characters with blanks
   IString hText = IString::change(helpText, (char*)"\xA", (char*)" ");

  // szText, useWideChar ignored in OS/2, Motif
#ifdef IC_WIN
   if (useWideChar)
      {
      mbstowcs( (wchar_t*)szText, hText, 80) ;
      ((wchar_t*)szText)[79] = 0;     // insure last char is null
      }
   else
      {
      unsigned lengthToCopy = hText.length();
      if(lengthToCopy != 0)
        {
        if (lengthToCopy > 79)
           {
           // Adjust length back so it will fit, insuring that MBCS is
           // preserved
           lengthToCopy = 80;
           while ( lengthToCopy > 1 &&
                   hText.charType( lengthToCopy ) > IStringEnum::mbcs1 )
              lengthToCopy--;
           lengthToCopy--;
           }
        if (lengthToCopy)
          memcpy( szText, (char*)hText, lengthToCopy);
        }
      szText[lengthToCopy] = '\0';
      }

   // Give the fly text window the same bidi text direction as
   // its owner window.  The text direction of the fly text is
   // controlled by the presence of the TTF_RTLREADING flag.
   if ( flags  &&  IBidiSettings::isBidiSupported() )
      {
      IWindow
       *flyTextOwner = fFlytxt->owner();
      if ( flyTextOwner )
         {
         IBidiSettings
           ownerSettings( *flyTextOwner );
         if ( ownerSettings.textOrientation() ==
                 IBidiSettings::textLeftToRight )
            {
            ( *flags ) &= (unsigned int) ~TTF_RTLREADING;
            }
         else
            {
            ( *flags ) |= TTF_RTLREADING;
            }
         }
      }
#endif  //WIN
#ifdef IC_MOTIFPM
  if(hText.size()!=0)
  {
    if(fFlytxt->text()!=hText)
    {
      fFlytxt->hide();
      fFlytxt->setText(hText);
    }
#ifdef IC_PM
    // If the previous handle is null, this means the mouse has moved
    // onto a new window so show the fly text control.
    if ( fPrevHandle == 0 )
    {
      // Give the fly text window the bidi attributes of its
      // owner window.
      if ( IBidiSettings::isBidiSupported() )
      {
         IWindow
          *flyTextOwner = fFlytxt->owner();
         if ( flyTextOwner )
         {
            IBidiSettings
              ownerSettings( *flyTextOwner );
            ownerSettings
             .apply( *fFlytxt, true, true );
         }
      }

      positionTextWindow();
    }
#endif
#ifdef IC_MOTIF
    positionTextWindow();
#endif
  }
  else
  {
    if(fFlytxt->isVisible())
      fFlytxt->hide();
  }
#endif  // MOTIFPM
  return *this;
}

/*------------------------------------------------------------------------------
| IFlyOverHelpHandler::setLongText                                             |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IFlyOverData& IFlyOverData::setLongText( const IString& helpText )
{
  bool preventLongTextUpdate = true;
  if ( fLongtxt && fLongtxt->isValid() )
    preventLongTextUpdate =
      fLongtxt->sendEvent(IC_UM_QRY_PREVENTUPDATE).asUnsignedLong();
  if (!preventLongTextUpdate)
  {
    if (helpText.size()!=0)
      fLongtxt->setText( helpText );
    else
      if ( fDefault.length() != 0 )
        fLongtxt->setText( fDefault );
      else
        // At a minimum, set the long text to a single blank to avoid
        // the frame handler from hiding the long text control if the
        // long text control happens to be a frame extension.
        fLongtxt->setText( " " );
  }
  return *this;
}

#ifdef IC_MOTIFPM
/*------------------------------------------------------------------------------
| IFlyOverData::positionTextWindow                                             |
|                                                                              |
| Reposition and show the flyText window if the mouse has moved over a         |
| new window since the last timer pop.                                         |
|                                                                              |
------------------------------------------------------------------------------*/
IFlyOverData& IFlyOverData::positionTextWindow( )
{
 // We use the mouse position as the relative rect, because we have
 // it in terms of the desktop.
 IRectangle controlRect( this->fPrevPos, ISize(1,1));
#ifdef IC_MOTIF
 if ( ICoordinateSystem::applicationOrientation() ==
      ICoordinateSystem::originLowerLeft )
     {
       controlRect = ICoordinateSystem::convertToApplication(
                     controlRect, IWindow::desktopWindow()->size() );
     }

  fFlytxt->setRelativeWindowRect( controlRect );
#endif
#ifdef IC_PM
  controlRect = ICoordinateSystem::convertToApplication(
                  controlRect, IWindow::desktopWindow()->size() );
  fFlytxt->setRelativeWindowRect( controlRect );
  fFlytxt->postEvent(IC_UM_FLY_PAINT);
#endif
#ifdef IC_MOTIF
  fFlytxt->show();
  // Insure that the fly help is at the top of the Z order.
  Widget w = fFlytxt->handle();
  if (XtIsRealized(w))
     XRaiseWindow( XtDisplay(w), XtWindow(w) );
#endif
  return *this;
}
#endif //IC_MOTIFPM

