/******************************************************************************
* .FILE:         xebc2asc.h                                                   *
*                                                                             *
* .COPYRIGHT:                                                                 *
*    IBM Open Class Library                                                   *
*    Licensed Material - Program-Property of IBM                              *
*    (C) Copyright IBM Corp. 1992, 1997 - All Rights Reserved                 *
*                                                                             *
* .DISCLAIMER:                                                                *
*   The following [enclosed] code is sample code created by IBM               *
*   Corporation.  This sample code is not part of any standard IBM product    *
*   and is provided to you solely for the purpose of assisting you in the     *
*   development of your applications.  The code is provided 'AS IS',          *
*   without warranty of any kind.  IBM shall not be liable for any damages    *
*   arising out of your use of the sample code, even if they have been        *
*   advised of the possibility of such damages.                               *
*                                                                             *
* .NOTE: WE RECOMMEND USING A FIXED SPACE FONT TO LOOK AT THE SOURCE          *
*                                                                             *
******************************************************************************/

/*-------------------------------------------------------------*\
|  xebc2asc.h :   EBCDIC - ASCII Translation Table.             |
|                                                               |
|  Example:   To convert from an EBCDIC blank, 40,              |
|             use translationtable[40], which gives 20,         |
|             the ASCII blank.                                  |
\*-------------------------------------------------------------*/

 const unsigned char translationTable[256] = {
    /* 00 */      0x00, 0x01, 0x02, 0x03, 0xCF, 0x09, 0xD3, 0x7F,
    /* 08 */      0xD4, 0xD5, 0xC3, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
    /* 10 */      0x10, 0x11, 0x12, 0x13, 0xC7, 0xB4, 0x08, 0xC9,
    /* 18 */      0x18, 0x19, 0xCC, 0xCD, 0x83, 0x1D, 0xD2, 0x1F,
    /* 20 */      0x81, 0x82, 0x1C, 0x84, 0x86, 0x0A, 0x17, 0x1B,
    /* 28 */      0x89, 0x91, 0x92, 0x95, 0xA2, 0x05, 0x06, 0x07,
    /* 30 */      0xE0, 0xEE, 0x16, 0xE5, 0xD0, 0x1E, 0xEA, 0x04,
    /* 38 */      0x8A, 0xF6, 0xC6, 0xC2, 0x14, 0x15, 0xC1, 0x1A,
    /* 40 */      0x20, 0xA6, 0xE1, 0x80, 0xEB, 0x90, 0x9F, 0xE2,
    /* 48 */      0xAB, 0x8B, 0x9B, 0x2E, 0x3C, 0x28, 0x2B, 0x7C,
    /* 50 */      0x26, 0xA9, 0xAA, 0x9C, 0xDB, 0xA5, 0x99, 0xE3,
    /* 58 */      0xA8, 0x9E, 0x21, 0x24, 0x2A, 0x29, 0x3B, 0x5E,
    /* 60 */      0x2D, 0x2F, 0xDF, 0xDC, 0x9A, 0xDD, 0xDE, 0x98,
    /* 68 */      0x9D, 0xAC, 0xBA, 0x2C, 0x25, 0x5F, 0x3E, 0x3F,
    /* 70 */      0xD7, 0x88, 0x94, 0xB0, 0xB1, 0xB2, 0xFC, 0xD6,
    /* 78 */      0xFB, 0x60, 0x3A, 0x23, 0x40, 0x27, 0x3D, 0x22,
    /* 80 */      0xF8, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
    /* 88 */      0x68, 0x69, 0x96, 0xA4, 0xF3, 0xAF, 0xAE, 0xC5,
    /* 90 */      0x8C, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F, 0x70,
    /* 98 */      0x71, 0x72, 0x97, 0x87, 0xCE, 0x93, 0xF1, 0xFE,
    /* A0 */      0xC8, 0x7E, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78,
    /* A8 */      0x79, 0x7A, 0xEF, 0xC0, 0xDA, 0x5B, 0xF2, 0xF9,
    /* B0 */      0xB5, 0xB6, 0xFD, 0xB7, 0xB8, 0xB9, 0xE6, 0xBB,
    /* B8 */      0xBC, 0xBD, 0x8D, 0xD9, 0xBF, 0x5D, 0xD8, 0xC4,
    /* C0 */      0x7B, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
    /* C8 */      0x48, 0x49, 0xCB, 0xCA, 0xBE, 0xE8, 0xEC, 0xED,
    /* D0 */      0x7D, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, 0x50,
    /* D8 */      0x51, 0x52, 0xA1, 0xAD, 0xF5, 0xF4, 0xA3, 0x8F,
    /* E0 */      0x5C, 0xE7, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58,
    /* E8 */      0x59, 0x5A, 0xA0, 0x85, 0x8E, 0xE9, 0xE4, 0xD1,
    /* F0 */      0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
    /* F8 */      0x38, 0x39, 0xB3, 0xF7, 0xF0, 0xFA, 0xA7, 0xFF
};
