/*******************************************************************************
* FILE NAME: CmrWndow.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class:                                         *
*     CameraWindow                                                             *
* ---------------------------------------------------------------------------- *
* Warning: This file was generated by the VisualAge C++ Visual Builder.        *
* Modifications to this source file will be lost when the part is regenerated. *
*******************************************************************************/
#ifndef _IFRAME_
#include <iframe.hpp>
#endif

#ifndef _IMCELCV_
#include <imcelcv.hpp>
#endif

#ifndef _ISTATTXT_
#include <istattxt.hpp>
#endif

#ifndef _IENTRYFD_
#include <ientryfd.hpp>
#endif

#ifndef _ISETCV_
#include <isetcv.hpp>
#endif

#ifndef _IPUSHBUT_
#include <ipushbut.hpp>
#endif

#ifndef _IRESLIB_
#include <ireslib.hpp>
#endif

#ifndef _IPOINT_
#include <ipoint.hpp>
#endif

#ifndef _IVSEQ_H_
#include <ivseq.h>
#endif

#ifndef _CAMERA_
#include "Camera.hpp"
#endif

#ifndef _DISPLAYWINDOW_
#include "DsplyWnd.hpp"
#endif

#ifndef _CAMERAITEMPROVIDER_
#include "dmprov.hpp"
#endif

#ifndef _INOTIFEV_
#include <inotifev.hpp>
#endif

#ifndef _IOBSERVR_
#include <iobservr.hpp>
#endif

#ifndef _ISTDNTFY_
#include <istdntfy.hpp>
#endif

#ifndef _CAMERAWINDOW_
#include "CmrWndow.hpp"
#endif

#ifndef _IVBDEFS_
#include <ivbdefs.h>
#endif

#ifndef _ITRACE_
#include <itrace.hpp>
#endif


//*****************************************************************************
// Class definition for CameraWindowConn4
//*****************************************************************************
class CameraWindowConn4 : public IObserver, public IStandardNotifier {
public:
   virtual  ~CameraWindowConn4(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IPushButton * aSource, CameraWindowCameraFactoryFactory * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IPushButton::buttonClickId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : PushButton1(buttonClickEvent) to CameraFactory(new))");
         try {target->create();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IPushButton * source;
   CameraWindowCameraFactoryFactory * target;


};   //CameraWindowConn4


//*****************************************************************************
// Class definition for CameraWindowConn5
//*****************************************************************************
class CameraWindowConn5 : public IObserver, public IStandardNotifier {
public:
   virtual  ~CameraWindowConn5(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(CameraWindowCameraFactoryFactory * aSource, IVSequence< Camera* > * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == CameraWindowCameraFactoryFactory::newObjectCreatedId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : CameraFactory(newEvent) to CameraList(addAsLast))");
         try {target->addAsLast((Camera *) (anEvent.eventData().asUnsignedLong()));}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   CameraWindowCameraFactoryFactory * source;
   IVSequence< Camera* > * target;


};   //CameraWindowConn5


//*****************************************************************************
// Class definition for CameraWindowConn15
//*****************************************************************************
class CameraWindowConn15 : public IObserver {
public:
   virtual  ~CameraWindowConn15(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IVSequence< Camera* > * aSource, IVBContainerControl< Camera*, IVSequence<Camera*>, CameraWindowVBContainerControl1CnrObj > * aTarget)
      {source = aSource; target = aTarget; aligning = false; };
   void setSource()
      {      };
   void setTarget()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : CameraList(this) to VBContainerControl1(items))");
         ITRACE_DEVELOP(" setting target from source ");
         aligning = true;
         try {target->setItems(source);}
         catch (IException& exc) {};
         aligning = false;
         }
      };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VBINITIALIZEID) setTarget();
      if ((anEvent.notificationId() == IVBContainerControl< Camera*, IVSequence<Camera*>, CameraWindowVBContainerControl1CnrObj >::itemsId) && (target == &anEvent.notifier()))
         setSource();  /* set source to target value */
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IVSequence< Camera* > * source;
   IVBContainerControl< Camera*, IVSequence<Camera*>, CameraWindowVBContainerControl1CnrObj > * target;
   Boolean aligning;


};   //CameraWindowConn15


//*****************************************************************************
// Class definition for CameraWindowConn20
//*****************************************************************************
class CameraWindowConn20 : public IObserver, public IStandardNotifier {
public:
   virtual  ~CameraWindowConn20(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(CameraWindow * aSource, IFrameWindow * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == CameraWindow::readyId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : (ready) to FrameWindow(setFocus))");
         try {target->setFocus();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   CameraWindow * source;
   IFrameWindow * target;


};   //CameraWindowConn20


//*****************************************************************************
// Class definition for CameraWindowConn21
//*****************************************************************************
class CameraWindowConn21 : public IObserver, public IStandardNotifier {
public:
   virtual  ~CameraWindowConn21(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(CameraWindow * aSource, IVBContainerControl< Camera*, IVSequence<Camera*>, CameraWindowVBContainerControl1CnrObj > * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == CameraWindow::readyId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : (ready) to VBContainerControl1(customLogic))");
         try {codeSnippet(&anEvent);}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member functions
   //---------------------------------------------------------------------------
   void codeSnippet(const INotificationEvent* event)
      {
      IDMHandler::enableDragFrom(target);
      target->setItemProvider((IDMItemProvider*)(source->icameraItemProvider));
      };

   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   CameraWindow * source;
   IVBContainerControl< Camera*, IVSequence<Camera*>, CameraWindowVBContainerControl1CnrObj > * target;


};   //CameraWindowConn21


//*****************************************************************************
// Class definition for CameraWindowConn12
//*****************************************************************************
class CameraWindowConn12 : public IObserver, public IStandardNotifier {
public:
   virtual  ~CameraWindowConn12(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(CameraWindow * aSource, CameraWindowDisplayWindowFactoryFactory * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == CameraWindow::readyId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : (ready) to DisplayWindowFactory(new))");
         try {target->create();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   CameraWindow * source;
   CameraWindowDisplayWindowFactoryFactory * target;


};   //CameraWindowConn12


//*****************************************************************************
// Class definition for CameraWindowConn13
//*****************************************************************************
class CameraWindowConn13 : public IObserver, public IStandardNotifier {
public:
   virtual  ~CameraWindowConn13(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(CameraWindowDisplayWindowFactoryFactory * aSource, IVBVariablePartPointer<DisplayWindow *> * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (!target) return(*this);
      if (anEvent.notificationId() == CameraWindowDisplayWindowFactoryFactory::newObjectCreatedId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : DisplayWindowFactory(newEvent) to newDisplayWindow(this))");
         try {target->setTarget((DisplayWindow *) (anEvent.eventData().asUnsignedLong()));}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   CameraWindowDisplayWindowFactoryFactory * source;
   IVBVariablePartPointer<DisplayWindow *> * target;


};   //CameraWindowConn13


//------------------------------------------------------------------------------
// CameraWindowVBContainerControl1CnrObj :: CameraWindowVBContainerControl1CnrObj
//------------------------------------------------------------------------------
#pragma export (CameraWindowVBContainerControl1CnrObj::CameraWindowVBContainerControl1CnrObj(Camera&))
CameraWindowVBContainerControl1CnrObj::CameraWindowVBContainerControl1CnrObj(Camera& anObject)
 :IVBContainerObject(anObject.Name(), IResourceLibrary().loadIcon(100)), pRealObject(anObject)
{
   enableDataUpdate();
   handleNotificationsFor(pRealObject);
}


//------------------------------------------------------------------------------
// CameraWindowVBContainerControl1CnrObj :: CameraWindowVBContainerControl1CnrObj
//------------------------------------------------------------------------------
#pragma export (CameraWindowVBContainerControl1CnrObj::CameraWindowVBContainerControl1CnrObj(CameraWindowVBContainerControl1CnrObj&))
CameraWindowVBContainerControl1CnrObj::CameraWindowVBContainerControl1CnrObj(CameraWindowVBContainerControl1CnrObj& anObject)
 :IVBContainerObject(anObject.iconText(), anObject.icon()), pRealObject(anObject.pRealObject)
{  }


//------------------------------------------------------------------------------
// CameraWindowVBContainerControl1CnrObj :: ~CameraWindowVBContainerControl1CnrObj
//------------------------------------------------------------------------------
#pragma export (CameraWindowVBContainerControl1CnrObj::~CameraWindowVBContainerControl1CnrObj())
CameraWindowVBContainerControl1CnrObj::~CameraWindowVBContainerControl1CnrObj()
{
   this->stopHandlingNotificationsFor(pRealObject);
}


//------------------------------------------------------------------------------
// CameraWindowVBContainerControl1CnrObj :: refreshFromObject
//------------------------------------------------------------------------------
#pragma export (CameraWindowVBContainerControl1CnrObj::refreshFromObject())
IVBContainerObject & CameraWindowVBContainerControl1CnrObj::refreshFromObject()
{
   setIconText(pRealObject.Name());
   setIcon(IResourceLibrary().loadIcon(100));
   return *this;
}


//------------------------------------------------------------------------------
// CameraWindowVBContainerControl1CnrObj :: updateToObject
//------------------------------------------------------------------------------
IVBContainerObject & CameraWindowVBContainerControl1CnrObj::updateToObject()
{
   return *this;
}


//------------------------------------------------------------------------------
// CameraWindowVBContainerControl1CnrObj :: operator=
//------------------------------------------------------------------------------
CameraWindowVBContainerControl1CnrObj& CameraWindowVBContainerControl1CnrObj::operator=(const CameraWindowVBContainerControl1CnrObj& anObject)
{
   if (this == &anObject) {
      return *this;
      }
   IVBContainerObject::operator=(anObject);
   return *this;
}



const INotificationId CameraWindowCameraFactoryFactory::newObjectCreatedId = "CameraWindowCameraFactoryFactory::newObjectCreatedId";

//------------------------------------------------------------------------------
// CameraWindowCameraFactoryFactory :: CameraWindowCameraFactoryFactory
//------------------------------------------------------------------------------
#pragma export (CameraWindowCameraFactoryFactory::CameraWindowCameraFactoryFactory())
CameraWindowCameraFactoryFactory::CameraWindowCameraFactoryFactory()
{
   enableNotification();
}

//------------------------------------------------------------------------------
// CameraWindowCameraFactoryFactory :: ~CameraWindowCameraFactoryFactory
//------------------------------------------------------------------------------
#pragma export (CameraWindowCameraFactoryFactory::~CameraWindowCameraFactoryFactory())
CameraWindowCameraFactoryFactory::~CameraWindowCameraFactoryFactory()
{
   disableNotification();
}

//------------------------------------------------------------------------------
// CameraWindowCameraFactoryFactory :: create
//------------------------------------------------------------------------------
#pragma export (CameraWindowCameraFactoryFactory::create())
Camera * CameraWindowCameraFactoryFactory::create()
{
   Camera *iCameraFactory = new Camera();
   iCameraFactory->setDescription(iEntryField3->text());
   iCameraFactory->setNumber(iEntryField2->VBINTVALUEFROMTEXT());
   iCameraFactory->setLocation(iEntryField1->text());
   iCameraFactory->enableNotification();
   notifyObservers(INotificationEvent(newObjectCreatedId, *this, true, IEventData((void *)iCameraFactory)));
   return(iCameraFactory);
}




const INotificationId CameraWindowDisplayWindowFactoryFactory::newObjectCreatedId = "CameraWindowDisplayWindowFactoryFactory::newObjectCreatedId";

//------------------------------------------------------------------------------
// CameraWindowDisplayWindowFactoryFactory :: CameraWindowDisplayWindowFactoryFactory
//------------------------------------------------------------------------------
#pragma export (CameraWindowDisplayWindowFactoryFactory::CameraWindowDisplayWindowFactoryFactory(unsigned long))
CameraWindowDisplayWindowFactoryFactory::CameraWindowDisplayWindowFactoryFactory(unsigned long anId)
{
   enableNotification();
   partWindowId = anId;
}

//------------------------------------------------------------------------------
// CameraWindowDisplayWindowFactoryFactory :: ~CameraWindowDisplayWindowFactoryFactory
//------------------------------------------------------------------------------
#pragma export (CameraWindowDisplayWindowFactoryFactory::~CameraWindowDisplayWindowFactoryFactory())
CameraWindowDisplayWindowFactoryFactory::~CameraWindowDisplayWindowFactoryFactory()
{
   disableNotification();
}

//------------------------------------------------------------------------------
// CameraWindowDisplayWindowFactoryFactory :: create
//------------------------------------------------------------------------------
#pragma export (CameraWindowDisplayWindowFactoryFactory::create())
DisplayWindow * CameraWindowDisplayWindowFactoryFactory::create()
{
   DisplayWindow *iDisplayWindowFactory = new DisplayWindow(
      partWindowId+WNDOFFSET_CameraWindow_DisplayWindowFactory, 
      IWindow::desktopWindow(), 
      0, 
      DisplayWindow::defaultFramingSpec());
   iDisplayWindowFactory->enableNotification();
   iDisplayWindowFactory->initializePart();
   notifyObservers(INotificationEvent(newObjectCreatedId, *this, true, IEventData((void *)iDisplayWindowFactory)));
   return(iDisplayWindowFactory);
}

#pragma export (CameraWindow::readyId)
const INotificationId CameraWindow::readyId = "CameraWindow::readyId";

#pragma export (CameraWindow::partWindowId)
unsigned long CameraWindow::partWindowId = 0;

//------------------------------------------------------------------------------
// CameraWindow :: defaultFramingSpec
//------------------------------------------------------------------------------
#pragma export (CameraWindow::defaultFramingSpec())
const IRectangle CameraWindow::defaultFramingSpec()
{
   return(IRectangle(IPoint(30, IWindow::desktopWindow()->size().height() - 9 - 351),ISize(540, 351)));
}


//------------------------------------------------------------------------------
// CameraWindow :: defaultStyle
//------------------------------------------------------------------------------
#pragma export (CameraWindow::defaultStyle())
const IFrameWindow::Style CameraWindow::defaultStyle()
{
   return(IFrameWindow::defaultStyle() | IFrameWindow::dialogBackground | IWindow::visible);
}


//------------------------------------------------------------------------------
// CameraWindow :: defaultTitle
//------------------------------------------------------------------------------
#pragma export (CameraWindow::defaultTitle())
IString CameraWindow::defaultTitle()
{
   return("Camera Window");
}


//------------------------------------------------------------------------------
// CameraWindow :: CameraWindow
//------------------------------------------------------------------------------
#pragma export (CameraWindow::CameraWindow(unsigned long, IWindow*, IWindow*, const IRectangle&, const IFrameWindow::Style&, const char*))
CameraWindow::CameraWindow(
      unsigned long id, 
      IWindow* parent, 
      IWindow* owner, 
      const IRectangle& rect, 
      const IFrameWindow::Style& style, 
      const char* title)
   : IFrameWindow((partWindowId) ? partWindowId : id, parent, owner, rect, style, title)
{
   partWindowId = (partWindowId) ? partWindowId : id;
   iMultiCellCanvas1 = new IMultiCellCanvas(
      IC_FRAME_CLIENT_ID, 
      this, 
      this, 
      IRectangle());
   iStaticText1 = new IStaticText(
      partWindowId+WNDOFFSET_CameraWindow_StaticText1, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iStaticText2 = new IStaticText(
      partWindowId+WNDOFFSET_CameraWindow_StaticText2, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iStaticText3 = new IStaticText(
      partWindowId+WNDOFFSET_CameraWindow_StaticText3, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iEntryField1 = new IEntryField(
      partWindowId+WNDOFFSET_CameraWindow_EntryField1, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle(), 
      IEntryField::defaultStyle() | IControl::tabStop);
   iEntryField2 = new IEntryField(
      partWindowId+WNDOFFSET_CameraWindow_EntryField2, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle(), 
      IEntryField::defaultStyle() | IControl::tabStop);
   iEntryField3 = new IEntryField(
      partWindowId+WNDOFFSET_CameraWindow_EntryField3, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle(), 
      IEntryField::defaultStyle() | IControl::tabStop);
   iSetCanvas1 = new ISetCanvas(
      partWindowId+WNDOFFSET_CameraWindow_SetCanvas1, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iPushButton1 = new IPushButton(
      partWindowId+WNDOFFSET_CameraWindow_PushButton1, 
      iSetCanvas1, 
      iSetCanvas1, 
      IRectangle(), 
      IPushButton::defaultStyle() | IPushButton::defaultButton | IControl::tabStop);
   iVBContainerControl1 = new IVBContainerControl< Camera*, IVSequence<Camera*>, CameraWindowVBContainerControl1CnrObj >(
      partWindowId+WNDOFFSET_CameraWindow_VBContainerControl1, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle ( ), 
      IContainerControl::defaultStyle() | IContainerControl::autoPosition);
   iCameraList = new IVSequence< Camera* >();
   iCameraFactory = new CameraWindowCameraFactoryFactory();
   iDisplayWindowFactory = new CameraWindowDisplayWindowFactoryFactory(partWindowId);
   inewDisplayWindow = new IVBVariablePartPointer<DisplayWindow *>();
   icameraItemProvider = new CameraItemProvider();

   conn4 = new CameraWindowConn4();
   conn5 = new CameraWindowConn5();
   conn15 = new CameraWindowConn15();
   conn20 = new CameraWindowConn20();
   conn21 = new CameraWindowConn21();
   conn12 = new CameraWindowConn12();
   conn13 = new CameraWindowConn13();

   this->setFocus();
   this->setClient(iMultiCellCanvas1);
   iMultiCellCanvas1->addToCell(iStaticText1, 1, 4, 1, 1);
   iMultiCellCanvas1->addToCell(iStaticText2, 1, 5, 1, 1);
   iMultiCellCanvas1->addToCell(iStaticText3, 1, 3, 1, 1);
   iMultiCellCanvas1->addToCell(iEntryField1, 2, 3, 1, 1);
   iMultiCellCanvas1->addToCell(iEntryField2, 2, 4, 1, 1);
   iMultiCellCanvas1->addToCell(iEntryField3, 2, 5, 1, 1);
   iMultiCellCanvas1->addToCell(iSetCanvas1, 4, 3, 1, 3);
   iMultiCellCanvas1->addToCell(iVBContainerControl1, 1, 1, 5, 1);
   iMultiCellCanvas1->setColumnWidth(5, IMultiCellCanvas::defaultCell().width(), true);
   iMultiCellCanvas1->setRowHeight(1, IMultiCellCanvas::defaultCell().height(), true);
   iMultiCellCanvas1->setRowHeight(5, IMultiCellCanvas::defaultCell().height(), false);
   iStaticText1->setAlignment(IStaticText::centerRight);
   iStaticText1->setText("Number:");
   iStaticText2->setAlignment(IStaticText::centerRight);
   iStaticText2->setText("Description:");
   iStaticText3->setAlignment(IStaticText::centerRight);
   iStaticText3->setText("Location:");
   iSetCanvas1->setAlignment(ISetCanvas::centerCenter);
   iSetCanvas1->setDeckOrientation(ISetCanvas::vertical);
   iPushButton1->setText("Add");
   iVBContainerControl1->setMinimumSize(ISize(526, 158));
   iVBContainerControl1->showIconView();
   iCameraFactory->setEntryField1(iEntryField1);
   iCameraFactory->setEntryField2(iEntryField2);
   iCameraFactory->setEntryField3(iEntryField3);
}     //end constructor


//------------------------------------------------------------------------------
// CameraWindow :: ~CameraWindow
//------------------------------------------------------------------------------
#pragma export (CameraWindow::~CameraWindow())
CameraWindow::~CameraWindow()
{
   conn4->stopHandlingNotificationsFor(*iPushButton1);
   conn5->stopHandlingNotificationsFor(*iCameraFactory);
   conn15->stopHandlingNotificationsFor(*iCameraList);
   conn15->stopHandlingNotificationsFor(*iVBContainerControl1);
   conn20->stopHandlingNotificationsFor(*this);
   conn21->stopHandlingNotificationsFor(*this);
   conn12->stopHandlingNotificationsFor(*this);
   conn13->stopHandlingNotificationsFor(*iDisplayWindowFactory);

   delete conn4;
   delete conn5;
   delete conn15;
   delete conn20;
   delete conn21;
   delete conn12;
   delete conn13;


   delete iMultiCellCanvas1;
   delete iStaticText1;
   delete iStaticText2;
   delete iStaticText3;
   delete iEntryField1;
   delete iEntryField2;
   delete iEntryField3;
   delete iSetCanvas1;
   delete iPushButton1;
   delete iVBContainerControl1;
   delete iCameraList;
   delete iCameraFactory;
   delete iDisplayWindowFactory;
   delete inewDisplayWindow;
   delete icameraItemProvider;
}

//------------------------------------------------------------------------------
// CameraWindow :: initializePart
//------------------------------------------------------------------------------
#pragma export (CameraWindow::initializePart())
CameraWindow & CameraWindow::initializePart()
{
   makeConnections();
   notifyObservers(INotificationEvent(readyId, *this));
   return *this;
}


//------------------------------------------------------------------------------
// CameraWindow :: makeConnections
//------------------------------------------------------------------------------
#pragma export (CameraWindow::makeConnections())
Boolean CameraWindow::makeConnections()
{
   this->enableNotification();
   iMultiCellCanvas1->enableNotification();
   iStaticText1->enableNotification();
   iStaticText2->enableNotification();
   iStaticText3->enableNotification();
   iEntryField1->enableNotification();
   iEntryField2->enableNotification();
   iEntryField3->enableNotification();
   iSetCanvas1->enableNotification();
   iPushButton1->enableNotification();
   iVBContainerControl1->enableNotification();
   iCameraList->enableNotification();
   iCameraFactory->enableNotification();
   iDisplayWindowFactory->enableNotification();
   inewDisplayWindow->enableNotification();

   conn4->initialize(iPushButton1, iCameraFactory);
   conn4->handleNotificationsFor(*iPushButton1);
   conn5->initialize(iCameraFactory, iCameraList);
   conn5->handleNotificationsFor(*iCameraFactory);
   conn15->initialize(iCameraList, iVBContainerControl1);
   conn15->handleNotificationsFor(*iCameraList);
   conn15->handleNotificationsFor(*iVBContainerControl1);
   conn20->initialize(this, this);
   conn20->handleNotificationsFor(*this);
   conn21->initialize(this, iVBContainerControl1);
   conn21->handleNotificationsFor(*this);
   conn12->initialize(this, iDisplayWindowFactory);
   conn12->handleNotificationsFor(*this);
   conn13->initialize(iDisplayWindowFactory, inewDisplayWindow);
   conn13->handleNotificationsFor(*iDisplayWindowFactory);

   conn15->setTarget();
   return true;
}



