/*******************************************************************************
* FILE NAME: DMProv.cpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class:                                         *
*     CameraItem                                                               *
*     CameraItemProvider                                                       *
* ---------------------------------------------------------------------------- *
* This file contains the code for the direct manipulation items and provider   *
* used in the sample. This file should not be generated by the visual builder. *
*******************************************************************************/

#include "dmprov.hpp"
#include "cmrwndow.hpp"
#include "dsplywnd.hpp"
#include "imsgbox.hpp"

//------------------------------------------------------------------------------
// CameraItem :: CameraItem
//------------------------------------------------------------------------------
CameraItem::CameraItem  ( const IDMItem::Handle& item )
           :IDMCnrItem ( item )
{
  //----------------------------------------------------------------------------
  // Add the "Camera" type to the item when constructed by the source operation
  // (we can use the object method to determine if we are called by the source
  // or target operation).
  //----------------------------------------------------------------------------
  if ( object() )
  {
    addType("Camera");
  }
}

//------------------------------------------------------------------------------
// CameraItem :: generateSourceItems
//------------------------------------------------------------------------------
Boolean CameraItem::generateSourceItems ( IDMSourceOperation* pSrcOp )
{
  //----------------------------------------------------------------------------
  // Allow the default IDMCnrItem code to create items then replace each item
  // with a CameraItem (since we are using this provider to drag camera objects)
  //----------------------------------------------------------------------------
  Boolean result = IDMCnrItem::generateSourceItems( pSrcOp );
  for (unsigned i = 1; i <= pSrcOp->numberOfItems(); i++)
  {
    pSrcOp->replaceItem( i, new CameraItem( pSrcOp->item( i ) ) );
  }
  return( result );
}

//------------------------------------------------------------------------------
// CameraItem :: targetDrop
//------------------------------------------------------------------------------
Boolean CameraItem::targetDrop ( IDMTargetDropEvent& event )
{
  Camera*                                 camera;
  Display*                                display;
  CameraWindowVBContainerControl1CnrObj*  cameraObj;
  DisplayWindowVBContainerControl1CnrObj* displayObj;

  //----------------------------------------------------------------------------
  // Get the container objects that are being used (the class type names used
  // by the container controls are available in CmrWndow.hpp and DsplyWnd.hpp)
  //----------------------------------------------------------------------------
  cameraObj = (CameraWindowVBContainerControl1CnrObj*) object();
  displayObj = (DisplayWindowVBContainerControl1CnrObj*) event.object();

  //----------------------------------------------------------------------------
  // Get the real objects that are represented by the container objects
  //----------------------------------------------------------------------------
  camera = cameraObj->realObject();
  display = displayObj->realObject();

  //----------------------------------------------------------------------------
  // Process the drop by changing the active camera for the display
  //----------------------------------------------------------------------------
  display->setActiveCamera(camera);

  //----------------------------------------------------------------------------
  // Display a message box to indicate the change to the user
  //
  // Note: A more sophisticated program would probably generate a notification
  //       event that could be connected to a visual part in the builder.  For
  //       simplicity, this sample just displays a message box using normal
  //       class library calls instead.
  //----------------------------------------------------------------------------
  IMessageBox msgBox ( IWindow::desktopWindow() );
  msgBox.show ( IString("Display ") +
                display->Location() +
                IString(" has been modified to use camera ") +
                camera->Name(),
                IMessageBox::information );

  return true;
}

//------------------------------------------------------------------------------
// CameraItemProvider :: provideEnterSupport
//------------------------------------------------------------------------------
Boolean CameraItemProvider::provideEnterSupport ( IDMTargetEnterEvent& event )
{
  //----------------------------------------------------------------------------
  // Get the target operation and item that is being dragged over the container
  //----------------------------------------------------------------------------
  IDMTargetOperation::Handle pTgtOpH = IDMTargetOperation::targetOperation();
  IDMItem::Handle            pTgtDIH = pTgtOpH->item(1);

  //----------------------------------------------------------------------------
  // Check if the item is a "Camera"
  //----------------------------------------------------------------------------
  if ( pTgtDIH->types().includes( "Camera" ))
  {
    //--------------------------------------------------------------------------
    // Ensure that we have a source item and that we are dropping onto a
    // display object (and not on the container white space)
    //--------------------------------------------------------------------------
    IDMItem::Handle pSrcDIH = IDMItem::sourceItemFor(pTgtDIH);
    if (pSrcDIH && event.object() )
    {
      Camera*                                 camera;
      Display*                                display;
      CameraWindowVBContainerControl1CnrObj*  cameraObj;
      DisplayWindowVBContainerControl1CnrObj* displayObj;

      //------------------------------------------------------------------------
      // Get the container objects that are being used
      //------------------------------------------------------------------------
      cameraObj = (CameraWindowVBContainerControl1CnrObj*) pSrcDIH->object();
      displayObj = (DisplayWindowVBContainerControl1CnrObj*) event.object();

      //------------------------------------------------------------------------
      // Get the real objects that are represented by the container objects
      //------------------------------------------------------------------------
      camera = cameraObj->realObject();
      display = displayObj->realObject();

      //------------------------------------------------------------------------
      // Determine if the display can use the camera by comparing locations
      //------------------------------------------------------------------------
      if ( display->Location() == camera->Location() )
      {
        //----------------------------------------------------------------------
        // Yes, it is ok to drop the camera on this display
        //----------------------------------------------------------------------
        return ( true );
      }
    }
    //--------------------------------------------------------------------------
    // The item cannot be dropped on the container or on the current display
    // item so do not allow the drop
    //--------------------------------------------------------------------------
    event.setDropIndicator( IDM::notOk );
  }
  else
  {
    //--------------------------------------------------------------------------
    // The item is not a "Camera" so it can never be dropped on this container
    //--------------------------------------------------------------------------
    event.setDropIndicator( IDM::neverOk );
  }
  return( false );
}

