/*******************************************************************************
* FILE NAME: DMProv.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class:                                                  *
*     CameraItem                                                               *
*     CameraItemProvider                                                       *
* ---------------------------------------------------------------------------- *
* This file contains the declaration for the direct manipulation items and     *
* provider used in the sample.  This file should not be generated by the       *
* visual builder.                                                              *
*******************************************************************************/
#ifndef _DMPROV_
#define _DMPROV_

#include <idmprov.hpp>
#include <idmcnrit.hpp>
#include <idmevent.hpp>

/*----------------------------------------------------------------------------*/
/* Align classes on four byte boundary.                                       */
/*----------------------------------------------------------------------------*/
#pragma pack(4)


//*****************************************************************************
// Class definition for CameraItem
//*****************************************************************************
class CameraItem : public IDMCnrItem {
public:
   //---------------------------------------------------------------------------
   // Constructors / destructors
   //---------------------------------------------------------------------------
   CameraItem ( const IDMItem::Handle& item );

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   static Boolean generateSourceItems ( IDMSourceOperation* srcOp );

   Boolean targetDrop ( IDMTargetDropEvent& event );

}; // CameraItem

//*****************************************************************************
// Class definition for CameraItemProvider
//*****************************************************************************
class CameraItemProvider : public IDMItemProviderFor<CameraItem> {
public:
   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   Boolean provideEnterSupport ( IDMTargetEnterEvent& event );

}; // CameraItemProvider

/*----------------------------------------------------------------------------*/
/* Resume compiler default packing.                                           */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif
