/*******************************************************************************
* FILE NAME: DsplyWnd.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class:                                         *
*     DisplayWindow                                                            *
* ---------------------------------------------------------------------------- *
* Warning: This file was generated by the VisualAge C++ Visual Builder.        *
* Modifications to this source file will be lost when the part is regenerated. *
*******************************************************************************/
#ifndef _IFRAME_
#include <iframe.hpp>
#endif

#ifndef _IMCELCV_
#include <imcelcv.hpp>
#endif

#ifndef _ISTATTXT_
#include <istattxt.hpp>
#endif

#ifndef _IENTRYFD_
#include <ientryfd.hpp>
#endif

#ifndef _ISETCV_
#include <isetcv.hpp>
#endif

#ifndef _IPUSHBUT_
#include <ipushbut.hpp>
#endif

#ifndef _IRESLIB_
#include <ireslib.hpp>
#endif

#ifndef _IPOINT_
#include <ipoint.hpp>
#endif

#ifndef _IVSEQ_H_
#include <ivseq.h>
#endif

#ifndef _DISPLAY_
#include "Display.hpp"
#endif

#ifndef _IMSGBOX_
#include <imsgbox.hpp>
#endif

#ifndef _CAMERAITEMPROVIDER_
#include "dmprov.hpp"
#endif

#ifndef _INOTIFEV_
#include <inotifev.hpp>
#endif

#ifndef _IOBSERVR_
#include <iobservr.hpp>
#endif

#ifndef _ISTDNTFY_
#include <istdntfy.hpp>
#endif

#ifndef _DISPLAYWINDOW_
#include "DsplyWnd.hpp"
#endif

#ifndef _IVBDEFS_
#include <ivbdefs.h>
#endif

#ifndef _ITRACE_
#include <itrace.hpp>
#endif


//*****************************************************************************
// Class definition for DisplayWindowConn0
//*****************************************************************************
class DisplayWindowConn0 : public IObserver {
public:
   virtual  ~DisplayWindowConn0(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IVSequence< Display* > * aSource, IVBContainerControl< Display*, IVSequence<Display*>, DisplayWindowVBContainerControl1CnrObj > * aTarget)
      {source = aSource; target = aTarget; aligning = false; };
   void setSource()
      {      };
   void setTarget()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : DisplayList(this) to VBContainerControl1(items))");
         ITRACE_DEVELOP(" setting target from source ");
         aligning = true;
         try {target->setItems(source);}
         catch (IException& exc) {};
         aligning = false;
         }
      };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VBINITIALIZEID) setTarget();
      if ((anEvent.notificationId() == IVBContainerControl< Display*, IVSequence<Display*>, DisplayWindowVBContainerControl1CnrObj >::itemsId) && (target == &anEvent.notifier()))
         setSource();  /* set source to target value */
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IVSequence< Display* > * source;
   IVBContainerControl< Display*, IVSequence<Display*>, DisplayWindowVBContainerControl1CnrObj > * target;
   Boolean aligning;


};   //DisplayWindowConn0


//*****************************************************************************
// Class definition for DisplayWindowConn1
//*****************************************************************************
class DisplayWindowConn1 : public IObserver, public IStandardNotifier {
public:
   virtual  ~DisplayWindowConn1(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IPushButton * aSource, DisplayWindowDisplayFactoryFactory * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IPushButton::buttonClickId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : PushButton1(buttonClickEvent) to DisplayFactory(new))");
         try {target->create();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IPushButton * source;
   DisplayWindowDisplayFactoryFactory * target;


};   //DisplayWindowConn1


//*****************************************************************************
// Class definition for DisplayWindowConn4
//*****************************************************************************
class DisplayWindowConn4 : public IObserver, public IStandardNotifier {
public:
   virtual  ~DisplayWindowConn4(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(DisplayWindowDisplayFactoryFactory * aSource, IVSequence< Display* > * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == DisplayWindowDisplayFactoryFactory::newObjectCreatedId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : DisplayFactory(newEvent) to DisplayList(addAsLast))");
         try {target->addAsLast((Display *) (anEvent.eventData().asUnsignedLong()));}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   DisplayWindowDisplayFactoryFactory * source;
   IVSequence< Display* > * target;


};   //DisplayWindowConn4


//*****************************************************************************
// Class definition for DisplayWindowConn5
//*****************************************************************************
class DisplayWindowConn5 : public IObserver, public IStandardNotifier {
public:
   virtual  ~DisplayWindowConn5(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IVBContainerControl< Display*, IVSequence<Display*>, DisplayWindowVBContainerControl1CnrObj > * aSource, IVBVariablePartPointer<Display *> * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };
   DisplayWindowConn5 & setThis(IVBContainerControl< Display*, IVSequence<Display*>, DisplayWindowVBContainerControl1CnrObj > * aSelf) {iThis = aSelf; return *this;};

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (!target) return(*this);
      if (anEvent.notificationId() == IVBContainerControl< Display*, IVSequence<Display*>, DisplayWindowVBContainerControl1CnrObj >::enterId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : VBContainerControl1(enterEvent) to selectedDisplay(this))");
         try {target->setTarget(iThis->selectedElement());}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IVBContainerControl< Display*, IVSequence<Display*>, DisplayWindowVBContainerControl1CnrObj > * source;
   IVBVariablePartPointer<Display *> * target;
   IVBContainerControl< Display*, IVSequence<Display*>, DisplayWindowVBContainerControl1CnrObj > * iThis;


};   //DisplayWindowConn5


//*****************************************************************************
// Class definition for DisplayWindowConn7
//*****************************************************************************
class DisplayWindowConn7 : public IObserver, public IStandardNotifier {
public:
   virtual  ~DisplayWindowConn7(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IVBVariablePartPointer<Display *> * aSource, IMessageBox * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (!source) return(*this);
      if (anEvent.notificationId() == IVBVariablePartPointer<Display *>::targetId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : selectedDisplay(this) to MessageBox1(customLogic))");
         try {codeSnippet(&anEvent);}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member functions
   //---------------------------------------------------------------------------
   void codeSnippet(const INotificationEvent* event)
      {
      Display*	display = source->targetPtr();
      Camera*		camera  = display->activeCamera(); 

      target->setTitle(display->Location());

      if ( camera )
      {
        target->show(	IString(" Active camera : ")+
                     	camera->Name(),
      		IMessageBox::information);
      }
      else
      {
        target->show(	IString("No active camera"),
      	        IMessageBox::information);
      }
      };

   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IVBVariablePartPointer<Display *> * source;
   IMessageBox * target;


};   //DisplayWindowConn7


//*****************************************************************************
// Class definition for DisplayWindowConn8
//*****************************************************************************
class DisplayWindowConn8 : public IObserver, public IStandardNotifier {
public:
   virtual  ~DisplayWindowConn8(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(DisplayWindow * aSource, IVBContainerControl< Display*, IVSequence<Display*>, DisplayWindowVBContainerControl1CnrObj > * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == DisplayWindow::readyId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : (ready) to VBContainerControl1(customLogic))");
         try {codeSnippet(&anEvent);}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member functions
   //---------------------------------------------------------------------------
   void codeSnippet(const INotificationEvent* event)
      {
      IDMHandler::enableDropOn(target);
      target->setItemProvider((IDMItemProvider*)(source->icameraItemProvider));
      };

   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   DisplayWindow * source;
   IVBContainerControl< Display*, IVSequence<Display*>, DisplayWindowVBContainerControl1CnrObj > * target;


};   //DisplayWindowConn8


//------------------------------------------------------------------------------
// DisplayWindowVBContainerControl1CnrObj :: DisplayWindowVBContainerControl1CnrObj
//------------------------------------------------------------------------------
#pragma export (DisplayWindowVBContainerControl1CnrObj::DisplayWindowVBContainerControl1CnrObj(Display&))
DisplayWindowVBContainerControl1CnrObj::DisplayWindowVBContainerControl1CnrObj(Display& anObject)
 :IVBContainerObject(anObject.Location(), IResourceLibrary().loadIcon(200)), pRealObject(anObject)
{
   enableDataUpdate();
   handleNotificationsFor(pRealObject);
}


//------------------------------------------------------------------------------
// DisplayWindowVBContainerControl1CnrObj :: DisplayWindowVBContainerControl1CnrObj
//------------------------------------------------------------------------------
#pragma export (DisplayWindowVBContainerControl1CnrObj::DisplayWindowVBContainerControl1CnrObj(DisplayWindowVBContainerControl1CnrObj&))
DisplayWindowVBContainerControl1CnrObj::DisplayWindowVBContainerControl1CnrObj(DisplayWindowVBContainerControl1CnrObj& anObject)
 :IVBContainerObject(anObject.iconText(), anObject.icon()), pRealObject(anObject.pRealObject)
{  }


//------------------------------------------------------------------------------
// DisplayWindowVBContainerControl1CnrObj :: ~DisplayWindowVBContainerControl1CnrObj
//------------------------------------------------------------------------------
#pragma export (DisplayWindowVBContainerControl1CnrObj::~DisplayWindowVBContainerControl1CnrObj())
DisplayWindowVBContainerControl1CnrObj::~DisplayWindowVBContainerControl1CnrObj()
{
   this->stopHandlingNotificationsFor(pRealObject);
}


//------------------------------------------------------------------------------
// DisplayWindowVBContainerControl1CnrObj :: refreshFromObject
//------------------------------------------------------------------------------
#pragma export (DisplayWindowVBContainerControl1CnrObj::refreshFromObject())
IVBContainerObject & DisplayWindowVBContainerControl1CnrObj::refreshFromObject()
{
   setIconText(pRealObject.Location());
   setIcon(IResourceLibrary().loadIcon(200));
   return *this;
}


//------------------------------------------------------------------------------
// DisplayWindowVBContainerControl1CnrObj :: updateToObject
//------------------------------------------------------------------------------
IVBContainerObject & DisplayWindowVBContainerControl1CnrObj::updateToObject()
{
   pRealObject.setLocation(iconText());
   return *this;
}


//------------------------------------------------------------------------------
// DisplayWindowVBContainerControl1CnrObj :: operator=
//------------------------------------------------------------------------------
DisplayWindowVBContainerControl1CnrObj& DisplayWindowVBContainerControl1CnrObj::operator=(const DisplayWindowVBContainerControl1CnrObj& anObject)
{
   if (this == &anObject) {
      return *this;
      }
   IVBContainerObject::operator=(anObject);
   return *this;
}



const INotificationId DisplayWindowDisplayFactoryFactory::newObjectCreatedId = "DisplayWindowDisplayFactoryFactory::newObjectCreatedId";

//------------------------------------------------------------------------------
// DisplayWindowDisplayFactoryFactory :: DisplayWindowDisplayFactoryFactory
//------------------------------------------------------------------------------
#pragma export (DisplayWindowDisplayFactoryFactory::DisplayWindowDisplayFactoryFactory())
DisplayWindowDisplayFactoryFactory::DisplayWindowDisplayFactoryFactory()
{
   enableNotification();
}

//------------------------------------------------------------------------------
// DisplayWindowDisplayFactoryFactory :: ~DisplayWindowDisplayFactoryFactory
//------------------------------------------------------------------------------
#pragma export (DisplayWindowDisplayFactoryFactory::~DisplayWindowDisplayFactoryFactory())
DisplayWindowDisplayFactoryFactory::~DisplayWindowDisplayFactoryFactory()
{
   disableNotification();
}

//------------------------------------------------------------------------------
// DisplayWindowDisplayFactoryFactory :: create
//------------------------------------------------------------------------------
#pragma export (DisplayWindowDisplayFactoryFactory::create())
Display * DisplayWindowDisplayFactoryFactory::create()
{
   Display *iDisplayFactory = new Display();
   iDisplayFactory->setActiveCamera(0);
   iDisplayFactory->setDescription(iEntryField2->text());
   iDisplayFactory->setLocation(iEntryField1->text());
   iDisplayFactory->enableNotification();
   notifyObservers(INotificationEvent(newObjectCreatedId, *this, true, IEventData((void *)iDisplayFactory)));
   return(iDisplayFactory);
}



#pragma export (DisplayWindow::readyId)
const INotificationId DisplayWindow::readyId = "DisplayWindow::readyId";

#pragma export (DisplayWindow::partWindowId)
unsigned long DisplayWindow::partWindowId = 0;

//------------------------------------------------------------------------------
// DisplayWindow :: defaultFramingSpec
//------------------------------------------------------------------------------
#pragma export (DisplayWindow::defaultFramingSpec())
const IRectangle DisplayWindow::defaultFramingSpec()
{
   return(IRectangle(IPoint(314, IWindow::desktopWindow()->size().height() - 287 - 360),ISize(532, 360)));
}


//------------------------------------------------------------------------------
// DisplayWindow :: defaultStyle
//------------------------------------------------------------------------------
#pragma export (DisplayWindow::defaultStyle())
const IFrameWindow::Style DisplayWindow::defaultStyle()
{
   return(IFrameWindow::defaultStyle() | IFrameWindow::dialogBackground | IWindow::visible);
}


//------------------------------------------------------------------------------
// DisplayWindow :: defaultTitle
//------------------------------------------------------------------------------
#pragma export (DisplayWindow::defaultTitle())
IString DisplayWindow::defaultTitle()
{
   return("Display Window");
}


//------------------------------------------------------------------------------
// DisplayWindow :: DisplayWindow
//------------------------------------------------------------------------------
#pragma export (DisplayWindow::DisplayWindow(unsigned long, IWindow*, IWindow*, const IRectangle&, const IFrameWindow::Style&, const char*))
DisplayWindow::DisplayWindow(
      unsigned long id, 
      IWindow* parent, 
      IWindow* owner, 
      const IRectangle& rect, 
      const IFrameWindow::Style& style, 
      const char* title)
   : IFrameWindow((partWindowId) ? partWindowId : id, parent, owner, rect, style, title)
{
   partWindowId = (partWindowId) ? partWindowId : id;
   iMultiCellCanvas1 = new IMultiCellCanvas(
      IC_FRAME_CLIENT_ID, 
      this, 
      this, 
      IRectangle());
   iStaticText1 = new IStaticText(
      partWindowId+WNDOFFSET_DisplayWindow_StaticText1, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iStaticText2 = new IStaticText(
      partWindowId+WNDOFFSET_DisplayWindow_StaticText2, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iEntryField1 = new IEntryField(
      partWindowId+WNDOFFSET_DisplayWindow_EntryField1, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle(), 
      IEntryField::defaultStyle() | IControl::tabStop);
   iEntryField2 = new IEntryField(
      partWindowId+WNDOFFSET_DisplayWindow_EntryField2, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle(), 
      IEntryField::defaultStyle() | IControl::tabStop);
   iSetCanvas1 = new ISetCanvas(
      partWindowId+WNDOFFSET_DisplayWindow_SetCanvas1, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iPushButton1 = new IPushButton(
      partWindowId+WNDOFFSET_DisplayWindow_PushButton1, 
      iSetCanvas1, 
      iSetCanvas1, 
      IRectangle(), 
      IPushButton::defaultStyle() | IPushButton::defaultButton | IControl::tabStop);
   iVBContainerControl1 = new IVBContainerControl< Display*, IVSequence<Display*>, DisplayWindowVBContainerControl1CnrObj >(
      partWindowId+WNDOFFSET_DisplayWindow_VBContainerControl1, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle ( ), 
      IContainerControl::defaultStyle() | IContainerControl::autoPosition | IContainerControl::singleSelection);
   iDisplayList = new IVSequence< Display* >();
   iDisplayFactory = new DisplayWindowDisplayFactoryFactory();
   iselectedDisplay = new IVBVariablePartPointer<Display *>();
   iMessageBox1 = new IMessageBox(this);
   icameraItemProvider = new CameraItemProvider();

   conn0 = new DisplayWindowConn0();
   conn1 = new DisplayWindowConn1();
   conn4 = new DisplayWindowConn4();
   conn5 = new DisplayWindowConn5();
   conn7 = new DisplayWindowConn7();
   conn8 = new DisplayWindowConn8();

   this->setFocus();
   this->setClient(iMultiCellCanvas1);
   iMultiCellCanvas1->addToCell(iStaticText1, 1, 3, 1, 1);
   iMultiCellCanvas1->addToCell(iStaticText2, 1, 4, 1, 1);
   iMultiCellCanvas1->addToCell(iEntryField1, 2, 3, 1, 1);
   iMultiCellCanvas1->addToCell(iEntryField2, 2, 4, 1, 1);
   iMultiCellCanvas1->addToCell(iSetCanvas1, 4, 3, 1, 2);
   iMultiCellCanvas1->addToCell(iVBContainerControl1, 1, 1, 5, 1);
   iMultiCellCanvas1->setColumnWidth(5, IMultiCellCanvas::defaultCell().width(), true);
   iMultiCellCanvas1->setRowHeight(1, IMultiCellCanvas::defaultCell().height(), true);
   iMultiCellCanvas1->setRowHeight(4, IMultiCellCanvas::defaultCell().height(), false);
   iStaticText1->setAlignment(IStaticText::centerRight);
   iStaticText1->setText("Location:");
   iStaticText2->setAlignment(IStaticText::centerRight);
   iStaticText2->setText("Description:");
   iPushButton1->setText("Add");
   iVBContainerControl1->setMinimumSize(ISize(511, 166));
   iVBContainerControl1->showIconView();
   iDisplayFactory->setEntryField1(iEntryField1);
   iDisplayFactory->setEntryField2(iEntryField2);
}     //end constructor


//------------------------------------------------------------------------------
// DisplayWindow :: ~DisplayWindow
//------------------------------------------------------------------------------
#pragma export (DisplayWindow::~DisplayWindow())
DisplayWindow::~DisplayWindow()
{
   conn0->stopHandlingNotificationsFor(*iDisplayList);
   conn0->stopHandlingNotificationsFor(*iVBContainerControl1);
   conn1->stopHandlingNotificationsFor(*iPushButton1);
   conn4->stopHandlingNotificationsFor(*iDisplayFactory);
   conn5->stopHandlingNotificationsFor(*iVBContainerControl1);
   conn7->stopHandlingNotificationsFor(*iselectedDisplay);
   conn8->stopHandlingNotificationsFor(*this);

   delete conn0;
   delete conn1;
   delete conn4;
   delete conn5;
   delete conn7;
   delete conn8;


   delete iMultiCellCanvas1;
   delete iStaticText1;
   delete iStaticText2;
   delete iEntryField1;
   delete iEntryField2;
   delete iSetCanvas1;
   delete iPushButton1;
   delete iVBContainerControl1;
   delete iDisplayList;
   delete iDisplayFactory;
   delete iselectedDisplay;
   delete iMessageBox1;
   delete icameraItemProvider;
}

//------------------------------------------------------------------------------
// DisplayWindow :: initializePart
//------------------------------------------------------------------------------
#pragma export (DisplayWindow::initializePart())
DisplayWindow & DisplayWindow::initializePart()
{
   makeConnections();
   notifyObservers(INotificationEvent(readyId, *this));
   return *this;
}


//------------------------------------------------------------------------------
// DisplayWindow :: makeConnections
//------------------------------------------------------------------------------
#pragma export (DisplayWindow::makeConnections())
Boolean DisplayWindow::makeConnections()
{
   this->enableNotification();
   iMultiCellCanvas1->enableNotification();
   iStaticText1->enableNotification();
   iStaticText2->enableNotification();
   iEntryField1->enableNotification();
   iEntryField2->enableNotification();
   iSetCanvas1->enableNotification();
   iPushButton1->enableNotification();
   iVBContainerControl1->enableNotification();
   iDisplayList->enableNotification();
   iDisplayFactory->enableNotification();
   iselectedDisplay->enableNotification();

   conn0->initialize(iDisplayList, iVBContainerControl1);
   conn0->handleNotificationsFor(*iDisplayList);
   conn0->handleNotificationsFor(*iVBContainerControl1);
   conn1->initialize(iPushButton1, iDisplayFactory);
   conn1->handleNotificationsFor(*iPushButton1);
   conn4->initialize(iDisplayFactory, iDisplayList);
   conn4->handleNotificationsFor(*iDisplayFactory);
   conn5->initialize(iVBContainerControl1, iselectedDisplay);
   conn5->handleNotificationsFor(*iVBContainerControl1);
   conn5->setThis(iVBContainerControl1);
   conn7->initialize(iselectedDisplay, iMessageBox1);
   conn7->handleNotificationsFor(*iselectedDisplay);
   conn8->initialize(this, iVBContainerControl1);
   conn8->handleNotificationsFor(*this);

   conn0->setTarget();
   return true;
}



