//****************************************************************************
// CnrHelpHandler - cnrhelph.cpp                                             *
//                                                                           *
// COPYRIGHT: Copyright (C) International Business Machines Corp., 1994,1995 *
//                                                                           *
// DISCLAIMER OF WARRANTIES:                                                 *
//   The following [enclosed] code is sample code created by IBM             *
//   Corporation.  This sample code is not part of any standard IBM product  *
//   and is provided to you solely for the purpose of assisting you in the   *
//   development of your applications.  The code is provided "AS IS",        *
//   without warranty of any kind.  IBM shall not be liable for any damages  *
//   arising out of your use of the sample code, even if they have been      *
//   advised of the possibility of such damages.                             *
//****************************************************************************
//NOTE: WE RECOMMEND USING A FIXED-SPACE FONT TO LOOK AT THE SOURCE.
//

#ifndef _ITRACE_
#include <itrace.hpp>
#endif

#ifndef _IHELP_
#include <ihelp.hpp>
#endif

#ifndef _ICNRCTL_
#include <icnrctl.hpp>
#endif

#ifndef _ICNRCOL_
#include <icnrcol.hpp>
#endif

#ifndef _IRESLIB_
#include <ireslib.hpp>
#endif

#include "cnrhelph.hpp"         //CnrHelpHandler

//***************************************************************************
// Class:   CnrHelpHandler
//
// Purpose: Provides help support for a container.
//
//***************************************************************************

//*******************************************************************
// Manager Member Functions (Not Part Actions)
//*******************************************************************
CnrHelpHandler :: CnrHelpHandler(unsigned long helpId) : ICnrHandler(),
     iCnrHelpId(helpId)
{
}

CnrHelpHandler :: ~CnrHelpHandler()
{
}

IBase::Boolean CnrHelpHandler :: help(ICnrHelpEvent& evt)
{
   IContainerControl* pCnrCtl = (IContainerControl*)evt.controlWindow();
   IContainerColumn* pCnrCol = 0;
   IContainerObject* pCnrObj = 0;
   IHelpWindow* pHelp = IHelpWindow::helpWindow(pCnrCtl);

   if(pHelp!=0)
   {
      unsigned long ulHelpId = 0;
      if(pCnrCtl!=0)
      {
         pCnrCol = pCnrCtl->currentEditColumn();
         if (pCnrCol)
            ulHelpId = pCnrCol->helpId();  //column help
         else
         {
            pCnrObj = evt.object();
            if (pCnrObj)
               ulHelpId = pCnrObj->helpId();  //object help
         }

         if (ulHelpId == 0)  //if no container column or object help
            ulHelpId = iCnrHelpId;   //container help
      }

      if (ulHelpId)
      {
         ITRACE_DEVELOP("About to show help for Id: " + IString(ulHelpId));
         pHelp->show(IResourceId(ulHelpId));
         return true;
      } /* endif */
      else
         ITRACE_DEVELOP("No help Id: ");

   } /* endif */

   return false;
}
