#ifndef _IVBCEHDR_
#define _IVBCEHDR_
/*******************************************************************************
* FILE NAME: ivbcehdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IVBCnrEditHandler                                                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1995       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <icnrehdr.hpp>
#include <ivbcnr.h>

#pragma pack(4)

class IVBCnrEditHandler : public ICnrEditHandler {
typedef IVBCnrEditHandler
   Inherited;

public:
/*-------------------------- Constructors ------------------------------------*/

/*-------------------------- Event Processing --------------------------------*/
virtual Boolean
  endEdit              ( ICnrEndEditEvent&       event)
     {
     ICnrEditHandler::endEdit(event);
     IVBContainerObject *cnrObj = ((IVBContainerObject *) event.object());
     cnrObj->updateToObject();
     return false;
     };
};

#pragma pack()
#endif
