#ifndef _IVBCNR_
  #define _IVBCNR_
/*******************************************************************************
* FILE NAME: ivbcnr.h                                                          *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IVBContainerControl                                                      *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1995       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <icnrctl.hpp>
#include <icnrobj.hpp>

#include <icolobsv.hpp>
#include <irect.hpp>
#include <inotify.hpp>
#include <ivseq.h>
#include <iexcbase.hpp>


class IString;
class IWindowHandle;
template <class Element, class ViewClass, class Collection> class IVBContainerControlData;
template < class Element > class IVSequence;


#pragma implementation("ivbcnr.c")
#pragma pack(4)


template <class Element, class Collection, class CnrElement>
  class IVBContainerControl : public IContainerControl {

typedef IContainerControl
  Inherited;

#pragma define(ICollectionObserver<Element,IVBContainerControl<Element,Collection,CnrElement>,Collection>)

public:
/*------------------------- Constructors -------------------------------------*/
  IVBContainerControl ( unsigned long                       identifier,
                        IWindow*                            parent,
                        IWindow*                            owner,
                        const IRectangle&                   initial   =
                           IRectangle                         ( ),
                        const IContainerControl::Style&     style     =
                           IContainerControl::defaultStyle    ( ),
                        const IContainerControl::Attribute& attribute =
                           IContainerControl::defaultAttribute( ) );

  IVBContainerControl ( unsigned long                identifier,
                        IWindow*                     parent   );

  IVBContainerControl ( const IWindowHandle&         handle   );

virtual
 ~IVBContainerControl ( );

/*------------------------- Collection ---------------------------------------*/
virtual Collection
 *items                  ( ) const;

virtual IVBContainerControl<Element,Collection,CnrElement>
 &setItems               ( Collection* collection );

/*------------------------- Collection-Reporting Protocol --------------------*/
virtual IVBContainerControl<Element,Collection,CnrElement>
 &elementChanged         ( unsigned long   position,
                           const Element&  element  ),
 &elementAdded           ( unsigned long   position,
                           const Element&  element  ),
 &elementDeleted         ( unsigned long   position ),
 &elementsChanged        ( ),
 &collectionReplaced     ( );

/*------------------------- Selection ----------------------------------------*/
static const unsigned long
  noSelection;

virtual IVBContainerControl<Element,Collection,CnrElement>
 &select                     ( unsigned long   collectionPosition,
                               Boolean         select = true ),
 &deselect                   ( unsigned long   collectionPosition );

virtual Element
  selectedElement            ( );

virtual CnrElement
 *selectedCnrObject          ( );

virtual unsigned long
  selectedCollectionPosition ( );

virtual IVBContainerControl<Element,Collection,CnrElement>
 &selectedElements           ( Collection&     elements ),
 &selectedCnrObjects         ( IVSequence<CnrElement *>& cnrObjects );

unsigned long
  numberOfSelections         ( ) const;

/*------------------------- Notification Members -----------------------------*/
static INotificationId const
  itemChangedId,
  itemsId;

private:
/*------------------------- Hidden Members -----------------------------------*/
  IVBContainerControl
             ( const IVBContainerControl< Element,Collection,CnrElement >& source );
IVBContainerControl<Element,Collection,CnrElement>
 &operator=  ( const IVBContainerControl< Element,Collection,CnrElement >& source );

/*------------------------- Private ------------------------------------------*/
IVBContainerControlData< Element,
                         IVBContainerControl<Element,Collection,CnrElement>,
                         Collection >
 *fVBContainerControlData;

void
  initialize ( );

static const unsigned long
  firstItem;

}; // IVBContainerControl<Element,Collection,CnrElement>


class IVBContainerObject : public IContainerObject, public IObserver {
public:
  IVBContainerObject       ( const IString&         string,
                             const IPointerHandle&  iconHandle = 0 );

IVBContainerObject
 &operator=                ( const IVBContainerObject&  aObject );

virtual IVBContainerObject
 &refreshFromObject        ( ) { return *this; }
virtual IVBContainerObject
 &updateToObject           ( ) { return *this; }

virtual IObserver
 &dispatchNotificationEvent( const INotificationEvent &anEvent );
IString
  asString                 ( ) const;

};  // IVBContainerObject

#pragma pack()

#endif  /*  _IVBCNR_  */
