 #ifndef _CNRHDR_
   #define _CNRHDR_

 #ifndef _ICNRHDR_
   #include <icnrhdr.hpp>
 #endif

 #ifndef _ICNREVT_
   #include <icnrevt.hpp>
 #endif

 #ifndef _ICNRCTL_
   #include <icnrctl.hpp>
 #endif

 template <class CnrOwnerClass, class CnrObjClass>
 class CnrSelectedElemHandler : public ICnrHandler
 {
   public:
     CnrSelectedElemHandler(CnrOwnerClass* cnrOwner)
       : ICnrHandler(), iCnrOwner(cnrOwner)
     {
     }
     ~CnrSelectedElemHandler()
     {
     }

     Boolean selectedChanged(ICnrEmphasisEvent& event)
     {
       if (event.changed(IContainerObject::selected))
       {
         CnrObjClass* selObject =
           (CnrObjClass *) event.object();

         iCnrOwner->setCnrSelectedElement(selObject->realObject());
       }
       return false;
     }
   private:
     CnrOwnerClass* iCnrOwner;
 };
 #endif
