#ifndef _DTS_HH_INCLUDED_cntxt
#define _DTS_HH_INCLUDED_cntxt
/* Start Interface Context */

// This file was generated by the IBM "DirectToSOM" emitter for C++ (V1.75)
// Generated at 03/10/95 04:42:32 EST

#include <som.hh>

     #pragma SOMAsDefault(on)
class SOMClass;
     #pragma SOMAsDefault(pop)
     #pragma SOMAsDefault(on)
class SOMObject;
     #pragma SOMAsDefault(pop)
     #pragma SOMAsDefault(on)
class Container;
     #pragma SOMAsDefault(pop)
     #pragma SOMAsDefault(on)
class NVList;
     #pragma SOMAsDefault(pop)
#include <somobj.hh>

/*
 * Context flags
 */
#define CTX_DELETE_DESCENDENTS      0x00000200
#define CTX_RESTRICT_SCOPE          0x00000400

#include <somcls.hh>
#pragma SOMNonDTS(on)

#pragma SOMAsDefault(on)
class Context : public SOMObject {

	#pragma SOMClassName(*, "Context")
	#pragma SOMNoMangling(*)
	#pragma SOMNonDTS(*)

     #pragma SOMClassVersion (Context, 2, 1)
     #pragma SOMCallstyle (idl)
     #pragma SOMAsDefault(off)
     #pragma SOMAsDefault(pop)
  public :
     
     //  This method sets or adds a single context object property. If prop_name
     //  does not exist in the property list, it is added. If prop_name
     //  does exist, its value is changed.
     //
     virtual ORBStatus set_one_value(Identifier prop_name, string value);
     
     //  This method sets or changes one or more property values in the context
     //  object. If a prop_name specified in the NVList does not exist in the
     //  Context object property list, it is added. If a prop_name specified in
     //  the NVList does exist in the Context object property list, its value
     //  is changed.
     //
     virtual ORBStatus set_values(NVList* values);
     
     //  This method retrieves the specified context property value(s) If
     //  prop_name has a trailing wildcard ("*"), then all matching properties
     //  and their values are returned. The returned NVList is the responsibility
     //  of the caller,
     //
     //  If no matching properties are found, and error is returned the property
     //  list contains no values.
     //
     //  Scope indicates the context object level at which to initiate the search
     //  for the specified properties (e.g. "_USER", "_SYSTEM"). If the property
     //  is not found at the indicated level, the search continues up the context
     //  object tree until a match is found or all context objects in the chain
     //  have been searched.
     //
     //  If scope name is ommitted, the search begins with the specified context
     //  object. If the specified scope name is not found, an exception is
     //  returned.
     //
     //  The following operation flags may be specified:
     //
     //  CTX_RESTRICT_SCOPE  Searching is limited to the specified search scope or
     //                      context object.
     //
     virtual ORBStatus get_values(Identifier start_scope, Flags op_flags, 
                                  Identifier prop_name, NVList** values);
     
     //  This method deletes the specified property value(s) from the context
     //  object.  If prop_name has a trailing wildcard character ("*"), then
     //  all property names which match will be deleted.
     //
     //  Search scope is always limited to the specified context object.
     //
     //  If no matching property is found, an exception is returned.
     //
     virtual ORBStatus delete_values(Identifier prop_name);
     
     //
     //  This method creates a child context object.
     //
     //  The returned context object is chained to its parent context. That is,
     //  searches on the child context object will look in the parent context
     //  (and so on, up the context tree), if necessary, for matching property
     //  names.
     //
     virtual ORBStatus create_child(Identifier ctx_name, Context** child_ctx);
     
     //  This operation deletes the indicated context object.
     //  The following flags may be specified:
     //
     //  CTX_DELETE_DESCENDENTS    Deletes the indicated context object and all
     //                            of its descendent context objects as well.
     //
     //  An exception is returned if there are one or more child context objects
     //  and the CTX_DELETE_DESCENDENTS flag was not set.
     //
     virtual ORBStatus destroy(Flags flags);
     #pragma SOMReleaseOrder ( \
			      "set_one_value", \
			      "set_values", \
			      "get_values", \
			      "delete_values", \
			      "create_child", \
			      "destroy", \
			      *, \
			      *, \
			      *, \
			      *, \
			      *, \
			      *)
};
#pragma SOMAsDefault(pop)

     #pragma SOMNonDTS(pop)
/* End Context */
#endif /* _DTS_HH_INCLUDED_cntxt */
