#ifndef _DTS_HH_INCLUDED_implrep
#define _DTS_HH_INCLUDED_implrep
/* Start Interface ImplRepository */

// This file was generated by the IBM "DirectToSOM" emitter for C++ (V1.75)
// Generated at 03/10/95 04:42:51 EST

#include <som.hh>

     #pragma SOMAsDefault(on)
class SOMClass;
     #pragma SOMAsDefault(pop)
     #pragma SOMAsDefault(on)
class SOMObject;
     #pragma SOMAsDefault(pop)
     #pragma SOMAsDefault(on)
class Container;
     #pragma SOMAsDefault(pop)
     #pragma SOMAsDefault(on)
class ImplementationDef;
     #pragma SOMAsDefault(pop)
#include <somobj.hh>

#include <impldef.hh>

#include <snglicls.hh>
#pragma SOMNonDTS(on)

#pragma SOMAsDefault(on)
class ImplRepository : public SOMObject {

	#pragma SOMClassName(*, "ImplRepository")
	#pragma SOMNoMangling(*)
	#pragma SOMNonDTS(*)

     #pragma SOMClassName (ImplRepository, "ImplRepository")
     #pragma SOMMetaClass (ImplRepository, "SOMMSingleInstance")
     #pragma SOMClassVersion (ImplRepository, 2, 1)
     #pragma SOMCallstyle (idl)
     #pragma SOMAsDefault(off)
  public :
     typedef struct {
	unsigned long _maximum;
	unsigned long _length;
	ImplementationDef **_buffer;
     } _IDL_SEQUENCE_ImplementationDef;
     typedef struct {
	unsigned long _maximum;
	unsigned long _length;
	string *_buffer;
     } _IDL_SEQUENCE_string;
     #pragma SOMAsDefault(pop)

     // This method searches the Implementation Repository and returns
     // an ImplementationDef object with the specified implid.
     virtual ImplementationDef* find_impldef(ImplId implid);

     // This method searches the Implementation Repository and returns
     // an ImplementationDef object with the specified name (alias).
     virtual ImplementationDef* find_impldef_by_alias(string alias_name);

     // This method searches the Implementation Repository and returns
     // all the ImplementationDef objects in it.
     virtual ORBStatus find_all_impldefs(_IDL_SEQUENCE_ImplementationDef* outimpldefs);

     // This method searches the class index and returns the sequence of
     // ImplementationDef objects for servers which implement that class.
     virtual /* seq<	     0> */ _IDL_SEQUENCE_ImplementationDef find_impldef_by_class(string classname);

     // This method inserts an ImplementationDef object into the Implementation
     // Repository.
     virtual void add_impldef(ImplementationDef* impldef);

     // This method replaces an ImplementationDef object in the Implementation
     // Repository with the supplied object.  The "impl_id" attribute of the
     // supplied object is used to find the object to replace in the Impl.
     // Repository.
     virtual void update_impldef(ImplementationDef* impldef);

     // This method deletes the ImplementationDef object with the specified
     // implid from the Implementation Repository.
     virtual void delete_impldef(ImplId implid);

     // This method associates the classname with the ImplementationDef
     // whose id is "implid".  This is meant to indicate that the server
     // (specified by the ImplementationDef) implements the named class.
     virtual void add_class_to_impldef(ImplId implid, string classname);

     // This method removes the classname from the list of classnames
     // associated with the ImplementationDef whose id is "implid".
     virtual void remove_class_from_impldef(ImplId implid, string classname);

     // This method removes the classname from all the ImplementationDefs.
     virtual void remove_class_from_all(string classname);

     // This method searches the class index and returns the sequence of
     // class names supported by a server with specified "implid".
     virtual /* seq<	     0> */ _IDL_SEQUENCE_string find_classes_by_impldef(ImplId implid);
     ImplRepository();
     virtual ~ImplRepository();
     #pragma SOMReleaseOrder ( \
			      "find_impldef", \
			      "find_impldef_by_alias", \
			      *, \
			      *, \
			      "find_impldef_by_class", \
			      "add_impldef", \
			      "update_impldef", \
			      "delete_impldef", \
			      "add_class_to_impldef", \
			      "remove_class_from_impldef", \
			      "remove_class_from_all", \
			      "find_classes_by_impldef", \
			      *, \
			      *, \
			      *, \
			      *, \
			      "find_all_impldefs")
};
#pragma SOMAsDefault(pop)

SOMEXTERN ImplRepository * SOMDLINK SOMD_ImplRepObject;

     #pragma SOMNonDTS(pop)
/* End ImplRepository */
#endif /* _DTS_HH_INCLUDED_implrep */
