#ifndef _DTS_HH_INCLUDED_request
#define _DTS_HH_INCLUDED_request
/* Start Interface Request */

// This file was generated by the IBM "DirectToSOM" emitter for C++ (V1.75)
// Generated at 03/10/95 04:43:23 EST

#include <som.hh>

     #pragma SOMAsDefault(on)
class SOMClass;
     #pragma SOMAsDefault(pop)
     #pragma SOMAsDefault(on)
class SOMObject;
     #pragma SOMAsDefault(pop)
     #pragma SOMAsDefault(on)
class Container;
     #pragma SOMAsDefault(pop)
#include <somobj.hh>
/*
 *  Flags defined on requests
 */

#define ARG_IN		0x00000001  	/* defined in somir.h */
#define ARG_OUT		0x00000002	/* defined in somir.h */
#define ARG_INOUT	0x00000004	/* defined in somir.h */
#define IN_COPY_VALUE	0x00000008	/* add_arg flag */
#define DEPENDENT_LIST	0x00000010	/* add_item flag */
#define OUT_LIST_MEMORY	0x00000020	/* req flag */
#define INV_NO_RESPONSE	0x00000040	/* invoke flag */
#define INV_TERM_ON_ERR	0x00000080	/* invoke flag */
#define RESP_NO_WAIT	0x00000100	/* response flag */
/* Internal Use Flags */
#define AUTH_IN_MSG      0x00010000      /* msg includes auth info */
#define ACKONEWAY        0x00020000      /* ack oneway messages */
#define ENV_IN_MSG       0x00040000      /* msg includes env info */
#define CTX_IN_MSG       0x00080000      /* msg includes ctx info */
#define OBJ_OWNED        0x00100000	/* arg. mem. is obj. owned */
#define CALLER_OWNED     0x00200000	/* arg mem is caller owned */
#define RESULT_OUT       0x00400000	/* method result, not arg  */
#define CLIENT_SIDE      0x00800000	/* client side of request */
#define SERVER_SIDE      0x01000000	/* server side of request */
#define TXCTX_IN_MSG     0x02000000      /* msg includes trans info */
#define ARG_IS_PTRARG    0x10000000      /* ptr to arg, !aggregate */
#define ARG_IS_COMPONENT 0x20000000      /* comp of aggregate type */
#define ROOT_NOT_PTRARG  0x40000000      /* root struct not ptr */
#define RESERVED_FLAGS	0x8c00fe00	/* future/internal use */

/*
 *  Functions for multiple deferred-synchronous requests.
 */
ORBStatus SOMLINK send_multiple_requests (
	IN	Request*	reqs[],		/* array of Requests */
	IN	Environment	*env,
	IN	long		count,		/* number of Requests */
	IN	Flags		invoke_flags
    );

ORBStatus SOMLINK get_next_response (
	INOUT	Environment	*env,
	IN	Flags		response_flags,
	OUT	Request*	*req
);

#include <somcls.hh>
#pragma SOMNonDTS(on)

#pragma SOMAsDefault(on)
class Request : public SOMObject {

	#pragma SOMClassName(*, "Request")
	#pragma SOMNoMangling(*)
	#pragma SOMNonDTS(*)

     #pragma SOMClassVersion (Request, 2, 1)
     #pragma SOMCallstyle (idl)
     #pragma SOMAsDefault(off)
     #pragma SOMAsDefault(pop)
  public :
     
     // Incrementally adds an arg to the Request.
     // The Request must have been created using the "create_request"
     // method, with an empty argument list.  (We can't add args to a
     // list that was passed in to the create_request call. [pg. 109])
     virtual ORBStatus add_arg(Identifier name, TypeCode arg_type, 
                               void* value, long len, Flags arg_flags);
     
     // Invokes the Request synchronously, waiting for the response.
     virtual ORBStatus invoke(Flags invoke_flags);
     
     // Invokes the Request asynchronously.  The response must eventually
     // be checked by invoking get_response or get_next_response.
     virtual ORBStatus send(Flags invoke_flags);
     
     // Determines whether an asynchronous Request has completed.
     virtual ORBStatus get_response(Flags response_flags);
     
     // Deletes the memory allocated by the ORB for the Request.
     virtual ORBStatus destroy();
     Request();  
     virtual ~Request();  
     #pragma SOMReleaseOrder ( \
			      "add_arg", \
			      "invoke", \
			      "send", \
			      "get_response", \
			      "destroy", \
			      *, \
			      *, \
			      *, \
			      *, \
			      *, \
			      *, \
			      *, \
			      *, \
			      *, \
			      *, \
			      *, \
			      *, \
			      *, \
			      *)
};
#pragma SOMAsDefault(pop)

     #pragma SOMNonDTS(pop)
/* End Request */
#endif /* _DTS_HH_INCLUDED_request */
