#ifndef _DTS_HH_INCLUDED_SOMDSERV
#define _DTS_HH_INCLUDED_SOMDSERV
/* Start Interface SOMDServer */

// This file was generated by the IBM "DirectToSOM" emitter for C++ (V1.75)
// Generated at 03/10/95 04:42:14 EST

#include <som.hh>

     #pragma SOMAsDefault(on)
class SOMClass;
     #pragma SOMAsDefault(pop)
     #pragma SOMAsDefault(on)
class SOMObject;
     #pragma SOMAsDefault(pop)
     #pragma SOMAsDefault(on)
class Container;
     #pragma SOMAsDefault(pop)
     #pragma SOMAsDefault(on)
class SOMDObject;
     #pragma SOMAsDefault(pop)
#include <somobj.hh>

SOMEXTERN SOMDServer * SOMDLINK SOMD_ServerObject; /* global variable */

#include <snglicls.hh>
#pragma SOMNonDTS(on)

#pragma SOMAsDefault(on)
class SOMDServer : public SOMObject {

	#pragma SOMClassName(*, "SOMDServer")
	#pragma SOMNoMangling(*)
	#pragma SOMNonDTS(*)

     #pragma SOMClassName (SOMDServer, "SOMDServer")
     #pragma SOMMetaClass (SOMDServer, "SOMMSingleInstance")
     #pragma SOMClassVersion (SOMDServer, 2, 1)
     #pragma SOMCallstyle (idl)
     #pragma SOMAsDefault(off)
     #pragma SOMAsDefault(pop)
  public :
     
     // This method returns a DSOM object reference for a SOM object
     // instance in this server process.  SOMOA will call this method
     // whenever it returns a result from a method call which includes
     // a pointer to a SOMObject (versus a pointer to a SOMDObject).
     // Ownership of the returned object reference is given to the
     // caller EXCEPT when the somdObjReferencesCached method returns TRUE.
     // When the input (somobj) is already an object reference, the default
     // implementation simply returns somobj, rather than creating a new reference.
     // (Subclasses might override this method to duplicate the input reference, however.)
     // Hence, callers should note when the returned value is the same as
     // the input (somobj) when determining whether or not to free the result.
     virtual SOMDObject* somdRefFromSOMObj(SOMObject* somobj);
     
     // This method maps a DSOM object reference into a SOM object.
     // This can be done in whatever way is appropriate for the application.
     // This method is called by SOMOA in order to translate any method call
     // parameters which are object references (created from somdRefFromSOMObj
     // above) into SOM objects.
     virtual SOMObject* somdSOMObjFromRef(SOMDObject* objref);
     
     // This method is called by SOMOA to dispatch a method on a SOM object.
     // The intention is to give the Server object an opportunity to intercept
     // method calls, if desired.  The parameters to this method are the same
     // as the parameters passed to SOMObject::somDispatch.
     //
     // The default implementation invokes SOMObject::somDispatch on the
     // specified target object, "somobj", with the supplied arguments.
     virtual void somdDispatchMethod(SOMObject* somobj, somToken* retValue, 
                                     somId methodId, va_list ap);
     
     // Creates an object of the specified class.  This method (if overridden)
     // may optionally define creation "hints" which the client may specify in
     // this call.
     //
     // Called indirectly by SOMDObjectMgr::somdNewObject.
     //
     // The default implementation calls somdGetClassObj to get the specified
     // SOMClass object, and invokes "somNew".  The "hints" argument is ignored
     // in the default implementation.
     virtual SOMObject* somdCreateObj(Identifier objclass, string hints);
     
     // Deletes a SOM object.  By default, simply calls somFree on the object.
     // Can be overridden by the application.
     //
     // Called indirectly by SOMDObjectMgr::somdDestroyObject.
     virtual void somdDeleteObj(SOMObject* somobj);
     
     // Creates/returns a class object for the specified class.
     // (May result in the loading of a DLL for the class.)
     virtual SOMClass* somdGetClassObj(Identifier objclass);
     
     // Whether the server retains ownership of the object references
     // it creates via the somdRefFromSOMObj method.
     virtual boolean somdObjReferencesCached();
     #pragma SOMReleaseOrder ( \
			      "somdSOMObjFromRef", \
			      "somdRefFromSOMObj", \
			      "somdCreateObj", \
			      "somdDeleteObj", \
			      "somdGetClassObj", \
			      "somdDispatchMethod", \
			      "somdObjReferencesCached")
};
#pragma SOMAsDefault(pop)

     #pragma SOMNonDTS(pop)
/* End SOMDServer */
#endif /* _DTS_HH_INCLUDED_SOMDSERV */
