#ifndef _DTS_HH_INCLUDED_somoa
#define _DTS_HH_INCLUDED_somoa
/* Start Interface SOMOA */

// This file was generated by the IBM "DirectToSOM" emitter for C++ (V1.75)
// Generated at 03/10/95 04:44:04 EST

#include <som.hh>

     #pragma SOMAsDefault(on)
class SOMClass;
     #pragma SOMAsDefault(pop)
     #pragma SOMAsDefault(on)
class SOMObject;
     #pragma SOMAsDefault(pop)
     #pragma SOMAsDefault(on)
class Container;
     #pragma SOMAsDefault(pop)
     #pragma SOMAsDefault(on)
class SOMDObject;
     #pragma SOMAsDefault(pop)
     #pragma SOMAsDefault(on)
class Principal;
     #pragma SOMAsDefault(pop)
     #pragma SOMAsDefault(on)
class ImplementationDef;
     #pragma SOMAsDefault(pop)
     #pragma SOMAsDefault(on)
class InterfaceDef;
     #pragma SOMAsDefault(pop)
     #pragma SOMAsDefault(on)
class Context;
     #pragma SOMAsDefault(pop)
#include <boa.hh>

#define SOMD_WAIT     1
#define SOMD_NO_WAIT  0
#define SOMD_IMPL_NOT_INITIALIZED	   0
#define SOMD_IMPL_NOT_ACTIVE		   1
#define SOMD_IMPL_ACTIVE		   2

#include <somcls.hh>
#pragma SOMNonDTS(on)

#pragma SOMAsDefault(on)
class SOMOA : public BOA {

	#pragma SOMClassName(*, "SOMOA")
	#pragma SOMNoMangling(*)
	#pragma SOMNonDTS(*)

     #pragma SOMClassVersion (SOMOA, 2, 1)
     #pragma SOMCallstyle (idl)
     #pragma SOMAsDefault(off)
     #pragma SOMAsDefault(pop)
  public :

     // This method receives a single request message, executes it, and
     // sends the result to the calling client.  If waitFlag is SOMD_WAIT,
     // the call will block if there is no message pending.  If waitFlag
     // is SOMD_NO_WAIT, the call will immediately return "SOMDERROR_NoMessages"
     // if there is no message pending.
     //
     // ("SOMDERROR_NoMessage" is only returned as a status code, not as an
     // exception structure.)
     virtual ORBStatus execute_next_request(Flags waitFlag);

     // Repeatedly calls execute_next_request.	If waitFlag is SOMD_WAIT,
     // the call will continue to wait for messages when there is no message
     // pending.  If waitFlag is SOMD_NO_WAIT, the call will process any
     // messages that are present, and return "SOMD_NoMessages" as soon as there
     // are no more messages pending.
     //
     // ("SOMDERROR_NoMessage" is only returned as a status code, not as an
     // exception structure.)
     virtual ORBStatus execute_request_loop(Flags waitFlag);

     // This method changes the ReferenceData associated with the object
     // identified by "objref".  The ReferenceData previously stored in the
     // SOMOA's reference data table is replaced with the value of "id".
     // The new id value cannot be larger than the maximum size of the
     // original ReferenceData (usually specified as 1024 bytes).
     virtual void change_id(SOMDObject* objref, ReferenceData* id);

     // This method is a variant of the "create" method.  Like "create", it
     // creates an object reference for an object (with the specified interface)
     // and associates the supplied ReferenceData with the object reference.
     // The ReferenceData can later be retrieved using the "get_id" method.
     // Unlike "create", this method creates a "contant" reference whose id
     // value cannot be changed.  (See "change_id" below.)  This is because
     // the id is part of the object reference state, versus stored in the
     // SOMOA reference data table.
     //
     // This method would be used whenever the application prefers not to
     // maintain an object's ReferenceData in the SOMOA reference data table.
     virtual SOMDObject* create_constant(ReferenceData* id, InterfaceDef* intf,
					 ImplementationDef* impl);

     // This methods creates a simple DSOM reference (SOMDObject) for a local
     // SOM object.  The reference is "special" in that there is no explicit
     // ReferenceData associated with the object.  Also, the reference is
     // only valid while the SOM object exists.
     //
     // The SOMObject can be retrieved via the get_SOM_object method.
     // The SOMDObject::is_SOM_ref method can be used to tell if the
     // reference was created using create_SOM_ref or not.
     virtual SOMDObject* create_SOM_ref(SOMObject* somobj, ImplementationDef* impl);

     // This method returns the SOM object associated with a SOMDObject
     // reference created by the create_SOM_ref method.
     virtual SOMObject* get_SOM_object(SOMDObject* somref);

     // Indicates there was an error when activating this implementation.
     // Called by a server program.  ORBStatus code is returned to the client
     // in an exception.
     virtual void activate_impl_failed(ImplementationDef* impl,
				       ORBStatus rc);

     // Wakes up a server waiting for a request message.
     virtual void interrupt_server();
     SOMOA();
     virtual ~SOMOA();
     virtual SOMDObject* create(ReferenceData* id, InterfaceDef* intf,
				ImplementationDef* impl);
     virtual void dispose(SOMDObject* obj);
     virtual void change_implementation(SOMDObject* obj, ImplementationDef* impl);
     virtual ReferenceData get_id(SOMDObject* obj);
     virtual Principal* get_principal(SOMDObject* obj, Environment* req_ev);
     virtual void set_exception(exception_type major, string userid,
				void* param);
     virtual void impl_is_ready(ImplementationDef* impl);
     virtual void deactivate_impl(ImplementationDef* impl);
     virtual void obj_is_ready(SOMDObject* obj, ImplementationDef* impl);
     virtual void deactivate_obj(SOMDObject* obj);
     #pragma SOMReleaseOrder ( \
			      "execute_next_request", \
			      "execute_request_loop", \
			      "create_constant", \
			      "change_id", \
			      "create_SOM_ref", \
			      "get_SOM_object", \
			      "activate_impl_failed", \
			      "interrupt_server")
};
#pragma SOMAsDefault(pop)

SOMEXTERN SOMOA * SOMDLINK SOMD_SOMOAObject;

     #pragma SOMNonDTS(pop)
/* End SOMOA */
#endif /* _DTS_HH_INCLUDED_somoa */
