/*******************************************************************************
* FILE NAME: Dumper.cpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class:                                         *
*     Dumper- MIDI Stream Dump Window                                          *
* ---------------------------------------------------------------------------- *
* Warning: This file was generated by the VisualAge C++ Visual Builder.        *
* Modifications to this source file will be lost when the part is regenerated. *
*******************************************************************************/
#ifndef _IFRAME_
#include <iframe.hpp>
#endif

#ifndef _IMCELCV_
#include <imcelcv.hpp>
#endif

#ifndef _IMLE_
#include <imle.hpp>
#endif

#ifndef _IPOINT_
#include <ipoint.hpp>
#endif

#ifndef _ISETCV_
#include <isetcv.hpp>
#endif

#ifndef _IPUSHBUT_
#include <ipushbut.hpp>
#endif

#ifndef _IMIDIDMP_
#include "IMidiDmp.hpp"
#endif

#ifndef _IPROFILE_
#include <iprofile.hpp>
#endif

#ifndef _INOTIFEV_
#include <inotifev.hpp>
#endif

#ifndef _IOBSERVR_
#include <iobservr.hpp>
#endif

#ifndef _ISTDNTFY_
#include <istdntfy.hpp>
#endif

#ifndef _DUMPER_
#include "Dumper.hpp"
#endif

#ifndef _IVBDEFS_
#include <ivbdefs.h>
#endif

#ifndef _ITRACE_
#include <itrace.hpp>
#endif


//*****************************************************************************
// Class definition for DumperConn0
//*****************************************************************************
class DumperConn0 : public IObserver, public IStandardNotifier {
public:
   virtual  ~DumperConn0(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IPushButton * aSource, IMultiLineEdit * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IPushButton::buttonClickId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : PushButton1(buttonClickEvent) to MultiLineEdit1(removeAll))");
         try {target->removeAll();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IPushButton * source;
   IMultiLineEdit * target;


};   //DumperConn0


//*****************************************************************************
// Class definition for DumperConn1
//*****************************************************************************
class DumperConn1 : public IObserver, public IStandardNotifier {
public:
   virtual  ~DumperConn1(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IPushButton * aSource, IMidiDumper * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };
   DumperConn1 & setIMultiLineEdit(IMultiLineEdit * aSelf) {iIMultiLineEdit = aSelf; return *this;};

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IPushButton::buttonClickId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : PushButton2(buttonClickEvent) to MidiDumper(startDumper))");
         try {target->startDumper(iIMultiLineEdit);}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IPushButton * source;
   IMidiDumper * target;
   IMultiLineEdit * iIMultiLineEdit;


};   //DumperConn1


//*****************************************************************************
// Class definition for DumperConn3
//*****************************************************************************
class DumperConn3 : public IObserver, public IStandardNotifier {
public:
   virtual  ~DumperConn3(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IPushButton * aSource, IMidiDumper * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IPushButton::buttonClickId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : PushButton3(buttonClickEvent) to MidiDumper(stopDumper))");
         try {target->stopDumper();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IPushButton * source;
   IMidiDumper * target;


};   //DumperConn3


//*****************************************************************************
// Class definition for DumperConn6
//*****************************************************************************
class DumperConn6 : public IObserver, public IStandardNotifier {
public:
   virtual  ~DumperConn6(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(Dumper * aSource, IFrameWindow * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == Dumper::readyId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : (ready) to FrameWindow(show))");
         try {target->show();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   Dumper * source;
   IFrameWindow * target;


};   //DumperConn6


//*****************************************************************************
// Class definition for DumperConn7
//*****************************************************************************
class DumperConn7 : public IObserver, public IStandardNotifier {
public:
   virtual  ~DumperConn7(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IFrameWindow * aSource, IMidiDumper * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IFrameWindow::closeId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : FrameWindow(closeEvent) to MidiDumper(stopDumper))");
         try {target->stopDumper();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IFrameWindow * source;
   IMidiDumper * target;


};   //DumperConn7


//*****************************************************************************
// Class definition for DumperConn16
//*****************************************************************************
class DumperConn16 : public IObserver, public IStandardNotifier {
public:
   virtual  ~DumperConn16(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(Dumper * aSource, Dumper * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };
   DumperConn16 & setProfile(IProfile * aSelf) {iProfile = aSelf; return *this;};

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == Dumper::readyId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : (ready) to (restoreFromProfile))");
         try {target->restoreFromProfile(iProfile);}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   Dumper * source;
   Dumper * target;
   IProfile * iProfile;


};   //DumperConn16


//*****************************************************************************
// Class definition for DumperConn8
//*****************************************************************************
class DumperConn8 : public IObserver, public IStandardNotifier {
public:
   virtual  ~DumperConn8(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IFrameWindow * aSource, Dumper * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };
   DumperConn8 & setProfile(IProfile * aSelf) {iProfile = aSelf; return *this;};

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IFrameWindow::closeId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : FrameWindow(closeEvent) to (saveToProfile))");
         try {target->saveToProfile(iProfile);}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IFrameWindow * source;
   Dumper * target;
   IProfile * iProfile;


};   //DumperConn8


#pragma export (Dumper::readyId)
const INotificationId Dumper::readyId = "Dumper::readyId";

//------------------------------------------------------------------------------
// Dumper :: defaultFramingSpec
//------------------------------------------------------------------------------
#pragma export (Dumper::defaultFramingSpec())
const IRectangle Dumper::defaultFramingSpec()
{
   return(IRectangle(IPoint(130, IWindow::desktopWindow()->size().height() - 28 - 322),ISize(323, 322)));
}


//------------------------------------------------------------------------------
// Dumper :: defaultTitle
//------------------------------------------------------------------------------
#pragma export (Dumper::defaultTitle())
IString Dumper::defaultTitle()
{
   return("MIDI Stream Dumper");
}


//------------------------------------------------------------------------------
// Dumper :: Dumper
//------------------------------------------------------------------------------
#pragma export (Dumper::Dumper(unsigned long, IWindow*, IWindow*, const IRectangle&, const IFrameWindow::Style&, const char*))
Dumper::Dumper(
      unsigned long id, 
      IWindow* parent, 
      IWindow* owner, 
      const IRectangle& rect, 
      const IFrameWindow::Style& style, 
      const char* title)
   : IFrameWindow(id, parent, owner, rect, style, title)
{
   iMultiCellCanvas1 = new IMultiCellCanvas(
      IC_FRAME_CLIENT_ID, 
      this, 
      this, 
      IRectangle());
   iMultiLineEdit1 = new IMultiLineEdit(
      id+WNDOFFSET_Dumper_MultiLineEdit1, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iSetCanvas1 = new ISetCanvas(
      id+WNDOFFSET_Dumper_SetCanvas1, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iPushButton1 = new IPushButton(
      id+WNDOFFSET_Dumper_PushButton1, 
      iSetCanvas1, 
      iSetCanvas1, 
      IRectangle());
   iPushButton2 = new IPushButton(
      id+WNDOFFSET_Dumper_PushButton2, 
      iSetCanvas1, 
      iSetCanvas1, 
      IRectangle());
   iPushButton3 = new IPushButton(
      id+WNDOFFSET_Dumper_PushButton3, 
      iSetCanvas1, 
      iSetCanvas1, 
      IRectangle());
   iMidiDumper = new IMidiDumper();
   iProfile = new IProfile("VisMIDI.ini");

   conn0 = new DumperConn0();
   conn1 = new DumperConn1();
   conn3 = new DumperConn3();
   conn6 = new DumperConn6();
   conn7 = new DumperConn7();
   conn16 = new DumperConn16();
   conn8 = new DumperConn8();

   iMultiCellCanvas1->addToCell(iMultiLineEdit1, 1, 1, 1, 1);
   iMultiCellCanvas1->addToCell(iSetCanvas1, 1, 2, 1, 1);
   iMultiCellCanvas1->setColumnWidth(1, IMultiCellCanvas::defaultCell().width(), true);
   iMultiCellCanvas1->setRowHeight(1, IMultiCellCanvas::defaultCell().height(), true);
   iMultiCellCanvas1->setRowHeight(2, IMultiCellCanvas::defaultCell().height(), false);
   iMultiLineEdit1->setMinimumSize(ISize(293, 225));
   iPushButton1->setText("Clear");
   iPushButton1->setMinimumSize(ISize(68, 34));
   iPushButton2->setText("Start");
   iPushButton2->setMinimumSize(ISize(66, 34));
   iPushButton3->setText("Stop");
   iPushButton3->setMinimumSize(ISize(63, 34));
   this->setFocus();
   this->setClient(iMultiCellCanvas1);
   iProfile->setDefaultApplicationName("Dumper");
}     //end constructor


//------------------------------------------------------------------------------
// Dumper :: ~Dumper
//------------------------------------------------------------------------------
#pragma export (Dumper::~Dumper())
Dumper::~Dumper()
{
   conn0->stopHandlingNotificationsFor(*iPushButton1);
   conn1->stopHandlingNotificationsFor(*iPushButton2);
   conn3->stopHandlingNotificationsFor(*iPushButton3);
   conn6->stopHandlingNotificationsFor(*this);
   conn7->stopHandlingNotificationsFor(*this);
   conn16->stopHandlingNotificationsFor(*this);
   conn8->stopHandlingNotificationsFor(*this);

   delete conn0;
   delete conn1;
   delete conn3;
   delete conn6;
   delete conn7;
   delete conn16;
   delete conn8;


   delete iMultiCellCanvas1;
   delete iMultiLineEdit1;
   delete iSetCanvas1;
   delete iPushButton1;
   delete iPushButton2;
   delete iPushButton3;
   delete iMidiDumper;
   delete iProfile;
}

//------------------------------------------------------------------------------
// Dumper :: initializePart
//------------------------------------------------------------------------------
#pragma export (Dumper::initializePart())
Dumper & Dumper::initializePart()
{
   makeConnections();
   notifyObservers(INotificationEvent(readyId, *this));
   return *this;
}


//------------------------------------------------------------------------------
// Dumper :: makeConnections
//------------------------------------------------------------------------------
#pragma export (Dumper::makeConnections())
Boolean Dumper::makeConnections()
{
   this->enableNotification();
   iMultiCellCanvas1->enableNotification();
   iMultiLineEdit1->enableNotification();
   iSetCanvas1->enableNotification();
   iPushButton1->enableNotification();
   iPushButton2->enableNotification();
   iPushButton3->enableNotification();
   iMidiDumper->enableNotification();

   unsigned long id = this->id();
   conn0->initialize(iPushButton1, iMultiLineEdit1);
   conn0->handleNotificationsFor(*iPushButton1);
   conn1->initialize(iPushButton2, iMidiDumper);
   conn1->handleNotificationsFor(*iPushButton2);
   conn1->setIMultiLineEdit(iMultiLineEdit1);
   conn3->initialize(iPushButton3, iMidiDumper);
   conn3->handleNotificationsFor(*iPushButton3);
   conn6->initialize(this, this);
   conn6->handleNotificationsFor(*this);
   conn7->initialize(this, iMidiDumper);
   conn7->handleNotificationsFor(*this);
   conn16->initialize(this, this);
   conn16->handleNotificationsFor(*this);
   conn16->setProfile(iProfile);
   conn8->initialize(this, this);
   conn8->handleNotificationsFor(*this);
   conn8->setProfile(iProfile);

   return true;
}



#include "Dumper.cpv"
