/*******************************************************************************
* FILE NAME: Info.cpp                                                          *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class:                                         *
*     Info- Product Info Window                                                *
* ---------------------------------------------------------------------------- *
* Warning: This file was generated by the VisualAge C++ Visual Builder.        *
* Modifications to this source file will be lost when the part is regenerated. *
*******************************************************************************/
#ifndef _IFRAME_
#include <iframe.hpp>
#endif

#ifndef _IMCELCV_
#include <imcelcv.hpp>
#endif

#ifndef _ISTATTXT_
#include <istattxt.hpp>
#endif

#ifndef _IFONT_
#include <ifont.hpp>
#endif

#ifndef _IPOINT_
#include <ipoint.hpp>
#endif

#ifndef _ISETCV_
#include <isetcv.hpp>
#endif

#ifndef _IPUSHBUT_
#include <ipushbut.hpp>
#endif

#ifndef _IRMIDI_
#include "IRTMidi.hpp"
#endif

#ifndef _INOTIFEV_
#include <inotifev.hpp>
#endif

#ifndef _IOBSERVR_
#include <iobservr.hpp>
#endif

#ifndef _ISTDNTFY_
#include <istdntfy.hpp>
#endif

#ifndef _INFO_
#include "Info.hpp"
#endif

#ifndef _IVBDEFS_
#include <ivbdefs.h>
#endif

#ifndef _ITRACE_
#include <itrace.hpp>
#endif


//*****************************************************************************
// Class definition for InfoConn1
//*****************************************************************************
class InfoConn1 : public IObserver, public IStandardNotifier {
public:
   virtual  ~InfoConn1(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IPushButton * aSource, IFrameWindow * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IPushButton::buttonClickId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : PushButton1(buttonClickEvent) to FrameWindow(close))");
         try {target->close();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IPushButton * source;
   IFrameWindow * target;


};   //InfoConn1


//*****************************************************************************
// Class definition for InfoConn11
//*****************************************************************************
class InfoConn11 : public IObserver {
public:
   virtual  ~InfoConn11(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IVBVariablePartPointer<IRTMidi *> * aSource, IStaticText * aTarget)
      {source = aSource; target = aTarget; aligning = false; };
   void setSource()
      {      };
   void setTarget()
      {
      if (!source->target()) return;
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : RTMidi(version) to StaticText3(text))");
         ITRACE_DEVELOP(" setting target from source ");
         aligning = true;
         try {target->setText(source->target()->version());}
         catch (IException& exc) {};
         aligning = false;
         }
      };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (!source->target()) return(*this);
      if (anEvent.notificationId() == VBINITIALIZEID) setTarget();
      if ((anEvent.notificationId() == IStaticText::textId) && (target == &anEvent.notifier()))
         setSource();  /* set source to target value */
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IVBVariablePartPointer<IRTMidi *> * source;
   IStaticText * target;
   Boolean aligning;


};   //InfoConn11


//*****************************************************************************
// Class definition for InfoConn2
//*****************************************************************************
class InfoConn2 : public IObserver, public IStandardNotifier {
public:
   virtual  ~InfoConn2(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(Info * aSource, IFrameWindow * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == Info::readyId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : (ready) to FrameWindow(showModally))");
         try {target->showModally();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   Info * source;
   IFrameWindow * target;


};   //InfoConn2


#pragma export (Info::readyId)
const INotificationId Info::readyId = "Info::readyId";

#pragma export (Info::RTMidi)
const INotificationId Info::RTMidi = "Info::RTMidi";

//------------------------------------------------------------------------------
// Info :: defaultFramingSpec
//------------------------------------------------------------------------------
#pragma export (Info::defaultFramingSpec())
const IRectangle Info::defaultFramingSpec()
{
   return(IRectangle(IPoint(30, IWindow::desktopWindow()->size().height() - 30 - 418),ISize(409, 418)));
}


//------------------------------------------------------------------------------
// Info :: defaultTitle
//------------------------------------------------------------------------------
#pragma export (Info::defaultTitle())
IString Info::defaultTitle()
{
   return("Real Time MIDI Sample Program");
}


//------------------------------------------------------------------------------
// Info :: Info
//------------------------------------------------------------------------------
#pragma export (Info::Info(unsigned long, IWindow*, IWindow*, const IRectangle&, const IFrameWindow::Style&, const char*))
Info::Info(
      unsigned long id, 
      IWindow* parent, 
      IWindow* owner, 
      const IRectangle& rect, 
      const IFrameWindow::Style& style, 
      const char* title)
   : IFrameWindow(id, parent, owner, rect, style, title)
{
   iMultiCellCanvas1 = new IMultiCellCanvas(
      IC_FRAME_CLIENT_ID, 
      this, 
      this, 
      IRectangle(), 
      IMultiCellCanvas::defaultStyle() & ~IMultiCellCanvas::gridLines);
   iStaticText1 = new IStaticText(
      id+WNDOFFSET_Info_StaticText1, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iStaticText4 = new IStaticText(
      id+WNDOFFSET_Info_StaticText4, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iStaticText5 = new IStaticText(
      id+WNDOFFSET_Info_StaticText5, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iStaticText6 = new IStaticText(
      id+WNDOFFSET_Info_StaticText6, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iStaticText2 = new IStaticText(
      id+WNDOFFSET_Info_StaticText2, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iStaticText3 = new IStaticText(
      id+WNDOFFSET_Info_StaticText3, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iSetCanvas1 = new ISetCanvas(
      id+WNDOFFSET_Info_SetCanvas1, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iPushButton1 = new IPushButton(
      id+WNDOFFSET_Info_PushButton1, 
      iSetCanvas1, 
      iSetCanvas1, 
      IRectangle());
   iRTMidi = new IVBVariablePartPointer<IRTMidi *>();

   conn1 = new InfoConn1();
   conn11 = new InfoConn11();
   conn2 = new InfoConn2();

   iMultiCellCanvas1->addToCell(iStaticText1, 2, 2, 1, 1);
   iMultiCellCanvas1->addToCell(iStaticText4, 2, 4, 1, 1);
   iMultiCellCanvas1->addToCell(iStaticText5, 2, 6, 1, 1);
   iMultiCellCanvas1->addToCell(iStaticText6, 2, 8, 1, 1);
   iMultiCellCanvas1->addToCell(iStaticText2, 2, 10, 1, 1);
   iMultiCellCanvas1->addToCell(iStaticText3, 2, 11, 1, 1);
   iMultiCellCanvas1->addToCell(iSetCanvas1, 2, 13, 1, 1);
   iMultiCellCanvas1->setColumnWidth(3, IMultiCellCanvas::defaultCell().width(), false);
   iMultiCellCanvas1->setRowHeight(13, IMultiCellCanvas::defaultCell().height(), false);
   iStaticText1->setAlignment(IStaticText::topCenter);
   iStaticText1->setFont(IFont("System Proportional", 14).setBold(true).setItalic(false).setUnderscore(false).setStrikeout(false).setOutline(false));
   iStaticText1->setText("VisMIDI");
   iStaticText1->setMinimumSize(ISize(167, 38));
   iStaticText4->setAlignment(IStaticText::topLeftWrapped);
   iStaticText4->setText("A Real Time MIDI Subsystem sample program. Build using VisualAge C++ for OS/2 Version 3.0");
   iStaticText4->setMinimumSize(ISize(385, 49));
   iStaticText5->setAlignment(IStaticText::topLeftWrapped);
   iStaticText5->setText("Author: Joel Troster (jtroster@ca.ibm.com) with help from Timur Tabi.");
   iStaticText5->setMinimumSize(ISize(390, 46));
   iStaticText6->setAlignment(IStaticText::topLeftWrapped);
   iStaticText6->setText("(C) Copyright IBM Corporation, 1997, all rights reserved.");
   iStaticText6->setMinimumSize(ISize(361, 52));
   iStaticText2->setText("RTMIDI Version Information:");
   iStaticText2->setMinimumSize(ISize(361, 25));
   iStaticText3->setText("StaticText3");
   iStaticText3->setMinimumSize(ISize(361, 28));
   iSetCanvas1->setMinimumSize(ISize(361, 54));
   iPushButton1->setText("Ok");
   this->setFocus();
   this->setClient(iMultiCellCanvas1);
}     //end constructor


//------------------------------------------------------------------------------
// Info :: ~Info
//------------------------------------------------------------------------------
#pragma export (Info::~Info())
Info::~Info()
{
   this->stopHandlingNotificationsFor(*iRTMidi);
   conn1->stopHandlingNotificationsFor(*iPushButton1);
   conn11->stopHandlingNotificationsFor(*iRTMidi);
   conn11->stopHandlingNotificationsFor(*iStaticText3);
   conn2->stopHandlingNotificationsFor(*this);

   delete conn1;
   delete conn11;
   delete conn2;


   delete iMultiCellCanvas1;
   delete iStaticText1;
   delete iStaticText4;
   delete iStaticText5;
   delete iStaticText6;
   delete iStaticText2;
   delete iStaticText3;
   delete iSetCanvas1;
   delete iPushButton1;
   delete iRTMidi;
}

//------------------------------------------------------------------------------
// Info :: initializePart
//------------------------------------------------------------------------------
#pragma export (Info::initializePart())
Info & Info::initializePart()
{
   this->handleNotificationsFor(*iRTMidi);
   makeConnections();
   notifyObservers(INotificationEvent(readyId, *this));
   return *this;
}


//------------------------------------------------------------------------------
// Info :: makeConnections
//------------------------------------------------------------------------------
#pragma export (Info::makeConnections())
Boolean Info::makeConnections()
{
   this->enableNotification();
   iMultiCellCanvas1->enableNotification();
   iStaticText1->enableNotification();
   iStaticText4->enableNotification();
   iStaticText5->enableNotification();
   iStaticText6->enableNotification();
   iStaticText2->enableNotification();
   iStaticText3->enableNotification();
   iSetCanvas1->enableNotification();
   iPushButton1->enableNotification();
   iRTMidi->enableNotification();

   unsigned long id = this->id();
   conn1->initialize(iPushButton1, this);
   conn1->handleNotificationsFor(*iPushButton1);
   conn11->initialize(iRTMidi, iStaticText3);
   conn11->handleNotificationsFor(*iRTMidi);
   conn11->handleNotificationsFor(*iStaticText3);
   conn2->initialize(this, this);
   conn2->handleNotificationsFor(*this);

   conn11->setTarget();
   return true;
}


//------------------------------------------------------------------------------
// Info :: dispatchNotificationEvent
//------------------------------------------------------------------------------
#pragma export (Info::dispatchNotificationEvent(const INotificationEvent &))
IObserver & Info::dispatchNotificationEvent(const INotificationEvent & anEvent)
{
   if ((anEvent.notificationId() == IVBVariablePartPointer<IRTMidi *>::targetId) && (iRTMidi == &anEvent.notifier()))
       notifyObservers(INotificationEvent(RTMidi, *this, anEvent.hasNotifierAttrChanged(), IEventData((void *)anEvent.eventData()), anEvent.observerData()));
   return *this;
}



