/*******************************************************************************
* FILE NAME: Key.cpp                                                           *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class:                                         *
*     Key- MIDI Keyboard Key                                                   *
* ---------------------------------------------------------------------------- *
* Warning: This file was generated by the VisualAge C++ Visual Builder.        *
* Modifications to this source file will be lost when the part is regenerated. *
*******************************************************************************/
#ifndef _IPUSHBUT_
#include <ipushbut.hpp>
#endif

#ifndef _ICOLOR_
#include <icolor.hpp>
#endif

#ifndef _IPOINT_
#include <ipoint.hpp>
#endif

#ifndef _INOTIFEV_
#include <inotifev.hpp>
#endif

#ifndef _IOBSERVR_
#include <iobservr.hpp>
#endif

#ifndef _ISTDNTFY_
#include <istdntfy.hpp>
#endif

#ifndef _KEY_
#include "Key.hpp"
#endif

#ifndef _IVBDEFS_
#include <ivbdefs.h>
#endif

#ifndef _ITRACE_
#include <itrace.hpp>
#endif


#pragma export (Key::readyId)
const INotificationId Key::readyId = "Key::readyId";

//------------------------------------------------------------------------------
// Key :: defaultFramingSpec
//------------------------------------------------------------------------------
#pragma export (Key::defaultFramingSpec())
const IRectangle Key::defaultFramingSpec()
{
   return(IRectangle(IPoint(30,313),ISize(25, 150)));
}


//------------------------------------------------------------------------------
// Key :: defaultStyle
//------------------------------------------------------------------------------
#pragma export (Key::defaultStyle())
const IPushButton::Style Key::defaultStyle()
{
   return(IPushButton::defaultStyle() | IButton::noPointerFocus | IWindow::clipSiblings);
}


//------------------------------------------------------------------------------
// Key :: Key
//------------------------------------------------------------------------------
#pragma export (Key::Key(unsigned short, unsigned long, IWindow*, IWindow*, const IRectangle&, const IPushButton::Style&))
Key::Key(
      unsigned short note, 
      unsigned long id, 
      IWindow* parent, 
      IWindow* owner, 
      const IRectangle& rect, 
      const IPushButton::Style& style)
   : IPushButton(id, parent, owner, rect, style)
{

   iKeyKeyMouse = new KeyMouse(this);
   iKeyKeyMouse->handleEventsFor(this);
   this->setBackgroundColor(IColor(IColor::white));
   this->setMinimumSize(ISize(25, 150));
   iNote = note;
}     //end constructor


//------------------------------------------------------------------------------
// Key :: ~Key
//------------------------------------------------------------------------------
#pragma export (Key::~Key())
Key::~Key()
{
   iKeyKeyMouse->stopHandlingEventsFor(this);
   delete iKeyKeyMouse;

}

//------------------------------------------------------------------------------
// Key :: initializePart
//------------------------------------------------------------------------------
#pragma export (Key::initializePart())
Key & Key::initializePart()
{
   makeConnections();
   notifyObservers(INotificationEvent(readyId, *this));
   return *this;
}


//------------------------------------------------------------------------------
// Key :: makeConnections
//------------------------------------------------------------------------------
#pragma export (Key::makeConnections())
Boolean Key::makeConnections()
{
   this->enableNotification();

   unsigned long id = this->id();
   return true;
}



#include "Key.cpv"
