#include <keymouse.hpp>

#ifndef _KEYCANVAS_
#include <keycan.hpp>
#endif


Boolean KeyMouse::mouseClicked( IMouseClickEvent& event )
{
   unsigned int note  = keyWindow->note();
   KeyCanvas * keyCanvas = (KeyCanvas*)keyWindow->parent();
   switch( event.mouseAction() )
   {
    case IMouseClickEvent::down :
      //
      keyCanvas->setNote( note );
      keyCanvas->notifyObservers( INotificationEvent( KeyCanvas::noteOnId, *keyCanvas ));
      break;

    case IMouseClickEvent::up :
      keyCanvas->setNote( note );
      keyCanvas->notifyObservers( INotificationEvent( KeyCanvas::noteOffId, *keyCanvas ));
      break;

//  case IMouseClickEvent::click :
//  case IMouseClickEvent::doubleClick :
//     return true;
//     break;

    default:
       break;
    }
   return false;  // Allow continued processing
}

