/*******************************************************************************
* FILE NAME: Keyboard.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class:                                         *
*     Keyboard- MIDI Keyboard                                                  *
* ---------------------------------------------------------------------------- *
* Warning: This file was generated by the VisualAge C++ Visual Builder.        *
* Modifications to this source file will be lost when the part is regenerated. *
*******************************************************************************/
#ifndef _IFRAME_
#include <iframe.hpp>
#endif

#ifndef _IPOINT_
#include <ipoint.hpp>
#endif

#ifndef _ICANVAS_
#include <icanvas.hpp>
#endif

#ifndef _KEYCANVAS_
#include "KeyCan.hpp"
#endif

#ifndef _IRECT_
#include <irect.hpp>
#endif

#ifndef _ISLIDER_
#include <islider.hpp>
#endif

#ifndef _ISPINNUM_
#include <ispinnum.hpp>
#endif

#ifndef _ISTATTXT_
#include <istattxt.hpp>
#endif

#ifndef _ICOMBOBX_
#include <icombobx.hpp>
#endif

#ifndef _IMIDIKBD_
#include "IMidiKbd.hpp"
#endif

#ifndef _IPROFILE_
#include <iprofile.hpp>
#endif

#ifndef _INOTIFEV_
#include <inotifev.hpp>
#endif

#ifndef _IOBSERVR_
#include <iobservr.hpp>
#endif

#ifndef _ISTDNTFY_
#include <istdntfy.hpp>
#endif

#ifndef _KEYBOARD_
#include "Keyboard.hpp"
#endif

#ifndef _IVBDEFS_
#include <ivbdefs.h>
#endif

#ifndef _ITRACE_
#include <itrace.hpp>
#endif


//*****************************************************************************
// Class definition for KeyboardConn0
//*****************************************************************************
class KeyboardConn0 : public IObserver, public IStandardNotifier {
public:
   virtual  ~KeyboardConn0(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(KeyCanvas * aSource, IMidiKeyboard * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };
   KeyboardConn0 & setNote(KeyCanvas * aSelf) {iNote = aSelf; return *this;};

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == KeyCanvas::noteOnId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : KeyCanvas1(noteOn) to MidiKeyboard(keyDown))");
         try {target->keyDown(iNote->note());}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   KeyCanvas * source;
   IMidiKeyboard * target;
   KeyCanvas * iNote;


};   //KeyboardConn0


//*****************************************************************************
// Class definition for KeyboardConn2
//*****************************************************************************
class KeyboardConn2 : public IObserver, public IStandardNotifier {
public:
   virtual  ~KeyboardConn2(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(KeyCanvas * aSource, IMidiKeyboard * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };
   KeyboardConn2 & setNote(KeyCanvas * aSelf) {iNote = aSelf; return *this;};

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == KeyCanvas::noteOffId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : KeyCanvas1(noteOff) to MidiKeyboard(keyUp))");
         try {target->keyUp(iNote->note());}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   KeyCanvas * source;
   IMidiKeyboard * target;
   KeyCanvas * iNote;


};   //KeyboardConn2


//*****************************************************************************
// Class definition for KeyboardConn6
//*****************************************************************************
class KeyboardConn6 : public IObserver, public IStandardNotifier {
public:
   virtual  ~KeyboardConn6(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(ISlider * aSource, IMidiKeyboard * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == ISlider::armChangeId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : Volume(armTickOffset) to MidiKeyboard(customLogic, \"Set volume based on tick count\"))");
         try {codeSnippet(&anEvent);}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member functions
   //---------------------------------------------------------------------------
   void codeSnippet(const INotificationEvent* event)
      {
      target->setVolume( (source->armTickOffset() * 127) / 10 + 1 );
      };

   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   ISlider * source;
   IMidiKeyboard * target;


};   //KeyboardConn6


//*****************************************************************************
// Class definition for KeyboardConn7
//*****************************************************************************
class KeyboardConn7 : public IObserver {
public:
   virtual  ~KeyboardConn7(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(INumericSpinButton * aSource, IMidiKeyboard * aTarget)
      {source = aSource; target = aTarget; aligning = false; };
   void setSource()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : Channel(value) to MidiKeyboard(channel))");
         ITRACE_DEVELOP(" setting source from target ");
         aligning = true;
         try {source->setValue(target->channel());}
         catch (IException& exc) {};
         aligning = false;
         }
      };
   void setTarget()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : Channel(value) to MidiKeyboard(channel))");
         ITRACE_DEVELOP(" setting target from source ");
         aligning = true;
         try {target->setChannel(source->value());}
         catch (IException& exc) {};
         aligning = false;
         }
      };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VBINITIALIZEID) setTarget();
      if ((anEvent.notificationId() == INumericSpinButton::valueId) && (source == &anEvent.notifier()))
         setTarget();  /* set target to source value */
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   INumericSpinButton * source;
   IMidiKeyboard * target;
   Boolean aligning;


};   //KeyboardConn7


//*****************************************************************************
// Class definition for KeyboardConn18
//*****************************************************************************
class KeyboardConn18 : public IObserver, public IStandardNotifier {
public:
   virtual  ~KeyboardConn18(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(Keyboard * aSource, Keyboard * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };
   KeyboardConn18 & setProfile(IProfile * aSelf) {iProfile = aSelf; return *this;};

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == Keyboard::readyId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : (ready) to (restoreFromProfile))");
         try {target->restoreFromProfile(iProfile);}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   Keyboard * source;
   Keyboard * target;
   IProfile * iProfile;


};   //KeyboardConn18


//*****************************************************************************
// Class definition for KeyboardConn8
//*****************************************************************************
class KeyboardConn8 : public IObserver, public IStandardNotifier {
public:
   virtual  ~KeyboardConn8(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(Keyboard * aSource, IFrameWindow * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == Keyboard::readyId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : (ready) to FrameWindow(show))");
         try {target->show();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   Keyboard * source;
   IFrameWindow * target;


};   //KeyboardConn8


//*****************************************************************************
// Class definition for KeyboardConn9
//*****************************************************************************
class KeyboardConn9 : public IObserver {
public:
   virtual  ~KeyboardConn9(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IComboBox * aSource, IMidiKeyboard * aTarget)
      {source = aSource; target = aTarget; aligning = false; };
   void setSource()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : Patch(selection) to MidiKeyboard(patch))");
         ITRACE_DEVELOP(" setting source from target ");
         aligning = true;
         try {source->select(target->patch());}
         catch (IException& exc) {};
         aligning = false;
         }
      };
   void setTarget()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : Patch(selection) to MidiKeyboard(patch))");
         ITRACE_DEVELOP(" setting target from source ");
         aligning = true;
         try {target->setPatch(source->selection());}
         catch (IException& exc) {};
         aligning = false;
         }
      };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VBINITIALIZEID) setTarget();
      if ((anEvent.notificationId() == IComboBox::selectId) && (source == &anEvent.notifier()))
         setTarget();  /* set target to source value */
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IComboBox * source;
   IMidiKeyboard * target;
   Boolean aligning;


};   //KeyboardConn9


//*****************************************************************************
// Class definition for KeyboardConn10
//*****************************************************************************
class KeyboardConn10 : public IObserver, public IStandardNotifier {
public:
   virtual  ~KeyboardConn10(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IFrameWindow * aSource, Keyboard * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };
   KeyboardConn10 & setProfile(IProfile * aSelf) {iProfile = aSelf; return *this;};

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IFrameWindow::closeId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : FrameWindow(closeEvent) to (saveToProfile))");
         try {target->saveToProfile(iProfile);}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IFrameWindow * source;
   Keyboard * target;
   IProfile * iProfile;


};   //KeyboardConn10


#pragma export (Keyboard::readyId)
const INotificationId Keyboard::readyId = "Keyboard::readyId";

//------------------------------------------------------------------------------
// Keyboard :: defaultFramingSpec
//------------------------------------------------------------------------------
#pragma export (Keyboard::defaultFramingSpec())
const IRectangle Keyboard::defaultFramingSpec()
{
   return(IRectangle(IPoint(19, IWindow::desktopWindow()->size().height() - 98 - 210),ISize(732, 210)));
}


//------------------------------------------------------------------------------
// Keyboard :: defaultStyle
//------------------------------------------------------------------------------
#pragma export (Keyboard::defaultStyle())
const IFrameWindow::Style Keyboard::defaultStyle()
{
   return(IFrameWindow::defaultStyle() & ~IFrameWindow::maximizeButton & ~IFrameWindow::minimizeButton | IFrameWindow::noMoveWithOwner);
}


//------------------------------------------------------------------------------
// Keyboard :: defaultTitle
//------------------------------------------------------------------------------
#pragma export (Keyboard::defaultTitle())
IString Keyboard::defaultTitle()
{
   return("MIDI Keyboard");
}


//------------------------------------------------------------------------------
// Keyboard :: Keyboard
//------------------------------------------------------------------------------
#pragma export (Keyboard::Keyboard(unsigned long, IWindow*, IWindow*, const IRectangle&, const IFrameWindow::Style&, const char*))
Keyboard::Keyboard(
      unsigned long id, 
      IWindow* parent, 
      IWindow* owner, 
      const IRectangle& rect, 
      const IFrameWindow::Style& style, 
      const char* title)
   : IFrameWindow(id, parent, owner, rect, style, title)
{
   iCanvas1 = new ICanvas(
      IC_FRAME_CLIENT_ID, 
      this, 
      this, 
      IRectangle());
   iKeyCanvas1 = new KeyCanvas(
      id+WNDOFFSET_Keyboard_KeyCanvas1, 
      iCanvas1, 
      iCanvas1, 
      IRectangle(IPoint(0,0),ISize(725, 150)));
   iVolume = new ISlider(
      id+WNDOFFSET_Keyboard_Volume, 
      iCanvas1, 
      iCanvas1, 
      IRectangle(IPoint(100,150),ISize(100, 30)), 
      10, 
      0, 
      ISlider::defaultStyle() & ~ISlider::buttonsLeft & ~ISlider::buttonsRight | IProgressIndicator::horizontal);
   iChannel = new INumericSpinButton(
      id+WNDOFFSET_Keyboard_Channel, 
      iCanvas1, 
      iCanvas1, 
      IRectangle(IPoint(303,150),ISize(45, 29)));
   iStaticText1 = new IStaticText(
      id+WNDOFFSET_Keyboard_StaticText1, 
      iCanvas1, 
      iCanvas1, 
      IRectangle(IPoint(30,150),ISize(66, 25)));
   iStaticText2 = new IStaticText(
      id+WNDOFFSET_Keyboard_StaticText2, 
      iCanvas1, 
      iCanvas1, 
      IRectangle(IPoint(232,150),ISize(71, 25)));
   iStaticText3 = new IStaticText(
      id+WNDOFFSET_Keyboard_StaticText3, 
      iCanvas1, 
      iCanvas1, 
      IRectangle(IPoint(378,150),ISize(52, 25)));
   iPatch = new IComboBox(
      id+WNDOFFSET_Keyboard_Patch, 
      iCanvas1, 
      iCanvas1, 
      IRectangle(IPoint(429,4),ISize(291, 176)), 
      (IComboBox::defaultStyle()) & ~IBaseComboBox::simpleType | IBaseComboBox::readOnlyDropDownType);
   iMidiKeyboard = new IMidiKeyboard();
   iProfile = new IProfile("VisMIDI.INI");

   conn0 = new KeyboardConn0();
   conn2 = new KeyboardConn2();
   conn6 = new KeyboardConn6();
   conn7 = new KeyboardConn7();
   conn18 = new KeyboardConn18();
   conn8 = new KeyboardConn8();
   conn9 = new KeyboardConn9();
   conn10 = new KeyboardConn10();

   iKeyCanvas1->setMinimumSize(ISize(725, 150));
   iVolume->setHomePosition(IProgressIndicator::homeBottomLeft);
   iVolume->moveArmToTick(8);
   iChannel->setLimit(16);
   iChannel->setRange(IRange(1, 16));
   iChannel->setValue(1);
   iStaticText1->setText("Volume");
   iStaticText2->setText("Channel");
   iStaticText3->setText("Patch");
   iPatch->addAsLast("Grand Piano");
   iPatch->addAsLast("Bright Piano");
   iPatch->addAsLast("Elec. Grand");
   iPatch->addAsLast("Honky Tonk");
   iPatch->addAsLast("Elec. Piano 1");
   iPatch->addAsLast("Elec. Piano 2");
   iPatch->addAsLast("Harpsichord");
   iPatch->addAsLast("Clavinet");
   iPatch->addAsLast("Celesta");
   iPatch->addAsLast("Glockenspiel");
   iPatch->addAsLast("Music Box");
   iPatch->addAsLast("Vibraphone");
   iPatch->addAsLast("Marimba");
   iPatch->addAsLast("Xylophone");
   iPatch->addAsLast("Tubular Bells");
   iPatch->addAsLast("Dulcimer");
   iPatch->addAsLast("Drawbar Organ");
   iPatch->addAsLast("Perc. Organ");
   iPatch->addAsLast("Rock Organ");
   iPatch->addAsLast("Pipe Organ");
   iPatch->addAsLast("Reed Organ");
   iPatch->addAsLast("Accordian");
   iPatch->addAsLast("Harmonica");
   iPatch->addAsLast("Tango Accord.");
   iPatch->addAsLast("Nylon Guitar");
   iPatch->addAsLast("Steel Guitar");
   iPatch->addAsLast("Jazz Guitar");
   iPatch->addAsLast("Clean Guitar");
   iPatch->addAsLast("Muted Guitar");
   iPatch->addAsLast("Overdrive Gtr");
   iPatch->addAsLast("Distorted Gtr");
   iPatch->addAsLast("Harmonics Gtr");
   iPatch->addAsLast("Acous. Bass");
   iPatch->addAsLast("Fingered Bass");
   iPatch->addAsLast("Picked Bass");
   iPatch->addAsLast("Fretless Bass");
   iPatch->addAsLast("Slap 1 Bass");
   iPatch->addAsLast("Slap 2 Bass");
   iPatch->addAsLast("Synth Bass 1");
   iPatch->addAsLast("Synth Bass 2");
   iPatch->addAsLast("Violin");
   iPatch->addAsLast("Viola");
   iPatch->addAsLast("Cello");
   iPatch->addAsLast("Contra Bass");
   iPatch->addAsLast("Tremolo Strs");
   iPatch->addAsLast("Pizzicato Str");
   iPatch->addAsLast("Orch. Harp");
   iPatch->addAsLast("Timpani");
   iPatch->addAsLast("Strings");
   iPatch->addAsLast("Slow Strings");
   iPatch->addAsLast("Syn. 1 String");
   iPatch->addAsLast("Syn. 2 String");
   iPatch->addAsLast("Choir Aahs");
   iPatch->addAsLast("Choir Oohs");
   iPatch->addAsLast("Synth Voice");
   iPatch->addAsLast("Orchestra Hit");
   iPatch->addAsLast("Trumpet");
   iPatch->addAsLast("Trombone");
   iPatch->addAsLast("Tuba");
   iPatch->addAsLast("Muted Trumpet");
   iPatch->addAsLast("French Horn");
   iPatch->addAsLast("Brass 1");
   iPatch->addAsLast("Syn. Brass 1");
   iPatch->addAsLast("Syn. Brass 2");
   iPatch->addAsLast("Soprano Sax");
   iPatch->addAsLast("Alto Sax");
   iPatch->addAsLast("Tenor Sax");
   iPatch->addAsLast("Baritone Sax");
   iPatch->addAsLast("Oboe");
   iPatch->addAsLast("English Horn");
   iPatch->addAsLast("Bassoon");
   iPatch->addAsLast("Clarinet");
   iPatch->addAsLast("Piccolo");
   iPatch->addAsLast("Flute");
   iPatch->addAsLast("Recorder");
   iPatch->addAsLast("Pan Flute");
   iPatch->addAsLast("Bottle Blow");
   iPatch->addAsLast("Shakuhachi");
   iPatch->addAsLast("Whistle");
   iPatch->addAsLast("Ocarina");
   iPatch->addAsLast("Square Wave");
   iPatch->addAsLast("Saw Wave");
   iPatch->addAsLast("Syn. Calliope");
   iPatch->addAsLast("Chiffer Lead");
   iPatch->addAsLast("Charang");
   iPatch->addAsLast("Solo Voice");
   iPatch->addAsLast("Saw 5th's");
   iPatch->addAsLast("Bass + Lead");
   iPatch->addAsLast("New Age");
   iPatch->addAsLast("Warm Pad");
   iPatch->addAsLast("Polysynth");
   iPatch->addAsLast("Space Voice");
   iPatch->addAsLast("Bowed Glass");
   iPatch->addAsLast("Metal Pad");
   iPatch->addAsLast("Halo Pad");
   iPatch->addAsLast("Sweep Pad");
   iPatch->addAsLast("Ice Rain");
   iPatch->addAsLast("Soundtrack");
   iPatch->addAsLast("Crystal");
   iPatch->addAsLast("Atmosphere");
   iPatch->addAsLast("Brightness");
   iPatch->addAsLast("Goblin");
   iPatch->addAsLast("Echo Drops");
   iPatch->addAsLast("Star Theme");
   iPatch->addAsLast("Sitar");
   iPatch->addAsLast("Banjo");
   iPatch->addAsLast("Shamisen");
   iPatch->addAsLast("Koto");
   iPatch->addAsLast("Kalimba");
   iPatch->addAsLast("Bag Pipes");
   iPatch->addAsLast("Fiddle");
   iPatch->addAsLast("Shannai");
   iPatch->addAsLast("Tinkle Bell");
   iPatch->addAsLast("Agogo");
   iPatch->addAsLast("Steel Drums");
   iPatch->addAsLast("Woodblock");
   iPatch->addAsLast("Taiko");
   iPatch->addAsLast("Melodic Tom");
   iPatch->addAsLast("Synth Drum");
   iPatch->addAsLast("Reverse Cym.");
   iPatch->addAsLast("Gt.Fret Noise");
   iPatch->addAsLast("Breath Noise");
   iPatch->addAsLast("Seashore");
   iPatch->addAsLast("Birds");
   iPatch->addAsLast("Telephone");
   iPatch->addAsLast("Helicopter");
   iPatch->addAsLast("Applause");
   iPatch->addAsLast("Gun Shot");
   iPatch->enableAutoScroll(true);
   iPatch->select(0);
   this->setFocus();
   this->setClient(iCanvas1);
   this->setMinimumSize(ISize(732, 210));
   iProfile->setDefaultApplicationName("Keyboard");
}     //end constructor


//------------------------------------------------------------------------------
// Keyboard :: ~Keyboard
//------------------------------------------------------------------------------
#pragma export (Keyboard::~Keyboard())
Keyboard::~Keyboard()
{
   conn0->stopHandlingNotificationsFor(*iKeyCanvas1);
   conn2->stopHandlingNotificationsFor(*iKeyCanvas1);
   conn6->stopHandlingNotificationsFor(*iVolume);
   conn7->stopHandlingNotificationsFor(*iChannel);
   conn7->stopHandlingNotificationsFor(*iMidiKeyboard);
   conn18->stopHandlingNotificationsFor(*this);
   conn8->stopHandlingNotificationsFor(*this);
   conn9->stopHandlingNotificationsFor(*iPatch);
   conn9->stopHandlingNotificationsFor(*iMidiKeyboard);
   conn10->stopHandlingNotificationsFor(*this);

   delete conn0;
   delete conn2;
   delete conn6;
   delete conn7;
   delete conn18;
   delete conn8;
   delete conn9;
   delete conn10;


   delete iCanvas1;
   delete iKeyCanvas1;
   delete iVolume;
   delete iChannel;
   delete iStaticText1;
   delete iStaticText2;
   delete iStaticText3;
   delete iPatch;
   delete iMidiKeyboard;
   delete iProfile;
}

//------------------------------------------------------------------------------
// Keyboard :: initializePart
//------------------------------------------------------------------------------
#pragma export (Keyboard::initializePart())
Keyboard & Keyboard::initializePart()
{
   iKeyCanvas1->initializePart();
   makeConnections();
   notifyObservers(INotificationEvent(readyId, *this));
   return *this;
}


//------------------------------------------------------------------------------
// Keyboard :: makeConnections
//------------------------------------------------------------------------------
#pragma export (Keyboard::makeConnections())
Boolean Keyboard::makeConnections()
{
   this->enableNotification();
   iCanvas1->enableNotification();
   iKeyCanvas1->enableNotification();
   iVolume->enableNotification();
   iChannel->enableNotification();
   iStaticText1->enableNotification();
   iStaticText2->enableNotification();
   iStaticText3->enableNotification();
   iPatch->enableNotification();
   iMidiKeyboard->enableNotification();

   unsigned long id = this->id();
   conn0->initialize(iKeyCanvas1, iMidiKeyboard);
   conn0->handleNotificationsFor(*iKeyCanvas1);
   conn0->setNote(iKeyCanvas1);
   conn2->initialize(iKeyCanvas1, iMidiKeyboard);
   conn2->handleNotificationsFor(*iKeyCanvas1);
   conn2->setNote(iKeyCanvas1);
   conn6->initialize(iVolume, iMidiKeyboard);
   conn6->handleNotificationsFor(*iVolume);
   conn7->initialize(iChannel, iMidiKeyboard);
   conn7->handleNotificationsFor(*iChannel);
   conn7->handleNotificationsFor(*iMidiKeyboard);
   conn18->initialize(this, this);
   conn18->handleNotificationsFor(*this);
   conn8->initialize(this, this);
   conn8->handleNotificationsFor(*this);
   conn9->initialize(iPatch, iMidiKeyboard);
   conn9->handleNotificationsFor(*iPatch);
   conn9->handleNotificationsFor(*iMidiKeyboard);
   conn18->setProfile(iProfile);
   conn10->initialize(this, this);
   conn10->handleNotificationsFor(*this);
   conn10->setProfile(iProfile);

   conn7->setTarget();
   conn9->setTarget();
   return true;
}



#include "Keyboard.cpv"
