/*******************************************************************************
* FILE NAME: Keyboard.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class:                                                  *
*     Keyboard- MIDI Keyboard                                                  *
* ---------------------------------------------------------------------------- *
* Warning: This file was generated by the VisualAge C++ Visual Builder.        *
* Modifications to this source file will be lost when the part is regenerated. *
*******************************************************************************/
#ifndef _KEYBOARD_
#define _KEYBOARD_  

class Keyboard;

#ifndef _IFRAME_
#include <iframe.hpp>
#endif

class ICanvas;
class KeyCanvas;
class ISlider;
class INumericSpinButton;
class IStaticText;
class IComboBox;
class IMidiKeyboard;
class IProfile;
#ifndef _IRECT_
#include <irect.hpp>
#endif

#ifndef _ISTRING_
#include <istring.hpp>
#endif

class KeyboardConn0;
class KeyboardConn2;
class KeyboardConn6;
class KeyboardConn7;
class KeyboardConn18;
class KeyboardConn8;
class KeyboardConn9;
class KeyboardConn10;
#include "Keyboard.h"


/*----------------------------------------------------------------------------*/
/* Align classes on four byte boundary.                                       */
/*----------------------------------------------------------------------------*/
#pragma pack(4)

//*****************************************************************************
// Class definition for Keyboard
//*****************************************************************************
class Keyboard : public IFrameWindow {
public:
   //---------------------------------------------------------------------------
   // Constructors / destructors
   //---------------------------------------------------------------------------
   Keyboard(
      unsigned long id = WND_Keyboard,
      IWindow* parent = IWindow::desktopWindow(),
      IWindow* owner = 0,
      const IRectangle& rect = defaultFramingSpec(),
      const IFrameWindow::Style& style = defaultStyle(),
      const char* title = defaultTitle());

   virtual  ~Keyboard();

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   static const IRectangle defaultFramingSpec();
   static const IFrameWindow::Style defaultStyle();
   static IString defaultTitle();
   virtual Keyboard & initializePart();
   Keyboard * getFrameWindow() { return this; };

   //---------------------------------------------------------------------------
   // public member data
   //---------------------------------------------------------------------------
   static const INotificationId readyId;

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   Boolean makeConnections();

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   ICanvas * iCanvas1;
   KeyCanvas * iKeyCanvas1;
   ISlider * iVolume;
   INumericSpinButton * iChannel;
   IStaticText * iStaticText1;
   IStaticText * iStaticText2;
   IStaticText * iStaticText3;
   IComboBox * iPatch;
   IMidiKeyboard * iMidiKeyboard;
   IProfile * iProfile;
   KeyboardConn0 * conn0;
   KeyboardConn2 * conn2;
   KeyboardConn6 * conn6;
   KeyboardConn7 * conn7;
   KeyboardConn18 * conn18;
   KeyboardConn8 * conn8;
   KeyboardConn9 * conn9;
   KeyboardConn10 * conn10;

friend class KeyboardConn6;

#include "Keyboard.hpv"
};   //Keyboard


/*----------------------------------------------------------------------------*/
/* Resume compiler default packing.                                           */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif
