/*******************************************************************************
* FILE NAME: Patch.cpp                                                         *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class:                                         *
*     Patch- Instance to Instance link                                         *
* ---------------------------------------------------------------------------- *
* Warning: This file was generated by the VisualAge C++ Visual Builder.        *
* Modifications to this source file will be lost when the part is regenerated. *
*******************************************************************************/
#ifndef _ICHECKBX_
#include <icheckbx.hpp>
#endif

#ifndef _IPOINT_
#include <ipoint.hpp>
#endif

#ifndef _INOTIFEV_
#include <inotifev.hpp>
#endif

#ifndef _IOBSERVR_
#include <iobservr.hpp>
#endif

#ifndef _ISTDNTFY_
#include <istdntfy.hpp>
#endif

#ifndef _PATCH_
#include "Patch.hpp"
#endif

#ifndef _IVBDEFS_
#include <ivbdefs.h>
#endif

#ifndef _ITRACE_
#include <itrace.hpp>
#endif


//*****************************************************************************
// Class definition for PatchConn0
//*****************************************************************************
class PatchConn0 : public IObserver, public IStandardNotifier {
public:
   virtual  ~PatchConn0(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(ICheckBox * aSource, Patch * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == ICheckBox::selectId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : patch(selected) to (customLogic, \"Enable/Disable patch\"))");
         try {codeSnippet(&anEvent);}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member functions
   //---------------------------------------------------------------------------
   void codeSnippet(const INotificationEvent* event)
      {
      if ( target->isSelected() )
      {  
         target->fromPatch->addLink(target->toPatch);
      }
      else
      {
         target->fromPatch->removeLink(target->toPatch);
      }
      };

   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   ICheckBox * source;
   Patch * target;


};   //PatchConn0


#pragma export (Patch::readyId)
const INotificationId Patch::readyId = "Patch::readyId";

//------------------------------------------------------------------------------
// Patch :: defaultFramingSpec
//------------------------------------------------------------------------------
#pragma export (Patch::defaultFramingSpec())
const IRectangle Patch::defaultFramingSpec()
{
   return(IRectangle(IPoint(30,452),ISize(20, 20)));
}


//------------------------------------------------------------------------------
// Patch :: defaultStyle
//------------------------------------------------------------------------------
#pragma export (Patch::defaultStyle())
const ICheckBox::Style Patch::defaultStyle()
{
   return(ICheckBox::defaultStyle());
}


//------------------------------------------------------------------------------
// Patch :: Patch
//------------------------------------------------------------------------------
#pragma export (Patch::Patch(IMidiInstance*, IMidiInstance*, unsigned long, IWindow*, IWindow*, const IRectangle&, const ICheckBox::Style&))
Patch::Patch(
      IMidiInstance* from, 
      IMidiInstance* to, 
      unsigned long id, 
      IWindow* parent, 
      IWindow* owner, 
      const IRectangle& rect, 
      const ICheckBox::Style& style)
   : ICheckBox(id, parent, owner, rect, style)
{

   conn0 = new PatchConn0();

   this->setMinimumSize(ISize(20, 20));
   fromPatch = from; toPatch=to;setup();
}     //end constructor


//------------------------------------------------------------------------------
// Patch :: ~Patch
//------------------------------------------------------------------------------
#pragma export (Patch::~Patch())
Patch::~Patch()
{
   setdown();
   conn0->stopHandlingNotificationsFor(*this);

   delete conn0;


}

//------------------------------------------------------------------------------
// Patch :: initializePart
//------------------------------------------------------------------------------
#pragma export (Patch::initializePart())
Patch & Patch::initializePart()
{
   makeConnections();
   notifyObservers(INotificationEvent(readyId, *this));
   return *this;
}


//------------------------------------------------------------------------------
// Patch :: makeConnections
//------------------------------------------------------------------------------
#pragma export (Patch::makeConnections())
Boolean Patch::makeConnections()
{
   this->enableNotification();

   unsigned long id = this->id();
   conn0->initialize(this, this);
   conn0->handleNotificationsFor(*this);

   return true;
}



#include "Patch.cpv"
