/*******************************************************************************
* FILE NAME: PatchPnl.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class:                                         *
*     PatchPanel- MIDI Patch Panel                                             *
* ---------------------------------------------------------------------------- *
* Warning: This file was generated by the VisualAge C++ Visual Builder.        *
* Modifications to this source file will be lost when the part is regenerated. *
*******************************************************************************/
#ifndef _IFRAME_
#include <iframe.hpp>
#endif

#ifndef _IVPORT_
#include <ivport.hpp>
#endif

#ifndef _IMCELCV_
#include <imcelcv.hpp>
#endif

#ifndef _IRECT_
#include <irect.hpp>
#endif

#ifndef _IPOINT_
#include <ipoint.hpp>
#endif

#ifndef _ISTATTXT_
#include <istattxt.hpp>
#endif

#ifndef _IRMIDI_
#include "IRTMidi.hpp"
#endif

#ifndef _IPROFILE_
#include <iprofile.hpp>
#endif

#ifndef _INOTIFEV_
#include <inotifev.hpp>
#endif

#ifndef _IOBSERVR_
#include <iobservr.hpp>
#endif

#ifndef _ISTDNTFY_
#include <istdntfy.hpp>
#endif

#ifndef _PATCHPNL_
#include "PatchPnl.hpp"
#endif

#ifndef _IVBDEFS_
#include <ivbdefs.h>
#endif

#ifndef _ITRACE_
#include <itrace.hpp>
#endif


//*****************************************************************************
// Class definition for PatchPanelConn2
//*****************************************************************************
class PatchPanelConn2 : public IObserver, public IStandardNotifier {
public:
   virtual  ~PatchPanelConn2(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(PatchPanel * aSource, PatchPanel * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };
   PatchPanelConn2 & setMcell(IMultiCellCanvas * aSelf) {iMcell = aSelf; return *this;};
   PatchPanelConn2 & setInstances(IVBVariablePartPointer<IRTMidi *> * aSelf) {iInstances = aSelf; return *this;};

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == PatchPanel::readyId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : (ready) to (addPatches))");
         try {target->addPatches(iMcell, iInstances->target()->instances());}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   PatchPanel * source;
   PatchPanel * target;
   IMultiCellCanvas * iMcell;
   IVBVariablePartPointer<IRTMidi *> * iInstances;


};   //PatchPanelConn2


//*****************************************************************************
// Class definition for PatchPanelConn17
//*****************************************************************************
class PatchPanelConn17 : public IObserver, public IStandardNotifier {
public:
   virtual  ~PatchPanelConn17(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(PatchPanel * aSource, PatchPanel * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };
   PatchPanelConn17 & setProfile(IProfile * aSelf) {iProfile = aSelf; return *this;};

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == PatchPanel::readyId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : (ready) to (restoreFromProfile))");
         try {target->restoreFromProfile(iProfile);}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   PatchPanel * source;
   PatchPanel * target;
   IProfile * iProfile;


};   //PatchPanelConn17


//*****************************************************************************
// Class definition for PatchPanelConn5
//*****************************************************************************
class PatchPanelConn5 : public IObserver, public IStandardNotifier {
public:
   virtual  ~PatchPanelConn5(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IVBVariablePartPointer<IRTMidi *> * aSource, PatchPanel * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };
   PatchPanelConn5 & setMcell(IMultiCellCanvas * aSelf) {iMcell = aSelf; return *this;};
   PatchPanelConn5 & setInstances(IVBVariablePartPointer<IRTMidi *> * aSelf) {iInstances = aSelf; return *this;};

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (!source->target()) return(*this);
      if (anEvent.notificationId() == IRTMidi::instancesId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : RTMidi(instances) to (updatePatches))");
         try {target->updatePatches(iMcell, iInstances->target()->instances());}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IVBVariablePartPointer<IRTMidi *> * source;
   PatchPanel * target;
   IMultiCellCanvas * iMcell;
   IVBVariablePartPointer<IRTMidi *> * iInstances;


};   //PatchPanelConn5


//*****************************************************************************
// Class definition for PatchPanelConn8
//*****************************************************************************
class PatchPanelConn8 : public IObserver, public IStandardNotifier {
public:
   virtual  ~PatchPanelConn8(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(PatchPanel * aSource, IFrameWindow * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == PatchPanel::readyId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : (ready) to FrameWindow(show))");
         try {target->show();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   PatchPanel * source;
   IFrameWindow * target;


};   //PatchPanelConn8


//*****************************************************************************
// Class definition for PatchPanelConn9
//*****************************************************************************
class PatchPanelConn9 : public IObserver, public IStandardNotifier {
public:
   virtual  ~PatchPanelConn9(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IFrameWindow * aSource, PatchPanel * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };
   PatchPanelConn9 & setProfile(IProfile * aSelf) {iProfile = aSelf; return *this;};

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IFrameWindow::closeId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : FrameWindow(closeEvent) to (saveToProfile))");
         try {target->saveToProfile(iProfile);}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IFrameWindow * source;
   PatchPanel * target;
   IProfile * iProfile;


};   //PatchPanelConn9


//*****************************************************************************
// Class definition for PatchPanelConn11
//*****************************************************************************
class PatchPanelConn11 : public IObserver {
public:
   virtual  ~PatchPanelConn11(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IMultiCellCanvas * aSource, IMultiCellCanvas * aTarget)
      {source = aSource; target = aTarget; aligning = false; };
   void setSource()
      {      };
   void setTarget()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : MCell(parentSize) to MCell(size))");
         ITRACE_DEVELOP(" setting target from source ");
         aligning = true;
         try {target->sizeTo(source->parentSize());}
         catch (IException& exc) {};
         aligning = false;
         }
      };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VBINITIALIZEID) setTarget();
      if ((anEvent.notificationId() == IMultiCellCanvas::sizeId) && (target == &anEvent.notifier()))
         setSource();  /* set source to target value */
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IMultiCellCanvas * source;
   IMultiCellCanvas * target;
   Boolean aligning;


};   //PatchPanelConn11


#pragma export (PatchPanel::readyId)
const INotificationId PatchPanel::readyId = "PatchPanel::readyId";

#pragma export (PatchPanel::RTMidi)
const INotificationId PatchPanel::RTMidi = "PatchPanel::RTMidi";

//------------------------------------------------------------------------------
// PatchPanel :: defaultFramingSpec
//------------------------------------------------------------------------------
#pragma export (PatchPanel::defaultFramingSpec())
const IRectangle PatchPanel::defaultFramingSpec()
{
   return(IRectangle(IPoint(42, IWindow::desktopWindow()->size().height() - 123 - 265),ISize(330, 265)));
}


//------------------------------------------------------------------------------
// PatchPanel :: defaultStyle
//------------------------------------------------------------------------------
#pragma export (PatchPanel::defaultStyle())
const IFrameWindow::Style PatchPanel::defaultStyle()
{
   return(IFrameWindow::defaultStyle() | IFrameWindow::noMoveWithOwner);
}


//------------------------------------------------------------------------------
// PatchPanel :: defaultTitle
//------------------------------------------------------------------------------
#pragma export (PatchPanel::defaultTitle())
IString PatchPanel::defaultTitle()
{
   return("Patch Panel");
}


//------------------------------------------------------------------------------
// PatchPanel :: PatchPanel
//------------------------------------------------------------------------------
#pragma export (PatchPanel::PatchPanel(unsigned long, IWindow*, IWindow*, const IRectangle&, const IFrameWindow::Style&, const char*))
PatchPanel::PatchPanel(
      unsigned long id, 
      IWindow* parent, 
      IWindow* owner, 
      const IRectangle& rect, 
      const IFrameWindow::Style& style, 
      const char* title)
   : IFrameWindow(id, parent, owner, rect, style, title)
{
   iViewPort1 = new IViewPort(
      IC_FRAME_CLIENT_ID, 
      this, 
      this, 
      IRectangle());
   iMCell = new IMultiCellCanvas(
      id+WNDOFFSET_PatchPanel_MCell, 
      iViewPort1, 
      iViewPort1, 
      IRectangle(IPoint(0,144),ISize(131, 91)), 
      IMultiCellCanvas::defaultStyle() & ~IMultiCellCanvas::gridLines);
   iStaticText1 = new IStaticText(
      id+WNDOFFSET_PatchPanel_StaticText1, 
      iMCell, 
      iMCell, 
      IRectangle());
   iRTMidi = new IVBVariablePartPointer<IRTMidi *>();
   iProfile = new IProfile("VisMIDI.ini");

   conn2 = new PatchPanelConn2();
   conn17 = new PatchPanelConn17();
   conn5 = new PatchPanelConn5();
   conn8 = new PatchPanelConn8();
   conn9 = new PatchPanelConn9();
   conn11 = new PatchPanelConn11();

   iMCell->addToCell(iStaticText1, 1, 1, 1, 1);
   iMCell->setColumnWidth(1, IMultiCellCanvas::defaultCell().width(), false);
   iMCell->setRowHeight(1, IMultiCellCanvas::defaultCell().height(), false);
   iStaticText1->setAlignment(IStaticText::centerCenter);
   iStaticText1->setText("Instance");
   this->setFocus();
   this->setClient(iViewPort1);
   iProfile->setDefaultApplicationName("PatchPanel");
}     //end constructor


//------------------------------------------------------------------------------
// PatchPanel :: ~PatchPanel
//------------------------------------------------------------------------------
#pragma export (PatchPanel::~PatchPanel())
PatchPanel::~PatchPanel()
{
   this->stopHandlingNotificationsFor(*iRTMidi);
   conn2->stopHandlingNotificationsFor(*this);
   conn17->stopHandlingNotificationsFor(*this);
   conn5->stopHandlingNotificationsFor(*iRTMidi);
   conn8->stopHandlingNotificationsFor(*this);
   conn9->stopHandlingNotificationsFor(*this);
   conn11->stopHandlingNotificationsFor(*iMCell);
   conn11->stopHandlingNotificationsFor(*iMCell);

   delete conn2;
   delete conn17;
   delete conn5;
   delete conn8;
   delete conn9;
   delete conn11;


   delete iViewPort1;
   delete iMCell;
   delete iStaticText1;
   delete iRTMidi;
   delete iProfile;
}

//------------------------------------------------------------------------------
// PatchPanel :: initializePart
//------------------------------------------------------------------------------
#pragma export (PatchPanel::initializePart())
PatchPanel & PatchPanel::initializePart()
{
   this->handleNotificationsFor(*iRTMidi);
   makeConnections();
   notifyObservers(INotificationEvent(readyId, *this));
   return *this;
}


//------------------------------------------------------------------------------
// PatchPanel :: makeConnections
//------------------------------------------------------------------------------
#pragma export (PatchPanel::makeConnections())
Boolean PatchPanel::makeConnections()
{
   this->enableNotification();
   iViewPort1->enableNotification();
   iMCell->enableNotification();
   iStaticText1->enableNotification();
   iRTMidi->enableNotification();

   unsigned long id = this->id();
   conn2->initialize(this, this);
   conn2->handleNotificationsFor(*this);
   conn17->initialize(this, this);
   conn17->handleNotificationsFor(*this);
   conn2->setInstances(iRTMidi);
   conn2->setMcell(iMCell);
   conn5->initialize(iRTMidi, this);
   conn5->handleNotificationsFor(*iRTMidi);
   conn5->setMcell(iMCell);
   conn5->setInstances(iRTMidi);
   conn8->initialize(this, this);
   conn8->handleNotificationsFor(*this);
   conn17->setProfile(iProfile);
   conn9->initialize(this, this);
   conn9->handleNotificationsFor(*this);
   conn9->setProfile(iProfile);
   conn11->initialize(iMCell, iMCell);
   conn11->handleNotificationsFor(*iMCell);
   conn11->handleNotificationsFor(*iMCell);

   conn11->setTarget();
   return true;
}


//------------------------------------------------------------------------------
// PatchPanel :: dispatchNotificationEvent
//------------------------------------------------------------------------------
#pragma export (PatchPanel::dispatchNotificationEvent(const INotificationEvent &))
IObserver & PatchPanel::dispatchNotificationEvent(const INotificationEvent & anEvent)
{
   if ((anEvent.notificationId() == IVBVariablePartPointer<IRTMidi *>::targetId) && (iRTMidi == &anEvent.notifier()))
       notifyObservers(INotificationEvent(RTMidi, *this, anEvent.hasNotifierAttrChanged(), IEventData((void *)anEvent.eventData()), anEvent.observerData()));
   return *this;
}



#include "PatchPnl.cpv"
