/*******************************************************************************
* FILE NAME: PatchPnl.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class:                                                  *
*     PatchPanel- MIDI Patch Panel                                             *
* ---------------------------------------------------------------------------- *
* Warning: This file was generated by the VisualAge C++ Visual Builder.        *
* Modifications to this source file will be lost when the part is regenerated. *
*******************************************************************************/
#ifndef _PATCHPNL_
#define _PATCHPNL_  

class PatchPanel;

#ifndef _IFRAME_
#include <iframe.hpp>
#endif

#ifndef _IOBSERVR_
#include <iobservr.hpp>
#endif

class IViewPort;
class IMultiCellCanvas;
class IStaticText;
#ifndef _IVBVPRTP_
#include <ivbvprtp.h>
#endif

#ifndef _IRMIDI_
#include "IRTMidi.hpp"
#endif

class IProfile;
#ifndef _IRECT_
#include <irect.hpp>
#endif

#ifndef _ISTRING_
#include <istring.hpp>
#endif

#ifndef _IMIDIINS_
#include "IMidiIns.hpp"
#endif

#ifndef _PATCH_
#include "Patch.hpp"
#endif

#ifndef _VERTTEXT_
#include "VertText.hpp"
#endif

class PatchPanelConn2;
class PatchPanelConn17;
class PatchPanelConn5;
class PatchPanelConn8;
class PatchPanelConn9;
class PatchPanelConn11;
#include "PatchPnl.h"


/*----------------------------------------------------------------------------*/
/* Align classes on four byte boundary.                                       */
/*----------------------------------------------------------------------------*/
#pragma pack(4)

//*****************************************************************************
// Class definition for PatchPanel
//*****************************************************************************
class PatchPanel : public IFrameWindow, public IObserver {
public:
   //---------------------------------------------------------------------------
   // Constructors / destructors
   //---------------------------------------------------------------------------
   PatchPanel(
      unsigned long id = WND_PatchPanel,
      IWindow* parent = IWindow::desktopWindow(),
      IWindow* owner = 0,
      const IRectangle& rect = defaultFramingSpec(),
      const IFrameWindow::Style& style = defaultStyle(),
      const char* title = defaultTitle());

   virtual  ~PatchPanel();

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   static const IRectangle defaultFramingSpec();
   static const IFrameWindow::Style defaultStyle();
   static IString defaultTitle();
   virtual PatchPanel & initializePart();
   PatchPanel * getFrameWindow() { return this; };
   IVBVariablePartPointer<IRTMidi *> *  getRTMidi() const { return iRTMidi; };

   //---------------------------------------------------------------------------
   // public member data
   //---------------------------------------------------------------------------
   static const INotificationId readyId;
   static const INotificationId RTMidi;

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   Boolean makeConnections();
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent);

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IViewPort * iViewPort1;
   IMultiCellCanvas * iMCell;
   IStaticText * iStaticText1;
   IVBVariablePartPointer<IRTMidi *> * iRTMidi;
   IProfile * iProfile;
   PatchPanelConn2 * conn2;
   PatchPanelConn17 * conn17;
   PatchPanelConn5 * conn5;
   PatchPanelConn8 * conn8;
   PatchPanelConn9 * conn9;
   PatchPanelConn11 * conn11;


#include "PatchPnl.hpv"
};   //PatchPanel


/*----------------------------------------------------------------------------*/
/* Resume compiler default packing.                                           */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif
